/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.SM2PrivateKeySpec;
import java.security.spec.SM2PublicKeySpec;
import sun.security.ec.SM2PrivateKey;
import sun.security.ec.SM2PublicKey;

public final class SM2KeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof SM2PublicKeySpec)) {
            throw new InvalidKeySpecException("Only accept SM2PublicKeySpec");
        }
        SM2PublicKeySpec sM2PublicKeySpec = (SM2PublicKeySpec)keySpec;
        ECPoint eCPoint = sM2PublicKeySpec.getW();
        if (eCPoint == null || eCPoint.getAffineX() == null || eCPoint.getAffineY() == null) {
            throw new InvalidKeySpecException("No public key");
        }
        return new SM2PublicKey(eCPoint);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof SM2PrivateKeySpec)) {
            throw new InvalidKeySpecException("Only accept SM2PrivateKeySpec");
        }
        SM2PrivateKeySpec sM2PrivateKeySpec = (SM2PrivateKeySpec)keySpec;
        BigInteger bigInteger = sM2PrivateKeySpec.getS();
        if (bigInteger == null) {
            throw new InvalidKeySpecException("No private key");
        }
        return new SM2PrivateKey(bigInteger);
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
        if (key instanceof ECPrivateKey) {
            if (clazz.isAssignableFrom(SM2PrivateKeySpec.class)) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
                return (T)((KeySpec)clazz.cast(new SM2PrivateKeySpec(eCPrivateKey.getS())));
            }
            throw new InvalidKeySpecException("keySpecClass must be SM2PrivateKeySpec for SM2 private key");
        }
        if (key instanceof ECPublicKey) {
            if (clazz.isAssignableFrom(SM2PublicKeySpec.class)) {
                ECPublicKey eCPublicKey = (ECPublicKey)key;
                return (T)((KeySpec)clazz.cast(new SM2PublicKeySpec(eCPublicKey.getW())));
            }
            throw new InvalidKeySpecException("keySpecClass must be SM2PublicKeySpec for SM2 public key");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            return new SM2PrivateKey(((ECPrivateKey)key).getS());
        }
        if (key instanceof ECPublicKey) {
            return new SM2PublicKey(((ECPublicKey)key).getW());
        }
        throw new InvalidKeyException("key must be ECPrivateKey or ECPublicKey");
    }
}

