/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.SM2ParameterSpec;
import java.util.Arrays;
import sun.security.util.SMUtil;

public final class SM2PublicKey
implements ECPublicKey {
    private static final long serialVersionUID = 682873544399078680L;
    private final byte[] encoded;
    private final transient ECPoint pubPoint;

    public SM2PublicKey(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Missing encoded public key");
        }
        this.pubPoint = SM2PublicKey.decodePubPoint(byArray);
        this.encoded = (byte[])byArray.clone();
    }

    public SM2PublicKey(ECPoint eCPoint) {
        if (eCPoint == null) {
            throw new IllegalArgumentException("Missing public key");
        }
        if (eCPoint.equals(ECPoint.POINT_INFINITY)) {
            throw new IllegalArgumentException("Public point cannot be infinite point");
        }
        this.encoded = SM2PublicKey.encodePubPoint(eCPoint);
        this.pubPoint = eCPoint;
    }

    public SM2PublicKey(ECPublicKey eCPublicKey) {
        this(eCPublicKey.getW());
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    @Override
    public ECPoint getW() {
        return this.pubPoint;
    }

    @Override
    public ECParameterSpec getParams() {
        return SM2ParameterSpec.instance();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SM2PublicKey sM2PublicKey = (SM2PublicKey)object;
        return Arrays.equals(this.encoded, sM2PublicKey.encoded);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoded);
    }

    private static ECPoint decodePubPoint(byte[] byArray) {
        if (byArray.length != 65) {
            throw new IllegalArgumentException("The encoded public key must be 65-bytes: " + byArray.length);
        }
        if (byArray[0] != 4) {
            throw new IllegalArgumentException("The encoded public key must start with 0x04");
        }
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(byArray, 1, 33));
        BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(byArray, 33, 65));
        return new ECPoint(bigInteger, bigInteger2);
    }

    private static byte[] encodePubPoint(ECPoint eCPoint) {
        byte[] byArray = SMUtil.bigIntToBytes32((BigInteger)eCPoint.getAffineX());
        byte[] byArray2 = SMUtil.bigIntToBytes32((BigInteger)eCPoint.getAffineY());
        byte[] byArray3 = new byte[65];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, 1, 32);
        System.arraycopy(byArray2, 0, byArray3, 33, 32);
        return byArray3;
    }
}

