/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.SM4Crypt;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

class SM4Cipher
extends CipherSpi {
    private final CipherCore core = new CipherCore(new SM4Crypt(), 16);
    private final int fixedKeySize;
    private boolean updateCalled;

    static void checkKeySize(Key key, int n) throws InvalidKeyException {
        if (n != -1) {
            if (key == null) {
                throw new InvalidKeyException("The key must not be null");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key encoding must not be null");
            }
            Arrays.fill(byArray, (byte)0);
            if (byArray.length != n) {
                throw new InvalidKeyException("The key must be " + n + " bytes");
            }
        }
    }

    protected SM4Cipher(int n) {
        this.fixedKeySize = n;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.core.setMode(string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.core.setPadding(string);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.core.getOutputSize(n);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.core.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.core.getParameters("SM4");
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        SM4Cipher.checkKeySize(key, this.fixedKeySize);
        this.updateCalled = false;
        this.core.init(n, key, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SM4Cipher.checkKeySize(key, this.fixedKeySize);
        this.updateCalled = false;
        this.core.init(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SM4Cipher.checkKeySize(key, this.fixedKeySize);
        this.updateCalled = false;
        this.core.init(n, key, algorithmParameters, secureRandom);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.updateCalled = true;
        return this.core.update(byArray, n, n2);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.updateCalled = true;
        return this.core.update(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = this.core.doFinal(byArray, n, n2);
        this.updateCalled = false;
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int n4 = this.core.doFinal(byArray, n, n2, byArray2, n3);
        this.updateCalled = false;
        return n4;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        Arrays.fill(byArray, (byte)0);
        if (byArray.length != 16) {
            throw new InvalidKeyException("Invalid SM4 key length: " + byArray.length + " bytes");
        }
        return Math.multiplyExact(byArray.length, 8);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.core.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.core.unwrap(byArray, string, n);
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        if (this.core.getMode() == 7 && this.updateCalled) {
            throw new IllegalStateException("AAD must be supplied before encryption/decryption starts");
        }
        this.core.updateAAD(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n;
        if (this.core.getMode() == 7 && this.updateCalled) {
            throw new IllegalStateException("AAD must be supplied before encryption/decryption starts");
        }
        if (byteBuffer != null && (n = byteBuffer.limit() - byteBuffer.position()) > 0) {
            if (byteBuffer.hasArray()) {
                int n2 = Math.addExact(byteBuffer.arrayOffset(), byteBuffer.position());
                this.core.updateAAD(byteBuffer.array(), n2, n);
                byteBuffer.position(byteBuffer.limit());
            } else {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                this.core.updateAAD(byArray, 0, n);
            }
        }
    }

    public static final class SM4_GCM_NoPadding
    extends OidImpl {
        public SM4_GCM_NoPadding() {
            super(16, "GCM", "PKCS5Padding");
        }
    }

    public static final class SM4_ECB_PKCS7Padding
    extends OidImpl {
        public SM4_ECB_PKCS7Padding() {
            super(16, "ECB", "PKCS5Padding");
        }
    }

    public static final class SM4_ECB_NoPadding
    extends OidImpl {
        public SM4_ECB_NoPadding() {
            super(16, "ECB", "NOPADDING");
        }
    }

    public static final class SM4_CTR_NoPadding
    extends OidImpl {
        public SM4_CTR_NoPadding() {
            super(16, "CTR", "NOPADDING");
        }
    }

    public static final class SM4_CBC_PKCS7Padding
    extends OidImpl {
        public SM4_CBC_PKCS7Padding() {
            super(16, "CBC", "PKCS5Padding");
        }
    }

    public static final class SM4_CBC_NoPadding
    extends OidImpl {
        public SM4_CBC_NoPadding() {
            super(16, "CBC", "NOPADDING");
        }
    }

    static class OidImpl
    extends SM4Cipher {
        protected OidImpl(int n, String string, String string2) {
            super(n);
            try {
                this.engineSetMode(string);
                this.engineSetPadding(string2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException("Internal Error", generalSecurityException);
            }
        }
    }

    public static final class General
    extends SM4Cipher {
        public General() {
            super(-1);
        }
    }
}

