/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.TlsPrfGenerator;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.interfaces.TlsMasterSecret;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;

public final class TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private TlsMasterSecretParameterSpec spec;
    private int protocolVersion;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
        if (!"RAW".equals(this.spec.getPremasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if ((this.protocolVersion < 768 || this.protocolVersion > 771) && this.protocolVersion != 257) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0/1.1/1.2, TLCP 1.1 supported");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        int n;
        int n2;
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        SecretKey secretKey = this.spec.getPremasterSecret();
        byte[] byArray = secretKey.getEncoded();
        if (secretKey.getAlgorithm().equals("TlsRsaPremasterSecret")) {
            n2 = byArray[0] & 0xFF;
            n = byArray[1] & 0xFF;
        } else {
            n2 = -1;
            n = -1;
        }
        try {
            byte[] byArray2;
            if (this.protocolVersion >= 769 || this.protocolVersion == 257) {
                byte[] byArray3;
                byte[] byArray4;
                byte[] byArray5 = this.spec.getExtendedMasterSecretSessionHash();
                if (byArray5.length != 0) {
                    byArray4 = TlsPrfGenerator.LABEL_EXTENDED_MASTER_SECRET;
                    byArray3 = byArray5;
                } else {
                    byte[] byArray6 = this.spec.getClientRandom();
                    byte[] byArray7 = this.spec.getServerRandom();
                    byArray4 = TlsPrfGenerator.LABEL_MASTER_SECRET;
                    byArray3 = TlsPrfGenerator.concat(byArray6, byArray7);
                }
                byArray2 = this.protocolVersion >= 771 || this.protocolVersion == 257 ? TlsPrfGenerator.doTLS12PRF(byArray, byArray4, byArray3, 48, this.spec.getPRFHashAlg(), this.spec.getPRFHashLength(), this.spec.getPRFBlockSize()) : TlsPrfGenerator.doTLS10PRF(byArray, byArray4, byArray3, 48);
            } else {
                byArray2 = new byte[48];
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
                byte[] byArray8 = this.spec.getClientRandom();
                byte[] byArray9 = this.spec.getServerRandom();
                byte[] byArray10 = new byte[20];
                for (int i = 0; i < 3; ++i) {
                    messageDigest2.update(TlsPrfGenerator.SSL3_CONST[i]);
                    messageDigest2.update(byArray);
                    messageDigest2.update(byArray8);
                    messageDigest2.update(byArray9);
                    messageDigest2.digest(byArray10, 0, 20);
                    messageDigest.update(byArray);
                    messageDigest.update(byArray10);
                    messageDigest.digest(byArray2, i << 4, 16);
                }
            }
            return new TlsMasterSecretKey(byArray2, n2, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    private static final class TlsMasterSecretKey
    implements TlsMasterSecret {
        private static final long serialVersionUID = 1019571680375368880L;
        private byte[] key;
        private final int majorVersion;
        private final int minorVersion;

        TlsMasterSecretKey(byte[] byArray, int n, int n2) {
            this.key = byArray;
            this.majorVersion = n;
            this.minorVersion = n2;
        }

        @Override
        public int getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public int getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public String getAlgorithm() {
            return "TlsMasterSecret";
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return (byte[])this.key.clone();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.key == null || this.key.length == 0) {
                throw new InvalidObjectException("TlsMasterSecretKey is null");
            }
            this.key = (byte[])this.key.clone();
        }
    }
}

