/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.af;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_af extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Central Africa Time",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskou-standaardtyd",
               "MST",
               "Moskou-somertyd",
               "MST",
               "Moskou-tyd",
               "MT",
            };
        final String[] Argentina = new String[] {
               "Argentini\u00eb-tyd",
               "AST",
               "Argentini\u00eb-somertyd",
               "AST",
               "Argentini\u00eb-tyd",
               "AT",
            };
        final String[] Hovd = new String[] {
               "Hovd-tyd",
               "HST",
               "Hovd-somertyd",
               "HST",
               "Hovd-tyd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadan-tyd",
               "MST",
               "Magadan-somertyd",
               "MST",
               "Magadan-tyd",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australiese sentraal-Westelike standaard-tyd",
               "ACWST",
               "Australiese sentraal-Westelike dagligtyd",
               "ACWDT",
               "Australiese sentraal-Westelike tyd",
               "ACWT",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-tyd",
               "SST",
               "Sakhalin-somertyd",
               "SST",
               "Sakhalin-tyd",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-tyd",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "Oostelike standaardtyd",
               "EST",
               "Oostelike dagligtyd",
               "EDT",
               "Oostelike tyd",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii Aleutiese standaardtyd",
               "HAST",
               "Hawaii Aleutiese dagligtyd",
               "HADT",
               "Hawaii Aleutiese tyd",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Australiese sentraal-standaardtyd",
               "ACST",
               "Australiese sentrale dagligtyd",
               "ACDT",
               "Sentraal-Australi\u00eb-tyd",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-standaardtyd",
               "LHST",
               "Lord Howe-dagligtyd",
               "LHDT",
               "Lord Howe-tyd",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk-tyd",
               "YST",
               "Yakutsk-somertyd",
               "YST",
               "Yakutsk-tyd",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "Pasifiese standaardtyd",
               "PST",
               "Pasifiese dagligtyd",
               "PDT",
               "Pasifiese tyd",
               "PT",
            };
        final String[] Africa_Eastern = new String[] {
               "East Africa Time",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland-standaard-tyd",
               "NST",
               "Newfoundland-dagligtyd",
               "NDT",
               "Newfoundland-tyd",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "Westelike Argentini\u00eb-tyd",
               "WAST",
               "Argentini\u00eb Westelike somertyd",
               "WAST",
               "Argentini\u00eb Westelike tyd",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlantiese standaardtyd",
               "AST",
               "Atlantiese dagligtyd",
               "ADT",
               "Atlantiese tyd",
               "AT",
            };
        final String[] Africa_Western = new String[] {
               "West Africa Standard Time",
               "WAT",
               "West Africa Summer Time",
               "WAST",
               "West Africa Time",
               "WAT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg-tyd",
               "YST",
               "Yekaterinburg-somertyd",
               "YST",
               "Yekaterinburg-tyd",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "Volgograd-tyd",
               "VST",
               "Volgograd-somertyd",
               "VST",
               "Volgograd-tyd",
               "VT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonesi\u00eb-sentraal-tyd",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonesiese Oostelike tyd",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Omsk = new String[] {
               "Omsk-tyd",
               "OST",
               "Omsk-somertyd",
               "OST",
               "Omsk-tyd",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "Australiese Westelike standaardtyd",
               "AWST",
               "Australiese Westelike dagligtyd",
               "AWDT",
               "Westelike Australi\u00eb-tyd",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonesiese Westelike tyd",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "Oelan Bator-tyd",
               "UBST",
               "Oelan Bator-somertyd",
               "UBST",
               "Mongoli\u00eb-tyd",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Sentraal-standaardtyd",
               "CST",
               "Sentrale dagligtyd",
               "CDT",
               "Sentrale tyd",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australiese Oostelike standaardtyd",
               "AEST",
               "Australiese Oostelike dagligtyd",
               "AEDT",
               "Oostelike Australiese tyd",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "Berg-standaardtyd",
               "MST",
               "Berg-dagligtyd",
               "MDT",
               "Bergtyd",
               "MT",
            };
        final String[] Alaska = new String[] {
               "Alaska-standaardtyd",
               "AKST",
               "Alaska-dagligtyd",
               "AKDT",
               "Alaska-tyd",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-tyd",
               "NST",
               "Novosibirsk-somertyd",
               "NST",
               "Novosibirsk-tyd",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-tyd",
               "VST",
               "Vladivostok-somertyd",
               "VST",
               "Vladivostok-tyd",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-tyd",
               "IST",
               "Irkutsk-somertyd",
               "IST",
               "Irkutsk-tyd",
               "IT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-tyd",
               "FNST",
               "Fernando de Noronha-somertyd",
               "FNST",
               "Noronha-tyd",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan-tyd",
               "CST",
               "Choibalsan-somertyd",
               "CST",
               "Choibalsan-tyd",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brasili\u00eb-tyd",
               "BST",
               "Brasili\u00eb somertyd",
               "BST",
               "Brasili\u00eb-tyd",
               "BT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk-tyd",
               "KST",
               "Krasnoyarsk-somertyd",
               "KST",
               "Krasnoyarsk-tyd",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Wes-Kazakstan-standaardtyd",
               "WKT",
               "Kazakstan Westelike somertyd",
               "WKST",
               "Wes-Kazakstan-tyd",
               "WKT",
            };
        final String[] Amazon = new String[] {
               "Amasone-tyd",
               "AST",
               "Amasone-somertyd",
               "AST",
               "Amasone-tyd",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oos-Kazakstan-standaardtyd",
               "EKT",
               "Kazakstan Oostelike somertyd",
               "EKST",
               "Oos-Kazakstan-tyd",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Amazon },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Windhoek", Africa_Western },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "America/Manaus", Amazon },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Catamarca", Argentina },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "America/Anguilla", Atlantic },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/St_Lucia", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Martinique", Atlantic },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Tortola", Atlantic },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Asia/Yakutsk", Yakutsk },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
        };
        return data;
    }
}
