/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.MapInfo;
import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.TensorInfo;
import ai.onnxruntime.ValueInfo;

public class SequenceInfo
implements ValueInfo {
    public final boolean sequenceOfMaps;
    public final OnnxJavaType sequenceType;
    public final MapInfo mapInfo;
    public final int length;

    SequenceInfo(int n2, OnnxJavaType onnxJavaType) {
        this.length = n2;
        this.sequenceType = onnxJavaType;
        this.sequenceOfMaps = false;
        this.mapInfo = null;
    }

    SequenceInfo(int n2, int n3) {
        this.length = n2;
        this.sequenceType = OnnxJavaType.mapFromOnnxTensorType(TensorInfo.OnnxTensorType.mapFromInt(n3));
        this.sequenceOfMaps = false;
        this.mapInfo = null;
    }

    SequenceInfo(int n2, MapInfo mapInfo) {
        this.length = n2;
        this.sequenceOfMaps = true;
        this.mapInfo = mapInfo;
        this.sequenceType = OnnxJavaType.UNKNOWN;
    }

    SequenceInfo(int n2, OnnxJavaType onnxJavaType, OnnxJavaType onnxJavaType2) {
        this.length = n2;
        this.sequenceType = OnnxJavaType.UNKNOWN;
        this.sequenceOfMaps = true;
        this.mapInfo = new MapInfo(onnxJavaType, onnxJavaType2);
    }

    public boolean isSequenceOfMaps() {
        return this.sequenceOfMaps;
    }

    public String toString() {
        String string = "SequenceInfo(length=" + (this.length == -1 ? "UNKNOWN" : Integer.valueOf(this.length));
        if (this.sequenceOfMaps) {
            return string + ",type=" + this.mapInfo.toString() + ")";
        }
        return string + ",type=" + this.sequenceType.toString() + ")";
    }
}

