/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime.providers;

import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtProviderOptions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class StringConfigProviderOptions
extends OrtProviderOptions {
    protected final Map<String, String> options = new LinkedHashMap<String, String>();

    protected StringConfigProviderOptions(long l2) {
        super(l2);
    }

    public void add(String string, String string2) throws OrtException {
        Objects.requireNonNull(string, "Key must not be null");
        Objects.requireNonNull(string2, "Value must not be null");
        this.options.put(string, string2);
        this.add(StringConfigProviderOptions.getApiHandle(), this.nativeHandle, string, string2);
    }

    public void parseOptionsString(String string) throws OrtException {
        String[] stringArray;
        for (String string2 : stringArray = string.split(";")) {
            if (string2.isEmpty() || !string2.contains("=")) continue;
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length == 2 && !stringArray2[0].isEmpty() && !stringArray2[1].isEmpty()) {
                this.add(stringArray2[0], stringArray2[1]);
                continue;
            }
            throw new IllegalArgumentException("Failed to parse option from string '" + string2 + "'");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getOptionsString() + ")";
    }

    public String getOptionsString() {
        return this.options.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(";", "", ";"));
    }

    protected abstract void add(long var1, long var3, String var5, String var6) throws OrtException;
}

