/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.code.FactoryMethodMarker;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.MaterializedObjectState;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class OutlineAllocationsPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)structuredGraph.method().getDeclaringClass(), FactoryMethodMarker.class)) {
            return;
        }
        for (MethodCallTargetNode methodCallTargetNode : structuredGraph.getNodes(MethodCallTargetNode.TYPE).snapshot()) {
            if (!methodCallTargetNode.isAlive()) continue;
            OutlineAllocationsPhase.a(structuredGraph, coreProviders, methodCallTargetNode);
        }
    }

    private static boolean a(List<ValueNode> list, ValueNode valueNode) {
        int n2 = 0;
        for (ValueNode valueNode2 : list) {
            if (valueNode2 != valueNode || ++n2 <= 1) continue;
            return false;
        }
        return n2 == 1;
    }

    private static void a(StructuredGraph structuredGraph, CoreProviders coreProviders, MethodCallTargetNode methodCallTargetNode) {
        if (!(methodCallTargetNode.invoke() instanceof InvokeWithExceptionNode)) {
            return;
        }
        InvokeWithExceptionNode invokeWithExceptionNode = (InvokeWithExceptionNode)methodCallTargetNode.invoke();
        if (!methodCallTargetNode.targetMethod().isConstructor() || !(methodCallTargetNode.receiver() instanceof AllocatedObjectNode)) {
            return;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)methodCallTargetNode.targetMethod(), AlwaysInline.class)) {
            return;
        }
        AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)methodCallTargetNode.receiver();
        CommitAllocationNode commitAllocationNode = allocatedObjectNode.getCommit();
        if (commitAllocationNode.next() != invokeWithExceptionNode) {
            return;
        }
        ResolvedJavaType resolvedJavaType = allocatedObjectNode.getVirtualObject().type();
        if (!methodCallTargetNode.targetMethod().getDeclaringClass().equals((Object)resolvedJavaType)) {
            return;
        }
        FrameState frameState = invokeWithExceptionNode.stateAfter();
        if (frameState.stackSize() == 0 || frameState.stackAt(frameState.stackSize() - 1) != allocatedObjectNode.getVirtualObject()) {
            return;
        }
        if (!OutlineAllocationsPhase.a((List<ValueNode>)frameState.values(), (ValueNode)allocatedObjectNode.getVirtualObject())) {
            return;
        }
        boolean bl2 = OutlineAllocationsPhase.a(coreProviders, invokeWithExceptionNode, allocatedObjectNode);
        if (bl2) {
            invokeWithExceptionNode.setStateAfter(frameState.duplicateModified(structuredGraph, frameState.bci, frameState.rethrowException(), frameState.duringCall(), JavaKind.Object, null, null, null, false));
            frameState.safeDelete();
        }
        ResolvedJavaMethod resolvedJavaMethod = FactoryMethodSupport.singleton().lookup((UniverseMetaAccess)coreProviders.getMetaAccess(), methodCallTargetNode.targetMethod(), bl2);
        ValueNode[] valueNodeArray = (ValueNode[])methodCallTargetNode.arguments().toArray((Object[])ValueNode.EMPTY_ARRAY);
        ValueNode[] valueNodeArray2 = Arrays.copyOfRange(valueNodeArray, 1, valueNodeArray.length);
        StampPair stampPair = StampFactory.forDeclaredType((Assumptions)structuredGraph.getAssumptions(), (JavaType)resolvedJavaType, (boolean)true);
        SubstrateMethodCallTargetNode substrateMethodCallTargetNode = (SubstrateMethodCallTargetNode)structuredGraph.add((Node)new SubstrateMethodCallTargetNode(CallTargetNode.InvokeKind.Static, resolvedJavaMethod, valueNodeArray2, stampPair, null, null, null));
        substrateMethodCallTargetNode.setNodeSourcePosition(methodCallTargetNode.getNodeSourcePosition());
        methodCallTargetNode.replaceAtAllUsages((Node)substrateMethodCallTargetNode, true);
        methodCallTargetNode.safeDelete();
        for (MaterializedObjectState materializedObjectState : allocatedObjectNode.usages().filter(MaterializedObjectState.class).snapshot()) {
            VMError.guarantee((materializedObjectState.materializedValue() == allocatedObjectNode ? 1 : 0) != 0);
            block1: for (FrameState frameState2 : materializedObjectState.usages().filter(FrameState.class).snapshot()) {
                for (int i2 = 0; i2 < frameState2.virtualObjectMappingCount(); ++i2) {
                    if (frameState2.virtualObjectMappingAt(i2) != materializedObjectState) continue;
                    frameState2.virtualObjectMappings().remove(i2);
                    frameState2.values().replaceAll(valueNode -> valueNode == allocatedObjectNode.getVirtualObject() ? invokeWithExceptionNode : valueNode);
                    assert (!frameState2.virtualObjectMappings().contains((Node)materializedObjectState)) : "Each MaterializedObjectState must be registered only once in the object mappings";
                    continue block1;
                }
            }
            if (!materializedObjectState.usages().isEmpty()) {
                throw GraalError.shouldNotReachHere((String)("Unexpected usages of MaterializedObjectState: " + String.valueOf(materializedObjectState.usages().first())));
            }
            materializedObjectState.safeDelete();
        }
        if (bl2) {
            assert (invokeWithExceptionNode.getStackKind() == JavaKind.Void);
        } else {
            invokeWithExceptionNode.setStamp(stampPair.getTrustedStamp());
            assert (invokeWithExceptionNode.getStackKind() == JavaKind.Object);
        }
        allocatedObjectNode.replaceAtAllUsages((Node)invokeWithExceptionNode, true);
        allocatedObjectNode.safeDelete();
        if (bl2) {
            GraphUtil.killCFG((FixedNode)invokeWithExceptionNode.next().next());
            assert (invokeWithExceptionNode.next().next() == null);
            invokeWithExceptionNode.next().setNext((FixedNode)structuredGraph.add((Node)new LoweredDeadEndNode()));
        }
    }

    private static boolean a(CoreProviders coreProviders, InvokeWithExceptionNode invokeWithExceptionNode, AllocatedObjectNode allocatedObjectNode) {
        if (!coreProviders.getMetaAccess().lookupJavaType(Throwable.class).isAssignableFrom(allocatedObjectNode.getVirtualObject().type())) {
            return false;
        }
        if (!(invokeWithExceptionNode.next() instanceof BeginNode) || !(invokeWithExceptionNode.next().next() instanceof EndNode)) {
            return false;
        }
        EndNode endNode = (EndNode)invokeWithExceptionNode.next().next();
        if (!(invokeWithExceptionNode.exceptionEdge() instanceof ExceptionObjectNode) || !(invokeWithExceptionNode.exceptionEdge().next() instanceof EndNode)) {
            return false;
        }
        ExceptionObjectNode exceptionObjectNode = (ExceptionObjectNode)invokeWithExceptionNode.exceptionEdge();
        EndNode endNode2 = (EndNode)exceptionObjectNode.next();
        if (endNode.merge() != endNode2.merge()) {
            return false;
        }
        AbstractMergeNode abstractMergeNode = endNode.merge();
        if (abstractMergeNode.phis().count() != 1) {
            return false;
        }
        PhiNode phiNode = (PhiNode)abstractMergeNode.phis().first();
        return phiNode.valueAt((AbstractEndNode)endNode) == allocatedObjectNode && phiNode.valueAt((AbstractEndNode)endNode2) == exceptionObjectNode;
    }

    public static final class a {
        public static final HostedOptionKey<Boolean> OutlineAllocations = new HostedOptionKey((Object)true);
    }
}

