/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.graal;

import com.oracle.graal.duplication.phases.simulation.j;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import java.util.ArrayList;
import java.util.BitSet;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeFlood;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.loop.phases.SpeculativeGuardMovementPhase;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.OpaqueLogicNode;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopFragmentWhole;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.PostRunCanonicalizationPhase;
import org.graalvm.compiler.phases.common.util.OptimizationUtility;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class GuardHoistingLoopDuplicationPhase
extends PostRunCanonicalizationPhase<MidTierContext> {
    private final d fG;

    public GuardHoistingLoopDuplicationPhase(d d2, CanonicalizerPhase canonicalizerPhase) {
        super(canonicalizerPhase);
        this.fG = d2;
    }

    protected void run(StructuredGraph structuredGraph, MidTierContext midTierContext) {
        this.a(structuredGraph, midTierContext);
    }

    private void a(StructuredGraph structuredGraph, MidTierContext midTierContext) {
        if (!structuredGraph.hasLoops()) {
            return;
        }
        if (!this.fG.a(structuredGraph)) {
            return;
        }
        LoopsData loopsData = midTierContext.getLoopsDataProvider().getLoopsData(structuredGraph);
        loopsData.detectCountedLoops();
        ArrayList<b> arrayList = this.a(structuredGraph, loopsData);
        if (arrayList == null) {
            return;
        }
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after duplicating %d loops and floating guards", (Object)arrayList.size());
        loopsData = midTierContext.getLoopsDataProvider().getLoopsData(structuredGraph);
        loopsData.detectCountedLoops();
        boolean bl2 = true;
        SpeculativeGuardMovementPhase.performSpeculativeGuardMovement((MidTierContext)midTierContext, (StructuredGraph)structuredGraph, (LoopsData)loopsData, (boolean)true);
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after base speculative guard movement");
        GuardHoistingLoopDuplicationPhase.a(structuredGraph, arrayList);
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after postprocessing duplicated loops");
    }

    private ArrayList<b> a(StructuredGraph structuredGraph, LoopsData loopsData) {
        ArrayList<b> arrayList = null;
        try (Indent indent = structuredGraph.getDebug().logAndIndent("Consider %s for duplication before speculative guard movement", (Object)structuredGraph.method().format("%h.%n"));){
            for (LoopEx loopEx : loopsData.countedLoops()) {
                FrameState frameState;
                InductionVariable inductionVariable;
                if (!this.fG.a(loopEx, structuredGraph, loopsData) || !(loopEx.counted().getCountedExit() instanceof LoopExitNode) || !(inductionVariable = loopEx.counted().getLimitCheckedIV()).isConstantStride() || !CodeUtil.isPowerOf2((long)Math.abs(inductionVariable.constantStride())) || (frameState = com.oracle.graal.duplication.util.d.e((FixedNode)loopEx.entryPoint())) == null) continue;
                structuredGraph.getDebug().dump(4, (Object)structuredGraph, "before duplicating %s", (Object)loopEx.loopBegin());
                loopEx.loopBegin().getDebug().log("Duplicating loop: %s", (Object)loopEx.loopBegin());
                LoopFragmentWhole loopFragmentWhole = loopEx.whole().duplicate();
                assert (loopEx.entryPoint().predecessor() instanceof FixedWithNextNode);
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)loopEx.entryPoint().predecessor();
                fixedWithNextNode.clearSuccessors();
                AbstractBeginNode abstractBeginNode = BeginNode.begin((FixedNode)loopEx.entryPoint());
                AbstractBeginNode abstractBeginNode2 = BeginNode.begin((FixedNode)loopFragmentWhole.entryPoint());
                LogicNode logicNode = (LogicNode)structuredGraph.addWithoutUnique((Node)new OpaqueLogicNode((LogicNode)LogicConstantNode.contradiction((Graph)structuredGraph)));
                IfNode ifNode = (IfNode)structuredGraph.add((Node)new IfNode(logicNode, abstractBeginNode, abstractBeginNode2, BranchProbabilityNode.ALWAYS_TAKEN_PROFILE));
                fixedWithNextNode.setNext((FixedNode)ifNode);
                b b2 = new b(ifNode, loopEx);
                structuredGraph.getDebug().dump(4, (Object)structuredGraph, "after duplicating %s", (Object)loopEx.loopBegin());
                HIRBlock hIRBlock = loopsData.getCFG().blockFor((Node)loopEx.counted().getBody());
                e e2 = new e(loopEx, b2.fM);
                j.a((ControlFlowGraph)loopsData.getCFG(), (ControlFlowGraph.RecursiveVisitor)e2, (HIRBlock)hIRBlock, (int)0, (int)loopsData.getCFG().getMaxDominatorDepth());
                CountedLoopInfo countedLoopInfo = loopEx.counted();
                if (!countedLoopInfo.counterNeverOverflows()) {
                    LogicNode logicNode2 = loopEx.counted().createOverflowGuardCondition();
                    GuardNode guardNode = (GuardNode)structuredGraph.addWithoutUnique((Node)new GuardNode(logicNode2, (AnchoringNode)AbstractBeginNode.prevBegin((FixedNode)loopEx.entryPoint()), DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.None, true, null, abstractBeginNode.getNodeSourcePosition()));
                    b2.fM.add(0, new a(guardNode, null, null));
                    loopEx.loopBegin().setOverflowGuard((GuardingNode)guardNode);
                    structuredGraph.getDebug().dump(5, (Object)structuredGraph, "After creating overflow guard %s", (Object)guardNode);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<b>();
                }
                arrayList.add(b2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static void a(StructuredGraph structuredGraph, ArrayList<b> arrayList) {
        structuredGraph.getDebug().log("Postprocess %d loop dispatch ifs", arrayList.size());
        for (b b2 : arrayList) {
            double d2;
            boolean bl2;
            IfNode ifNode = b2.fK;
            LogicNode logicNode = ifNode.condition();
            ArrayList<a> arrayList2 = b2.fM;
            if (arrayList2.size() == 0) {
                GraalError.shouldNotReachHere((String)"should only have duplicated this loop if we were going to float guards");
            }
            AbstractBeginNode abstractBeginNode = ifNode.trueSuccessor();
            AbstractBeginNode abstractBeginNode2 = ifNode.falseSuccessor();
            FrameState frameState = com.oracle.graal.duplication.util.d.e((FixedNode)ifNode);
            GraalError.guarantee((frameState != null ? 1 : 0) != 0, (String)"We checked for a valid state before building a descriptor, there should still be one");
            LoopEx loopEx = b2.fL;
            EconomicSet economicSet = EconomicSet.create();
            for (a a2 : arrayList2) {
                GuardNode guardNode = a2.fH;
                if (!loopEx.isOutsideLoop((Node)guardNode.getAnchor().asNode())) continue;
                economicSet.add((Object)guardNode);
            }
            double d3 = (double)economicSet.size() / (double)arrayList2.size();
            boolean bl3 = bl2 = d3 >= (d2 = ((Double)c.fT.getValue(structuredGraph.getOptions())).doubleValue());
            if (OptimizationUtility.hotGlobalSelfTime((StructuredGraph)structuredGraph) && economicSet.size() > 0) {
                bl2 = true;
            }
            structuredGraph.getDebug().log(4, "%s: hoisted %s of %s guards, minimal hoisting fraction %s, should duplicate? %s", (Object)ifNode, (Object)economicSet.size(), (Object)arrayList2.size(), (Object)d2, (Object)bl2);
            if (bl2) {
                void var18_21;
                FixedNode fixedNode = abstractBeginNode.next();
                abstractBeginNode.setNext(null);
                AbstractBeginNode abstractBeginNode3 = abstractBeginNode;
                var19_24 = (MergeNode)structuredGraph.add((Node)new MergeNode());
                ArrayList<IfNode> arrayList3 = new ArrayList<IfNode>();
                for (a a2 : arrayList2) {
                    LogicNode logicNode2;
                    GuardNode guardNode = a2.fH;
                    boolean bl4 = economicSet.contains((Object)guardNode);
                    structuredGraph.getDebug().dump(5, (Object)structuredGraph, "before un-floating %s guard %s", (Object)(bl4 ? "hoisted" : "non-hoisted"), (Object)guardNode);
                    if (bl4) {
                        logicNode2 = guardNode.getCondition();
                        if (guardNode.isNegated()) {
                            logicNode2 = (LogicNode)structuredGraph.addOrUniqueWithInputs((Node)LogicNegationNode.create((LogicNode)logicNode2));
                        }
                        BeginNode beginNode = (BeginNode)structuredGraph.add((Node)new BeginNode());
                        EndNode endNode = (EndNode)structuredGraph.add((Node)new EndNode());
                        var19_24.addForwardEnd(endNode);
                        AbstractBeginNode abstractBeginNode4 = (AbstractBeginNode)structuredGraph.add((Node)new BeginNode());
                        abstractBeginNode4.setNext((FixedNode)endNode);
                        IfNode ifNode2 = (IfNode)structuredGraph.add((Node)new IfNode(logicNode2, (AbstractBeginNode)beginNode, abstractBeginNode4, BranchProbabilityNode.FAST_PATH_PROFILE));
                        guardNode.replaceAtUsagesAndDelete((Node)beginNode);
                        arrayList3.add(ifNode2);
                        var18_21.setNext((FixedNode)ifNode2);
                        BeginNode beginNode2 = beginNode;
                        structuredGraph.getDebug().dump(5, (Object)structuredGraph, "after un-floating guard %s cond %s with new if %s", (Object)guardNode, (Object)logicNode2, (Object)ifNode2);
                        if (a2.fI == null) continue;
                        structuredGraph.removeSplitPropagate((ControlSplitNode)a2.fI, a2.fJ);
                        structuredGraph.getDebug().dump(5, (Object)structuredGraph, "after removing original exception split %s, keeping %s", (Object)a2.fI, (Object)a2.fJ);
                        continue;
                    }
                    logicNode2 = a2.fJ;
                    guardNode.replaceAtUsagesAndDelete((Node)logicNode2);
                    structuredGraph.getDebug().dump(5, (Object)structuredGraph, "after deleting guard %s and rewiring back to %s", (Object)guardNode, (Object)logicNode2);
                }
                var18_21.setNext(fixedNode);
                ifNode.setFalseSuccessor(null);
                var19_24.setNext((FixedNode)abstractBeginNode2);
                structuredGraph.removeSplitPropagate((ControlSplitNode)ifNode, ifNode.trueSuccessor());
                MergeNode.removeMergeIfDegenerated((MergeNode)var19_24);
                if (var19_24.isAlive()) {
                    var19_24.setStateAfter(frameState);
                }
            } else {
                for (a a3 : arrayList2) {
                    var19_24 = a3.fH;
                    var19_24.replaceAtUsagesAndDelete((Node)var19_24.getAnchor().asNode());
                }
                structuredGraph.removeSplitPropagate((ControlSplitNode)ifNode, ifNode.falseSuccessor());
            }
            logicNode.safeDelete();
        }
    }

    public static class d {
        public boolean a(StructuredGraph structuredGraph) {
            return true;
        }

        public boolean a(LoopEx loopEx, StructuredGraph structuredGraph, LoopsData loopsData) {
            int n2;
            int n3;
            assert (loopEx.isCounted());
            DebugContext debugContext = structuredGraph.getDebug();
            if (!loopEx.loop().getChildren().isEmpty()) {
                debugContext.log(4, "don't duplicate %s: not an innermost loop", (Object)loopEx.loopBegin());
                return false;
            }
            double d2 = loopEx.localLoopFrequency() - (double)(!loopEx.counted().isInverted() ? 1 : 0);
            if (SchedulePhase.Instance.compareRelativeFrequencies((double)d2, (double)(n3 = ((Integer)OptimizationUtility.chooseAdaptiveBudgetFactor((StructuredGraph)structuredGraph, c.fP, c.fQ)).intValue())) < 0) {
                debugContext.log(4, "don't duplicate %s: body iterations %s below limit of %s", (Object)loopEx.loopBegin(), (Object)d2, (Object)n3);
                return false;
            }
            double d3 = loopsData.getCFG().blockFor((Node)loopEx.loopBegin()).getRelativeFrequency();
            if (SchedulePhase.Instance.compareRelativeFrequencies((double)d3, (double)1.0) < 0) {
                debugContext.log(4, "don't duplicate %s: relative frequency %f too low", (Object)loopEx.loopBegin(), (Object)d3);
                return false;
            }
            NodeIterable nodeIterable = loopEx.inside().nodes().filter(ThrowBytecodeExceptionNode.class);
            if (nodeIterable.isEmpty()) {
                return false;
            }
            boolean bl2 = false;
            for (ThrowBytecodeExceptionNode throwBytecodeExceptionNode : nodeIterable) {
                Node node = throwBytecodeExceptionNode.predecessor();
                if (!(node instanceof AbstractBeginNode) || !(((AbstractBeginNode)node).predecessor() instanceof IfNode)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                debugContext.log(4, "don't duplicate %s: all bytecode exception throws have an unsupported graph shape", (Object)loopEx.loopBegin());
                return false;
            }
            int n4 = com.oracle.graal.compiler.enterprise.loop.d.c((LoopEx)loopEx);
            int n5 = n4 - d.a(loopEx);
            if (n5 > (n2 = ((Integer)OptimizationUtility.chooseAdaptiveBudgetFactor((StructuredGraph)structuredGraph, c.fR, c.fS)).intValue())) {
                debugContext.log(4, "don't duplicate %s: estimated loop size %d above limit of %d (original loop size %d)", (Object)loopEx.loopBegin(), (Object)n5, (Object)n2, (Object)n4);
                return false;
            }
            return true;
        }

        private static int a(LoopEx loopEx) {
            NodeFlood nodeFlood = new NodeFlood((Graph)loopEx.loopBegin().graph());
            int n2 = 0;
            for (ThrowBytecodeExceptionNode throwBytecodeExceptionNode : loopEx.inside().nodes().filter(ThrowBytecodeExceptionNode.class)) {
                n2 += throwBytecodeExceptionNode.estimatedNodeSize().value;
                nodeFlood.addAll((Iterable)throwBytecodeExceptionNode.inputs());
                Node node = throwBytecodeExceptionNode.predecessor();
                while (node instanceof BeginNode) {
                    node = ((BeginNode)node).predecessor();
                }
                if (!(node instanceof IfNode)) continue;
                IfNode ifNode = (IfNode)node;
                n2 += ifNode.estimatedNodeSize().value;
                nodeFlood.add((Node)ifNode.condition());
            }
            for (ThrowBytecodeExceptionNode throwBytecodeExceptionNode : nodeFlood) {
                if (!throwBytecodeExceptionNode.hasExactlyOneUsage() || loopEx.isOutsideLoop((Node)throwBytecodeExceptionNode)) continue;
                n2 += throwBytecodeExceptionNode.estimatedNodeSize().value;
                nodeFlood.addAll((Iterable)throwBytecodeExceptionNode.inputs());
            }
            return n2;
        }
    }

    private static class b {
        final IfNode fK;
        final LoopEx fL;
        final ArrayList<a> fM;

        b(IfNode ifNode, LoopEx loopEx) {
            this.fK = ifNode;
            this.fL = loopEx;
            this.fM = new ArrayList();
        }
    }

    public static class e
    implements ControlFlowGraph.RecursiveVisitor<Object> {
        private final ArrayList<a> fU;
        private final BitSet fV;
        private final StructuredGraph fW;

        public e(LoopEx loopEx, ArrayList<a> arrayList) {
            this.fU = arrayList;
            this.fV = new BitSet(loopEx.loopsData().getCFG().getBlocks().length);
            for (HIRBlock hIRBlock : loopEx.loop().getBlocks()) {
                this.fV.set(hIRBlock.getId());
            }
            this.fW = loopEx.loopBegin().graph();
        }

        public Object enter(HIRBlock hIRBlock) {
            if (!this.fV.get(hIRBlock.getId())) {
                return null;
            }
            if (!(hIRBlock.getEndNode() instanceof IfNode)) {
                return null;
            }
            IfNode ifNode = (IfNode)hIRBlock.getEndNode();
            AbstractBeginNode abstractBeginNode = null;
            AbstractBeginNode abstractBeginNode2 = null;
            if (ifNode.trueSuccessor().next() instanceof ThrowBytecodeExceptionNode) {
                abstractBeginNode = ifNode.trueSuccessor();
                abstractBeginNode2 = ifNode.falseSuccessor();
            } else if (ifNode.falseSuccessor().next() instanceof ThrowBytecodeExceptionNode) {
                abstractBeginNode = ifNode.falseSuccessor();
                abstractBeginNode2 = ifNode.trueSuccessor();
            } else {
                return null;
            }
            IfNode ifNode2 = (IfNode)abstractBeginNode.predecessor();
            this.fW.getDebug().dump(5, (Object)this.fW, "before floating %s", (Object)ifNode2);
            boolean bl2 = abstractBeginNode == ifNode2.trueSuccessor();
            GuardNode guardNode = (GuardNode)this.fW.addWithoutUnique((Node)new GuardNode(ifNode2.condition(), null, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.None, bl2, null, abstractBeginNode2.getNodeSourcePosition()));
            abstractBeginNode2.replaceAtUsages((Node)guardNode, InputType.Guard);
            guardNode.setAnchor((AnchoringNode)abstractBeginNode2);
            this.fW.getDebug().dump(5, (Object)this.fW, "after floating %s as %s", (Object)ifNode2, (Object)guardNode);
            this.fU.add(new a(guardNode, ifNode2, abstractBeginNode2));
            return null;
        }

        public void exit(HIRBlock hIRBlock, Object object) {
        }
    }

    private static class a {
        final GuardNode fH;
        final IfNode fI;
        final AbstractBeginNode fJ;

        a(GuardNode guardNode, IfNode ifNode, AbstractBeginNode abstractBeginNode) {
            this.fH = guardNode;
            this.fI = ifNode;
            this.fJ = abstractBeginNode;
        }
    }

    public static class c {
        public static final OptionKey<Boolean> fN = new OptionKey((Object)true);
        public static final OptionKey<Long> fO = new OptionKey((Object)1L);
        public static final OptionKey<Integer> fP = new OptionKey((Object)4);
        public static final OptionKey<Integer> fQ = new OptionKey((Object)0);
        public static final OptionKey<Integer> fR = new OptionKey((Object)64);
        public static final OptionKey<Integer> fS = new OptionKey((Object)2048);
        public static final OptionKey<Double> fT = new OptionKey((Object)0.5);
    }
}

