/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.pltgot;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.at;
import com.oracle.svm.enterprise.core.pltgot.e;
import com.oracle.svm.enterprise.core.pltgot.f;
import com.oracle.svm.enterprise.core.pltgot.g;
import com.oracle.svm.enterprise.hosted.code.pltgot.amd64.a;
import com.oracle.svm.enterprise.hosted.code.pltgot.c;
import com.oracle.svm.enterprise.hosted.code.pltgot.d;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.DynamicMethodAddressResolutionHostedSupport;
import com.oracle.svm.hosted.image.MethodPointerRelocationProvider;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

public class b
implements InternalFeature {
    public static final SectionName rx = new SectionName.ProgbitsSectionName("svm_got");
    private final com.oracle.svm.enterprise.core.pltgot.b ry = new com.oracle.svm.enterprise.core.pltgot.b();
    private final d rz = new d();
    private Method rA;
    private HostedMethod rB;
    private f rC;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return (Boolean)com.oracle.svm.enterprise.core.graal.pltgot.c.EnablePLTGOT.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        VMError.guarantee((Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class) ? 1 : 0) != 0, (String)"PLT and GOT is currently only supported on Linux and Darwin.");
        VMError.guarantee((Platform.includedIn(Platform.AARCH64.class) || Platform.includedIn(Platform.AMD64.class) ? 1 : 0) != 0, (String)"PLT and GOT is currently only supported on AArch64 and AMD64.");
        VMError.guarantee((!RuntimeCompilation.isEnabled() ? 1 : 0) != 0, (String)"PLT and GOT is currently not supported with runtime compilation.");
        VMError.guarantee((!DeoptimizationSupport.enabled() ? 1 : 0) != 0, (String)"PLT and GOT is currently not supported with deoptimization.");
        VMError.guarantee((boolean)((Boolean)SubstrateOptions.SpawnIsolates.getValue()), (String)"PLT and GOT cannot work without isolates.");
        VMError.guarantee(((Boolean)at.ProtectionKeys.getValue() == false ? 1 : 0) != 0, (String)"PLT and GOT cannot work with MPK.");
        VMError.guarantee((boolean)"lir".equals(SubstrateOptions.CompilerBackend.getValue()), (String)"PLT and GOT cannot work with a custom compiler backend.");
        ImageSingletons.add(com.oracle.svm.enterprise.core.pltgot.b.class, (Object)this.ry);
        ImageSingletons.add(DynamicMethodAddressResolutionHostedSupport.class, this::b);
        if (Platform.includedIn(Platform.AMD64.class)) {
            this.rz.a(new a(this.rz));
        } else if (Platform.includedIn(Platform.AARCH64.class)) {
            this.rz.a(new com.oracle.svm.enterprise.hosted.code.pltgot.aarch64.a(this.rz));
        }
    }

    public void duringSetup(Feature.DuringSetupAccess duringSetupAccess) {
        this.rC = (f)ImageSingletons.lookup(f.class);
        ImageSingletons.add(g.class, (Object)this.rC.aS());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        ImageSingletons.add(MethodPointerRelocationProvider.class, (Object)((Object)new c(this.rC::i, this.rz)));
        this.rA = ReflectionUtil.lookupMethod(e.class, (String)"resolveMethodAddress", (Class[])new Class[]{Long.TYPE});
        ((FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess).registerAsRoot((Executable)this.rA, false, "PLT GOT support, registered in " + String.valueOf(b.class), new MultiMethod.MultiMethodKey[0]);
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        this.rB = ((FeatureImpl.AfterCompilationAccessImpl)afterCompilationAccess).getMetaAccess().lookupJavaMethod((Executable)this.rA);
        for (HostedMethod hostedMethod : ((FeatureImpl.AfterCompilationAccessImpl)afterCompilationAccess).getCompilations().keySet()) {
            if (!this.rC.i((SharedMethod)hostedMethod)) continue;
            this.ry.g((SharedMethod)hostedMethod);
        }
        this.ry.aL();
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess beforeImageWriteAccess) {
        this.rz.s(this.rB);
    }

    public void b(ObjectFile objectFile) {
        SharedMethod[] sharedMethodArray = this.ry.aM();
        this.rz.a(sharedMethodArray, objectFile);
        b.a(sharedMethodArray, objectFile, this.rz);
        this.rC.a(objectFile);
    }

    public static void a(SharedMethod[] sharedMethodArray, ObjectFile objectFile, d d2) {
        int n2 = ConfigurationValues.getTarget().wordSize;
        int n3 = sharedMethodArray.length * n2;
        RelocatableBuffer relocatableBuffer = new RelocatableBuffer((long)n3, objectFile.getByteOrder());
        BasicProgbitsSectionImpl basicProgbitsSectionImpl = new BasicProgbitsSectionImpl(relocatableBuffer.getBackingArray());
        String string = rx.getFormatDependentName(objectFile.getFormat());
        ObjectFile.Section section = objectFile.newProgbitsSection(string, objectFile.getPageSize(), true, false, (ObjectFile.ProgbitsSectionImpl)basicProgbitsSectionImpl);
        ObjectFile.RelocationKind relocationKind = ObjectFile.RelocationKind.getDirect((int)n2);
        for (int i2 = 0; i2 < sharedMethodArray.length; ++i2) {
            int n4 = n3 + com.oracle.svm.enterprise.core.pltgot.a.k(i2);
            d2.a((ObjectFile.ProgbitsSectionImpl)basicProgbitsSectionImpl, n4, relocationKind, sharedMethodArray[i2], true);
        }
        objectFile.createDefinedSymbol(section.getName(), (ObjectFile.Element)section, 0L, 0, false, false);
        objectFile.createDefinedSymbol("__svm_got_begin", (ObjectFile.Element)section, 0L, n2, false, ((Boolean)SubstrateOptions.InternalSymbolsAreGlobal.getValue()).booleanValue());
        objectFile.createDefinedSymbol("__svm_got_end", (ObjectFile.Element)section, (long)n3, n2, false, ((Boolean)SubstrateOptions.InternalSymbolsAreGlobal.getValue()).booleanValue());
        if (((Boolean)com.oracle.svm.enterprise.core.graal.pltgot.c.PrintGOT.getValue()).booleanValue()) {
            ReportUtils.report((String)"GOT Section contents", (String)SubstrateOptions.reportsPath(), (String)"got", (String)"txt", printWriter -> {
                printWriter.println("GOT Entry No | GOT Entry Offset From Image Heap Register | Method Name");
                for (int i2 = 0; i2 < sharedMethodArray.length; ++i2) {
                    printWriter.printf("%5X %5X %s%n", i2, -com.oracle.svm.enterprise.core.pltgot.a.k(i2), sharedMethodArray[i2].toString());
                }
            });
        }
    }
}

