/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.profiles;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.profiling.PGOProfiling;
import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.m;
import com.oracle.svm.enterprise.profiling.data.n;
import com.oracle.svm.enterprise.profiling.loaders.ProfilingLoader;
import com.oracle.svm.enterprise.profiling.metadata.a;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.path.ProfilingPathProfilePhase;
import com.oracle.svm.enterprise.profiling.path.f;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingBaseProfile;
import com.oracle.svm.util.LogUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ProfilingRuntimeProfile
extends ProfilingBaseProfile {
    public static final String PROFILES_DUMP_FILE_EXTENSION = ".iprof";
    public static final String DEFAULT_PROFILE_DUMP_FILE = "default.iprof";
    private final Lock dumpLock = new ReentrantLock();
    private ScheduledExecutorService periodicDumpingExecutor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ProfilingRuntimeProfile() {
        this.profilingData = new n();
    }

    @Fold
    public static ProfilingRuntimeProfile instance() {
        return (ProfilingRuntimeProfile)ImageSingletons.lookup(ProfilingRuntimeProfile.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static b metadataBuilder() {
        return (b)ImageSingletons.lookup(b.class);
    }

    @Fold
    public n data() {
        return (n)this.profilingData;
    }

    @Fold
    public a metadata() {
        return this.profilingMetadata;
    }

    @Override
    public void dump(OutputStream outputStream) throws IOException {
        if (((Boolean)ProfilingPathProfilePhase.a.ProfilingEnablePathProfiling.getValue()).booleanValue()) {
            f f2 = this.data().pathProfilingInstrumentation();
            if (((Boolean)ProfilingPathProfilePhase.a.ProfilingPathProfilingVerify.getValue()).booleanValue()) {
                try (DebugContext debugContext = DebugContext.forCurrentThread();){
                    debugContext.log(f2.hE());
                }
            } else {
                f2.d(DebugContext.forCurrentThread());
            }
        }
        super.dump(outputStream);
    }

    @Override
    public ProfilingBaseProfile merge(ProfilingBaseProfile profilingBaseProfile) {
        throw VMError.shouldNotReachHere((String)"Operation is not permitted for instrumentation profile.");
    }

    @Override
    public ProfilingBaseProfile normalize(long l2) {
        throw VMError.shouldNotReachHere((String)"Operation is not permitted for instrumentation profile.");
    }

    @Override
    protected ProfilingBaseProfile newInstance(a a2, m m2) {
        throw VMError.shouldNotReachHere((String)"There is only once instance of instrumentation profile.");
    }

    @Override
    protected <T, M> a buildMetadata(ProfilingLoader<T, M> profilingLoader, e e2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2) {
        throw VMError.shouldNotReachHere((String)"Operation is not permitted for instrumentation profile.");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void reset() {
        this.data().reset();
        ProfilingRuntimeProfile.metadataBuilder().reset();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMetadata(a a2) {
        this.profilingMetadata = a2;
    }

    public RuntimeSupport.Hook dumpShutdownHook() {
        return bl2 -> {
            if (!bl2) {
                return;
            }
            if (this.periodicDumpingExecutor != null) {
                try {
                    this.dumpLock.lock();
                    this.periodicDumpingExecutor.shutdownNow();
                }
                finally {
                    this.dumpLock.unlock();
                }
            }
            ProfilingRuntimeProfile.dump();
        };
    }

    public RuntimeSupport.Hook dumpStartupHook() {
        return bl2 -> {
            if (!bl2) {
                return;
            }
            Integer n2 = (Integer)Options.ProfilingDumpPeriod.getValue();
            if (n2 == -1) {
                return;
            }
            if (n2 <= 0) {
                VMError.shouldNotReachHere((String)"PGO capture period length should be greater than zero. Will not schedule periodic capture");
            }
            this.periodicDumpingExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("PGOPeriodicDumper");
                return thread;
            });
            this.periodicDumpingExecutor.scheduleAtFixedRate(() -> {
                try {
                    this.dumpLock.lock();
                    ProfilingRuntimeProfile.dump();
                }
                finally {
                    this.dumpLock.unlock();
                }
            }, n2.intValue(), n2.intValue(), TimeUnit.SECONDS);
        };
    }

    private static void dump() {
        Path path = ProfilingRuntimeProfile.getPath();
        long l2 = System.nanoTime();
        String string = String.format("profile-%d", l2);
        try {
            Path path2 = Files.createTempFile(path.getParent(), string, PROFILES_DUMP_FILE_EXTENSION, new FileAttribute[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(path2.toFile());){
                PGOProfiling.dump(fileOutputStream);
            }
            ProfilingRuntimeProfile.tryAtomicMove(path2, path);
        }
        catch (Exception exception) {
            throw VMError.shouldNotReachHere((String)"Error during profile writing", (Throwable)exception);
        }
        finally {
            long l3 = System.nanoTime();
            if (((Boolean)Options.ProfilingDumpVerbose.getValue()).booleanValue()) {
                System.err.println("[dumped profile to " + String.valueOf(path) + " in " + TimeUnit.NANOSECONDS.toMillis(l3 - l2) + " ms]");
            }
        }
    }

    private static Path getPath() {
        Path path = Paths.get((String)Options.ProfilesDumpFile.getValue(), new String[0]).toAbsolutePath();
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            throw VMError.shouldNotReachHere((String)("Profile dump path is a directory: " + String.valueOf(path.toAbsolutePath()) + ". Please be sure that profile points to a file."));
        }
        if (path.getParent() == null || !Files.exists(path.getParent(), new LinkOption[0])) {
            throw VMError.shouldNotReachHere((String)("Directory " + String.valueOf(path.toAbsolutePath()) + " does not exist. Please be sure that the profile dump path is correct."));
        }
        return path;
    }

    private static void tryAtomicMove(Path path, Path path2) throws IOException {
        try {
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            LogUtils.warning((String)("Could not move temporary PGO profile (" + String.valueOf(path.toAbsolutePath()) + ") to (" + String.valueOf(path2.toAbsolutePath()) + ") atomically. This might result in inconsistencies while reading the file."));
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    static class Options {
        static final RuntimeOptionKey<String> ProfilesDumpFile = new RuntimeOptionKey((Object)"default.iprof", new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        static final RuntimeOptionKey<Integer> ProfilingDumpPeriod = new RuntimeOptionKey((Object)-1, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        static final RuntimeOptionKey<Boolean> ProfilingDumpVerbose = new RuntimeOptionKey((Object)Boolean.FALSE, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);

        Options() {
        }
    }
}

