/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import com.oracle.jipher.pki.internal.AlgIdException;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class AlgorithmId {
    private String alg;
    private String shortAlg;
    private AlgorithmParameterSpec paramSpec;
    private static Map<String, Decoder> decoderMap = new HashMap<String, Decoder>();
    private static Map<String, Encoder> encoderMap = new HashMap<String, Encoder>();

    public static AlgorithmId decode(Asn1BerValue value) throws AlgIdException {
        try {
            Iterator<Asn1BerValue> algIdIter = value.tag(UniversalTag.SEQUENCE).count(1, 2).sequence().iterator();
            String oid = algIdIter.next().tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
            Asn1BerValue params = algIdIter.hasNext() ? algIdIter.next() : null;
            Decoder decoder = decoderMap.get(oid);
            if (decoder == null) {
                if (params != null) {
                    params.tag(UniversalTag.NULL).getNull();
                }
                return new AlgorithmId(oid);
            }
            return decoder.handle(params);
        }
        catch (Asn1Exception e) {
            throw new AlgIdException("Error decoding AlgorithmId");
        }
    }

    public static AlgorithmId newInstance(String alg) {
        return new AlgorithmId(alg);
    }

    private AlgorithmId(String alg) {
        this(alg, alg, null);
    }

    AlgorithmId(String alg, AlgorithmParameterSpec params) {
        this(alg, alg, params);
    }

    private AlgorithmId(String alg, String shortAlg, AlgorithmParameterSpec params) {
        this.alg = alg;
        this.shortAlg = shortAlg;
        this.paramSpec = params;
    }

    void updateParams(AlgorithmParameterSpec spec) {
        this.paramSpec = spec;
    }

    public String getAlg() {
        return this.alg;
    }

    String getShortAlg() {
        return this.shortAlg;
    }

    AlgorithmParameterSpec getParameterSpec() {
        return this.paramSpec;
    }

    public Asn1BerValue toAsn1Value() throws AlgIdException {
        Encoder encoder = encoderMap.get(this.alg.toUpperCase());
        if (encoder == null) {
            throw new AlgIdException("Could not encode, unsupported algorithm " + this.alg);
        }
        return encoder.handle(this.alg, this.paramSpec);
    }

    private static Encoder newAlgIdEncoder(String algOid) {
        return (alg, spec) -> Asn1.newSequence(Asn1.newOid(algOid));
    }

    private static Encoder newAlgIdEncoder(String algOid, Encoder paramsEncoder) {
        return (alg, spec) -> Asn1.newSequence(Asn1.newOid(algOid), paramsEncoder.handle(alg, spec));
    }

    private static Decoder newIvDecoder(String alg, String shortAlg) {
        return ber -> {
            if (ber == null) {
                throw new AlgIdException("Expected IV algorithm parameters not present.");
            }
            byte[] iv = ber.tag(UniversalTag.OCTET_STRING).getOctetString();
            return new AlgorithmId(alg, shortAlg, new IvParameterSpec(iv));
        };
    }

    private static Decoder newNullParamsDecoder(String alg, String shortAlg) {
        return ber -> {
            if (ber != null) {
                ber.tag(UniversalTag.NULL).getNull();
            }
            return new AlgorithmId(alg, shortAlg, null);
        };
    }

    private static Decoder newNullParamsDecoder(String alg) {
        return AlgorithmId.newNullParamsDecoder(alg, alg);
    }

    private static Decoder newPbeP12Decoder(String alg) {
        return ber -> {
            if (ber == null) {
                throw new AlgIdException("Expected PBE algorithm parameters not present.");
            }
            List<Asn1BerValue> paramVals = ber.tag(UniversalTag.SEQUENCE).count(2).sequence();
            byte[] salt = paramVals.get(0).tag(UniversalTag.OCTET_STRING).getOctetString();
            int iterCount = paramVals.get(1).tag(UniversalTag.INTEGER).getInteger().intValueExact();
            return new AlgorithmId(alg, new PBEParameterSpec(salt, iterCount));
        };
    }

    private static Decoder newPbes2Decoder() {
        return ber -> {
            if (ber == null) {
                throw new AlgIdException("Expected PBE algorithm parameters not present.");
            }
            List<Asn1BerValue> pbes2Params = ber.tag(UniversalTag.SEQUENCE).count(2).sequence();
            AlgorithmId kdfAlgId = null;
            AlgorithmId encAlgId = null;
            try {
                kdfAlgId = AlgorithmId.decode(pbes2Params.get(0));
                encAlgId = AlgorithmId.decode(pbes2Params.get(1));
            }
            catch (AlgIdException e) {
                Asn1BerValue p = pbes2Params.get(0);
                if (p.hasTag(UniversalTag.OBJECT_IDENTIFIER) && p.getOid().equals("1.2.840.113549.1.5.13")) {
                    pbes2Params = pbes2Params.get(1).tag(UniversalTag.SEQUENCE).count(2).sequence();
                    kdfAlgId = AlgorithmId.decode(pbes2Params.get(0));
                    encAlgId = AlgorithmId.decode(pbes2Params.get(1));
                }
                throw e;
            }
            if (!pbes2Params.get(0).sequence().get(0).getOid().equals("1.2.840.113549.1.5.12")) {
                throw new AlgIdException("Unexpected KDF algorithmId");
            }
            PBEParameterSpec kdfSpec = (PBEParameterSpec)kdfAlgId.getParameterSpec();
            return new AlgorithmId(kdfAlgId.getAlg() + "And" + encAlgId.getShortAlg(), new PBEParameterSpec(kdfSpec.getSalt(), kdfSpec.getIterationCount(), encAlgId.getParameterSpec()));
        };
    }

    private static Decoder newPbkdf2Decoder() {
        return ber -> {
            Asn1BerValue prf;
            if (ber == null) {
                throw new AlgIdException("Expected PBE algorithm parameters not present.");
            }
            Iterator<Asn1BerValue> paramIter = ber.tag(UniversalTag.SEQUENCE).count(2, 4).sequence().iterator();
            byte[] salt = paramIter.next().tag(UniversalTag.OCTET_STRING).getOctetString();
            int iterCount = paramIter.next().tag(UniversalTag.INTEGER).getInteger().intValueExact();
            String hmacAlg = "HMACSHA1";
            Asn1BerValue next = paramIter.hasNext() ? paramIter.next() : null;
            Asn1BerValue asn1BerValue = prf = paramIter.hasNext() ? paramIter.next() : null;
            if (prf != null || next != null && next.hasTag(UniversalTag.INTEGER)) {
                next.tag(UniversalTag.INTEGER).getInteger();
            } else {
                prf = next;
            }
            if (prf != null) {
                AlgorithmId hmacAlgId = AlgorithmId.decode(prf);
                if (hmacAlgId.getAlg().startsWith("HMAC")) {
                    hmacAlg = hmacAlgId.getAlg();
                } else {
                    throw new AlgIdException("Unknown algorithm for prf.");
                }
            }
            return new AlgorithmId("PBEWith" + hmacAlg, new PBEParameterSpec(salt, iterCount));
        };
    }

    private static Encoder newPbeP12Encoder() {
        return (alg, spec) -> {
            if (!(spec instanceof PBEParameterSpec)) {
                throw new AlgIdException("Invalid parameters for " + alg);
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)spec;
            return Asn1.newSequence(Asn1.newOctetString(pbeSpec.getSalt()), Asn1.newInteger(pbeSpec.getIterationCount()));
        };
    }

    private static Encoder newPbes2Encoder() {
        return (alg, spec) -> {
            if (!(spec instanceof PBEParameterSpec)) {
                throw new AlgIdException("Invalid parameters for " + alg);
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)spec;
            if (!(pbeSpec.getParameterSpec() instanceof IvParameterSpec)) {
                throw new AlgIdException("Expected IvParameters for PBE alg " + alg);
            }
            return Asn1.newSequence(Asn1.newSequence(Asn1.newOid("1.2.840.113549.1.5.12"), Asn1.newSequence(Asn1.newOctetString(pbeSpec.getSalt()), Asn1.newInteger(pbeSpec.getIterationCount()), Asn1.newInteger(AlgorithmId.pbes2KeySize(alg)), Asn1.newSequence(Asn1.newOid(AlgorithmId.pbes2HmacOid(alg)), Asn1.newNull()))), Asn1.newSequence(Asn1.newOid(AlgorithmId.pbes2SymAlgOid(alg)), Asn1.newOctetString(((IvParameterSpec)pbeSpec.getParameterSpec()).getIV())));
        };
    }

    private static int pbes2KeySize(String alg) {
        if (alg.endsWith("AES_128")) {
            return 16;
        }
        return 32;
    }

    private static String pbes2SymAlgOid(String alg) {
        if (alg.endsWith("AES_128")) {
            return "2.16.840.1.101.3.4.1.2";
        }
        return "2.16.840.1.101.3.4.1.42";
    }

    private static String pbes2HmacOid(String alg) {
        if (alg.toUpperCase().startsWith("PBEWITHHMACSHA224")) {
            return "1.2.840.113549.2.8";
        }
        if (alg.toUpperCase().startsWith("PBEWITHHMACSHA256")) {
            return "1.2.840.113549.2.9";
        }
        if (alg.toUpperCase().startsWith("PBEWITHHMACSHA384")) {
            return "1.2.840.113549.2.10";
        }
        if (alg.toUpperCase().startsWith("PBEWITHHMACSHA512")) {
            return "1.2.840.113549.2.11";
        }
        return "1.2.840.113549.2.7";
    }

    static {
        decoderMap.put("1.2.840.10045.2.1", ber -> new AlgorithmId("EC"));
        decoderMap.put("1.2.840.10040.4.1", ber -> new AlgorithmId("DSA"));
        decoderMap.put("1.2.840.113549.1.1.1", ber -> new AlgorithmId("RSA"));
        decoderMap.put("1.3.14.3.2.26", AlgorithmId.newNullParamsDecoder("SHA-1", "SHA1"));
        decoderMap.put("2.16.840.1.101.3.4.2.4", AlgorithmId.newNullParamsDecoder("SHA-224", "SHA224"));
        decoderMap.put("2.16.840.1.101.3.4.2.1", AlgorithmId.newNullParamsDecoder("SHA-256", "SHA256"));
        decoderMap.put("2.16.840.1.101.3.4.2.2", AlgorithmId.newNullParamsDecoder("SHA-384", "SHA384"));
        decoderMap.put("2.16.840.1.101.3.4.2.3", AlgorithmId.newNullParamsDecoder("SHA-512", "SHA512"));
        decoderMap.put("1.2.840.113549.2.7", AlgorithmId.newNullParamsDecoder("HMACSHA1"));
        decoderMap.put("1.2.840.113549.2.8", AlgorithmId.newNullParamsDecoder("HMACSHA224"));
        decoderMap.put("1.2.840.113549.2.9", AlgorithmId.newNullParamsDecoder("HMACSHA256"));
        decoderMap.put("1.2.840.113549.2.10", AlgorithmId.newNullParamsDecoder("HMACSHA384"));
        decoderMap.put("1.2.840.113549.2.11", AlgorithmId.newNullParamsDecoder("HMACSHA512"));
        decoderMap.put("1.2.840.113549.1.12.1.3", AlgorithmId.newPbeP12Decoder("OID.1.2.840.113549.1.12.1.3"));
        decoderMap.put("1.2.840.113549.1.12.1.6", AlgorithmId.newPbeP12Decoder("OID.1.2.840.113549.1.12.1.6"));
        decoderMap.put("1.2.840.113549.1.12.1.5", AlgorithmId.newPbeP12Decoder("PBEWithSHA1AndRC2_128"));
        decoderMap.put("1.2.840.113549.1.12.1.2", AlgorithmId.newPbeP12Decoder("PBEWithSHA1AndRC4_40"));
        decoderMap.put("1.2.840.113549.1.12.1.1", AlgorithmId.newPbeP12Decoder("PBEWithSHA1AndRC4_128"));
        decoderMap.put("2.16.840.1.101.3.4.1", AlgorithmId.newNullParamsDecoder("AES"));
        decoderMap.put("2.16.840.1.101.3.4.1.2", AlgorithmId.newIvDecoder("AES128/CBC/PKCS5Padding", "AES_128"));
        decoderMap.put("2.16.840.1.101.3.4.1.42", AlgorithmId.newIvDecoder("AES256/CBC/PKCS5Padding", "AES_256"));
        decoderMap.put("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Decoder());
        decoderMap.put("1.2.840.113549.1.5.12", AlgorithmId.newPbkdf2Decoder());
        encoderMap.put("OID.1.2.840.113549.1.12.1.3", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.12.1.3", AlgorithmId.newPbeP12Encoder()));
        encoderMap.put("OID.1.2.840.113549.1.12.1.6", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.12.1.6", AlgorithmId.newPbeP12Encoder()));
        encoderMap.put("PBEWITHHMACSHA1ANDAES_128", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA224ANDAES_128", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA256ANDAES_128", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA384ANDAES_128", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA512ANDAES_128", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA1ANDAES_256", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA224ANDAES_256", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA256ANDAES_256", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA384ANDAES_256", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("PBEWITHHMACSHA512ANDAES_256", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.5.13", AlgorithmId.newPbes2Encoder()));
        encoderMap.put("SHA1WITHRSA", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.1.5", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA224WITHRSA", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.1.14", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA256WITHRSA", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.1.11", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA384WITHRSA", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.1.12", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA512WITHRSA", AlgorithmId.newAlgIdEncoder("1.2.840.113549.1.1.13", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA1WITHECDSA", AlgorithmId.newAlgIdEncoder("1.2.840.10045.4.1"));
        encoderMap.put("SHA224WITHECDSA", AlgorithmId.newAlgIdEncoder("1.2.840.10045.4.3.1"));
        encoderMap.put("SHA256WITHECDSA", AlgorithmId.newAlgIdEncoder("1.2.840.10045.4.3.2"));
        encoderMap.put("SHA384WITHECDSA", AlgorithmId.newAlgIdEncoder("1.2.840.10045.4.3.3"));
        encoderMap.put("SHA512WITHECDSA", AlgorithmId.newAlgIdEncoder("1.2.840.10045.4.3.4"));
        encoderMap.put("SHA1WITHDSA", AlgorithmId.newAlgIdEncoder("1.2.840.10040.4.3"));
        encoderMap.put("SHA224WITHDSA", AlgorithmId.newAlgIdEncoder("2.16.840.1.101.3.4.3.1"));
        encoderMap.put("SHA256WITHDSA", AlgorithmId.newAlgIdEncoder("2.16.840.1.101.3.4.3.2"));
        encoderMap.put("SHA-1", AlgorithmId.newAlgIdEncoder("1.3.14.3.2.26", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA-224", AlgorithmId.newAlgIdEncoder("2.16.840.1.101.3.4.2.4", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA-256", AlgorithmId.newAlgIdEncoder("2.16.840.1.101.3.4.2.1", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA-384", AlgorithmId.newAlgIdEncoder("2.16.840.1.101.3.4.2.2", (alg, spec) -> Asn1.newNull()));
        encoderMap.put("SHA-512", AlgorithmId.newAlgIdEncoder("2.16.840.1.101.3.4.2.3", (alg, spec) -> Asn1.newNull()));
    }

    static interface Decoder {
        public AlgorithmId handle(Asn1BerValue var1) throws AlgIdException;
    }

    static interface Encoder {
        public Asn1BerValue handle(String var1, AlgorithmParameterSpec var2) throws AlgIdException;
    }
}

