/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PKCS12Attribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class P12Attributes {
    private static final String OID_ATTR_FRIENDLYNAME = "1.2.840.113549.1.9.20";
    private static final String OID_ATTR_LOCALKEYID = "1.2.840.113549.1.9.21";
    private static final String OID_ATTR_TRUSTEDKEYUSAGE = "2.16.840.1.113894.746875.1.1";
    private static final String OID_ANY_USAGE = "2.5.29.37.0";
    private Map<String, Asn1BerValue> bagAttrs;

    private P12Attributes(Map<String, Asn1BerValue> bagAttrs) {
        this.bagAttrs = bagAttrs;
    }

    void setFriendlyName(String friendlyName) {
        this.bagAttrs.put(OID_ATTR_FRIENDLYNAME, Asn1.newSet(Asn1.newRcs(friendlyName, UniversalTag.BMPString)));
    }

    String getFriendlyName() {
        if (!this.bagAttrs.containsKey(OID_ATTR_FRIENDLYNAME)) {
            return null;
        }
        return this.bagAttrs.get(OID_ATTR_FRIENDLYNAME).set().get(0).getRcs(UniversalTag.BMPString);
    }

    byte[] getLocalKeyId() {
        if (!this.bagAttrs.containsKey(OID_ATTR_LOCALKEYID)) {
            return null;
        }
        return this.bagAttrs.get(OID_ATTR_LOCALKEYID).set().get(0).getOctetString();
    }

    boolean hasTrustAttr() {
        return this.bagAttrs.containsKey(OID_ATTR_TRUSTEDKEYUSAGE);
    }

    Asn1BerValue toAsn1Value() {
        ArrayList<Asn1BerValue> attrList = new ArrayList<Asn1BerValue>();
        for (Map.Entry<String, Asn1BerValue> at : this.bagAttrs.entrySet()) {
            attrList.add(this.attributeToValue(at));
        }
        return Asn1.newSetOf(attrList);
    }

    Set<KeyStore.Entry.Attribute> toAttributeSet() {
        HashSet<KeyStore.Entry.Attribute> set = new HashSet<KeyStore.Entry.Attribute>();
        for (Map.Entry<String, Asn1BerValue> at : this.bagAttrs.entrySet()) {
            Asn1BerValue p12Attribute = this.attributeToValue(at);
            set.add(new PKCS12Attribute(p12Attribute.encodeDerOctets()));
        }
        return set;
    }

    void addTrustedUsage() {
        this.bagAttrs.put(OID_ATTR_TRUSTEDKEYUSAGE, Asn1.newSetOf(Asn1.newOid(OID_ANY_USAGE)));
    }

    void addAttributes(Set<KeyStore.Entry.Attribute> attrs) throws KeyStoreException {
        for (KeyStore.Entry.Attribute a : attrs) {
            if (!(a instanceof PKCS12Attribute)) {
                throw new KeyStoreException("Invalid attribute, expected to be PKCS12Attribute");
            }
            PKCS12Attribute attr = (PKCS12Attribute)a;
            if (a.getName().equals(OID_ATTR_FRIENDLYNAME) || a.getName().equals(OID_ATTR_LOCALKEYID) || a.getName().equals(OID_ATTR_TRUSTEDKEYUSAGE)) continue;
            Asn1BerValue attrAsn1 = Asn1.decodeOne(attr.getEncoded());
            List<Asn1BerValue> val = attrAsn1.count(2).tag(UniversalTag.SEQUENCE).sequence();
            this.bagAttrs.put(val.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid(), val.get(1));
        }
    }

    static P12Attributes create() {
        return new P12Attributes(new LinkedHashMap<String, Asn1BerValue>());
    }

    static P12Attributes create(String friendlyName, byte[] localKeyId) {
        LinkedHashMap<String, Asn1BerValue> attrMap = new LinkedHashMap<String, Asn1BerValue>();
        attrMap.put(OID_ATTR_FRIENDLYNAME, Asn1.newSetOf(Asn1.newRcs(friendlyName, UniversalTag.BMPString)));
        if (localKeyId != null) {
            attrMap.put(OID_ATTR_LOCALKEYID, Asn1.newSetOf(Asn1.newOctetString(localKeyId)));
        }
        return new P12Attributes(attrMap);
    }

    static P12Attributes load(Asn1BerValue val) {
        LinkedHashMap<String, Asn1BerValue> attrMap = new LinkedHashMap<String, Asn1BerValue>();
        List<Asn1BerValue> attrs = val.tag(UniversalTag.SET).set();
        for (Asn1BerValue attr : attrs) {
            List<Asn1BerValue> attrContent = attr.tag(UniversalTag.SEQUENCE).count(2).sequence();
            String oid = attrContent.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
            if (oid.equals(OID_ATTR_FRIENDLYNAME) || oid.equals(OID_ATTR_LOCALKEYID)) {
                List<Asn1BerValue> attrValues = attrContent.get(1).tag(UniversalTag.SET).count(1).set();
                if (oid.equals(OID_ATTR_FRIENDLYNAME)) {
                    attrValues.get(0).tag(UniversalTag.BMPString);
                } else {
                    attrValues.get(0).tag(UniversalTag.OCTET_STRING);
                }
                attrMap.put(oid, attrContent.get(1));
                continue;
            }
            if (oid.equals(OID_ATTR_TRUSTEDKEYUSAGE)) {
                List<Asn1BerValue> usageOids = attrContent.get(1).tag(UniversalTag.SET).set();
                for (Asn1BerValue uOid : usageOids) {
                    uOid.tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
                }
                attrMap.put(oid, attrContent.get(1));
                continue;
            }
            attrMap.put(oid, attrContent.get(1));
        }
        return new P12Attributes(attrMap);
    }

    private Asn1BerValue attributeToValue(Map.Entry<String, Asn1BerValue> at) {
        return Asn1.newSequence(Asn1.newOid(at.getKey()), at.getValue());
    }
}

