/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import com.oracle.jipher.pki.internal.AlgIdException;
import com.oracle.jipher.pki.internal.AlgorithmId;
import com.oracle.jipher.pki.internal.Debug;
import com.oracle.jipher.pki.internal.P12Attributes;
import com.oracle.jipher.pki.internal.P12Entry;
import com.oracle.jipher.pki.internal.RandBytes;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.x500.X500Principal;

public class Pkcs12KeyStoreSpi
extends KeyStoreSpi {
    private static final String DEFAULT_ENC_ALG = "PBEWithHmacSHA256AndAES_128";
    private static final int DEFAULT_ENC_SALT_LEN = 20;
    private static final int DEFAULT_ENC_IV_LEN = 16;
    private static final int DEFAULT_ENC_ITER_COUNT = 50000;
    private static final int DEFAULT_MAC_ITER_COUNT = 100000;
    private static final String OID_CONTENT_TYPE_DATA = "1.2.840.113549.1.7.1";
    private static final String OID_CONTENT_TYPE_ENCRYPTED_DATA = "1.2.840.113549.1.7.6";
    private static final String OID_SAFEBAG_TYPE_KEY = "1.2.840.113549.1.12.10.1.1";
    private static final String OID_SAFEBAG_TYPE_SHROUDEDKEY = "1.2.840.113549.1.12.10.1.2";
    private static final String OID_SAFEBAG_TYPE_CERT = "1.2.840.113549.1.12.10.1.3";
    private static final String OID_SAFEBAG_TYPE_SECRET = "1.2.840.113549.1.12.10.1.5";
    private static final String OID_CERTTYPE_X509 = "1.2.840.113549.1.9.22.1";
    private Debug debug = Debug.getInstance("PKCS12");
    private Map<String, P12Entry> entries = new LinkedHashMap<String, P12Entry>();
    private List<P12Entry.Cert> otherCerts = new ArrayList<P12Entry.Cert>();
    private Map<X500Principal, X509Certificate> otherCertsMap = new LinkedHashMap<X500Principal, X509Certificate>();
    private int aliasCounter = 0;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry == null || entry instanceof P12Entry.Cert) {
            return null;
        }
        P12Entry.Key keyEntry = (P12Entry.Key)entry;
        try {
            byte[] privKeyInfoBytes = this.pbeCipher(2, keyEntry.encAlgId, password, keyEntry.encryptedKey);
            Asn1BerValue keyInfo = Asn1.decodeOne(privKeyInfoBytes);
            List<Asn1BerValue> keyInfoContents = keyInfo.tag(UniversalTag.SEQUENCE).count(3, 4).sequence();
            AlgorithmId keyId = AlgorithmId.decode(keyInfoContents.get(1));
            if (entry instanceof P12Entry.PrivKey) {
                KeyFactory kf = KeyFactory.getInstance(keyId.getAlg());
                return kf.generatePrivate(new PKCS8EncodedKeySpec(privKeyInfoBytes));
            }
            byte[] keyBytes = keyInfoContents.get(2).getOctetString();
            return new SecretKeySpec(keyBytes, keyId.getAlg());
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new UnrecoverableKeyException("Failed to decrypt key: " + e.getMessage());
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (!(entry instanceof P12Entry.PrivKey)) {
            return null;
        }
        P12Entry.PrivKey keyEntry = (P12Entry.PrivKey)entry;
        if (keyEntry.getChain().isEmpty()) {
            return null;
        }
        return keyEntry.getChain().toArray(new Certificate[0]);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry == null || entry instanceof P12Entry.SecretKey) {
            return null;
        }
        if (entry instanceof P12Entry.PrivKey) {
            P12Entry.PrivKey keyEntry = (P12Entry.PrivKey)entry;
            if (keyEntry.getChain().isEmpty()) {
                return null;
            }
            return keyEntry.getChain().get(0);
        }
        return ((P12Entry.Cert)entry).cert;
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        P12Entry p12Entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (p12Entry == null) {
            return null;
        }
        if (p12Entry instanceof P12Entry.Cert) {
            if (protParam != null) {
                throw new KeyStoreException("Requested certificate entry does not require password");
            }
            P12Entry.Cert certEntry = (P12Entry.Cert)p12Entry;
            return new KeyStore.TrustedCertificateEntry(certEntry.cert, certEntry.attributes.toAttributeSet());
        }
        if (!(protParam instanceof KeyStore.PasswordProtection)) {
            throw new UnrecoverableEntryException("Requested key entry required PasswordProtection");
        }
        KeyStore.PasswordProtection pwdProtect = (KeyStore.PasswordProtection)protParam;
        char[] pwd = pwdProtect.getPassword();
        if (pwd == null) {
            throw new KeyStoreException("Password cannot be null");
        }
        if (p12Entry instanceof P12Entry.PrivKey) {
            PrivateKey key = (PrivateKey)this.engineGetKey(alias, pwd);
            Certificate[] chain = this.engineGetCertificateChain(alias);
            return new KeyStore.PrivateKeyEntry(key, chain, p12Entry.attributes.toAttributeSet());
        }
        SecretKey key = (SecretKey)this.engineGetKey(alias, pwd);
        return new KeyStore.SecretKeyEntry(key, p12Entry.attributes.toAttributeSet());
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        return entry == null ? null : entry.date;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protection) throws KeyStoreException {
        if (protection != null && !(protection instanceof KeyStore.PasswordProtection)) {
            throw new KeyStoreException("Unsupported protection parameter");
        }
        if (entry instanceof KeyStore.PrivateKeyEntry || entry instanceof KeyStore.SecretKeyEntry) {
            if (protection == null) {
                throw new KeyStoreException("Protection parameter required to store key.");
            }
            KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)protection;
            char[] pwd = passwordProtection.getPassword();
            if (pwd == null) {
                throw new KeyStoreException("Protection parameter requires non-null password to store key.");
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privEntry = (KeyStore.PrivateKeyEntry)entry;
                this.setKeyEntry(alias, privEntry.getPrivateKey(), passwordProtection, privEntry.getCertificateChain(), privEntry.getAttributes());
            } else {
                KeyStore.SecretKeyEntry secretEntry = (KeyStore.SecretKeyEntry)entry;
                this.setKeyEntry(alias, secretEntry.getSecretKey(), passwordProtection, null, secretEntry.getAttributes());
            }
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.setCertEntry(alias, trustEntry.getTrustedCertificate(), trustEntry.getAttributes());
        } else {
            throw new KeyStoreException("Unsupported entry type: " + entry.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(password);
        try {
            this.setKeyEntry(alias, key, param, chain, null);
        }
        finally {
            try {
                param.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        try {
            P12Entry.Key entry;
            List<Asn1BerValue> infoVals = Asn1.decodeOne(key).count(2).tag(UniversalTag.SEQUENCE).sequence();
            AlgorithmId algId = AlgorithmId.decode(infoVals.get(0));
            byte[] encrypted = infoVals.get(1).getOctetString();
            if (chain != null) {
                this.validateCertChain(chain);
                entry = new P12Entry.PrivKey(encrypted, algId, chain);
            } else {
                entry = new P12Entry.SecretKey(encrypted, algId);
            }
            P12Attributes p12Attrs = P12Attributes.create(alias, P12Entry.generateKeyId());
            ((P12Entry)entry).setAttributes(p12Attrs);
            this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
        }
        catch (Asn1Exception | IOException e) {
            throw new KeyStoreException("Invalid protected format key bytes", e);
        }
    }

    private void setKeyEntry(String alias, Key key, KeyStore.PasswordProtection passwordProtection, Certificate[] chain, Set<KeyStore.Entry.Attribute> attributes) throws KeyStoreException {
        try {
            P12Entry.Key entry;
            if (this.engineIsCertificateEntry(alias)) {
                throw new KeyStoreException("Cannot replace existing cert entry with key entry");
            }
            char[] password = passwordProtection.getPassword();
            String encryptAlg = passwordProtection.getProtectionAlgorithm();
            AlgorithmId algId = encryptAlg != null ? new AlgorithmId(encryptAlg, passwordProtection.getProtectionParameters()) : this.genEncryptIdDefault();
            if (key instanceof PrivateKey) {
                this.validateCertChain(chain);
                byte[] encrypted = this.pbeCipher(1, algId, password, key.getEncoded());
                entry = new P12Entry.PrivKey(encrypted, algId, chain);
            } else {
                if (!(key instanceof SecretKey)) {
                    throw new KeyStoreException("Unsupported key type.");
                }
                byte[] keyBytes = this.encodeSecretKey((SecretKey)key);
                byte[] encrypted = this.pbeCipher(1, algId, password, keyBytes);
                entry = new P12Entry.SecretKey(encrypted, algId);
            }
            P12Attributes p12Attrs = P12Attributes.create(alias, P12Entry.generateKeyId());
            if (attributes != null) {
                p12Attrs.addAttributes(attributes);
            }
            ((P12Entry)entry).setAttributes(p12Attrs);
            this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
        }
        catch (IOException e) {
            throw new KeyStoreException(e.getCause());
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.setCertEntry(alias, cert, null);
    }

    private void setCertEntry(String alias, Certificate cert, Set<KeyStore.Entry.Attribute> attributes) throws KeyStoreException {
        if (!(cert instanceof X509Certificate)) {
            throw new KeyStoreException("Cannot set non-X509Certificate");
        }
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null && !(entry instanceof P12Entry.Cert)) {
            throw new KeyStoreException("Cannot override key entry with certificate.");
        }
        P12Attributes attrs = P12Attributes.create(alias, null);
        attrs.addTrustedUsage();
        if (attributes != null) {
            attrs.addAttributes(attributes);
        }
        P12Entry.Cert newEntry = new P12Entry.Cert((X509Certificate)cert, attrs);
        this.entries.put(alias.toLowerCase(Locale.ENGLISH), newEntry);
    }

    @Override
    public void engineDeleteEntry(String alias) {
        P12Entry entry = this.entries.remove(alias.toLowerCase(Locale.ENGLISH));
        if (this.debug != null) {
            if (entry == null) {
                this.debug.println("No entry with alias " + alias + " to delete.");
            } else {
                this.debug.println("Deleted entry " + alias);
            }
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.entries.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.keySet().contains(alias.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        return entry instanceof P12Entry.Key;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        P12Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        return entry instanceof P12Entry.Cert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (Map.Entry<String, P12Entry> entry : this.entries.entrySet()) {
            P12Entry.PrivKey privEntry;
            P12Entry p12Entry = entry.getValue();
            if (!(p12Entry instanceof P12Entry.Cert ? ((P12Entry.Cert)p12Entry).cert.equals(cert) : p12Entry instanceof P12Entry.PrivKey && !(privEntry = (P12Entry.PrivKey)p12Entry).getChain().isEmpty() && privEntry.getChain().get(0).equals(cert))) continue;
            return p12Entry.alias;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, CertificateException {
        if (password == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        try {
            byte[] authSafeDer = this.constructAuthSafes(password);
            byte[] p12Der = Asn1.newSequence(Asn1.newInteger(3L), Asn1.newSequence(Asn1.newOid(OID_CONTENT_TYPE_DATA), Asn1.explicit(0).newOctetString(authSafeDer)), this.constructMacData(password, authSafeDer)).encodeDerOctets();
            stream.write(p12Der);
        }
        catch (AlgIdException | Asn1Exception e) {
            throw new IOException("Error during store", e);
        }
    }

    private void validateCertChain(Certificate[] certChain) throws KeyStoreException {
        for (Certificate c : certChain) {
            if (c instanceof X509Certificate) continue;
            throw new KeyStoreException("All certificates must be X509Certificate");
        }
        if (certChain.length == 1) {
            return;
        }
        for (int i = 0; i < certChain.length - 1; ++i) {
            X500Principal subjectDN;
            X500Principal issuerDN = ((X509Certificate)certChain[i]).getIssuerX500Principal();
            if (issuerDN.equals(subjectDN = ((X509Certificate)certChain[i + 1]).getSubjectX500Principal())) continue;
            throw new KeyStoreException("Certificate chain is not valid.");
        }
        HashSet<Certificate> set = new HashSet<Certificate>(Arrays.asList(certChain));
        if (set.size() != certChain.length) {
            throw new KeyStoreException("Certificate chain is not valid.");
        }
    }

    private byte[] encodeSecretKey(SecretKey key) throws KeyStoreException {
        return Asn1.newSequence(Asn1.newInteger(0L), Asn1.newSequence(this.secretKeyAlgToOid(key.getAlgorithm()), Asn1.newNull()), Asn1.newOctetString(key.getEncoded())).encodeDerOctets();
    }

    private Asn1BerValue secretKeyAlgToOid(String alg) throws KeyStoreException {
        if (alg.equalsIgnoreCase("AES")) {
            return Asn1.newOid("2.16.840.1.101.3.4.1");
        }
        String oid = alg;
        if (alg.toUpperCase(Locale.ENGLISH).startsWith("OID.")) {
            oid = alg.substring(4);
        }
        try {
            return Asn1.newOid(oid);
        }
        catch (Asn1Exception | IllegalArgumentException e) {
            throw new KeyStoreException("Invalid secret key alg " + alg);
        }
    }

    private byte[] constructAuthSafes(char[] pwd) throws IOException, CertificateException {
        Asn1BerValue dataSafe = this.constructSafeContentData();
        Asn1BerValue encryptedSafe = this.constructSafeContentEncryptedData(pwd);
        ArrayList<Asn1BerValue> safes = new ArrayList<Asn1BerValue>();
        if (dataSafe != null) {
            safes.add(dataSafe);
        }
        if (encryptedSafe != null) {
            safes.add(encryptedSafe);
        }
        return Asn1.newSequence(safes).encodeDerOctets();
    }

    private Asn1BerValue constructSafeContentData() throws IOException {
        ArrayList<Asn1BerValue> safeBags = new ArrayList<Asn1BerValue>();
        for (Map.Entry<String, P12Entry> entry : this.entries.entrySet()) {
            P12Entry p12Entry = entry.getValue();
            if (p12Entry instanceof P12Entry.PrivKey) {
                safeBags.add(this.constructSafeBag((P12Entry.PrivKey)p12Entry));
                continue;
            }
            if (!(p12Entry instanceof P12Entry.SecretKey)) continue;
            safeBags.add(this.constructSafeBag((P12Entry.SecretKey)p12Entry));
        }
        if (safeBags.isEmpty()) {
            return null;
        }
        byte[] safeContentsDer = Asn1.newSequence(safeBags).encodeDerOctets();
        return Asn1.newSequence(Asn1.newOid(OID_CONTENT_TYPE_DATA), Asn1.explicit(0).newOctetString(safeContentsDer));
    }

    private Asn1BerValue constructSafeContentEncryptedData(char[] pwd) throws CertificateEncodingException, IOException {
        ArrayList<Asn1BerValue> safeBags = new ArrayList<Asn1BerValue>();
        for (Map.Entry<String, P12Entry> entry : this.entries.entrySet()) {
            P12Entry p12Entry = entry.getValue();
            if (p12Entry instanceof P12Entry.Cert) {
                safeBags.add(this.constructSafeBag((P12Entry.Cert)p12Entry));
                continue;
            }
            if (!(p12Entry instanceof P12Entry.PrivKey)) continue;
            P12Entry.PrivKey privEntry = (P12Entry.PrivKey)p12Entry;
            for (int i = 0; i < privEntry.getChain().size(); ++i) {
                X509Certificate cert = privEntry.getChain().get(i);
                P12Entry.Cert crtEntry = new P12Entry.Cert(cert);
                P12Attributes attrs = i == 0 ? P12Attributes.create(privEntry.alias, privEntry.localKeyId) : P12Attributes.create(cert.getSubjectX500Principal().getName(), null);
                crtEntry.setAttributes(attrs);
                safeBags.add(this.constructSafeBag(crtEntry));
            }
        }
        if (safeBags.isEmpty()) {
            return null;
        }
        byte[] safeContentsDer = Asn1.newSequence(safeBags).encodeDerOctets();
        AlgorithmId pbeAlgId = this.genEncryptIdDefault();
        byte[] encryptedSafeContents = this.pbeCipher(1, pbeAlgId, pwd, safeContentsDer);
        return Asn1.newSequence(Asn1.newOid(OID_CONTENT_TYPE_ENCRYPTED_DATA), Asn1.explicit(0).newSequence(Asn1.newInteger(0L), Asn1.newSequence(Asn1.newOid(OID_CONTENT_TYPE_DATA), pbeAlgId.toAsn1Value(), Asn1.explicit(0).newOctetString(encryptedSafeContents))));
    }

    private Asn1BerValue constructSafeBag(P12Entry.Cert cert) throws CertificateEncodingException {
        return Asn1.newSequence(Asn1.newOid(OID_SAFEBAG_TYPE_CERT), Asn1.explicit(0).newSequence(Asn1.newOid(OID_CERTTYPE_X509), Asn1.explicit(0).newOctetString(cert.cert.getEncoded())), cert.attributes.toAsn1Value());
    }

    private Asn1BerValue constructSafeBag(P12Entry.PrivKey key) throws IOException {
        return Asn1.newSequence(Asn1.newOid(OID_SAFEBAG_TYPE_SHROUDEDKEY), Asn1.explicit(0).newSequence(key.encAlgId.toAsn1Value(), Asn1.newOctetString(key.encryptedKey)), key.attributes.toAsn1Value());
    }

    private Asn1BerValue constructSafeBag(P12Entry.SecretKey key) throws IOException {
        byte[] encryptedPrivKeyInfo = Asn1.newSequence(key.encAlgId.toAsn1Value(), Asn1.newOctetString(key.encryptedKey)).encodeDerOctets();
        return Asn1.newSequence(Asn1.newOid(OID_SAFEBAG_TYPE_SECRET), Asn1.explicit(0).newSequence(Asn1.newOid(OID_SAFEBAG_TYPE_SHROUDEDKEY), Asn1.explicit(0).newOctetString(encryptedPrivKeyInfo)), key.attributes.toAsn1Value());
    }

    private Asn1BerValue constructMacData(char[] pwd, byte[] authSafeToMac) throws IOException {
        byte[] macDigestVal;
        byte[] macSalt = RandBytes.generate(20);
        int iters = 100000;
        String macAlg = "HmacPBESHA1";
        try {
            macDigestVal = this.computeMac(macAlg, pwd, new PBEParameterSpec(macSalt, iters), authSafeToMac);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to compute integrity Mac", e);
        }
        return Asn1.newSequence(Asn1.newSequence(Asn1.newSequence(Asn1.newOid("1.3.14.3.2.26"), Asn1.newNull()), Asn1.newOctetString(macDigestVal)), Asn1.newOctetString(macSalt), Asn1.newInteger(iters));
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        this.entries.clear();
        if (stream == null) {
            return;
        }
        byte[] input = this.readAllBytes(stream);
        if (input.length >= 4) {
            switch (ByteBuffer.wrap(input, 0, 4).getInt(0)) {
                case -17957139: {
                    throw new IOException("Invalid PKCS12 KeyStore: JKS type not supported");
                }
                case -825307442: {
                    throw new IOException("Invalid PKCS12 KeyStore: JCEKS type not supported");
                }
            }
        }
        try {
            List<Asn1BerValue> pfxContent = Asn1.decodeOne(input).tag(UniversalTag.SEQUENCE).count(2, 3).sequence();
            BigInteger ver = pfxContent.get(0).tag(UniversalTag.INTEGER).getInteger();
            if (!ver.equals(BigInteger.valueOf(3L))) {
                throw new IOException("Invalid PKCS #12 version: expected 3");
            }
            List<Asn1BerValue> cInfo = pfxContent.get(1).tag(UniversalTag.SEQUENCE).count(2).sequence();
            String typeOid = cInfo.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
            if (!typeOid.equals(OID_CONTENT_TYPE_DATA)) {
                throw new IOException("Invalid ContentInfo type: was " + typeOid + ", expected " + OID_CONTENT_TYPE_DATA);
            }
            byte[] authSafeContents = cInfo.get(1).tag(0).explicit().getOctetString();
            if (password != null && pfxContent.size() == 3) {
                this.verifyIntegrity(authSafeContents, pfxContent.get(2), password);
            } else {
                if (pfxContent.size() == 2) {
                    this.debug.println("No integrity info to check.");
                }
                if (password == null) {
                    this.debug.println("Password was null, no integrity checking done.");
                }
            }
            List<Asn1BerValue> safes = Asn1.decodeOne(authSafeContents).tag(UniversalTag.SEQUENCE).sequence();
            for (Asn1BerValue safe : safes) {
                List<Asn1BerValue> typeAndContent = safe.tag(UniversalTag.SEQUENCE).count(2).sequence();
                String oidType = typeAndContent.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
                Asn1BerValue content = typeAndContent.get(1).tag(0).explicit();
                if (oidType.equals(OID_CONTENT_TYPE_DATA)) {
                    this.debug.println("Reading Data safe...");
                    Asn1BerValue safeContents = Asn1.decodeOne(content.tag(UniversalTag.OCTET_STRING).gatherContent());
                    this.loadSafeContents(safeContents, password);
                    continue;
                }
                if (oidType.equals(OID_CONTENT_TYPE_ENCRYPTED_DATA)) {
                    this.debug.println("Reading EncryptedData safe...");
                    if (password == null) {
                        this.debug.println("Password was null, skipping loading of encrypted data.");
                        continue;
                    }
                    this.loadEncryptedContents(content, password);
                    continue;
                }
                throw new IOException("Unsupported content type " + oidType);
            }
        }
        catch (AlgIdException | Asn1Exception e) {
            throw new IOException("Failed to decode PKCS #12", e);
        }
        this.postLoadProcess();
        this.otherCerts.clear();
        this.otherCertsMap.clear();
    }

    private void postLoadProcess() {
        boolean firstKey = true;
        for (Map.Entry<String, P12Entry> entry : this.entries.entrySet()) {
            if (!(entry.getValue() instanceof P12Entry.PrivKey)) continue;
            P12Entry.PrivKey keyEntry = (P12Entry.PrivKey)entry.getValue();
            X509Certificate cert = this.matchCert(keyEntry, firstKey);
            if (cert != null) {
                keyEntry.setChain(this.findChain(cert));
            } else {
                this.debug.println(() -> "Unable to find certificate for privateKey " + keyEntry.alias);
            }
            firstKey = false;
        }
    }

    private X509Certificate matchCert(P12Entry.PrivKey keyEntry, boolean isFirst) {
        X509Certificate idMatch = null;
        X509Certificate aliasMatch = null;
        if (keyEntry.localKeyId != null) {
            for (P12Entry.Cert c : this.otherCerts) {
                if (Arrays.equals(keyEntry.localKeyId, c.localKeyId)) {
                    if (keyEntry.alias.equals(c.alias)) {
                        return c.cert;
                    }
                    idMatch = c.cert;
                }
                if (!keyEntry.alias.equals(c.alias)) continue;
                aliasMatch = c.cert;
            }
            if (idMatch != null) {
                return idMatch;
            }
        } else {
            for (P12Entry.Cert c : this.otherCerts) {
                if (!keyEntry.alias.equals(c.alias)) continue;
                return c.cert;
            }
            if (isFirst && !this.otherCerts.isEmpty()) {
                return this.otherCerts.get((int)0).cert;
            }
        }
        return aliasMatch;
    }

    private List<X509Certificate> findChain(X509Certificate cert) {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        X509Certificate next = cert;
        LinkedHashMap<X500Principal, X509Certificate> newMap = new LinkedHashMap<X500Principal, X509Certificate>(this.otherCertsMap);
        while (next != null) {
            newMap.remove(cert.getSubjectX500Principal());
            chain.add(next);
            if (next.getSubjectX500Principal().equals(next.getIssuerX500Principal())) break;
            next = (X509Certificate)newMap.get(next.getIssuerX500Principal());
        }
        return chain;
    }

    private void loadSafeContents(Asn1BerValue seqSafeBags, char[] pwd) throws IOException {
        List<Asn1BerValue> safeBags = seqSafeBags.tag(UniversalTag.SEQUENCE).sequence();
        block12: for (Asn1BerValue bag : safeBags) {
            List<Asn1BerValue> bagContent = bag.tag(UniversalTag.SEQUENCE).count(2, 3).sequence();
            String bagType = bagContent.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
            Asn1BerValue taggedBag = bagContent.get(1).tag(0);
            Asn1BerValue bagValue = taggedBag.explicit();
            P12Attributes attributes = bagContent.size() == 2 ? P12Attributes.create() : P12Attributes.load(bagContent.get(2).tag(UniversalTag.SET));
            switch (bagType) {
                case "1.2.840.113549.1.12.10.1.3": {
                    this.loadCert(bagValue, attributes);
                    continue block12;
                }
                case "1.2.840.113549.1.12.10.1.2": {
                    this.loadShroudedKey(bagValue, attributes);
                    continue block12;
                }
                case "1.2.840.113549.1.12.10.1.5": {
                    this.loadSecret(bagValue, attributes);
                    continue block12;
                }
                case "1.2.840.113549.1.12.10.1.1": {
                    this.loadKey(taggedBag.octets(), attributes, pwd);
                    continue block12;
                }
            }
            this.debug.println(() -> "Ignoring unsupported bag type " + bagType);
        }
    }

    private void loadCert(Asn1BerValue certBag, P12Attributes attributes) throws IOException {
        List<Asn1BerValue> bagContents = certBag.tag(UniversalTag.SEQUENCE).count(2).sequence();
        String certId = bagContents.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
        if (!certId.equals(OID_CERTTYPE_X509)) {
            throw new IOException("Unsupported certificate type.");
        }
        byte[] certBytes = bagContents.get(1).tag(0).explicit().tag(UniversalTag.OCTET_STRING).getOctetString();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
            this.saveCert(cert, attributes);
        }
        catch (CertificateException e) {
            throw new IOException("Failed to decode certificate", e);
        }
    }

    private void saveCert(X509Certificate cert, P12Attributes attributes) {
        if (attributes.hasTrustAttr()) {
            this.saveEntry(new P12Entry.Cert(cert), attributes);
        } else {
            this.debug.println(" read untrusted certificate " + cert.getSubjectX500Principal());
            this.otherCerts.add(new P12Entry.Cert(cert, attributes));
            this.otherCertsMap.put(cert.getSubjectX500Principal(), cert);
        }
    }

    private void saveEntry(P12Entry entry, P12Attributes attributes) {
        String alias = attributes.getFriendlyName();
        if (alias == null) {
            alias = this.nextAlias();
            attributes.setFriendlyName(alias);
        }
        entry.setAttributes(attributes);
        this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
        this.debug.println(() -> " loaded " + entry);
    }

    private void loadShroudedKey(Asn1BerValue shroudedKeyBag, P12Attributes attributes) throws IOException {
        List<Asn1BerValue> encPrivInfo = shroudedKeyBag.tag(UniversalTag.SEQUENCE).count(2).sequence();
        AlgorithmId algId = AlgorithmId.decode(encPrivInfo.get(0));
        byte[] encryptedBytes = encPrivInfo.get(1).tag(UniversalTag.OCTET_STRING).getOctetString();
        this.saveEntry(new P12Entry.PrivKey(encryptedBytes, algId), attributes);
    }

    private void loadKey(byte[] privKeyBytes, P12Attributes attributes, char[] pwd) throws IOException {
        AlgorithmId algId = this.genEncryptIdDefault();
        byte[] encrypted = this.pbeCipher(1, algId, pwd, privKeyBytes);
        this.saveEntry(new P12Entry.PrivKey(encrypted, algId), attributes);
    }

    private AlgorithmId genEncryptIdDefault() {
        byte[] salt = RandBytes.generate(20);
        byte[] iv = RandBytes.generate(16);
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 50000, new IvParameterSpec(iv));
        return new AlgorithmId(DEFAULT_ENC_ALG, paramSpec);
    }

    private void loadSecret(Asn1BerValue secretBag, P12Attributes attributes) throws IOException {
        List<Asn1BerValue> bagContents = secretBag.tag(UniversalTag.SEQUENCE).count(2).sequence();
        String secretType = bagContents.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
        if (!secretType.equals(OID_SAFEBAG_TYPE_SHROUDEDKEY)) {
            this.debug.println(() -> "Skipping secret of unknown type " + secretType);
            return;
        }
        byte[] encryptedPrivateKeyInfo = bagContents.get(1).tag(0).explicit().tag(UniversalTag.OCTET_STRING).getOctetString();
        List<Asn1BerValue> encPrivInfo = Asn1.decodeOne(encryptedPrivateKeyInfo).tag(UniversalTag.SEQUENCE).count(2).sequence();
        AlgorithmId algId = AlgorithmId.decode(encPrivInfo.get(0));
        byte[] encryptedBytes = encPrivInfo.get(1).tag(UniversalTag.OCTET_STRING).getOctetString();
        this.saveEntry(new P12Entry.SecretKey(encryptedBytes, algId), attributes);
    }

    private void loadEncryptedContents(Asn1BerValue encryptedData, char[] password) throws IOException {
        List<Asn1BerValue> encDataValues = encryptedData.tag(UniversalTag.SEQUENCE).count(2).sequence();
        encDataValues.get(0).tag(UniversalTag.INTEGER).getInteger();
        Iterator<Asn1BerValue> encDataIter = encDataValues.get(1).tag(UniversalTag.SEQUENCE).count(3).sequence().iterator();
        String type = encDataIter.next().tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
        if (!type.equals(OID_CONTENT_TYPE_DATA)) {
            throw new IOException("Unexpected content type in EncryptedData: " + type);
        }
        AlgorithmId contentEncryptAlg = AlgorithmId.decode(encDataIter.next());
        byte[] encDataBytes = encDataIter.next().tag(0).getOctetString();
        byte[] safeBags = this.pbeCipher(2, contentEncryptAlg, password, encDataBytes);
        this.loadSafeContents(Asn1.decodeOne(safeBags), password);
    }

    private byte[] pbeCipher(int mode, AlgorithmId algId, char[] password, byte[] data) throws IOException {
        SecretKey key = null;
        try {
            key = this.pbeKey(password, algId.getAlg());
            Cipher cipher = Cipher.getInstance(algId.getAlg());
            cipher.init(mode, (Key)key, algId.getParameterSpec());
            byte[] ret = cipher.doFinal(data);
            if (mode == 1) {
                algId.updateParams(cipher.getParameters().getParameterSpec(PBEParameterSpec.class));
            }
            byte[] byArray = ret;
            this.destroyQuietly(key);
            return byArray;
        }
        catch (GeneralSecurityException e) {
            try {
                throw new IOException("Cipher operation failed", e);
            }
            catch (Throwable throwable) {
                this.destroyQuietly(key);
                throw throwable;
            }
        }
    }

    private void verifyIntegrity(byte[] contentBytes, Asn1BerValue macDataValue, char[] password) throws IOException {
        List<Asn1BerValue> macData = macDataValue.tag(UniversalTag.SEQUENCE).count(3).sequence();
        List<Asn1BerValue> digestInfo = macData.get(0).tag(UniversalTag.SEQUENCE).count(2).sequence();
        AlgorithmId algId = AlgorithmId.decode(digestInfo.get(0));
        byte[] macDigest = digestInfo.get(1).tag(UniversalTag.OCTET_STRING).getOctetString();
        byte[] macSalt = macData.get(1).tag(UniversalTag.OCTET_STRING).getOctetString();
        int iterCount = macData.get(2).tag(UniversalTag.INTEGER).getInteger().intValueExact();
        try {
            byte[] computedMac = this.computeMac("HmacPBE" + algId.getShortAlg(), password, new PBEParameterSpec(macSalt, iterCount), contentBytes);
            if (!MessageDigest.isEqual(computedMac, macDigest)) {
                throw new IOException("Integrity check failed.");
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to compute integrity check value", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] computeMac(String alg, char[] pwd, PBEParameterSpec params, byte[] content) throws GeneralSecurityException {
        SecretKey key = null;
        try {
            key = this.pbeKey(pwd, "OID.1.2.840.113549.1.12.1.3");
            Mac mac = Mac.getInstance(alg);
            mac.init(key, params);
            byte[] byArray = mac.doFinal(content);
            return byArray;
        }
        finally {
            this.destroyQuietly(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey pbeKey(char[] pwd, String alg) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec(pwd);
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(alg);
            SecretKey secretKey = skf.generateSecret(keySpec);
            return secretKey;
        }
        finally {
            keySpec.clearPassword();
        }
    }

    private String nextAlias() {
        ++this.aliasCounter;
        return String.valueOf(this.aliasCounter);
    }

    private byte[] readAllBytes(InputStream is) throws IOException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((c = is.read(buf)) != -1) {
            bout.write(buf, 0, c);
        }
        return bout.toByteArray();
    }

    private void destroyQuietly(SecretKey key) {
        try {
            if (key != null) {
                key.destroy();
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }
}

