/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.common.Platform;
import com.oracle.jipher.internal.loader.LibraryLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.zip.CRC32;

class FileUtil {
    private static final int BUFFER_SIZE = 8192;
    private final Platform platform;

    FileUtil(Platform platform) {
        this.platform = platform;
    }

    Path createTempDirs(Path dir) throws IOException {
        return Files.createDirectories(dir, this.platform.getTempDirAttributes());
    }

    Path createEmptyFile(Path dir, String f) throws IOException {
        Path p = dir.resolve(f);
        return Files.createFile(p, this.platform.getTempFileAttributes());
    }

    void copyFile(URL url, Path file) throws IOException {
        byte[] buf = new byte[8192];
        try (InputStream in = url.openStream();
             SeekableByteChannel sbc = this.newLibraryByteChannel(file);){
            int n;
            LibraryLoader.DEBUG.println("Copying " + url + " contents to file " + file);
            while ((n = in.read(buf)) > 0) {
                sbc.write(ByteBuffer.wrap(buf, 0, n));
            }
        }
    }

    void copyFileIfNotExist(URL url, Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            LibraryLoader.DEBUG.println("Library file exists: " + file);
            return;
        }
        this.copyFile(url, file);
    }

    void tryDelete(Path p) {
        boolean deleted;
        if (p != null && !(deleted = p.toFile().delete())) {
            p.toFile().deleteOnExit();
        }
    }

    String computeChecksum(Path file) throws IOException {
        CRC32 crc = new CRC32();
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            int n;
            byte[] read = new byte[8192];
            while ((n = is.read(read)) != -1) {
                crc.update(read, 0, n);
            }
        }
        return Long.toHexString(crc.getValue());
    }

    String readString(URL url, int maxBytes) throws IOException {
        int len;
        byte[] bb = new byte[maxBytes];
        try (InputStream in = url.openStream();){
            len = in.read(bb);
        }
        return new String(bb, 0, len);
    }

    private SeekableByteChannel newLibraryByteChannel(Path file) throws IOException {
        return Files.newByteChannel(file, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), this.platform.getTempFileAttributes());
    }
}

