/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.CipherPadding;
import java.security.InvalidKeyException;

abstract class CipherAlg {
    CipherAlg() {
    }

    abstract String getName();

    abstract int getBlockSize();

    abstract boolean isValidKeySize(int var1);

    void validateKeySize(int keySize) throws InvalidKeyException {
        if (!this.isValidKeySize(keySize)) {
            throw new InvalidKeyException("Invalid key length.");
        }
    }

    abstract String getAlg(int var1, CipherMode var2);

    abstract boolean supportsMode(CipherMode var1);

    abstract boolean supportsPadding(CipherMode var1, CipherPadding var2);

    static class AesKeyWrap
    extends AesAbstract {
        int fixedKeyBits = -1;

        AesKeyWrap() {
        }

        AesKeyWrap(int size) {
            this.fixedKeyBits = size;
        }

        @Override
        public boolean isValidKeySize(int keyBytes) {
            if (this.fixedKeyBits == -1) {
                return keyBytes == 16 || keyBytes == 24 || keyBytes == 32;
            }
            return keyBytes * 8 == this.fixedKeyBits;
        }

        @Override
        boolean supportsMode(CipherMode mode) {
            return false;
        }

        @Override
        boolean supportsPadding(CipherMode mode, CipherPadding padding) {
            return false;
        }

        @Override
        public String getAlg(int keyBits, CipherMode mode) {
            if (mode == CipherMode.KW) {
                return "id-aes" + keyBits + "-wrap";
            }
            return "id-aes" + keyBits + "-wrap-pad";
        }
    }

    static class DesEde
    extends DesEdeAbstract {
        DesEde() {
        }

        @Override
        public boolean supportsMode(CipherMode mode) {
            switch (mode) {
                case CBC: 
                case ECB: 
                case CFB: 
                case OFB: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean supportsPadding(CipherMode mode, CipherPadding padding) {
            if (padding == CipherPadding.PKCS5PADDING) {
                return mode == CipherMode.CBC || mode == CipherMode.ECB;
            }
            return true;
        }
    }

    static class DesEdeFixed
    extends DesEdeAbstract
    implements FixedModePad {
        private final CipherMode mode;
        private final CipherPadding pad;

        DesEdeFixed(CipherMode mode, CipherPadding pad) {
            this.mode = mode;
            this.pad = pad;
        }

        @Override
        public CipherMode getMode() {
            return this.mode;
        }

        @Override
        public CipherPadding getPadding() {
            return this.pad;
        }

        @Override
        public boolean supportsMode(CipherMode m) {
            return this.mode == m;
        }

        @Override
        public boolean supportsPadding(CipherMode m, CipherPadding padding) {
            return this.mode == m && this.pad == padding;
        }
    }

    static abstract class DesEdeAbstract
    extends CipherAlg {
        static final int BLOCK_SIZE = 8;

        DesEdeAbstract() {
        }

        @Override
        public String getName() {
            return "DESede";
        }

        @Override
        public int getBlockSize() {
            return 8;
        }

        @Override
        public boolean isValidKeySize(int keySize) {
            return keySize == 24;
        }

        @Override
        public String getAlg(int keySize, CipherMode mode) {
            return "des-ede3-" + mode.toString().toLowerCase();
        }
    }

    static class AesGcm
    extends AesAbstract {
        int fixedKeySize = -1;

        AesGcm() {
        }

        AesGcm(int sizeBytes) {
            this.fixedKeySize = sizeBytes;
        }

        @Override
        public boolean isValidKeySize(int keySizeBytes) {
            if (this.fixedKeySize != -1) {
                return this.fixedKeySize == keySizeBytes;
            }
            return super.isValidKeySize(keySizeBytes);
        }

        @Override
        public boolean supportsMode(CipherMode mode) {
            return mode == CipherMode.GCM;
        }

        @Override
        public boolean supportsPadding(CipherMode mode, CipherPadding padding) {
            return padding == CipherPadding.NOPADDING;
        }
    }

    static class AES
    extends AesAbstract {
        AES() {
        }

        @Override
        public boolean supportsMode(CipherMode mode) {
            switch (mode) {
                case CBC: 
                case ECB: 
                case CTR: 
                case CFB: 
                case OFB: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean supportsPadding(CipherMode mode, CipherPadding padding) {
            if (padding == CipherPadding.PKCS5PADDING) {
                return mode == CipherMode.CBC || mode == CipherMode.ECB;
            }
            return true;
        }
    }

    static class AesFixed
    extends AesAbstract
    implements FixedModePad {
        private final int keySizeBits;
        private final CipherMode mode;
        private final CipherPadding pad;

        AesFixed(int keySize, CipherMode mode, CipherPadding pad) {
            this.keySizeBits = keySize;
            this.mode = mode;
            this.pad = pad;
        }

        @Override
        public CipherMode getMode() {
            return this.mode;
        }

        @Override
        public CipherPadding getPadding() {
            return this.pad;
        }

        @Override
        public boolean isValidKeySize(int keySize) {
            return this.keySizeBits == keySize * 8;
        }

        @Override
        public boolean supportsMode(CipherMode m) {
            return this.mode == m;
        }

        @Override
        public boolean supportsPadding(CipherMode m, CipherPadding padding) {
            return this.mode == m && this.pad == padding;
        }
    }

    static abstract class AesAbstract
    extends CipherAlg {
        static final int BLOCK_SIZE = 16;

        AesAbstract() {
        }

        @Override
        public String getName() {
            return "AES";
        }

        @Override
        public int getBlockSize() {
            return 16;
        }

        @Override
        public String getAlg(int keySize, CipherMode mode) {
            return "aes-" + keySize + "-" + mode.toString().toLowerCase();
        }

        @Override
        boolean isValidKeySize(int keyBytes) {
            return keyBytes == 16 || keyBytes == 24 || keyBytes == 32;
        }
    }

    static interface FixedModePad {
        public CipherMode getMode();

        public CipherPadding getPadding();
    }
}

