/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Jre;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.InvalidAlgorithmParameterException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

abstract class InternalTlsSpec
implements AlgorithmParameterSpec {
    private AlgorithmParameterSpec spec;
    private Class<?> specClass;

    InternalTlsSpec(Class specClass, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (!specClass.isInstance(spec)) {
            throw new InvalidAlgorithmParameterException("Expected " + specClass.getName());
        }
        this.specClass = specClass;
        this.spec = spec;
    }

    Object call(String methodName) {
        try {
            return this.specClass.getMethod(methodName, new Class[0]).invoke((Object)this.spec, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProviderException("Problem loading JDK-internal parameter spec classes", e);
        }
    }

    static Class getTlsSpecClass(String className) {
        try {
            return Jre.getVendor() == Jre.Vendor.IBM ? Class.forName("ibm.security.internal.spec." + className) : Class.forName("sun.security.internal.spec." + className);
        }
        catch (ClassNotFoundException e) {
            throw new ProviderException("Problem loading JDK-internal parameter spec classes");
        }
    }

    static SecretKey newTlsMasterSecretKey(byte[] key, int maj, int min) {
        try {
            Class<?> cls = Jre.getVendor() == Jre.Vendor.IBM ? Class.forName("ibm.security.internal.interfaces.TlsMasterSecret") : Class.forName("sun.security.internal.interfaces.TlsMasterSecret");
            Object tlsMasterKey = Proxy.newProxyInstance(InternalTlsSpec.class.getClassLoader(), new Class[]{cls}, (InvocationHandler)new TlsMasterSecretHandler(maj, min, key));
            return (SecretKey)tlsMasterKey;
        }
        catch (ClassNotFoundException e) {
            return new SecretKeySpec(key, "TlsMasterSecret");
        }
    }

    static class TlsMasterSecretHandler
    implements InvocationHandler {
        private final int major;
        private final int minor;
        private byte[] key;

        private TlsMasterSecretHandler(int major, int minor, byte[] key) {
            this.major = major;
            this.minor = minor;
            this.key = key;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            switch (method.getName()) {
                case "getMajorVersion": {
                    return this.major;
                }
                case "getMinorVersion": {
                    return this.minor;
                }
                case "getEncoded": {
                    if (this.key == null) {
                        throw new IllegalStateException("key data has been cleared");
                    }
                    return this.key.clone();
                }
                case "getFormat": {
                    return "RAW";
                }
                case "getAlgorithm": {
                    return "TlsMasterSecret";
                }
                case "destroy": {
                    if (this.key != null) {
                        Arrays.fill(this.key, (byte)0);
                        this.key = null;
                    }
                    return null;
                }
                case "isDestroyed": {
                    return this.key == null;
                }
            }
            return null;
        }
    }

    static class RsaPremasterSecretParamSpec
    extends InternalTlsSpec {
        private static final Class SPEC_CLASS = RsaPremasterSecretParamSpec.getTlsSpecClass("TlsRsaPremasterSecretParameterSpec");

        RsaPremasterSecretParamSpec(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
            super(SPEC_CLASS, spec);
        }

        int getMajorVersion() {
            return (Integer)this.call("getMajorVersion");
        }

        int getMinorVersion() {
            return (Integer)this.call("getMinorVersion");
        }

        byte[] getEncodedSecret() {
            return (byte[])this.call("getEncodedSecret");
        }

        static boolean isInstance(AlgorithmParameterSpec spec) {
            return SPEC_CLASS.isInstance(spec);
        }
    }

    static class PrfParameterSpec
    extends InternalTlsSpec {
        private static final Class SPEC_CLASS = PrfParameterSpec.getTlsSpecClass("TlsPrfParameterSpec");

        PrfParameterSpec(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
            super(SPEC_CLASS, spec);
        }

        SecretKey getSecret() {
            return (SecretKey)this.call("getSecret");
        }

        String getLabel() {
            return (String)this.call("getLabel");
        }

        byte[] getSeed() {
            return (byte[])this.call("getSeed");
        }

        int getOutputLength() {
            return (Integer)this.call("getOutputLength");
        }

        String getPRFHashAlg() {
            return (String)this.call("getPRFHashAlg");
        }
    }

    static class MasterSecretParameterSpec
    extends InternalTlsSpec {
        private static final Class SPEC_CLASS = MasterSecretParameterSpec.getTlsSpecClass("TlsMasterSecretParameterSpec");

        MasterSecretParameterSpec(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
            super(SPEC_CLASS, spec);
        }

        SecretKey getPremasterSecret() {
            return (SecretKey)this.call("getPremasterSecret");
        }

        int getMajorVersion() {
            return (Integer)this.call("getMajorVersion");
        }

        int getMinorVersion() {
            return (Integer)this.call("getMinorVersion");
        }

        byte[] getClientRandom() {
            return (byte[])this.call("getClientRandom");
        }

        byte[] getServerRandom() {
            return (byte[])this.call("getServerRandom");
        }

        byte[] getExtendedMasterSecretSessionHash() {
            return (byte[])this.call("getExtendedMasterSecretSessionHash");
        }

        String getPRFHashAlg() {
            return (String)this.call("getPRFHashAlg");
        }
    }

    static class KeyMaterialParamSpec
    extends InternalTlsSpec {
        private static final Class SPEC_CLASS = KeyMaterialParamSpec.getTlsSpecClass("TlsKeyMaterialParameterSpec");

        KeyMaterialParamSpec(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
            super(SPEC_CLASS, spec);
        }

        SecretKey getMasterSecret() {
            return (SecretKey)this.call("getMasterSecret");
        }

        int getMajorVersion() {
            return (Integer)this.call("getMajorVersion");
        }

        int getMinorVersion() {
            return (Integer)this.call("getMinorVersion");
        }

        byte[] getClientRandom() {
            return (byte[])this.call("getClientRandom");
        }

        byte[] getServerRandom() {
            return (byte[])this.call("getServerRandom");
        }

        String getCipherAlgorithm() {
            return (String)this.call("getCipherAlgorithm");
        }

        int getCipherKeyLength() {
            return (Integer)this.call("getCipherKeyLength");
        }

        int getIvLength() {
            return (Integer)this.call("getIvLength");
        }

        int getMacKeyLength() {
            return (Integer)this.call("getMacKeyLength");
        }

        String getPRFHashAlg() {
            return (String)this.call("getPRFHashAlg");
        }
    }
}

