/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.spi.RsaParameters;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class OaepParameters
extends RsaParameters {
    private static final Asn1BerValue ID_PSPECIFIED = Asn1.newOid("1.2.840.113549.1.1.9");
    private OAEPParameterSpec oaepSpec;

    @Override
    protected byte[] engineGetEncoded() {
        Asn1BerValue hashAlgorithm = this.hashAlgToBer(this.oaepSpec.getDigestAlgorithm());
        Asn1BerValue maskGenAlgorithm = this.mgfToBer((MGF1ParameterSpec)this.oaepSpec.getMGFParameters());
        Asn1BerValue pSourceAlgorithm = null;
        byte[] pValue = ((PSource.PSpecified)this.oaepSpec.getPSource()).getValue();
        if (pValue.length > 0) {
            pSourceAlgorithm = Asn1.explicit(2).newSequence(ID_PSPECIFIED, Asn1.newOctetString(pValue));
        }
        Asn1BerValue rsaesOaepParams = Asn1.newSequence(hashAlgorithm, maskGenAlgorithm, pSourceAlgorithm);
        return rsaesOaepParams.encodeDerOctets();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (OAEPParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.oaepSpec));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            Asn1BerValue[] oaepParams = OaepParameters.decodeParams(3, params);
            String hash = this.getHashAlg(oaepParams[0]);
            MGF1ParameterSpec mgfSpec = this.getMgf1Spec(oaepParams[1]);
            Asn1BerValue pSourceAlgorithm = oaepParams[2];
            PSource.PSpecified pSpecified = pSourceAlgorithm == null ? PSource.PSpecified.DEFAULT : new PSource.PSpecified(OaepParameters.getAlgIdParams(pSourceAlgorithm, ID_PSPECIFIED, "PSource").getOctetString());
            this.oaepSpec = new OAEPParameterSpec(hash, "MGF1", mgfSpec, pSpecified);
        }
        catch (Asn1DecodeException ex) {
            throw new IOException("Invalid OAEP parameters", ex);
        }
    }

    @Override
    protected String engineToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OAEP Parameters [ ");
        sb.append("MD= ").append(this.oaepSpec.getDigestAlgorithm());
        sb.append(", MGF=MGF1(").append(((MGF1ParameterSpec)this.oaepSpec.getMGFParameters()).getDigestAlgorithm());
        byte[] value = ((PSource.PSpecified)this.oaepSpec.getPSource()).getValue();
        sb.append("), PSource=").append(Util.bytesToHex(value)).append(" ]");
        return sb.toString();
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec, expected OAEPParameterSpec");
        }
        OAEPParameterSpec oSpec = (OAEPParameterSpec)paramSpec;
        if (!oSpec.getMGFAlgorithm().equals("MGF1")) {
            throw new InvalidParameterSpecException("Only MGF1 supported.");
        }
        if (!(oSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Unsupported MGF parameters: only MGF1ParameterSpec supported.");
        }
        if (!(oSpec.getPSource() instanceof PSource.PSpecified)) {
            throw new InvalidParameterSpecException("Unsupported PSource: only PSource.PSpecified is supported.");
        }
        this.oaepSpec = (OAEPParameterSpec)paramSpec;
    }
}

