/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.EvpKdf;
import com.oracle.jipher.internal.openssl.MdAlg;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.Destroyable;

public abstract class Pbkdf2KeyFactory
extends SecretKeyFactorySpi {
    private final String algorithm;
    private final MdAlg digest;

    Pbkdf2KeyFactory(String algorithm, MdAlg digest) {
        this.algorithm = algorithm;
        this.digest = digest;
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeySpecException("Invalid key format/algorithm");
        }
        if (keySpec == null || !PBEKeySpec.class.isAssignableFrom(keySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return this.toKeySpec((PBEKey)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PBEKeySpec toKeySpec(PBEKey pbeKey) {
        byte[] dk = pbeKey.getEncoded();
        Arrays.fill(dk, (byte)0);
        int keyLength = dk.length * 8;
        char[] password = pbeKey.getPassword();
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(password, pbeKey.getSalt(), pbeKey.getIterationCount(), keyLength);
            return pBEKeySpec;
        }
        finally {
            Util.clearArray(password);
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return this.generateSecret((PBEKeySpec)keySpec);
    }

    byte[] encodePassword(char[] password) {
        return Util.utf8Encode(password);
    }

    private PBEKeyImpl generateSecret(PBEKeySpec keySpec) throws InvalidKeySpecException {
        byte[] salt = keySpec.getSalt();
        if (salt == null) {
            throw new InvalidKeySpecException("Salt not found");
        }
        if (keySpec.getKeyLength() <= 0) {
            throw new InvalidKeySpecException("Key length not found");
        }
        char[] password = keySpec.getPassword();
        byte[] pwBytes = null;
        try {
            pwBytes = this.encodePassword(password);
            int iter = keySpec.getIterationCount();
            byte[] dk = EvpKdf.pbkdf2Derive(pwBytes, pwBytes.length, salt, iter, this.digest, keySpec.getKeyLength() / 8);
            PBEKeyImpl pbeKey = new PBEKeyImpl(this.algorithm, dk, password, salt, iter);
            password = null;
            PBEKeyImpl pBEKeyImpl = pbeKey;
            return pBEKeyImpl;
        }
        catch (InvalidParameterException ex) {
            throw new InvalidKeySpecException("Unable to encode password", ex);
        }
        finally {
            Util.clearArray(password);
            Util.clearArray(pwBytes);
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!(key instanceof PBEKey && key.getAlgorithm().equalsIgnoreCase(this.algorithm) && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        PBEKeySpec keySpec = this.toKeySpec((PBEKey)key);
        try {
            PBEKeyImpl pBEKeyImpl = this.generateSecret(keySpec);
            return pBEKeyImpl;
        }
        catch (InvalidKeySpecException ex) {
            throw new InvalidKeyException(ex.getMessage(), ex);
        }
        finally {
            keySpec.clearPassword();
        }
    }

    static final class PBEKeyImpl
    implements PBEKey,
    Destroyable {
        final String algorithm;
        byte[] dk;
        char[] password;
        final byte[] salt;
        final int iterationCount;

        PBEKeyImpl(String algorithm, byte[] dk, char[] password, byte[] salt, int iterationCount) {
            this.algorithm = algorithm;
            this.dk = dk;
            this.password = password;
            this.salt = salt;
            this.iterationCount = iterationCount;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            if (this.dk == null) {
                throw new IllegalStateException("key data has been cleared");
            }
            return (byte[])this.dk.clone();
        }

        @Override
        public char[] getPassword() {
            if (this.password == null) {
                throw new IllegalStateException("password has been cleared");
            }
            return (char[])this.password.clone();
        }

        @Override
        public byte[] getSalt() {
            return (byte[])this.salt.clone();
        }

        @Override
        public int getIterationCount() {
            return this.iterationCount;
        }

        @Override
        public void destroy() {
            if (this.dk != null) {
                Arrays.fill(this.dk, (byte)0);
                this.dk = null;
            }
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
                this.password = null;
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.dk == null && this.password == null;
        }

        public int hashCode() {
            return this.algorithm.hashCode() + Util.hashCode(this.dk) + Util.hashCode(this.salt);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PBEKeyImpl)) {
                return false;
            }
            PBEKeyImpl other = (PBEKeyImpl)obj;
            return this.algorithm.equals(other.algorithm) && Util.equalsTC(this.dk, other.dk) && Util.equalsTC(this.password, other.password) && Util.equalsTC(this.salt, other.salt) && this.iterationCount == other.iterationCount;
        }
    }

    public static final class SHA512_8BIT
    extends EncodePassword8BIT {
        public SHA512_8BIT() {
            super("PBKDF2WithHmacSHA512and8BIT", MdAlg.SHA512);
        }
    }

    public static final class SHA384_8BIT
    extends EncodePassword8BIT {
        public SHA384_8BIT() {
            super("PBKDF2WithHmacSHA384and8BIT", MdAlg.SHA384);
        }
    }

    public static final class SHA256_8BIT
    extends EncodePassword8BIT {
        public SHA256_8BIT() {
            super("PBKDF2WithHmacSHA256and8BIT", MdAlg.SHA256);
        }
    }

    public static final class SHA224_8BIT
    extends EncodePassword8BIT {
        public SHA224_8BIT() {
            super("PBKDF2WithHmacSHA224and8BIT", MdAlg.SHA224);
        }
    }

    public static final class SHA1_8BIT
    extends EncodePassword8BIT {
        public SHA1_8BIT() {
            super("PBKDF2WithHmacSHA1and8BIT", MdAlg.SHA1);
        }
    }

    public static final class SHA512
    extends Pbkdf2KeyFactory {
        public SHA512() {
            super("PBKDF2WithHmacSHA512", MdAlg.SHA512);
        }
    }

    public static final class SHA384
    extends Pbkdf2KeyFactory {
        public SHA384() {
            super("PBKDF2WithHmacSHA384", MdAlg.SHA384);
        }
    }

    public static final class SHA256
    extends Pbkdf2KeyFactory {
        public SHA256() {
            super("PBKDF2WithHmacSHA256", MdAlg.SHA256);
        }
    }

    public static final class SHA224
    extends Pbkdf2KeyFactory {
        public SHA224() {
            super("PBKDF2WithHmacSHA224", MdAlg.SHA224);
        }
    }

    public static final class SHA1
    extends Pbkdf2KeyFactory {
        public SHA1() {
            super("PBKDF2WithHmacSHA1", MdAlg.SHA1);
        }
    }

    static class EncodePassword8BIT
    extends Pbkdf2KeyFactory {
        public EncodePassword8BIT(String algorithm, MdAlg digest) {
            super(algorithm, digest);
        }

        @Override
        final byte[] encodePassword(char[] password) {
            byte[] bytes = new byte[password.length];
            for (int i = 0; i < password.length; ++i) {
                bytes[i] = (byte)password[i];
            }
            return bytes;
        }
    }
}

