/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.spi.InternalProvider;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;

class WrapUtil {
    WrapUtil() {
    }

    static Key createKey(String alg, int type, byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeyException {
        if (type == 3) {
            return new SecretKeySpec(keyBytes, alg);
        }
        KeyFactory kf = KeyFactory.getInstance(alg, InternalProvider.get());
        try {
            if (type == 1) {
                return kf.generatePublic(new X509EncodedKeySpec(keyBytes));
            }
            return kf.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Key cannot be constructed", e);
        }
    }
}

