/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedTruffleCompilationIdentifier
extends IsolatedObjectProxy<CompilationIdentifier>
implements TruffleCompilationIdentifier {
    private static final CompilationIdentifier.Verbosity[] VERBOSITIES = CompilationIdentifier.Verbosity.values();
    private final String[] descriptions = new String[VERBOSITIES.length];
    private final TruffleCompilationTask task;
    private final TruffleCompilable compilable;

    IsolatedTruffleCompilationIdentifier(ClientHandle<CompilationIdentifier> handle, TruffleCompilationTask task, TruffleCompilable compilable) {
        super(handle);
        this.task = task;
        this.compilable = compilable;
    }

    public TruffleCompilable getCompilable() {
        return this.compilable;
    }

    public TruffleCompilationTask getTask() {
        return this.task;
    }

    public String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    public String toString(CompilationIdentifier.Verbosity verbosity) {
        int ordinal = verbosity.ordinal();
        if (this.descriptions[ordinal] == null) {
            CompilerHandle<String> h = IsolatedTruffleCompilationIdentifier.toString0(IsolatedCompileContext.get().getClient(), (ClientHandle<CompilationIdentifier>)this.handle, ordinal);
            this.descriptions[ordinal] = (String)IsolatedCompileContext.get().unhand(h);
        }
        return this.descriptions[ordinal];
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static CompilerHandle<String> toString0(ClientIsolateThread client, ClientHandle<CompilationIdentifier> idHandle, int verbosityOrdinal) {
        CompilationIdentifier id = (CompilationIdentifier)IsolatedCompileClient.get().unhand(idHandle);
        String description = id.toString(VERBOSITIES[verbosityOrdinal]);
        return IsolatedCompileClient.get().createStringInCompiler(description);
    }
}

