/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeClosure;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.truffle.api.interop.TruffleObject;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class NativeAPIImpl {
    static final CEntryPointLiteral<NativeAPI.GetTruffleContextFunction> GET_TRUFFLE_CONTEXT = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"getTruffleContext", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class});
    static final CEntryPointLiteral<NativeAPI.NewObjectRefFunction> NEW_OBJECT_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"newObjectRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.ReleaseObjectRefFunction> RELEASE_OBJECT_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"releaseObjectRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.ReleaseAndReturnFunction> RELEASE_AND_RETURN = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"releaseAndReturn", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.IsSameObjectFunction> IS_SAME_OBJECT = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"isSameObject", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.NewClosureRefFunction> NEW_CLOSURE_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"newClosureRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, PointerBase.class});
    static final CEntryPointLiteral<NativeAPI.ReleaseClosureRefFunction> RELEASE_CLOSURE_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"releaseClosureRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, PointerBase.class});
    static final CEntryPointLiteral<NativeAPI.GetClosureObjectFunction> GET_CLOSURE_OBJECT = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"getClosureObject", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, PointerBase.class});
    static final CEntryPointLiteral<NativeAPI.ExceptionCheckFunction> EXCEPTION_CHECK = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"exceptionCheck", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class});
    static final CEntryPointLiteral<NativeAPI.GetTruffleEnvFunction> GET_TRUFFLE_ENV = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"getTruffleEnv", (Class[])new Class[]{NativeAPI.NativeTruffleContext.class});
    static final CEntryPointLiteral<NativeAPI.AttachCurrentThreadFunction> ATTACH_CURRENT_THREAD = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"attachCurrentThread", (Class[])new Class[]{NativeAPI.NativeTruffleContext.class});
    static final CEntryPointLiteral<NativeAPI.DetachCurrentThreadFunction> DETACH_CURRENT_THREAD = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"detachCurrentThread", (Class[])new Class[]{NativeAPI.NativeTruffleContext.class});

    NativeAPIImpl() {
    }

    private static Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext lookupContext(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        return support.resolveContextHandle(context.contextHandle());
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static NativeAPI.NativeTruffleContext getTruffleContext(NativeAPI.NativeTruffleEnv env) {
        return env.context();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static TruffleObjectHandle newObjectRef(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Object object = support.resolveHandle(handle);
        return support.createGlobalHandle(object);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static void releaseObjectRef(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle) {
        ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).destroyGlobalHandle(handle);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static TruffleObjectHandle releaseAndReturn(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Object object = support.resolveHandle(handle);
        support.destroyGlobalHandle(handle);
        return TruffleNFISupport.createLocalHandle(object);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static int isSameObject(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle1, TruffleObjectHandle handle2) {
        Object object2;
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Object object1 = support.resolveHandle(handle1);
        return object1 == (object2 = support.resolveHandle(handle2)) ? 1 : 0;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static void newClosureRef(NativeAPI.NativeTruffleEnv env, PointerBase closure) {
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext context = NativeAPIImpl.lookupContext(env.context());
        context.newClosureRef(closure.rawValue());
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static void releaseClosureRef(NativeAPI.NativeTruffleEnv env, PointerBase closure) {
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext context = NativeAPIImpl.lookupContext(env.context());
        context.releaseClosureRef(closure.rawValue());
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static TruffleObjectHandle getClosureObject(NativeAPI.NativeTruffleEnv env, PointerBase closure) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext context = NativeAPIImpl.lookupContext(env.context());
        TruffleObject ret = context.getClosureObject(closure.rawValue());
        return support.createGlobalHandle(ret);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class)
    static boolean exceptionCheck(NativeAPI.NativeTruffleEnv env) {
        return NativeClosure.pendingException.get() != null;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=GetTruffleEnvPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static NativeAPI.NativeTruffleEnv getTruffleEnv(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext ctx = support.resolveContextHandle(context.contextHandle());
        return (NativeAPI.NativeTruffleEnv)WordFactory.pointer((long)ctx.getNativeEnv());
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=AttachCurrentThreadPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static NativeAPI.NativeTruffleEnv attachCurrentThread(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext ctx = support.resolveContextHandle(context.contextHandle());
        if (ctx.attachThread()) {
            return (NativeAPI.NativeTruffleEnv)WordFactory.pointer((long)ctx.getNativeEnv());
        }
        return (NativeAPI.NativeTruffleEnv)WordFactory.nullPointer();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=EnterNativeTruffleContextPrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class)
    static void detachCurrentThread(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext ctx = support.resolveContextHandle(context.contextHandle());
        ctx.detachThread();
    }

    static class EnterNativeTruffleEnvPrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString((String)"Thread failed to enter its existing context.");

        EnterNativeTruffleEnvPrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(NativeAPI.NativeTruffleEnv env) {
            int code = CEntryPointActions.enter((IsolateThread)env.isolateThread());
            if (code != 0) {
                CEntryPointActions.failFatally((int)code, (CCharPointer)((CCharPointer)errorMessage.get()));
            }
        }
    }

    static class EnterNativeTruffleContextPrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString((String)"Thread failed to enter the isolate of the truffle context.");

        EnterNativeTruffleContextPrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(NativeAPI.NativeTruffleContext context) {
            int code = CEntryPointActions.enterByIsolate((Isolate)context.isolate());
            if (code != 0) {
                CEntryPointActions.failFatally((int)code, (CCharPointer)((CCharPointer)errorMessage.get()));
            }
        }
    }

    static class AttachCurrentThreadPrologue
    implements CEntryPointOptions.Prologue {
        AttachCurrentThreadPrologue() {
        }

        @Uninterruptible(reason="prologue")
        static int enter(NativeAPI.NativeTruffleContext context) {
            return CEntryPointActions.enterAttachThread((Isolate)context.isolate(), (boolean)false, (boolean)true);
        }
    }

    static class GetTruffleEnvPrologue
    implements CEntryPointOptions.Prologue {
        GetTruffleEnvPrologue() {
        }

        @Uninterruptible(reason="prologue")
        static int enter(NativeAPI.NativeTruffleContext context) {
            return CEntryPointActions.enterByIsolate((Isolate)context.isolate());
        }
    }
}

