/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.diagnosticsagent;

import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public class NativeImageDiagnosticsAgentJNIHandleSet
extends JNIHandleSet {
    private JNIObjectHandle classInitializationTracking = (JNIObjectHandle)JNIObjectHandles.nullHandle();
    private JNIMethodId reportClassInitialized = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId reportObjectInstantiated = (JNIMethodId)WordFactory.nullPointer();
    final JNIObjectHandle javaLangStackTraceElement;
    final JNIMethodId javaLangStackTraceElementCtor4;

    public NativeImageDiagnosticsAgentJNIHandleSet(JNIEnvironment env) {
        super(env);
        this.javaLangStackTraceElement = this.newClassGlobalRef(env, "java/lang/StackTraceElement");
        this.javaLangStackTraceElementCtor4 = this.getMethodId(env, this.javaLangStackTraceElement, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", false);
    }

    public void initializeTrackingSupportHandles(JNIEnvironment env) {
        assert (this.classInitializationTracking.equal((ComparableWord)JNIObjectHandles.nullHandle()) && this.reportClassInitialized.isNull() && this.reportObjectInstantiated.isNull()) : "Attempt to reinitialize tracking support handles.";
        this.classInitializationTracking = this.newClassGlobalRef(env, "org/graalvm/nativeimage/impl/clinit/ClassInitializationTracking");
        this.reportClassInitialized = this.getMethodId(env, this.classInitializationTracking, "reportClassInitialized", "(Ljava/lang/Class;[Ljava/lang/StackTraceElement;)V", true);
        this.reportObjectInstantiated = this.getMethodId(env, this.classInitializationTracking, "reportObjectInstantiated", "(Ljava/lang/Object;[Ljava/lang/StackTraceElement;)V", true);
    }

    public JNIObjectHandle getClassInitializationTrackingClassHandle() {
        assert (this.classInitializationTracking.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) : "Attempt to access uninitialized class handle.";
        return this.classInitializationTracking;
    }

    public JNIMethodId getReportClassInitializedMethodId() {
        assert (this.reportClassInitialized.isNonNull()) : "Attempt to access an uninitialized method handle.";
        return this.reportClassInitialized;
    }

    public JNIMethodId getReportObjectInstantiatedMethodId() {
        assert (this.reportObjectInstantiated.isNonNull()) : "Attempt to access an uninitialized method handle.";
        return this.reportObjectInstantiated;
    }
}

