/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import com.oracle.svm.configure.filters.ModuleFilterTools;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import org.graalvm.nativeimage.ImageInfo;

public final class ConfigurationGenerateFiltersCommand
extends ConfigurationCommand {
    @Override
    public String getName() {
        return "generate-filters";
    }

    @Override
    public void apply(Iterator<String> argumentsIterator) throws IOException {
        Path outputPath = null;
        boolean reduce = false;
        ArrayList<String> args = new ArrayList<String>();
        while (argumentsIterator.hasNext()) {
            String argument = argumentsIterator.next();
            if (argument.startsWith("--reduce")) {
                String[] optionValue = argument.split("=", 2);
                reduce = optionValue.length < 2 || Boolean.parseBoolean(optionValue[1]);
                continue;
            }
            args.add(argument);
        }
        HierarchyFilterNode rootNode = HierarchyFilterNode.createRoot();
        ComplexFilter filter = new ComplexFilter(rootNode);
        boolean filterModified = false;
        block22: for (String arg : args) {
            String[] optionValue = arg.split("=", 2);
            String option = optionValue[0];
            String value = optionValue.length > 1 ? optionValue[1] : null;
            switch (option) {
                case "--include-packages-from-modules": 
                case "--exclude-packages-from-modules": 
                case "--exclude-unexported-packages-from-modules": {
                    if (!ImageInfo.inImageCode()) {
                        ConfigurationFilter.Inclusion exportedInclusion;
                        if (filterModified) {
                            throw new ConfigurationUsageException(option + " must be specified before other rule-creating arguments");
                        }
                        filterModified = true;
                        String[] moduleNames = value != null ? value.split(",") : new String[]{};
                        ConfigurationFilter.Inclusion unexportedInclusion = exportedInclusion = option.startsWith("--include") ? ConfigurationFilter.Inclusion.Include : ConfigurationFilter.Inclusion.Exclude;
                        ConfigurationFilter.Inclusion rootInclusion = exportedInclusion.invert();
                        if (option.equals("--exclude-unexported-packages-from-modules")) {
                            rootInclusion = ConfigurationFilter.Inclusion.Include;
                            exportedInclusion = ConfigurationFilter.Inclusion.Include;
                            unexportedInclusion = ConfigurationFilter.Inclusion.Exclude;
                        }
                        filter.setHierarchyFilterNode(ModuleFilterTools.generateFromModules(moduleNames, rootInclusion, exportedInclusion, unexportedInclusion, reduce));
                        continue block22;
                    }
                    throw new ConfigurationUsageException(option + " is currently not supported in the native-image build of this tool.");
                }
                case "--input-file": {
                    filterModified = true;
                    new FilterConfigurationParser(filter).parseAndRegister(ConfigurationGenerateFiltersCommand.requirePathUri(option, value));
                    continue block22;
                }
                case "--output-file": {
                    outputPath = ConfigurationGenerateFiltersCommand.requirePath(option, value);
                    continue block22;
                }
                case "--include-classes": {
                    filterModified = true;
                    ConfigurationGenerateFiltersCommand.addSingleRule(filter.getHierarchyFilterNode(), option, value, ConfigurationFilter.Inclusion.Include);
                    continue block22;
                }
                case "--exclude-classes": {
                    filterModified = true;
                    ConfigurationGenerateFiltersCommand.addSingleRule(filter.getHierarchyFilterNode(), option, value, ConfigurationFilter.Inclusion.Exclude);
                    continue block22;
                }
            }
            throw new ConfigurationUsageException("Unknown argument: " + option);
        }
        filter.getHierarchyFilterNode().removeRedundantNodes();
        if (outputPath != null) {
            try (FileOutputStream os = new FileOutputStream(outputPath.toFile());){
                ConfigurationGenerateFiltersCommand.printFilterToStream(filter, os);
            }
        } else {
            ConfigurationGenerateFiltersCommand.printFilterToStream(filter, System.out);
        }
    }

    @Override
    protected String getDescription0() {
        return "          builds a class filter according to the parameters.\n                          Filter rules are created according to the order of\n                          these parameters, and filter rules are applied in\n                          their order so that the last matching one \"wins\", so\n                          the order of the parameters is relevant. Filter files\n                          can be used with the caller-filter-file option of\n                          native-image-agent.\n    --include-classes=<class-pattern>\n                          adds a single rule to include a specific class, such\n                          as \"com.oracle.graal.Compiler\", or classes matching a\n                          specified pattern, for example \"com.oracle.graal.*\"\n                          for classes directly in package \"com.oracle.graal\",\n                          or \"com.oracle.graal.** (double asterisks) for all\n                          classes in \"com.oracle.graal\" AND all of its\n                          subpackages and their subpackages, recursively. The\n                          rule can potentially override rules from preceding\n                          parameters. Can be specified several times.\n    --exclude-classes=<class-pattern>\n                          adds a single rule to exclude classes matching the\n                          specified pattern, potentially overriding rules from\n                          preceding parameters. Can be specified several times.\n    --input-file=<path>\n                          reads a file with filter rules from the given path.\n                          Rules are processed in the order in which they occur\n                          in the file, so that subsequent rules potentially\n                          override preceding rules, including those from the\n                          --include and --exclude parameters. Can be specified\n                          several times.\n    --output-file=<path>\n                          specifies a file to which the output file is written.\n                          If this parameter is not provided, the filter is\n                          written to standard output.\n".replaceAll("\n", System.lineSeparator());
    }

    private static void printFilterToStream(ConfigurationFilter filter, OutputStream targetStream) throws IOException {
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(targetStream));){
            filter.printJson(writer);
        }
    }

    private static void addSingleRule(HierarchyFilterNode root, String argName, String qualifiedPkg, ConfigurationFilter.Inclusion inclusion) {
        if (qualifiedPkg == null || qualifiedPkg.isEmpty()) {
            throw new ConfigurationUsageException("Argument must be provided for: " + argName);
        }
        if (qualifiedPkg.indexOf(42) != -1 && !qualifiedPkg.endsWith(".**") && !qualifiedPkg.endsWith(".*")) {
            throw new ConfigurationUsageException("Rule may only contain '*' at the end, either as .* to include all classes in the package, or as .** to include all classes in the package and all of its subpackages");
        }
        root.addOrGetChildren(qualifiedPkg, inclusion);
    }
}

