/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.jdk.InternalVMMethod;
import jdk.internal.foreign.abi.VMStorage;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@InternalVMMethod
public final class DowncallStubsHolder {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ConstantPool getConstantPool(MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(DowncallStubsHolder.class).getDeclaredConstructors()[0].getConstantPool();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String stubName(NativeEntryPointInfo nep) {
        StringBuilder builder = new StringBuilder("downcall_");
        for (Class<?> param : nep.methodType().parameterArray()) {
            builder.append(JavaKind.fromJavaClass(param).getTypeChar());
        }
        builder.append("_");
        builder.append(JavaKind.fromJavaClass((Class)nep.methodType().returnType()).getTypeChar());
        if (nep.needsReturnBuffer()) {
            builder.append("_r");
        }
        if (nep.capturesCallState()) {
            builder.append("_c");
        }
        if (nep.skipsTransition()) {
            builder.append("_t");
        }
        StringBuilder assignmentsBuilder = new StringBuilder();
        for (VMStorage assignment : nep.parametersAssignment()) {
            assignmentsBuilder.append(assignment);
        }
        if (nep.returnsAssignment() != null) {
            assignmentsBuilder.append('_');
            for (VMStorage assignment : nep.returnsAssignment()) {
                assignmentsBuilder.append(assignment);
            }
        }
        builder.append('_');
        builder.append(SubstrateUtil.digest((String)assignmentsBuilder.toString()));
        return builder.toString();
    }

    private DowncallStubsHolder() {
    }
}

