/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.LinkToNativeSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.LinkToNativeSupportImpl;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.foreign.DowncallStub;
import com.oracle.svm.hosted.foreign.ForeignFunctionsConfigurationParser;
import com.oracle.svm.hosted.foreign.StronglyTypedRuntimeForeignAccessSupport;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ForeignFunctionsFeature
implements InternalFeature {
    private static final int FIRST_SUPPORTED_PREVIEW = 21;
    private static final int FIRST_SUPPORTED_NON_PREVIEW = 0x7FFFFFFE;
    private static final Map<String, String[]> REQUIRES_CONCEALED = Map.of("jdk.internal.vm.ci", new String[]{"jdk.vm.ci.code", "jdk.vm.ci.meta", "jdk.vm.ci.amd64"}, "java.base", new String[]{"jdk.internal.foreign", "jdk.internal.foreign.abi", "jdk.internal.foreign.abi.x64", "jdk.internal.foreign.abi.x64.sysv", "jdk.internal.foreign.abi.x64.windows"});
    private boolean sealed = false;
    private final RuntimeForeignAccessSupportImpl accessSupport = new RuntimeForeignAccessSupportImpl();
    private final Set<Pair<FunctionDescriptor, Linker.Option[]>> registeredDowncalls = ConcurrentHashMap.newKeySet();
    private int downcallCount = 0;

    private static boolean isPreviewEnabled() {
        try {
            return (Boolean)ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.misc.PreviewFeatures"), (String)"isEnabled", (Class[])new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere((Throwable)e);
        }
    }

    @Fold
    public static ForeignFunctionsFeature singleton() {
        return (ForeignFunctionsFeature)ImageSingletons.lookup(ForeignFunctionsFeature.class);
    }

    private void checkNotSealed() {
        UserError.guarantee((!this.sealed ? 1 : 0) != 0, (String)"Registration of foreign functions was closed.", (Object[])new Object[0]);
    }

    ForeignFunctionsFeature() {
        for (Map.Entry<String, String[]> modulePackages : REQUIRES_CONCEALED.entrySet()) {
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, ForeignFunctionsFeature.class, (boolean)false, (String)modulePackages.getKey(), (String[])modulePackages.getValue());
        }
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateUtil.getArchitectureName().contains("amd64") && !SubstrateOptions.useLLVMBackend();
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        assert (JavaVersionUtil.JAVA_SPEC >= 21 && ForeignFunctionsFeature.isPreviewEnabled() || JavaVersionUtil.JAVA_SPEC >= 0x7FFFFFFE);
        UserError.guarantee((!SubstrateOptions.useLLVMBackend() ? 1 : 0) != 0, (String)"Foreign functions interface is in use, but is not supported together with the LLVM backend.", (Object[])new Object[0]);
        ImageSingletons.add(AbiUtils.class, (Object)AbiUtils.create());
        ImageSingletons.add(ForeignFunctionsRuntime.class, (Object)new ForeignFunctionsRuntime());
        ImageSingletons.add(RuntimeForeignAccessSupport.class, (Object)this.accessSupport);
        ImageSingletons.add(LinkToNativeSupport.class, (Object)new LinkToNativeSupportImpl());
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ForeignFunctionsConfigurationParser parser = new ForeignFunctionsConfigurationParser(this.accessSupport);
        ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)parser, (ImageClassLoader)access.getImageClassLoader(), (String)"panama foreign", (HostedOptionKey)ConfigurationFiles.Options.ForeignConfigurationFiles, (HostedOptionKey)ConfigurationFiles.Options.ForeignResources, (String)ConfigurationFile.FOREIGN.getFileName());
    }

    private void createDowncallStubs(FeatureImpl.BeforeAnalysisAccessImpl access) {
        this.downcallCount = this.createStubs(this.registeredDowncalls, access, AbiUtils.singleton()::makeNativeEntrypoint, n -> new DowncallStub((NativeEntryPointInfo)n, access.getMetaAccess().getWrapped()), ForeignFunctionsRuntime.singleton()::addDowncallStubPointer);
    }

    private <S> int createStubs(Set<Pair<FunctionDescriptor, Linker.Option[]>> source, FeatureImpl.BeforeAnalysisAccessImpl access, BiFunction<FunctionDescriptor, Linker.Option[], S> stubGenerator, Function<S, ResolvedJavaMethod> wrapper, BiConsumer<S, CFunctionPointer> register) {
        HashMap<S, AnalysisMethod> created = new HashMap<S, AnalysisMethod>();
        for (Pair<FunctionDescriptor, Linker.Option[]> fdOptionsPair : source) {
            S nepi = stubGenerator.apply((FunctionDescriptor)fdOptionsPair.getLeft(), (Linker.Option[])fdOptionsPair.getRight());
            if (created.containsKey(nepi)) continue;
            ResolvedJavaMethod stub = wrapper.apply(nepi);
            AnalysisMethod analysisStub = access.getUniverse().lookup((JavaMethod)stub);
            access.getBigBang().addRootMethod(analysisStub, false, (Object)("Foreign stub, registered in " + String.valueOf(ForeignFunctionsFeature.class)), new MultiMethod.MultiMethodKey[0]);
            created.put(nepi, analysisStub);
            register.accept(nepi, (CFunctionPointer)new MethodPointer((ResolvedJavaMethod)analysisStub));
        }
        source.clear();
        return created.size();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.sealed = true;
        AbiUtils.singleton().checkLibrarySupport();
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.foreign.abi.DowncallLinker"), (String)"USE_SPEC"), (receiver, originalValue) -> false);
        access.registerAsRoot((Executable)ReflectionUtil.lookupMethod(ForeignFunctionsRuntime.class, (String)"captureCallState", (Class[])new Class[]{Integer.TYPE, CIntPointer.class}), false, "Runtime support, registered in " + String.valueOf(ForeignFunctionsFeature.class), new MultiMethod.MultiMethodKey[0]);
        this.createDowncallStubs(access);
        ProgressReporter.singleton().setForeignFunctionsInfo(this.getCreatedDowncallStubsCount());
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{ForeignFunctionsRuntime.CAPTURE_CALL_STATE});
    }

    public int getCreatedDowncallStubsCount() {
        assert (this.sealed);
        return this.downcallCount;
    }

    private class RuntimeForeignAccessSupportImpl
    extends ConditionalConfigurationRegistry
    implements StronglyTypedRuntimeForeignAccessSupport {
        private RuntimeForeignAccessSupportImpl() {
        }

        @Override
        public void registerForDowncall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
            ForeignFunctionsFeature.this.checkNotSealed();
            this.registerConditionalConfiguration(condition, () -> ForeignFunctionsFeature.this.registeredDowncalls.add((Pair<FunctionDescriptor, Linker.Option[]>)Pair.create((Object)desc, (Object)options)));
        }
    }
}

