/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface CEntryPointOptions {
    public Class<? extends Function<String, String>> nameTransformation() default DefaultNameTransformation.class;

    public Class<? extends Prologue> prologue() default AutomaticPrologue.class;

    public Class<? extends PrologueBailout> prologueBailout() default AutomaticPrologueBailout.class;

    public Class<? extends Epilogue> epilogue() default CEntryPointSetup.LeaveEpilogue.class;

    public Class<? extends CallerEpilogue> callerEpilogue() default NoCallerEpilogue.class;

    public static final class NoCallerEpilogue
    implements CallerEpilogue {
    }

    public static interface CallerEpilogue {
    }

    public static final class NoEpilogue
    implements Epilogue {
    }

    public static interface Epilogue {
    }

    public static final class ReturnNullPointer
    implements PrologueBailout {
        @Uninterruptible(reason="Thread state not set up yet.")
        public static PointerBase bailout(int prologueResult) {
            return WordFactory.nullPointer();
        }
    }

    public static final class AutomaticPrologueBailout
    implements PrologueBailout {
    }

    public static interface PrologueBailout {
    }

    public static final class NoPrologue
    implements Prologue {
    }

    public static final class AutomaticPrologue
    implements Prologue {
    }

    public static interface Prologue {
    }

    public static final class UnchangedNameTransformation
    implements Function<String, String> {
        @Override
        public String apply(String name) {
            return name;
        }
    }

    public static final class DefaultNameTransformation
    implements Function<String, String> {
        @Override
        public String apply(String name) {
            return SubstrateOptions.EntryPointNamePrefix.getValue() + name;
        }
    }
}

