/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

final class StackVerifier {
    private static final StackFrameVerificationVisitor STACK_FRAME_VISITOR = new StackFrameVerificationVisitor();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private StackVerifier() {
    }

    @NeverInline(value="Starts a stack walk in the caller frame")
    public static boolean verifyAllThreads() {
        boolean result = true;
        STACK_FRAME_VISITOR.initialize();
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), STACK_FRAME_VISITOR);
        result &= StackVerifier.STACK_FRAME_VISITOR.result;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                if (thread != CurrentIsolate.getCurrentThread()) {
                    STACK_FRAME_VISITOR.initialize();
                    JavaStackWalker.walkThread(thread, STACK_FRAME_VISITOR);
                    result &= StackVerifier.STACK_FRAME_VISITOR.result;
                }
                thread = VMThreads.nextThread(thread);
            }
        }
        return result;
    }

    private static class StackFrameVerificationVisitor
    extends StackFrameVisitor {
        private final VerifyFrameReferencesVisitor verifyFrameReferencesVisitor = new VerifyFrameReferencesVisitor();
        private boolean result;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        StackFrameVerificationVisitor() {
        }

        public void initialize() {
            this.result = true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the stack.")
        public boolean visitFrame(Pointer currentSP, CodePointer currentIP, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            this.verifyFrameReferencesVisitor.initialize(currentSP, currentIP);
            CodeInfoTable.visitObjectReferences(currentSP, currentIP, codeInfo, deoptimizedFrame, this.verifyFrameReferencesVisitor);
            this.result &= this.verifyFrameReferencesVisitor.result;
            return true;
        }
    }

    public static class VerifyFrameReferencesVisitor
    implements ObjectReferenceVisitor {
        private Pointer sp;
        private CodePointer ip;
        private boolean result;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        VerifyFrameReferencesVisitor() {
        }

        public void initialize(Pointer sp, CodePointer ip) {
            this.sp = sp;
            this.ip = ip;
            this.result = true;
        }

        public Pointer getSP() {
            return this.sp;
        }

        public CodePointer getIP() {
            return this.ip;
        }

        @Override
        @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"}, justification="Non-short circuit logic is used on purpose here.")
        public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            assert (holderObject == null);
            this.result &= HeapVerifier.verifyReference((Object)this, objRef, compressed);
            return true;
        }
    }
}

