/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import jdk.internal.loader.ClassLoaderValue;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.module.ServicesCatalog;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class RuntimeClassLoaderValueSupport {
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private ConcurrentHashMap<?, ?> bootLoaderCLV = new ConcurrentHashMap();
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private ConcurrentHashMap<ClassLoader, ConcurrentHashMap<?, ?>> classLoaderValueMaps = new ConcurrentHashMap();
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    ClassLoaderValue<ServicesCatalog> servicesCatalogCLV = new ClassLoaderValue();
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    ClassLoaderValue<List<ModuleLayer>> moduleLayerCLV = new ClassLoaderValue();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassLoader hostedBootLoader;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Field classLoaderCLVField = ReflectionUtil.lookupField(ClassLoader.class, (String)"classLoaderValueMap");
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final ClassLoaderValue<ServicesCatalog> hostedServicesCatalogCLV = (ClassLoaderValue)ReflectionUtil.readField(ServicesCatalog.class, (String)"CLV", null);

    public static RuntimeClassLoaderValueSupport instance() {
        return (RuntimeClassLoaderValueSupport)ImageSingletons.lookup(RuntimeClassLoaderValueSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void update(List<ModuleLayer> runtimeModuleLayers) {
        for (ModuleLayer runtimeLayer : runtimeModuleLayers) {
            Set loaders = runtimeLayer.modules().stream().map(Module::getClassLoader).collect(Collectors.toSet());
            for (ClassLoader loader : loaders) {
                this.bindRuntimeModuleLayerToLoader(runtimeLayer, loader);
                this.registerServicesCatalog(loader);
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ConcurrentHashMap<?, ?> getClassLoaderValueMapForLoader(ClassLoader loader) {
        if (loader == null) {
            return this.bootLoaderCLV;
        }
        return this.classLoaderValueMaps.computeIfAbsent(loader, k -> new ConcurrentHashMap());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassLoader resolveClassLoader(ClassLoader loaderOrNull) {
        if (loaderOrNull == null) {
            if (this.hostedBootLoader != null) {
                return this.hostedBootLoader;
            }
            Method method = ReflectionUtil.lookupMethod(ClassLoaders.class, (String)"bootLoader", (Class[])new Class[0]);
            this.hostedBootLoader = (ClassLoader)ReflectionUtil.invokeMethod((Method)method, null, (Object[])new Object[0]);
            return this.hostedBootLoader;
        }
        return loaderOrNull;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void bindRuntimeModuleLayerToLoader(ModuleLayer layer, ClassLoader loaderOrNull) {
        List previous;
        ClassLoader loader = this.resolveClassLoader(loaderOrNull);
        List<ModuleLayer> list = (CopyOnWriteArrayList<ModuleLayer>)this.moduleLayerCLV.get(loader);
        if (list == null && (previous = (List)this.moduleLayerCLV.putIfAbsent(loader, list = new CopyOnWriteArrayList<ModuleLayer>())) != null) {
            list = previous;
        }
        list.add(layer);
        ConcurrentHashMap<?, ?> classLoaderValueMap = this.getClassLoaderValueMapForLoader(loader);
        classLoaderValueMap.put(this.moduleLayerCLV, list);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void registerServicesCatalog(ClassLoader loaderOrNull) {
        ClassLoader loader = this.resolveClassLoader(loaderOrNull);
        ServicesCatalog servicesCatalog = this.getHostedServiceCatalogForLoader(loader);
        if (servicesCatalog == null) {
            servicesCatalog = ServicesCatalog.create();
        }
        this.servicesCatalogCLV.putIfAbsent(loader, servicesCatalog);
        ConcurrentHashMap<?, ?> classLoaderValueMap = this.getClassLoaderValueMapForLoader(loader);
        classLoaderValueMap.put(this.servicesCatalogCLV, servicesCatalog);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ServicesCatalog getHostedServiceCatalogForLoader(ClassLoader loader) {
        try {
            ConcurrentHashMap hostedLoaderCLV = (ConcurrentHashMap)this.classLoaderCLVField.get(loader);
            ServicesCatalog servicesCatalog = (ServicesCatalog)hostedLoaderCLV.get(this.hostedServicesCatalogCLV);
            return servicesCatalog;
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere("Failed to query ClassLoader.classLoaderValueMap", e);
        }
    }
}

