/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.jdk.localization.OptimizedLocalizationSupport;
import com.oracle.svm.core.jdk.localization.substitutions.modes.OptimizedLocaleMode;
import com.oracle.svm.core.util.VMError;
import java.util.Locale;
import java.util.spi.LocaleServiceProvider;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import sun.util.locale.provider.LocaleProviderAdapter;

@TargetClass(value=LocaleProviderAdapter.class, onlyWith={OptimizedLocaleMode.class})
final class Target_sun_util_locale_provider_LocaleProviderAdapter_OptimizedLocaleMode {
    Target_sun_util_locale_provider_LocaleProviderAdapter_OptimizedLocaleMode() {
    }

    @Substitute
    public static LocaleProviderAdapter getAdapter(Class<? extends LocaleServiceProvider> providerClass, Locale locale) {
        OptimizedLocalizationSupport support = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport();
        for (Locale candidateLocale : support.control.getCandidateLocales("", locale)) {
            LocaleProviderAdapter result = support.adaptersByClass.get(Pair.create(providerClass, (Object)candidateLocale));
            if (result == null) continue;
            return result;
        }
        throw VMError.unsupportedFeature("LocaleProviderAdapter.getAdapter:  providerClass: " + providerClass.getName() + ", locale: " + String.valueOf(locale));
    }

    @Substitute
    public static LocaleProviderAdapter forType(LocaleProviderAdapter.Type type) {
        LocaleProviderAdapter result = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().adaptersByType.get((Object)type);
        if (result != null) {
            return result;
        }
        throw VMError.unsupportedFeature("LocaleProviderAdapter.forType:  type: " + type.toString());
    }
}

