/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import java.util.function.Function;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JNINativeLinkage {
    private PointerBase entryPoint = WordFactory.nullPointer();
    private final CharSequence declaringClass;
    private final CharSequence name;
    private final CharSequence descriptor;
    private CGlobalDataInfo builtInAddress = null;

    public JNINativeLinkage(CharSequence declaringClass, CharSequence name, CharSequence descriptor) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.descriptor = descriptor;
    }

    public String getDeclaringClassName() {
        return (String)this.declaringClass;
    }

    public String getName() {
        return (String)this.name;
    }

    public String getDescriptor() {
        return (String)this.descriptor;
    }

    public boolean isBuiltInFunction() {
        return PlatformNativeLibrarySupport.singleton().isBuiltinPkgNative(this.getShortName());
    }

    public CGlobalDataInfo getOrCreateBuiltInAddress(Function<String, CGlobalDataInfo> createSymbol) {
        assert (this.isBuiltInFunction());
        if (this.builtInAddress == null) {
            this.builtInAddress = createSymbol.apply(this.getShortName());
        }
        return this.builtInAddress;
    }

    public void setEntryPoint(CFunctionPointer fnptr) {
        this.entryPoint = fnptr;
    }

    public void unsetEntryPoint() {
        this.entryPoint = WordFactory.nullPointer();
    }

    public int hashCode() {
        return (this.name.hashCode() * 31 + this.descriptor.hashCode()) * 31 + this.declaringClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JNINativeLinkage) {
            JNINativeLinkage that = (JNINativeLinkage)obj;
            return that == this || JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.declaringClass, (Object)that.declaringClass) && JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.name, (Object)that.name) && JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.descriptor, (Object)that.descriptor);
        }
        return false;
    }

    public String toString() {
        String shortName = this.getShortName();
        return MetaUtil.internalNameToJava((String)this.getDeclaringClassName(), (boolean)true, (boolean)false) + "." + String.valueOf(this.name) + String.valueOf(this.descriptor) + " [symbol: " + shortName + " or " + shortName + "__" + this.getSignature() + "]";
    }

    public PointerBase getOrFindEntryPoint() {
        if (this.entryPoint.isNull()) {
            String shortName = this.getShortName();
            this.entryPoint = NativeLibrarySupport.singleton().findSymbol(shortName);
            if (this.entryPoint.isNull()) {
                String longName = shortName + "__" + this.getSignature();
                this.entryPoint = NativeLibrarySupport.singleton().findSymbol(longName);
                if (this.entryPoint.isNull()) {
                    throw new UnsatisfiedLinkError(this.toString());
                }
            }
        }
        return this.entryPoint;
    }

    private String getShortName() {
        StringBuilder sb = new StringBuilder("Java_");
        JNINativeLinkage.mangleName(this.getDeclaringClassName(), 1, this.getDeclaringClassName().length() - 1, sb);
        sb.append('_');
        JNINativeLinkage.mangleName(this.getName(), 0, this.name.length(), sb);
        return sb.toString();
    }

    private String getSignature() {
        int closing = this.getDescriptor().indexOf(41);
        assert (this.getDescriptor().startsWith("(") && this.getDescriptor().indexOf(41) == closing && closing != -1);
        return JNINativeLinkage.mangleName(this.getDescriptor(), 1, closing, new StringBuilder()).toString();
    }

    private static StringBuilder mangleName(String name, int beginIndex, int endIndex, StringBuilder sb) {
        block6: for (int i = beginIndex; i < endIndex; ++i) {
            char c = name.charAt(i);
            if (c <= '\u007f' && Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '/': {
                    sb.append("_");
                    continue block6;
                }
                case '_': {
                    sb.append("_1");
                    continue block6;
                }
                case ';': {
                    sb.append("_2");
                    continue block6;
                }
                case '[': {
                    sb.append("_3");
                    continue block6;
                }
                default: {
                    sb.append('_');
                    String hex = Integer.toHexString(c);
                    for (int j = hex.length(); j < 5; ++j) {
                        sb.append('0');
                    }
                    sb.append(hex);
                }
            }
        }
        return sb;
    }
}

