/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes;

import java.util.Objects;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Depends on capture function.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Depends on capture function.", allowedUsageTypes={InputType.Memory})
public class CFunctionCaptureNode
extends FixedWithNextNode
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<CFunctionCaptureNode> TYPE = NodeClass.create(CFunctionCaptureNode.class);
    ForeignCallDescriptor captureFunction;
    @Node.Input
    ValueNode statesToCapture;
    @Node.Input
    ValueNode captureBuffer;

    public CFunctionCaptureNode(ForeignCallDescriptor captureFunction, ValueNode statesToCapture, ValueNode captureBuffer) {
        super(TYPE, StampFactory.forVoid());
        this.captureFunction = Objects.requireNonNull(captureFunction);
        this.statesToCapture = Objects.requireNonNull(statesToCapture);
        this.captureBuffer = Objects.requireNonNull(captureBuffer);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public ForeignCallDescriptor getCaptureFunction() {
        return this.captureFunction;
    }

    public ValueNode getStatesToCapture() {
        return this.statesToCapture;
    }

    public ValueNode getCaptureBuffer() {
        return this.captureBuffer;
    }
}

