/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.riscv64;

import com.oracle.svm.core.CPUFeatureAccessImpl;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.riscv64.RISCV64LibCHelper;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.riscv64.RISCV64ReflectionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;

public class RISCV64CPUFeatureAccess
extends CPUFeatureAccessImpl {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RISCV64CPUFeatureAccess(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        super(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static EnumSet<?> enabledRISCV64Flags() {
        Class riscv64Flag = RISCV64ReflectionUtil.lookupClass((boolean)false, (String)"jdk.vm.ci.riscv64.RISCV64$Flag");
        Method of = RISCV64ReflectionUtil.lookupMethod(EnumSet.class, (String)"of", (Class[])new Class[]{Enum.class, Enum.class});
        return (EnumSet)RISCV64ReflectionUtil.invokeMethod((Method)of, null, (Object[])new Object[]{RISCV64ReflectionUtil.readStaticField((Class)riscv64Flag, (String)"UseConservativeFence"), RISCV64ReflectionUtil.readStaticField((Class)riscv64Flag, (String)"AvoidUnalignedAccesses")});
    }

    @Override
    @Platforms(value={Platform.RISCV64.class})
    public EnumSet<?> determineHostCPUFeatures() {
        Class riscv64CPUFeature = RISCV64ReflectionUtil.lookupClass((boolean)false, (String)"jdk.vm.ci.riscv64.RISCV64$CPUFeature");
        Method noneOf = RISCV64ReflectionUtil.lookupMethod(EnumSet.class, (String)"noneOf", (Class[])new Class[]{Class.class});
        EnumSet features = (EnumSet)RISCV64ReflectionUtil.invokeMethod((Method)noneOf, null, (Object[])new Object[]{riscv64CPUFeature});
        RISCV64LibCHelper.CPUFeatures cpuFeatures = (RISCV64LibCHelper.CPUFeatures)StackValue.get(RISCV64LibCHelper.CPUFeatures.class);
        UnmanagedMemoryUtil.fill((Pointer)cpuFeatures, SizeOf.unsigned(RISCV64LibCHelper.CPUFeatures.class), (byte)0);
        RISCV64LibCHelper.determineCPUFeatures(cpuFeatures);
        ArrayList<String> unknownFeatures = new ArrayList<String>();
        for (Object feature : riscv64CPUFeature.getEnumConstants()) {
            if (!this.isFeaturePresent((Enum)feature, (Pointer)cpuFeatures, unknownFeatures)) continue;
            Method add = RISCV64ReflectionUtil.lookupMethod(AbstractCollection.class, (String)"add", (Class[])new Class[]{Object.class});
            RISCV64ReflectionUtil.invokeMethod((Method)add, (Object)features, (Object[])new Object[]{feature});
        }
        if (!unknownFeatures.isEmpty()) {
            throw VMError.shouldNotReachHere("Native image does not support the following JVMCI CPU features: " + String.valueOf(unknownFeatures));
        }
        return features;
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public int verifyHostSupportsArchitectureEarly() {
        return RISCV64LibCHelper.checkCPUFeatures((CCharPointer)BUILDTIME_CPU_FEATURE_MASK.get());
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public void verifyHostSupportsArchitectureEarlyOrExit() {
        RISCV64LibCHelper.checkCPUFeaturesOrExit((CCharPointer)BUILDTIME_CPU_FEATURE_MASK.get(), (CCharPointer)IMAGE_CPU_FEATURE_ERROR_MSG.get());
    }

    @Override
    public void enableFeatures(Architecture runtimeArchitecture) {
        EnumSet<?> features = this.determineHostCPUFeatures();
        Method addAll = RISCV64ReflectionUtil.lookupMethod(AbstractCollection.class, (String)"addAll", (Class[])new Class[]{Object.class});
        Method getFeatures = RISCV64ReflectionUtil.lookupMethod(Architecture.class, (String)"getFeatures", (Class[])new Class[0]);
        try {
            addAll.invoke(getFeatures.invoke((Object)runtimeArchitecture, new Object[0]), features);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

