/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public class VMThreadLocalMTSupport {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    public int vmThreadSize = -1;
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    public byte[] vmThreadReferenceMapEncoding;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    public long vmThreadReferenceMapIndex = -1L;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMThreadLocalMTSupport() {
    }

    @Fold
    public static VMThreadLocalMTSupport singleton() {
        return (VMThreadLocalMTSupport)ImageSingletons.lookup(VMThreadLocalMTSupport.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public NonmovableArray<Byte> getThreadLocalsReferenceMap() {
        assert (this.vmThreadReferenceMapEncoding != null);
        return NonmovableArrays.fromImageHeap((Object)this.vmThreadReferenceMapEncoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getThreadLocalsReferenceMapIndex() {
        long result = this.vmThreadReferenceMapIndex;
        assert (result >= 0L);
        assert ((long)((int)result) == result);
        return (int)result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walk(IsolateThread isolateThread, ObjectReferenceVisitor referenceVisitor) {
        NonmovableArray<Byte> threadRefMapEncoding = NonmovableArrays.fromImageHeap((Object)this.vmThreadReferenceMapEncoding);
        InstanceReferenceMapDecoder.walkOffsetsFromPointer((Pointer)isolateThread, threadRefMapEncoding, this.vmThreadReferenceMapIndex, referenceVisitor, null);
    }
}

