/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.jdk.JDKLibDirectoryProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import jdk.internal.loader.BootLoader;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
public final class JNIRegistrationSupport
extends JNIRegistrationUtil
implements InternalFeature {
    private final ConcurrentMap<String, Boolean> registeredLibraries = new ConcurrentHashMap<String, Boolean>();
    private NativeLibraries nativeLibraries = null;
    private boolean isSunMSCAPIProviderReachable = false;
    private final SortedMap<String, SortedSet<String>> shimExports = new TreeMap<String, SortedSet<String>>();
    private String imageName;
    private FeatureImpl.AfterImageWriteAccessImpl accessImpl;

    public static JNIRegistrationSupport singleton() {
        return (JNIRegistrationSupport)ImageSingletons.lookup(JNIRegistrationSupport.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.nativeLibraries = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getNativeLibraries();
    }

    @Override
    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (JNIRegistrationSupport.isWindows()) {
            Optional<Class<?>> optSunMSCAPIClass = JNIRegistrationSupport.optionalClazz((Feature.FeatureAccess)access, "sun.security.mscapi.SunMSCAPI");
            this.isSunMSCAPIProviderReachable = optSunMSCAPIClass.isPresent() && access.isReachable(optSunMSCAPIClass.get());
        }
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        this.registerLoadLibraryPlugin(providers, plugins, System.class);
        this.registerLoadLibraryPlugin(providers, plugins, BootLoader.class);
    }

    public void registerLoadLibraryPlugin(final Providers providers, GraphBuilderConfiguration.Plugins plugins, Class<?> clazz) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), clazz);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("loadLibrary", new Type[]{String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode libnameNode) {
                if (libnameNode.isConstant()) {
                    JNIRegistrationSupport.this.registerLibrary((String)providers.getSnippetReflection().asObject(String.class, libnameNode.asJavaConstant()));
                }
                return false;
            }
        });
    }

    void registerLibrary(String libname) {
        if (libname != null && this.registeredLibraries.putIfAbsent(libname, Boolean.TRUE) == null && NativeLibrarySupport.singleton().isPreregisteredBuiltinLibrary(libname)) {
            this.nativeLibraries.addStaticJniLibrary(libname, new String[0]);
        }
    }

    public boolean isRegisteredLibrary(String libname) {
        return this.registeredLibraries.containsKey(libname);
    }

    void addJvmShimExports(String ... exports) {
        this.addShimExports("jvm", exports);
    }

    void addJavaShimExports(String ... exports) {
        this.addShimExports("java", exports);
    }

    private void addShimExports(String shimName, String ... exports) {
        assert (exports != null && exports.length > 0);
        this.shimExports.computeIfAbsent(shimName, s -> new TreeSet()).addAll(List.of(exports));
    }

    public static Stream<String> getShimLibrarySymbols() {
        if (ImageSingletons.contains(JNIRegistrationSupport.class)) {
            return JNIRegistrationSupport.singleton().getShimExports();
        }
        return Stream.empty();
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        if (SubstrateOptions.StaticExecutable.getValue().booleanValue() || JNIRegistrationSupport.isDarwin()) {
            return;
        }
        if (this.shimExports.containsKey("jvm") || Options.CreateJvmShim.getValue().booleanValue()) {
            this.addJvmShimExports("JNI_CreateJavaVM", "JNI_GetCreatedJavaVMs", "JNI_GetDefaultJavaVMInitArgs");
        }
        ((FeatureImpl.BeforeImageWriteAccessImpl)access).registerLinkerInvocationTransformer(linkerInvocation -> {
            this.getShimExports().map(JNIRegistrationSupport.isWindows() ? "/export:"::concat : "-Wl,-u,"::concat).forEach(linkerInvocation::addNativeLinkerOption);
            return linkerInvocation;
        });
        this.imageName = ((FeatureImpl.BeforeImageWriteAccessImpl)access).getImageName();
    }

    private Stream<String> getShimExports() {
        return this.shimExports.values().stream().flatMap(Collection::stream).distinct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        if (SubstrateOptions.StaticExecutable.getValue().booleanValue() || JNIRegistrationSupport.isDarwin()) {
            return;
        }
        this.accessImpl = (FeatureImpl.AfterImageWriteAccessImpl)access;
        try (DebugContext.Scope s = this.accessImpl.getDebugContext().scope((Object)"JDKLibs");){
            Path jdkLibDir = JDKLibDirectoryProvider.singleton().getJDKLibDirectory();
            this.copyJDKLibraries(jdkLibDir);
            this.makeShimLibraries();
        }
        finally {
            this.accessImpl = null;
        }
    }

    private void copyJDKLibraries(Path jdkLibDir) {
        DebugContext debug = this.accessImpl.getDebugContext();
        try (DebugContext.Scope s = debug.scope((Object)"copy");
             Indent i = debug.logAndIndent("from: %s", (Object)jdkLibDir);){
            for (String libname : new TreeSet(this.registeredLibraries.keySet())) {
                String library = System.mapLibraryName(libname);
                if (NativeLibrarySupport.singleton().isPreregisteredBuiltinLibrary(libname)) {
                    debug.log(2, "%s: SKIPPED", (Object)library);
                    continue;
                }
                if (libname.equals("sunmscapi") && !this.isSunMSCAPIProviderReachable) {
                    debug.log(2, "%s: IGNORED", (Object)library);
                    continue;
                }
                try {
                    Path libraryPath = this.accessImpl.getImagePath().resolveSibling(library);
                    Files.copy(jdkLibDir.resolve(library), libraryPath, StandardCopyOption.REPLACE_EXISTING);
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.JDK_LIBRARY, libraryPath);
                    debug.log("%s: OK", (Object)library);
                }
                catch (NoSuchFileException e) {
                    debug.log(2, "%s: IGNORED", (Object)library);
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere(e);
                }
            }
        }
    }

    private void makeShimLibraries() {
        for (String shimName : this.shimExports.keySet()) {
            DebugContext debug = this.accessImpl.getDebugContext();
            DebugContext.Scope s = debug.scope((Object)(shimName + "Shim"));
            try {
                if (debug.isLogEnabled(2)) {
                    debug.log("exports: %s", (Object)String.join((CharSequence)", ", (Iterable)this.shimExports.get(shimName)));
                }
                this.makeShimLibrary(shimName);
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    private void makeShimLibrary(String shimName) {
        List<String> linkerCommand;
        assert (ImageSingletons.contains(CCompilerInvoker.class));
        Path image = this.accessImpl.getImagePath();
        Path shimLibrary = image.resolveSibling(System.mapLibraryName(shimName));
        if (JNIRegistrationSupport.isWindows()) {
            linkerCommand = ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).createCompilerCommand(List.of(), shimLibrary, this.getImageImportLib(), Path.of("msvcrt.lib", new String[0]));
            linkerCommand.addAll(List.of("/link", "/dll", "/implib:" + shimName + ".lib"));
            for (String export : (SortedSet)this.shimExports.get(shimName)) {
                linkerCommand.add("/export:" + export);
            }
        } else {
            linkerCommand = ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).createCompilerCommand(List.of("-shared", "-x", "c"), shimLibrary, Path.of("/dev/null", new String[0]));
            if (!this.accessImpl.getImageKind().isExecutable) {
                linkerCommand.addAll(List.of("-Wl,-no-as-needed", "-L" + String.valueOf(image.getParent()), "-l:" + String.valueOf(image.getFileName()), "-Wl,--enable-new-dtags", "-Wl,-rpath,$ORIGIN"));
            }
        }
        DebugContext debug = this.accessImpl.getDebugContext();
        try (DebugContext.Scope s = debug.scope((Object)"link");
             DebugContext.Activation a = debug.activate();){
            int cmdResult = FileUtils.executeCommand(linkerCommand);
            if (cmdResult != 0) {
                VMError.shouldNotReachHereUnexpectedInput(cmdResult);
            }
            BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.JDK_LIBRARY_SHIM, shimLibrary);
            debug.log("%s: OK", (Object)shimLibrary.getFileName());
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding();
        }
        catch (IOException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    private Path getImageImportLib() {
        assert (JNIRegistrationSupport.isWindows());
        Path importLib = this.accessImpl.getTempDirectory().resolve(this.imageName + ".lib");
        assert (Files.exists(importLib, new LinkOption[0]));
        return importLib;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> CreateJvmShim = new HostedOptionKey<Boolean>(false);
    }
}

