/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMemoryAccessProvider;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.function.ObjIntConsumer;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final SVMHost hostVM;
    private final AnalysisConstantReflectionProvider aConstantReflection;
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;
    private final HostedMemoryAccessProvider hMemoryAccess;

    public HostedConstantReflectionProvider(SVMHost hostVM, AnalysisConstantReflectionProvider aConstantReflection, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess) {
        this.hostVM = hostVM;
        this.aConstantReflection = aConstantReflection;
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.hMemoryAccess = new HostedMemoryAccessProvider(hMetaAccess, this);
    }

    @Override
    public Boolean constantEquals(Constant x, Constant y) {
        return this.aConstantReflection.constantEquals(x, y);
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return this.hMemoryAccess;
    }

    @Override
    public JavaConstant unboxPrimitive(JavaConstant source) {
        return this.aConstantReflection.unboxPrimitive(source);
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        return this.hUniverse.lookup((JavaType)this.aConstantReflection.asJavaType(constant));
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return SubstrateObjectConstant.forObject(this.hostVM.dynamicHub((ResolvedJavaType)((HostedType)type).wrapped));
    }

    @Override
    public Integer readArrayLength(JavaConstant array) {
        return this.aConstantReflection.readArrayLength(array);
    }

    @Override
    public JavaConstant readArrayElement(JavaConstant array, int index) {
        return this.aConstantReflection.readArrayElement(array, index);
    }

    @Override
    public void forEachArrayElement(JavaConstant array, ObjIntConsumer<JavaConstant> consumer) {
        this.aConstantReflection.forEachArrayElement(array, consumer);
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        HostedField hField = (HostedField)field;
        assert (this.checkHub(receiver)) : "Receiver " + String.valueOf(receiver) + " of field " + String.valueOf(hField) + " read should not be java.lang.Class. Expecting to see DynamicHub here.";
        return this.hUniverse.lookup(this.aConstantReflection.readValue(this.hMetaAccess, hField.getWrapped(), receiver, true));
    }

    private boolean checkHub(JavaConstant constant) {
        if (this.hMetaAccess.isInstanceOf(constant, Class.class)) {
            Object classObject = this.hUniverse.getSnippetReflection().asObject(Object.class, constant);
            return classObject instanceof DynamicHub;
        }
        return true;
    }
}

