/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.type.StampTool;

public class ReflectionGraphKit
extends HostedGraphKit {
    static final Map<JavaKind, List<JavaKind>> PRIMITIVE_UNBOXINGS = new HashMap<JavaKind, List<JavaKind>>();
    private final List<FixedWithNextNode> illegalArgumentExceptionPaths = new ArrayList<FixedWithNextNode>();
    private final List<ExceptionObjectNode> invocationTargetExceptionPaths = new ArrayList<ExceptionObjectNode>();
    private static final Constructor<InvocationTargetException> invocationTargetExceptionConstructor;

    public ReflectionGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, GraphProvider.Purpose purpose) {
        super(debug, providers, method, purpose);
    }

    public AbstractMergeNode endIf() {
        AbstractMergeNode merge = super.endIf();
        if (merge != null) {
            merge.setStateAfter(this.getFrameState().create(this.bci(), (StateSplit)merge));
        }
        return merge;
    }

    public void branchToIllegalArgumentException() {
        this.illegalArgumentExceptionPaths.add(this.lastFixedNode);
        this.lastFixedNode = null;
    }

    public void branchToInvocationTargetException(ExceptionObjectNode exceptionObjectNode) {
        assert (exceptionObjectNode == this.lastFixedNode);
        this.invocationTargetExceptionPaths.add(exceptionObjectNode);
        this.lastFixedNode = null;
    }

    public void emitIllegalArgumentException(ValueNode obj, ValueNode args) {
        ValueNode[] arguments;
        ResolvedJavaMethod targetMethod;
        this.continueWithMerge(this.illegalArgumentExceptionPaths);
        if (obj == null) {
            targetMethod = this.findMethod(ReflectionAccessorHolder.class, "throwIllegalArgumentExceptionWithoutReceiver", true);
            arguments = new ValueNode[]{args};
        } else {
            targetMethod = this.findMethod(ReflectionAccessorHolder.class, "throwIllegalArgumentExceptionWithReceiver", true);
            arguments = new ValueNode[]{obj, args};
        }
        InvokeWithExceptionNode invoke = this.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Static, targetMethod, arguments);
        invoke.setInlineControl(Invoke.InlineControl.Never);
        this.append((Node)new LoweredDeadEndNode());
    }

    public void emitInvocationTargetException() {
        AbstractMergeNode merge = this.continueWithMerge(this.invocationTargetExceptionPaths);
        ValueNode exception = this.createPhi(this.invocationTargetExceptionPaths, merge);
        ResolvedJavaMethod throwInvocationTargetException = FactoryMethodSupport.singleton().lookup((UniverseMetaAccess)this.getMetaAccess(), this.getMetaAccess().lookupJavaMethod(invocationTargetExceptionConstructor), true);
        InvokeWithExceptionNode invoke = this.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Static, throwInvocationTargetException, exception);
        invoke.setInlineControl(Invoke.InlineControl.Never);
        this.append((Node)new LoweredDeadEndNode());
    }

    public ValueNode startInstanceOf(ValueNode value, ResolvedJavaType type, boolean nonNull, boolean forException) {
        TypeReference typeRef = TypeReference.createTrusted((Assumptions)this.getAssumptions(), (ResolvedJavaType)type);
        LogicNode condition = nonNull ? (LogicNode)this.append((Node)InstanceOfNode.create((TypeReference)typeRef, (ValueNode)value)) : (LogicNode)this.append((Node)InstanceOfNode.createAllowNull((TypeReference)typeRef, (ValueNode)value, null, null));
        this.startIf(condition, forException ? BranchProbabilityNode.FAST_PATH_PROFILE : BranchProbabilityNode.LIKELY_PROFILE);
        this.thenPart();
        return this.createPiNode(value, (Stamp)StampFactory.object((TypeReference)typeRef, (boolean)nonNull));
    }

    public AbstractMergeNode continueWithMerge(List<? extends FixedWithNextNode> predecessors) {
        assert (predecessors.size() > 0);
        if (predecessors.size() == 1) {
            this.lastFixedNode = predecessors.get(0);
            return null;
        }
        MergeNode merge = (MergeNode)this.graph.add((Node)new MergeNode());
        merge.setStateAfter(this.getFrameState().create(this.bci(), (StateSplit)merge));
        for (int i = 0; i < predecessors.size(); ++i) {
            EndNode end = (EndNode)this.graph.add((Node)new EndNode());
            this.graph.addAfterFixed(predecessors.get(i), (FixedNode)end);
            merge.addForwardEnd(end);
        }
        this.lastFixedNode = merge;
        return merge;
    }

    public ValueNode createPhi(List<? extends ValueNode> values, AbstractMergeNode merge) {
        if (values.size() == 1) {
            assert (merge == null);
            return values.get(0);
        }
        assert (values.size() == merge.forwardEndCount());
        return this.unique((FloatingNode)new ValuePhiNode(StampTool.meetOrNull(values, null), merge, values.toArray(ValueNode.EMPTY_ARRAY)));
    }

    public void fillArgsArray(ValueNode argumentArray, int receiverOffset, ValueNode[] args, Class<?>[] argTypes) {
        LogicNode argsNullCondition = (LogicNode)this.append((Node)IsNullNode.create((ValueNode)argumentArray));
        this.startIf(argsNullCondition, BranchProbabilityNode.SLOW_PATH_PROFILE);
        this.thenPart();
        if (argTypes.length != 0) {
            this.branchToIllegalArgumentException();
        }
        this.elsePart();
        PiNode argumentArrayNonNull = this.createPiNode(argumentArray, StampFactory.objectNonNull());
        ValueNode argsLength = (ValueNode)this.append((Node)ArrayLengthNode.create((ValueNode)argumentArrayNonNull, (ConstantReflectionProvider)this.getConstantReflection()));
        LogicNode argsLengthCondition = (LogicNode)this.append((Node)IntegerEqualsNode.create((ValueNode)argsLength, (ValueNode)ConstantNode.forInt((int)argTypes.length), (NodeView)NodeView.DEFAULT));
        this.startIf(argsLengthCondition, BranchProbabilityNode.FAST_PATH_PROFILE);
        this.elsePart();
        this.branchToIllegalArgumentException();
        this.thenPart();
        AbstractBeginNode argsBoundsCheckGuard = AbstractBeginNode.prevBegin((FixedNode)this.lastFixedNode);
        for (int i = 0; i < argTypes.length; ++i) {
            ValueNode arg = this.createLoadIndexed((ValueNode)argumentArrayNonNull, i, JavaKind.Object, (GuardingNode)argsBoundsCheckGuard);
            ResolvedJavaType argType = this.getMetaAccess().lookupJavaType(argTypes[i]);
            JavaKind argKind = this.asKind((JavaType)argType);
            if (argKind.isPrimitive()) {
                arg = this.unboxPrimitive(arg, argKind);
            } else {
                arg = this.startInstanceOf(arg, argType, false, true);
                this.elsePart();
                this.branchToIllegalArgumentException();
                this.endIf();
            }
            args[i + receiverOffset] = arg;
        }
        this.endIf();
        this.endIf();
    }

    private ValueNode unboxPrimitive(ValueNode boxedValue, JavaKind argKind) {
        this.startIf((LogicNode)this.append((Node)IsNullNode.create((ValueNode)boxedValue)), BranchProbabilityNode.SLOW_PATH_PROFILE);
        this.thenPart();
        this.branchToIllegalArgumentException();
        this.elsePart();
        PiNode boxedValueNonNull = this.createPiNode(boxedValue, StampFactory.objectNonNull());
        ArrayList<ValueNode> widenedValues = new ArrayList<ValueNode>();
        ArrayList<FixedWithNextNode> controlFlows = new ArrayList<FixedWithNextNode>();
        List<JavaKind> boxedKinds = PRIMITIVE_UNBOXINGS.get(argKind);
        for (JavaKind boxedKind : boxedKinds) {
            ResolvedJavaType boxedType = this.getMetaAccess().lookupJavaType(boxedKind.toBoxedJavaClass());
            ValueNode boxedValueCasted = this.startInstanceOf((ValueNode)boxedValueNonNull, boxedType, true, false);
            ValueNode unboxedValue = this.createUnboxing(boxedValueCasted, boxedKind);
            ValueNode widenedValue = this.widenPrimitive(unboxedValue, boxedKind, argKind);
            widenedValues.add(widenedValue);
            controlFlows.add(this.lastFixedNode);
            this.lastFixedNode = null;
            this.elsePart();
            this.endIf();
        }
        this.branchToIllegalArgumentException();
        AbstractMergeNode merge = this.continueWithMerge(controlFlows);
        return this.createPhi(widenedValues, merge);
    }

    private ValueNode widenPrimitive(ValueNode unboxedValue, JavaKind fromKind, JavaKind toKind) {
        JavaKind toStackKind;
        JavaKind fromStackKind = fromKind.getStackKind();
        if (fromStackKind == (toStackKind = toKind.getStackKind())) {
            return unboxedValue;
        }
        switch (fromStackKind) {
            case Int: {
                switch (toStackKind) {
                    case Long: {
                        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)SignExtendNode.create((ValueNode)unboxedValue, (int)toStackKind.getBitCount(), (NodeView)NodeView.DEFAULT));
                    }
                    case Float: {
                        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)FloatConvertNode.create((FloatConvert)FloatConvert.I2F, (ValueNode)unboxedValue, (NodeView)NodeView.DEFAULT));
                    }
                    case Double: {
                        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)FloatConvertNode.create((FloatConvert)FloatConvert.I2D, (ValueNode)unboxedValue, (NodeView)NodeView.DEFAULT));
                    }
                }
                throw VMError.shouldNotReachHereUnexpectedInput(toStackKind);
            }
            case Long: {
                switch (toStackKind) {
                    case Float: {
                        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)FloatConvertNode.create((FloatConvert)FloatConvert.L2F, (ValueNode)unboxedValue, (NodeView)NodeView.DEFAULT));
                    }
                    case Double: {
                        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)FloatConvertNode.create((FloatConvert)FloatConvert.L2D, (ValueNode)unboxedValue, (NodeView)NodeView.DEFAULT));
                    }
                }
                throw VMError.shouldNotReachHereUnexpectedInput(toStackKind);
            }
            case Float: {
                switch (toStackKind) {
                    case Double: {
                        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)FloatConvertNode.create((FloatConvert)FloatConvert.F2D, (ValueNode)unboxedValue, (NodeView)NodeView.DEFAULT));
                    }
                }
                throw VMError.shouldNotReachHereUnexpectedInput(toStackKind);
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(fromStackKind);
    }

    static {
        PRIMITIVE_UNBOXINGS.put(JavaKind.Boolean, Arrays.asList(JavaKind.Boolean));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Byte, Arrays.asList(JavaKind.Byte));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Short, Arrays.asList(JavaKind.Short, JavaKind.Byte));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Char, Arrays.asList(JavaKind.Char));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Int, Arrays.asList(JavaKind.Int, JavaKind.Byte, JavaKind.Short, JavaKind.Char));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Long, Arrays.asList(JavaKind.Long, JavaKind.Int, JavaKind.Byte, JavaKind.Short, JavaKind.Char));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Float, Arrays.asList(JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Byte, JavaKind.Short, JavaKind.Char));
        PRIMITIVE_UNBOXINGS.put(JavaKind.Double, Arrays.asList(JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Byte, JavaKind.Short, JavaKind.Char));
        invocationTargetExceptionConstructor = ReflectionUtil.lookupConstructor(InvocationTargetException.class, (Class[])new Class[]{Throwable.class});
    }
}

