/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.ElementList;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.pecoff.PECoffObjectFile;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.graalvm.compiler.debug.DebugContext;
import sun.nio.ch.DirectBuffer;

public abstract class ObjectFile {
    private final int pageSize;
    protected final ElementList elements = this.createElementList();
    protected final Map<Element, String> nameForElement = new HashMap<Element, String>();
    private final TreeSet<BuildDependency> allDependencies = new TreeSet();
    private final HashSet<LayoutDecision> allDecisions = new HashSet();
    private final Map<Element, LayoutDecisionMap> decisionsByElement = new IdentityHashMap<Element, LayoutDecisionMap>();
    private final Map<Element, LayoutDecisionMap> decisionsTaken = new IdentityHashMap<Element, LayoutDecisionMap>();
    private final Map<Element, List<BuildDependency>> dependenciesByDependingElement = new IdentityHashMap<Element, List<BuildDependency>>();
    private final Map<Element, List<BuildDependency>> dependenciesByDependedOnElement = new IdentityHashMap<Element, List<BuildDependency>>();
    private DebugContext debugContext = null;

    public abstract Format getFormat();

    public ObjectFile(int pageSize) {
        assert (pageSize > 0) : "Invalid page size";
        this.pageSize = pageSize;
    }

    public static <E extends Enum<E>> long flagSetAsLong(EnumSet<E> flags) {
        long working = 0L;
        for (Enum f : flags) {
            working |= ((ValueEnum)((Object)f)).value();
        }
        return working;
    }

    public static <E extends Enum<E>> EnumSet<E> flagSetFromLong(long flags, Class<E> clazz) {
        EnumSet<Enum> working = EnumSet.noneOf(clazz);
        for (Enum f : EnumSet.allOf(clazz)) {
            if ((flags & ((ValueEnum)((Object)f)).value()) == 0L) continue;
            working.add(f);
        }
        return working;
    }

    public abstract ByteOrder getByteOrder();

    public abstract void setByteOrder(ByteOrder var1);

    private static String getHostOS() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            return "Linux";
        }
        if (osName.startsWith("Mac OS X")) {
            return "Mac OS X";
        }
        if (osName.startsWith("Windows")) {
            return "Windows";
        }
        throw new IllegalStateException("Unsupported OS: " + osName);
    }

    protected int initialVaddr() {
        return 0x400000;
    }

    public static String getFilenameSuffix() {
        return ObjectFile.getFilenameSuffix(ObjectFile.getNativeFormat());
    }

    public static String getFilenameSuffix(Format format) {
        return switch (format.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> ".o";
            case 2 -> ".obj";
            case 3 -> ".bc";
        };
    }

    public static Format getNativeFormat() {
        switch (ObjectFile.getHostOS()) {
            case "Linux": {
                return Format.ELF;
            }
            case "Mac OS X": {
                return Format.MACH_O;
            }
            case "Windows": {
                return Format.PECOFF;
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static ObjectFile getNativeObjectFile(int pageSize, boolean runtimeDebugInfoGeneration) {
        switch (ObjectFile.getNativeFormat().ordinal()) {
            case 0: {
                return new ELFObjectFile(pageSize, runtimeDebugInfoGeneration);
            }
            case 1: {
                return new MachOObjectFile(pageSize);
            }
            case 2: {
                return new PECoffObjectFile(pageSize);
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    public static ObjectFile getNativeObjectFile(int pageSize) {
        return ObjectFile.getNativeObjectFile(pageSize, true);
    }

    public static ObjectFile createRuntimeDebugInfo(int pageSize) {
        return ObjectFile.getNativeObjectFile(pageSize, true);
    }

    protected abstract Segment getOrCreateSegment(String var1, String var2, boolean var3, boolean var4);

    public abstract Section newUserDefinedSection(Segment var1, String var2, int var3, ElementImpl var4);

    public abstract Section newProgbitsSection(Segment var1, String var2, int var3, boolean var4, boolean var5, ProgbitsSectionImpl var6);

    public abstract Section newNobitsSection(Segment var1, String var2, NobitsSectionImpl var3);

    public Section newUserDefinedSection(String name, ElementImpl impl) {
        Segment segment = this.getOrCreateSegment(null, name, false, false);
        int alignment = this.getWordSizeInBytes();
        Section result = this.newUserDefinedSection(segment, name, alignment, impl);
        return result;
    }

    public Section newDebugSection(String name, ElementImpl impl) {
        Segment segment = this.getOrCreateSegment(null, name, false, false);
        boolean alignment = true;
        Section result = this.newUserDefinedSection(segment, name, 1, impl);
        return result;
    }

    public Section newProgbitsSection(String name, int alignment, boolean writable, boolean executable, ProgbitsSectionImpl impl) {
        assert (impl != null);
        Segment segment = this.getOrCreateSegment(null, name, writable, executable);
        int adaptedAlignment = ObjectFile.lowestCommonMultiple(alignment, this.getWordSizeInBytes());
        Section result = this.newProgbitsSection(segment, name, adaptedAlignment, writable, executable, impl);
        return result;
    }

    public Section newNobitsSection(String name, NobitsSectionImpl impl) {
        assert (impl != null);
        Segment segment = this.getOrCreateSegment(null, name, true, false);
        Section result = this.newNobitsSection(segment, name, impl);
        return result;
    }

    public Segment findSegmentByName(String name) {
        for (Segment s : this.getSegments()) {
            if (s.getName() == null || !s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public static int nextIntegerMultiple(int start, int multipleOf) {
        int mod = start % multipleOf;
        int compl = multipleOf - mod;
        int ret = start + (compl == multipleOf ? 0 : compl);
        assert (ret % multipleOf == 0);
        assert (ret - start >= 0);
        assert (ret - start < multipleOf);
        return ret;
    }

    public static int nextIntegerMultipleWithCongruence(int start, int multipleOf, int congruentTo, int modulo) {
        int candidate = start;
        while (candidate % modulo != congruentTo % modulo) {
            candidate = ObjectFile.nextIntegerMultiple(candidate + 1, multipleOf);
        }
        return candidate;
    }

    protected static int greatestCommonDivisor(int arg1, int arg2) {
        int first = arg1;
        int second = arg2;
        int rem = arg2;
        while (rem != 0) {
            rem = first % second;
            first = second;
            second = rem;
        }
        return first;
    }

    protected static int lowestCommonMultiple(int arg1, int arg2) {
        return arg1 * arg2 / ObjectFile.greatestCommonDivisor(arg1, arg2);
    }

    protected static int nextAvailableVaddr(Map<Element, LayoutDecisionMap> alreadyDecided, int base, int defaultValue) {
        int nextAvailable = -1;
        List<LayoutDecision> maxVaddrDecisions = ObjectFile.maximalDecisionValues(alreadyDecided, LayoutDecision.Kind.VADDR, new IntegerDecisionComparator(false));
        Collections.sort(maxVaddrDecisions, new SizeTiebreakComparator(alreadyDecided, false));
        LayoutDecision maxVaddrDecision = maxVaddrDecisions.get(maxVaddrDecisions.size() - 1);
        if (maxVaddrDecision == null || !maxVaddrDecision.isTaken()) {
            nextAvailable = defaultValue;
        } else {
            assert (alreadyDecided.get(maxVaddrDecision.getElement()).getDecision(LayoutDecision.Kind.SIZE).isTaken());
            int vaddr = (Integer)alreadyDecided.get(maxVaddrDecision.getElement()).getDecidedValue(LayoutDecision.Kind.VADDR);
            int size = maxVaddrDecision.getElement().getMemSize(alreadyDecided);
            nextAvailable = vaddr + size;
        }
        if (nextAvailable < base) {
            return base;
        }
        return nextAvailable;
    }

    protected static List<LayoutDecision> maximalDecisionValues(Map<Element, LayoutDecisionMap> alreadyDecided, LayoutDecision.Kind k, Comparator<LayoutDecision> cmp) {
        ArrayList<LayoutDecision> currentMax = null;
        for (Map.Entry<Element, LayoutDecisionMap> eOuter : alreadyDecided.entrySet()) {
            Integer compareResult;
            LayoutDecision decisionToCompare = eOuter.getValue().getDecision(k);
            Integer n = compareResult = currentMax == null ? null : Integer.valueOf(cmp.compare(decisionToCompare, (LayoutDecision)currentMax.get(0)));
            if (currentMax == null || compareResult > 0) {
                currentMax = new ArrayList<LayoutDecision>(1);
                currentMax.add(decisionToCompare);
                continue;
            }
            if (compareResult != 0) continue;
            currentMax.add(decisionToCompare);
        }
        return currentMax;
    }

    protected static List<LayoutDecision> minimalDecisionValues(Map<Element, LayoutDecisionMap> alreadyDecided, LayoutDecision.Kind k, Comparator<LayoutDecision> cmp) {
        ArrayList<LayoutDecision> currentMin = null;
        for (Map.Entry<Element, LayoutDecisionMap> eOuter : alreadyDecided.entrySet()) {
            Integer compareResult;
            LayoutDecision decisionToCompare = eOuter.getValue().getDecision(k);
            if (decisionToCompare == null) continue;
            Integer n = compareResult = currentMin == null ? null : Integer.valueOf(cmp.compare(decisionToCompare, (LayoutDecision)currentMin.get(0)));
            if (currentMin == null || compareResult < 0) {
                currentMin = new ArrayList<LayoutDecision>(1);
                currentMin.add(decisionToCompare);
                continue;
            }
            if (compareResult != 0) continue;
            currentMin.add(decisionToCompare);
        }
        return currentMin;
    }

    protected static List<LayoutDecision> sortedDecisionValues(Map<Element, LayoutDecisionMap> alreadyDecided, LayoutDecision.Kind k, Comparator<LayoutDecision> cmp) {
        ArrayList<LayoutDecision> l = new ArrayList<LayoutDecision>();
        for (LayoutDecision d : ObjectFile.decisionsByKind(k, alreadyDecided)) {
            l.add(d);
        }
        Collections.sort(l, cmp);
        return l;
    }

    protected static int nextAvailableOffset(Map<Element, LayoutDecisionMap> alreadyDecided) {
        int ret = -1;
        List<LayoutDecision> maxOffsetDecisions = ObjectFile.maximalDecisionValues(alreadyDecided, LayoutDecision.Kind.OFFSET, new IntegerDecisionComparator(false));
        Collections.sort(maxOffsetDecisions, new SizeTiebreakComparator(alreadyDecided, false));
        LayoutDecision maxOffsetDecision = maxOffsetDecisions.get(maxOffsetDecisions.size() - 1);
        if (maxOffsetDecision == null || !maxOffsetDecision.isTaken()) {
            ret = 0;
        } else {
            assert (alreadyDecided.get(maxOffsetDecision.getElement()).getDecision(LayoutDecision.Kind.SIZE).isTaken());
            int offset = (Integer)alreadyDecided.get(maxOffsetDecision.getElement()).getDecision(LayoutDecision.Kind.OFFSET).getValue();
            int size = (Integer)alreadyDecided.get(maxOffsetDecision.getElement()).getDecision(LayoutDecision.Kind.SIZE).getValue();
            ret = offset + size;
        }
        return ret;
    }

    public abstract int getWordSizeInBytes();

    public abstract boolean shouldRecordDebugRelocations();

    public static HashSet<BuildDependency> basicDependencies(Map<Element, LayoutDecisionMap> decisions, Element el, boolean sizeOnContent, boolean vaddrOnOffset) {
        HashSet<BuildDependency> deps = new HashSet<BuildDependency>();
        deps.add(BuildDependency.createOrGet(decisions.get(el).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(el).getDecision(LayoutDecision.Kind.SIZE)));
        if (decisions.get(el).getDecision(LayoutDecision.Kind.VADDR) != null) {
            deps.add(BuildDependency.createOrGet(decisions.get(el).getDecision(LayoutDecision.Kind.VADDR), decisions.get(el).getDecision(LayoutDecision.Kind.SIZE)));
        }
        if (sizeOnContent) {
            deps.add(BuildDependency.createOrGet(decisions.get(el).getDecision(LayoutDecision.Kind.SIZE), decisions.get(el).getDecision(LayoutDecision.Kind.CONTENT)));
        }
        if (vaddrOnOffset && decisions.get(el).getDecision(LayoutDecision.Kind.VADDR) != null) {
            deps.add(BuildDependency.createOrGet(decisions.get(el).getDecision(LayoutDecision.Kind.VADDR), decisions.get(el).getDecision(LayoutDecision.Kind.OFFSET)));
        }
        return deps;
    }

    public static HashSet<BuildDependency> minimalDependencies(Map<Element, LayoutDecisionMap> decisions, Element el) {
        return ObjectFile.basicDependencies(decisions, el, false, true);
    }

    public static HashSet<BuildDependency> defaultDependencies(Map<Element, LayoutDecisionMap> decisions, Element el) {
        return ObjectFile.basicDependencies(decisions, el, true, true);
    }

    public static <T> T defaultGetOrDecide(Map<Element, LayoutDecisionMap> alreadyDecided, Element el, LayoutDecision.Kind k, T hint) {
        LayoutDecisionMap m = alreadyDecided.get(el);
        if (m != null && m.getDecision(k) != null && m.getDecision(k).isTaken()) {
            return (T)m.getDecidedValue(k);
        }
        return hint;
    }

    public static int defaultGetOrDecideOffset(Map<Element, LayoutDecisionMap> alreadyDecided, Element el, int offsetHint) {
        assert (alreadyDecided.get(el).getDecision(LayoutDecision.Kind.VADDR) == null || !alreadyDecided.get(el).getDecision(LayoutDecision.Kind.VADDR).isTaken());
        return ObjectFile.defaultGetOrDecide(alreadyDecided, el, LayoutDecision.Kind.OFFSET, ObjectFile.nextIntegerMultiple(offsetHint, el.getAlignment()));
    }

    public static byte[] defaultGetOrDecideContent(Map<Element, LayoutDecisionMap> alreadyDecided, Element el, byte[] contentHint) {
        return ObjectFile.defaultGetOrDecide(alreadyDecided, el, LayoutDecision.Kind.CONTENT, contentHint);
    }

    public static int defaultGetOrDecideSize(Map<Element, LayoutDecisionMap> alreadyDecided, Element el, int sizeHint) {
        return ObjectFile.defaultGetOrDecide(alreadyDecided, el, LayoutDecision.Kind.SIZE, sizeHint);
    }

    public static int defaultGetOrDecideVaddr(Map<Element, LayoutDecisionMap> alreadyDecided, Element el, int vaddrHint) {
        int ourPageNum;
        int existingSize;
        Element alreadyMapped;
        int existingOffset;
        int existingEndPos;
        int endPageNum;
        int fileOffset = (Integer)alreadyDecided.get(el).getDecidedValue(LayoutDecision.Kind.OFFSET);
        int nextAvailableVaddr = vaddrHint;
        Iterable<Element> onCurrentPage = el.getOwner().elementsMappedOnPage(vaddrHint, alreadyDecided);
        boolean mustStartNewPage = false;
        Iterator<Element> iterator = onCurrentPage.iterator();
        while (iterator.hasNext() && !(mustStartNewPage |= (endPageNum = (existingEndPos = (existingOffset = ((Integer)alreadyDecided.get(alreadyMapped = iterator.next()).getDecidedValue(LayoutDecision.Kind.OFFSET)).intValue()) + (existingSize = ((Integer)alreadyDecided.get(alreadyMapped).getDecidedValue(LayoutDecision.Kind.SIZE)).intValue())) >> el.getOwner().getPageSizeShift()) != (ourPageNum = fileOffset >> el.getOwner().getPageSizeShift())) && !(mustStartNewPage |= !el.getOwner().elementsCanSharePage(el, alreadyMapped, fileOffset, (Integer)alreadyDecided.get(alreadyMapped).getDecidedValue(LayoutDecision.Kind.OFFSET)))) {
        }
        if (mustStartNewPage) {
            nextAvailableVaddr = (nextAvailableVaddr >> el.getOwner().getPageSizeShift()) + 1 << el.getOwner().getPageSizeShift();
        }
        int myOffset = (Integer)alreadyDecided.get(el).getDecidedValue(LayoutDecision.Kind.OFFSET);
        List<LayoutDecision> sortedOffsetDecisions = ObjectFile.sortedDecisionValues(alreadyDecided, LayoutDecision.Kind.OFFSET, new IntegerDecisionComparator(true));
        LayoutDecision predDecision = null;
        Element predElement = null;
        for (LayoutDecision d : sortedOffsetDecisions) {
            if (d.getElement() == el) break;
            predDecision = d;
        }
        if (predDecision != null) {
            predElement = predDecision.getElement();
        }
        boolean firstSection = false;
        boolean inAnySegment = false;
        for (List list : el.getOwner().getSegments()) {
            if (list.get(0) == el) {
                firstSection = true;
            }
            if (!list.contains(el)) continue;
            inAnySegment = true;
        }
        boolean canSharePageWithPredecessor = !(predElement instanceof Section) || el.getOwner().elementsCanSharePage(el, predElement, myOffset, (Integer)alreadyDecided.get(predElement).getDecidedValue(LayoutDecision.Kind.OFFSET));
        boolean bl = predElement.isLoadable();
        boolean requireModuloConstraint = firstSection || !bl || !inAnySegment && predElement.isLoadable() || !canSharePageWithPredecessor;
        int vaddr = !requireModuloConstraint ? ObjectFile.nextIntegerMultiple(nextAvailableVaddr, el.getAlignment()) : ObjectFile.nextIntegerMultipleWithCongruence(nextAvailableVaddr, el.getAlignment(), fileOffset % el.getOwner().getPageSize(), el.getOwner().getPageSize());
        nextAvailableVaddr = vaddr + el.getMemSize(alreadyDecided);
        return vaddr;
    }

    public static LayoutDecisionMap defaultDecisions(Element e, LayoutDecisionMap copyingIn) {
        LayoutDecisionMap decisions = new LayoutDecisionMap(e);
        decisions.putUndecided(LayoutDecision.Kind.CONTENT);
        assert (!decisions.getDecision(LayoutDecision.Kind.CONTENT).isTaken());
        decisions.putUndecided(LayoutDecision.Kind.SIZE);
        decisions.putUndecided(LayoutDecision.Kind.OFFSET);
        if (e.isReferenceable()) {
            decisions.putUndecided(LayoutDecision.Kind.VADDR);
        }
        decisions.putDecidedValues(copyingIn);
        return decisions;
    }

    protected boolean elementsCanSharePage(Element s1, Element s2, int offset1, int offset2) {
        boolean offsetSpaceCompatible = offset1 >> this.getPageSizeShift() == offset2 >> this.getPageSizeShift();
        return offsetSpaceCompatible;
    }

    public void installDebugInfo(DebugInfoProvider debugInfoProvider) {
    }

    protected static Iterable<LayoutDecision> allDecisions(Map<Element, LayoutDecisionMap> decisions) {
        return () -> StreamSupport.stream(decisions.values().spliterator(), false).flatMap(layoutDecisionMap -> StreamSupport.stream(layoutDecisionMap.spliterator(), false)).iterator();
    }

    protected static Iterable<LayoutDecision> decisionsByKind(LayoutDecision.Kind kind, Map<Element, LayoutDecisionMap> decisions) {
        return () -> StreamSupport.stream(decisions.values().spliterator(), false).flatMap(layoutDecisionMap -> StreamSupport.stream(layoutDecisionMap.spliterator(), false)).filter(decision -> decision.getKind() == kind).iterator();
    }

    public Map<Element, LayoutDecisionMap> getDecisionsTaken() {
        return this.decisionsTaken;
    }

    protected Iterable<Element> elementsMappedOnPage(long vaddr, Map<Element, LayoutDecisionMap> alreadyDecided) {
        long vaddrRoundedDown = vaddr >> this.getPageSizeShift() << this.getPageSizeShift();
        ArrayList<Element> ss = new ArrayList<Element>();
        for (LayoutDecision d : ObjectFile.decisionsByKind(LayoutDecision.Kind.VADDR, alreadyDecided)) {
            Element s = d.getElement();
            assert (d.getKind() == LayoutDecision.Kind.VADDR);
            int va = (Integer)d.getValue();
            int sizeInMemory = d.getElement().getMemSize(alreadyDecided);
            assert (sizeInMemory != -1);
            int mappingBegin = va;
            int mappingEnd = va + sizeInMemory;
            long pageBegin = vaddrRoundedDown;
            long pageEnd = vaddrRoundedDown + (long)this.getPageSize();
            if ((long)mappingBegin >= pageEnd || (long)mappingEnd <= pageBegin) continue;
            ss.add(s);
        }
        return ss;
    }

    protected ElementList createElementList() {
        return new ElementList();
    }

    public List<Element> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public Element elementForName(String s) {
        return this.elements.forName(s);
    }

    public String nameForElement(Element e) {
        return e.getName();
    }

    public List<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>(this.elements.sectionsCount());
        Iterator<Section> it = this.elements.sectionsIterator();
        while (it.hasNext()) {
            sections.add(it.next());
        }
        return sections;
    }

    public abstract Set<Segment> getSegments();

    public Header getHeader() {
        ArrayList<Header> headers = new ArrayList<Header>(this.elements.size());
        for (Element e : this.elements) {
            if (!(e instanceof Header)) continue;
            headers.add((Header)e);
        }
        if (headers.size() == 0) {
            throw new IllegalStateException("File has no header");
        }
        if (headers.size() > 1) {
            throw new IllegalStateException("File has multiple headers");
        }
        assert (headers.size() == 1);
        return (Header)headers.get(0);
    }

    public Element getOffsetBootstrapElement() {
        return this.getHeader();
    }

    public void write(DebugContext context, Path outputFile, ForkJoinPool forkJoinPool) throws IOException {
        try (FileChannel channel = FileChannel.open(outputFile, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            this.withDebugContext(context, "ObjectFile.write", () -> this.write(channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(FileChannel outputChannel) {
        ArrayList<Element> sortedObjectFileElements = new ArrayList<Element>();
        int totalSize = this.bake(sortedObjectFileElements);
        try {
            MappedByteBuffer buffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, 0L, totalSize);
            try {
                this.writeBuffer(sortedObjectFileElements, buffer);
            }
            finally {
                ((DirectBuffer)((Object)buffer)).cleaner().clean();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void putDependency(BuildDependency d) {
        this.allDependencies.add(d);
    }

    BuildDependency getExistingDependency(BuildDependency d) {
        if (this.allDependencies.contains(d)) {
            return (BuildDependency)this.allDependencies.subSet(d, true, d, true).first();
        }
        return null;
    }

    private String dependencyGraphAsDotString(Set<LayoutDecision> decisionsToInclude) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph deps {").append(System.lineSeparator());
        for (BuildDependency d : this.allDependencies) {
            if (decisionsToInclude != null && (!decisionsToInclude.contains(d.depending) || !decisionsToInclude.contains(d.dependedOn))) continue;
            sb.append(String.format("\t\"%s\" -> \"%s\";%n", d.depending, d.dependedOn));
        }
        sb.append('}').append(System.lineSeparator());
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public int bake(List<Element> sortedObjectFileElements) {
        int n;
        void var14_35;
        boolean bl;
        void var6_10;
        LayoutDecision[] deps;
        this.allDecisions.clear();
        this.decisionsByElement.clear();
        this.dependenciesByDependingElement.clear();
        this.dependenciesByDependedOnElement.clear();
        for (Element e : this.elements) {
            LayoutDecisionMap m = e.getDecisions(new LayoutDecisionMap(e));
            this.allDecisions.addAll(m.getDecisions());
            this.decisionsByElement.put(e, m);
            assert (this.decisionsByElement.containsKey(e));
            assert (this.decisionsByElement.get(e).containsKey((Object)LayoutDecision.Kind.CONTENT));
            assert (this.decisionsByElement.get(e).containsKey((Object)LayoutDecision.Kind.SIZE));
            assert (this.decisionsByElement.get(e).containsKey((Object)LayoutDecision.Kind.OFFSET));
        }
        for (Element e : this.elements) {
            deps = e.getDependencies(this.decisionsByElement);
            for (BuildDependency buildDependency : deps) {
                Object byDependedOn;
                this.allDependencies.add(buildDependency);
                Element dependingElement = buildDependency.depending.getElement();
                Element dependedOnElement = buildDependency.dependedOn.getElement();
                List<BuildDependency> byDepending = this.dependenciesByDependingElement.get(dependingElement);
                if (byDepending == null) {
                    byDepending = new ArrayList<BuildDependency>();
                    this.dependenciesByDependingElement.put(dependingElement, byDepending);
                }
                if ((byDependedOn = this.dependenciesByDependedOnElement.get(dependedOnElement)) == null) {
                    byDependedOn = new ArrayList<BuildDependency>();
                    this.dependenciesByDependedOnElement.put(dependedOnElement, (List<BuildDependency>)byDependedOn);
                }
                assert (buildDependency.depending.getElement() == dependingElement);
                byDepending.add(buildDependency);
                assert (buildDependency.dependedOn.getElement() == dependedOnElement);
                byDependedOn.add((BuildDependency)buildDependency);
            }
        }
        LayoutDecision dummyFinalDecision = new LayoutDecision(LayoutDecision.Kind.OFFSET, null, null);
        LayoutDecision[] realDecisions = this.allDecisions.toArray(new LayoutDecision[0]);
        this.allDecisions.add(dummyFinalDecision);
        deps = realDecisions;
        int n2 = deps.length;
        boolean bl2 = false;
        while (var6_10 < n2) {
            LayoutDecision decision = deps[var6_10];
            assert (decision.getElement() != null);
            dummyFinalDecision.dependsOn().add(decision);
            decision.dependedOnBy().add(dummyFinalDecision);
            ++var6_10;
        }
        assert (this.allDecisions.size() > 1);
        Element offsetBootstrapElement = this.getOffsetBootstrapElement();
        LayoutDecision offsetBootstrapDecision = this.decisionsByElement.get(offsetBootstrapElement).getDecision(LayoutDecision.Kind.OFFSET);
        boolean bl3 = false;
        boolean sawBootstrapOffsetDecision = false;
        for (LayoutDecision d : this.allDecisions) {
            if (d.getKind() == LayoutDecision.Kind.OFFSET && d.getElement() == offsetBootstrapElement) {
                sawBootstrapOffsetDecision = true;
                for (LayoutDecision dependedOn : d.dependsOn()) {
                    assert (dependedOn.getKind() != LayoutDecision.Kind.OFFSET);
                }
            }
            if (d.getKind() != LayoutDecision.Kind.OFFSET || d.getElement() == offsetBootstrapElement || d.getElement() == null) continue;
            ArrayList<BuildDependency> l1 = this.dependenciesByDependingElement.get(d.getElement());
            List<BuildDependency> l2 = this.dependenciesByDependedOnElement.get(offsetBootstrapElement);
            if (l1 == null) {
                l1 = new ArrayList<BuildDependency>();
                this.dependenciesByDependingElement.put(d.getElement(), l1);
            }
            if (l2 == null) {
                l2 = new ArrayList<BuildDependency>();
                this.dependenciesByDependedOnElement.put(offsetBootstrapElement, l2);
            }
            boolean l1contains = false;
            for (BuildDependency buildDependency : l1) {
                assert (buildDependency.depending.getElement() == d.getElement());
                if (buildDependency.depending.getKind() != LayoutDecision.Kind.OFFSET || buildDependency.dependedOn != offsetBootstrapDecision) continue;
                l1contains = true;
            }
            boolean l2contains = false;
            for (BuildDependency dep2 : l2) {
                assert (dep2.dependedOn.getElement() == offsetBootstrapElement);
                if (dep2.dependedOn.getKind() != LayoutDecision.Kind.OFFSET || dep2.depending != d) continue;
                l2contains = true;
            }
            assert (!l1contains && !l2contains || l1contains && l2contains);
            if (!l1contains) {
                BuildDependency buildDependency = BuildDependency.createOrGet(d, offsetBootstrapDecision);
                l1.add(buildDependency);
                l2.add(buildDependency);
                this.allDependencies.add(buildDependency);
            }
            bl = true;
        }
        assert (sawBootstrapOffsetDecision);
        assert (bl || this.elements.size() == 1);
        ArrayList<LayoutDecision> reverseBuildOrder = new ArrayList<LayoutDecision>();
        HashSet<LayoutDecision> decisionsWithNoInEdges = new HashSet<LayoutDecision>();
        decisionsWithNoInEdges.addAll(this.allDecisions);
        for (LayoutDecision d : this.allDecisions) {
            decisionsWithNoInEdges.removeAll(d.dependsOn());
        }
        assert (decisionsWithNoInEdges.contains(dummyFinalDecision));
        HashMap removedEdgesDependingOn = new HashMap();
        HashMap removedEdgesDependedOnBy = new HashMap();
        for (LayoutDecision l : this.allDecisions) {
            removedEdgesDependingOn.put(l, new ArrayList());
            removedEdgesDependedOnBy.put(l, new ArrayList());
        }
        TreeSet<LayoutDecision> working = new TreeSet<LayoutDecision>();
        working.addAll(decisionsWithNoInEdges);
        while (!working.isEmpty()) {
            LayoutDecision n3 = (LayoutDecision)working.iterator().next();
            working.remove(n3);
            reverseBuildOrder.add(n3);
            for (LayoutDecision m : n3.dependsOn()) {
                if (((ArrayList)removedEdgesDependingOn.get(n3)).contains(m)) {
                    assert (((ArrayList)removedEdgesDependedOnBy.get(m)).contains(n3));
                    continue;
                }
                ((ArrayList)removedEdgesDependingOn.get(n3)).add(m);
                ((ArrayList)removedEdgesDependedOnBy.get(m)).add(n3);
                ArrayList<LayoutDecision> mInEdges = new ArrayList<LayoutDecision>();
                mInEdges.addAll(m.dependedOnBy());
                assert (mInEdges.contains(n3));
                mInEdges.removeAll((Collection)removedEdgesDependedOnBy.get(m));
                assert (!mInEdges.contains(n3));
                if (mInEdges.size() != 0) continue;
                working.add(m);
            }
        }
        if (reverseBuildOrder.size() != this.allDecisions.size()) {
            HashSet<LayoutDecision> remainingDecisions = new HashSet<LayoutDecision>();
            remainingDecisions.addAll(this.allDecisions);
            remainingDecisions.removeAll(reverseBuildOrder);
            throw new IllegalStateException("Cyclic build dependencies: " + this.dependencyGraphAsDotString(remainingDecisions));
        }
        assert (reverseBuildOrder.get(0) == dummyFinalDecision);
        ArrayList<LayoutDecision> buildOrder = new ArrayList<LayoutDecision>(reverseBuildOrder.size());
        int n4 = reverseBuildOrder.size() - 1;
        while (var14_35 >= 0) {
            buildOrder.add((LayoutDecision)reverseBuildOrder.get((int)var14_35));
            --var14_35;
        }
        this.decisionsTaken.clear();
        for (Element e : this.elements) {
            this.decisionsTaken.put(e, new LayoutDecisionMap(e));
        }
        for (LayoutDecision d : buildOrder) {
            Element e = d.getElement();
            if (e == null) continue;
            Object valueDecided = null;
            int offsetHint = ObjectFile.nextAvailableOffset(this.decisionsTaken);
            int vaddrHint = ObjectFile.nextAvailableVaddr(this.decisionsTaken, 0, this.initialVaddr());
            if (d.isTaken()) {
                valueDecided = d.getValue();
            } else {
                switch (d.getKind()) {
                    case CONTENT: {
                        valueDecided = e.getOrDecideContent(this.decisionsTaken, new byte[0]);
                        assert (valueDecided != null);
                        break;
                    }
                    case OFFSET: {
                        valueDecided = e.getOrDecideOffset(this.decisionsTaken, offsetHint);
                        assert (valueDecided != null);
                        break;
                    }
                    case SIZE: {
                        byte[] decidedContent = null;
                        if (this.decisionsTaken.get(e).getDecision(LayoutDecision.Kind.CONTENT) != null) {
                            decidedContent = (byte[])this.decisionsTaken.get(e).getDecision(LayoutDecision.Kind.CONTENT).getValue();
                        }
                        valueDecided = e.getOrDecideSize(this.decisionsTaken, decidedContent != null ? decidedContent.length : -1);
                        assert (valueDecided != null);
                        assert (!(valueDecided instanceof Integer) || (Integer)valueDecided != -1);
                        break;
                    }
                    case VADDR: {
                        valueDecided = e.getOrDecideVaddr(this.decisionsTaken, vaddrHint);
                        assert (valueDecided != null);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unreachable");
                    }
                }
                d.setValue(valueDecided);
            }
            LayoutDecisionMap m = this.decisionsTaken.get(e);
            assert (m != null);
            m.decisions.put(d.getKind(), d);
        }
        sortedObjectFileElements.addAll(this.elements);
        Collections.sort(sortedObjectFileElements, new ElementComparatorByDecidedOffset(this.decisionsByElement));
        int n5 = this.getMinimumFileSize();
        for (Element e : sortedObjectFileElements) {
            n = Math.max(n, (Integer)this.decisionsTaken.get(e).getDecision(LayoutDecision.Kind.OFFSET).getValue() + (Integer)this.decisionsTaken.get(e).getDecidedValue(LayoutDecision.Kind.SIZE));
        }
        return n;
    }

    public Map<Element, LayoutDecisionMap> getDecisionsByElement() {
        return this.decisionsByElement;
    }

    public void writeBuffer(List<Element> sortedObjectFileElements, ByteBuffer out) {
        for (Element e : sortedObjectFileElements) {
            int off = (Integer)this.decisionsTaken.get(e).getDecision(LayoutDecision.Kind.OFFSET).getValue();
            assert (off != Integer.MAX_VALUE);
            out.position(off);
            int expectedSize = (Integer)this.decisionsTaken.get(e).getDecidedValue(LayoutDecision.Kind.SIZE);
            byte[] content = (byte[])this.decisionsTaken.get(e).getDecidedValue(LayoutDecision.Kind.CONTENT);
            out.put(content);
            int emittedSize = out.position() - off;
            assert (emittedSize >= 0);
            if (emittedSize == expectedSize) continue;
            throw new IllegalStateException("For element " + String.valueOf(e) + ", expected size " + expectedSize + " but emitted size " + emittedSize);
        }
    }

    protected abstract int getMinimumFileSize();

    public int getPageSize() {
        assert (this.pageSize > 0) : "Must be initialized";
        return this.pageSize;
    }

    public int getPageSizeShift() {
        int pagesize = this.getPageSize();
        int pageSizeShift = Integer.numberOfTrailingZeros(pagesize);
        return pageSizeShift;
    }

    public int roundUpToPageSize(int x) {
        int pageShift = this.getPageSizeShift();
        if (x % this.getPageSize() == 0) {
            return x;
        }
        return (x >> pageShift) + 1 << pageShift;
    }

    public abstract Symbol createDefinedSymbol(String var1, Element var2, long var3, int var5, boolean var6, boolean var7);

    public abstract Symbol createUndefinedSymbol(String var1, int var2, boolean var3);

    protected abstract SymbolTable createSymbolTable();

    public abstract SymbolTable getSymbolTable();

    public final SymbolTable getOrCreateSymbolTable() {
        SymbolTable t = this.getSymbolTable();
        if (t != null) {
            return t;
        }
        return this.createSymbolTable();
    }

    public void withDebugContext(DebugContext context, String scopeName, Runnable task) {
        try (DebugContext.Scope s = context.scope((Object)scopeName);){
            this.debugContext = context;
            task.run();
        }
        catch (Throwable e) {
            throw this.debugContext.handle(e);
        }
        finally {
            this.debugContext = null;
        }
    }

    public void debugContext(String scopeName, Consumer<DebugContext> action) {
        assert (this.debugContext != null);
        try (DebugContext.Scope s = this.debugContext.scope((Object)scopeName);){
            action.accept(this.debugContext);
        }
        catch (Throwable e) {
            throw this.debugContext.handle(e);
        }
    }

    public static interface ValueEnum {
        public long value();
    }

    public static enum Format {
        ELF,
        MACH_O,
        PECOFF,
        LLVM;

    }

    public static interface Segment
    extends List<Element> {
        public String getName();

        public void setName(String var1);

        public boolean isWritable();

        public boolean isExecutable();
    }

    public abstract class Section
    extends Element {
        public Section(String name) {
            super(name);
        }

        public Section(String name, int alignment) {
            super(name, alignment);
        }

        public Section(String name, int alignment, int elementIndex) {
            super(name, alignment, elementIndex);
        }
    }

    public static interface ProgbitsSectionImpl
    extends RelocatableSectionImpl {
        public void setContent(byte[] var1);

        public byte[] getContent();

        public void markRelocationSite(int var1, RelocationKind var2, String var3, long var4);
    }

    public static interface NobitsSectionImpl
    extends ElementImpl {
        public void setSizeInMemory(long var1);

        public long getSizeInMemory();
    }

    public static class IntegerDecisionComparator
    implements Comparator<LayoutDecision> {
        private int undecidedValue;

        public IntegerDecisionComparator(boolean undecidedIsLarge) {
            this.undecidedValue = undecidedIsLarge ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }

        @Override
        public int compare(LayoutDecision d0, LayoutDecision d1) {
            int off0 = d0 == null || !d0.isTaken() ? this.undecidedValue : (Integer)d0.getValue();
            int off1 = d1 == null || !d1.isTaken() ? this.undecidedValue : (Integer)d1.getValue();
            return Integer.compare(off0, off1);
        }
    }

    public static class SizeTiebreakComparator
    implements Comparator<LayoutDecision> {
        Map<Element, LayoutDecisionMap> alreadyDecided;
        boolean nullsToTail;

        public SizeTiebreakComparator(Map<Element, LayoutDecisionMap> alreadyDecided, boolean nullsToTail) {
            this.alreadyDecided = alreadyDecided;
            this.nullsToTail = nullsToTail;
        }

        @Override
        public int compare(LayoutDecision d0, LayoutDecision d1) {
            LayoutDecision sizeDecision0 = d0 == null ? null : this.alreadyDecided.get(d0.getElement()).getDecision(LayoutDecision.Kind.SIZE);
            LayoutDecision sizeDecision1 = d1 == null ? null : this.alreadyDecided.get(d1.getElement()).getDecision(LayoutDecision.Kind.SIZE);
            int defaultValue = this.nullsToTail ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            int s0 = sizeDecision0 == null || !sizeDecision0.isTaken() ? defaultValue : (Integer)sizeDecision0.getValue();
            int s1 = sizeDecision1 == null || !sizeDecision1.isTaken() ? defaultValue : (Integer)sizeDecision1.getValue();
            return Integer.compare(s0, s1);
        }
    }

    public abstract class Element
    implements ElementImpl {
        private final String name;
        private final int alignment;

        public Element(String name) {
            this(name, 1, -1);
        }

        public Element(String name, int alignment) {
            this(name, alignment, -1);
        }

        private Element(String name, int alignment, int elementIndex) {
            assert (name != null) : "Null not allowed as Element name.";
            assert (!name.equals("")) : "The empty string is not allowed as an Element name.";
            this.name = name;
            if (elementIndex == -1) {
                ObjectFile.this.elements.add(this);
            } else {
                ObjectFile.this.elements.add(elementIndex, this);
            }
            assert (ObjectFile.this.elements.forName(this.getName()) == this);
            this.alignment = alignment;
        }

        public String toString() {
            return this.getClass().getName() + "(" + this.name + ")";
        }

        @Override
        public void setElement(Element element) {
            assert (element == this);
            assert (this.getImpl() != this);
        }

        @Override
        public int getAlignment() {
            return this.alignment;
        }

        @Override
        public final Element getElement() {
            return this;
        }

        public abstract ElementImpl getImpl();

        public String getName() {
            return this.name;
        }

        public final String getElementName() {
            return this.name;
        }

        public ObjectFile getOwner() {
            return ObjectFile.this;
        }

        @Override
        public abstract boolean isLoadable();

        @Override
        public boolean isReferenceable() {
            return this.isLoadable();
        }

        @Override
        public abstract LayoutDecisionMap getDecisions(LayoutDecisionMap var1);

        @Override
        public int getMemSize(Map<Element, LayoutDecisionMap> alreadyDecided) {
            return (Integer)alreadyDecided.get(this).getDecidedValue(LayoutDecision.Kind.SIZE);
        }
    }

    public abstract class Header
    extends Element {
        public Header(String name) {
            super(name);
        }

        @Override
        public boolean isLoadable() {
            return false;
        }

        @Override
        public final ElementImpl getImpl() {
            return this;
        }

        @Override
        public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
            return ObjectFile.defaultDecisions(this, copyingIn);
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<Element, LayoutDecisionMap> decisions) {
            return ObjectFile.defaultDependencies(decisions, this);
        }

        @Override
        public byte[] getOrDecideContent(Map<Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            return ObjectFile.defaultGetOrDecideContent(alreadyDecided, this, contentHint);
        }

        @Override
        public int getOrDecideOffset(Map<Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
        }

        @Override
        public int getOrDecideSize(Map<Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return ObjectFile.defaultGetOrDecideSize(alreadyDecided, this, sizeHint);
        }

        @Override
        public int getOrDecideVaddr(Map<Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
            return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
        }
    }

    public static class ElementComparatorByDecidedOffset
    implements Comparator<Element> {
        Map<Element, LayoutDecisionMap> decisionsByElement;

        public ElementComparatorByDecidedOffset(Map<Element, LayoutDecisionMap> decisionsByElement) {
            this.decisionsByElement = decisionsByElement;
        }

        @Override
        public int compare(Element e1, Element e2) {
            int e2offset;
            LayoutDecisionMap e1decisions = this.decisionsByElement.get(e1);
            LayoutDecision e1OffsetDecision = e1decisions.getDecision(LayoutDecision.Kind.OFFSET);
            int e1offset = e1OffsetDecision != null && e1OffsetDecision.isTaken() ? (Integer)e1OffsetDecision.getValue() : Integer.MAX_VALUE;
            LayoutDecisionMap e2decisions = this.decisionsByElement.get(e2);
            LayoutDecision e2OffsetDecision = e2decisions.getDecision(LayoutDecision.Kind.OFFSET);
            int n = e2offset = e2OffsetDecision != null && e2OffsetDecision.isTaken() ? (Integer)e2OffsetDecision.getValue() : Integer.MAX_VALUE;
            if (e1offset < e2offset) {
                return -1;
            }
            if (e1offset > e2offset) {
                return 1;
            }
            return 0;
        }
    }

    public static interface Symbol {
        public String getName();

        public boolean isDefined();

        public boolean isAbsolute();

        public boolean isCommon();

        public long getSize();

        public Section getDefinedSection();

        public long getDefinedOffset();

        public long getDefinedAbsoluteValue();

        public boolean isFunction();

        public boolean isGlobal();
    }

    public static interface RelocatableSectionImpl
    extends ElementImpl {
        public void markRelocationSite(int var1, ByteBuffer var2, RelocationKind var3, String var4, long var5);

        public Element getOrCreateRelocationElement(long var1);
    }

    public static interface RelocationRecord
    extends RelocationSiteInfo {
        public Symbol getReferencedSymbol();
    }

    public static interface RelocationSiteInfo {
        public long getOffset();
    }

    public static interface RelocationMethod {
    }

    public static enum RelocationKind {
        UNKNOWN,
        DIRECT_1,
        DIRECT_2,
        DIRECT_4,
        DIRECT_8,
        SECTION_2,
        SECREL_4,
        PC_RELATIVE_1,
        PC_RELATIVE_2,
        PC_RELATIVE_4,
        PC_RELATIVE_8,
        AARCH64_R_MOVW_UABS_G0,
        AARCH64_R_MOVW_UABS_G0_NC,
        AARCH64_R_MOVW_UABS_G1,
        AARCH64_R_MOVW_UABS_G1_NC,
        AARCH64_R_MOVW_UABS_G2,
        AARCH64_R_MOVW_UABS_G2_NC,
        AARCH64_R_MOVW_UABS_G3,
        AARCH64_R_AARCH64_ADR_PREL_PG_HI21,
        AARCH64_R_AARCH64_ADD_ABS_LO12_NC,
        AARCH64_R_LD_PREL_LO19,
        AARCH64_R_GOT_LD_PREL19,
        AARCH64_R_AARCH64_LDST128_ABS_LO12_NC,
        AARCH64_R_AARCH64_LDST64_ABS_LO12_NC,
        AARCH64_R_AARCH64_LDST32_ABS_LO12_NC,
        AARCH64_R_AARCH64_LDST16_ABS_LO12_NC,
        AARCH64_R_AARCH64_LDST8_ABS_LO12_NC;


        public static RelocationKind getDirect(int relocationSize) {
            switch (relocationSize) {
                case 1: {
                    return DIRECT_1;
                }
                case 2: {
                    return DIRECT_2;
                }
                case 4: {
                    return DIRECT_4;
                }
                case 8: {
                    return DIRECT_8;
                }
            }
            return UNKNOWN;
        }

        public static RelocationKind getPCRelative(int relocationSize) {
            switch (relocationSize) {
                case 1: {
                    return PC_RELATIVE_1;
                }
                case 2: {
                    return PC_RELATIVE_2;
                }
                case 4: {
                    return PC_RELATIVE_4;
                }
                case 8: {
                    return PC_RELATIVE_8;
                }
            }
            return UNKNOWN;
        }

        public static boolean isPCRelative(RelocationKind kind) {
            switch (kind.ordinal()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return true;
                }
            }
            return false;
        }

        public static boolean isDirect(RelocationKind kind) {
            switch (kind.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return true;
                }
            }
            return false;
        }

        public static int getRelocationSize(RelocationKind kind) {
            switch (kind.ordinal()) {
                case 1: 
                case 7: {
                    return 1;
                }
                case 2: 
                case 5: 
                case 8: {
                    return 2;
                }
                case 3: 
                case 6: 
                case 9: {
                    return 4;
                }
                case 18: 
                case 19: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return 4;
                }
                case 4: 
                case 10: {
                    return 8;
                }
            }
            throw new IllegalArgumentException("Invalid RelocationKind provided: " + String.valueOf((Object)kind));
        }
    }
}

