// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: LocalizationFeature.java
package com.oracle.svm.hosted.jdk.localization;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class LocalizationFeature_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AddAllCharsets": {
            return OptionDescriptor.create(
                /*name*/ "AddAllCharsets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Make all hosted charsets available at run time",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "AddAllCharsets",
                /*option*/ LocalizationFeature.Options.AddAllCharsets,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DefaultCharset": {
            return OptionDescriptor.create(
                /*name*/ "DefaultCharset",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Default charset of the image, by the default it is the same as the default charset of the image builder.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "DefaultCharset",
                /*option*/ LocalizationFeature.Options.DefaultCharset,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DefaultLocale": {
            return OptionDescriptor.create(
                /*name*/ "DefaultLocale",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Default locale of the image, by the default it is the same as the default locale of the image builder.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "DefaultLocale",
                /*option*/ LocalizationFeature.Options.DefaultLocale,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please switch to using system properties such as '-Duser.country=CH -Duser.language=de'.");
        }
        case "IncludeAllLocales": {
            return OptionDescriptor.create(
                /*name*/ "IncludeAllLocales",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Make all hosted locales available at run time.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "IncludeAllLocales",
                /*option*/ LocalizationFeature.Options.IncludeAllLocales,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeLocales": {
            return OptionDescriptor.create(
                /*name*/ "IncludeLocales",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma separated list of locales to be included into the image. The default locale is included in the list automatically if not present.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "IncludeLocales",
                /*option*/ LocalizationFeature.Options.IncludeLocales,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeResourceBundles": {
            return OptionDescriptor.create(
                /*name*/ "IncludeResourceBundles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma separated list of bundles to be included into the image.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "IncludeResourceBundles",
                /*option*/ LocalizationFeature.Options.IncludeResourceBundles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LocalizationCompressBundles": {
            return OptionDescriptor.create(
                /*name*/ "LocalizationCompressBundles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Regular expressions matching which bundles should be compressed.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "LocalizationCompressBundles",
                /*option*/ LocalizationFeature.Options.LocalizationCompressBundles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LocalizationCompressInParallel": {
            return OptionDescriptor.create(
                /*name*/ "LocalizationCompressInParallel",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Compress the bundles in parallel.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "LocalizationCompressInParallel",
                /*option*/ LocalizationFeature.Options.LocalizationCompressInParallel,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LocalizationOptimizedMode": {
            return OptionDescriptor.create(
                /*name*/ "LocalizationOptimizedMode",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Optimize the resource bundle lookup using a simple map.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "LocalizationOptimizedMode",
                /*option*/ LocalizationFeature.Options.LocalizationOptimizedMode,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LocalizationSubstituteLoadLookup": {
            return OptionDescriptor.create(
                /*name*/ "LocalizationSubstituteLoadLookup",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Store the resource bundle content more efficiently in the fallback mode.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "LocalizationSubstituteLoadLookup",
                /*option*/ LocalizationFeature.Options.LocalizationSubstituteLoadLookup,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceLocalizationFeature": {
            return OptionDescriptor.create(
                /*name*/ "TraceLocalizationFeature",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When enabled, localization feature details are printed.",
                /*declaringClass*/ LocalizationFeature.Options.class,
                /*fieldName*/ "TraceLocalizationFeature",
                /*option*/ LocalizationFeature.Options.TraceLocalizationFeature,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 11;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AddAllCharsets");
                    case 1: return get("DefaultCharset");
                    case 2: return get("DefaultLocale");
                    case 3: return get("IncludeAllLocales");
                    case 4: return get("IncludeLocales");
                    case 5: return get("IncludeResourceBundles");
                    case 6: return get("LocalizationCompressBundles");
                    case 7: return get("LocalizationCompressInParallel");
                    case 8: return get("LocalizationOptimizedMode");
                    case 9: return get("LocalizationSubstituteLoadLookup");
                    case 10: return get("TraceLocalizationFeature");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
