// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// GENERATOR: org.graalvm.compiler.lir.processor.IntrinsicStubProcessor
package org.graalvm.compiler.hotspot.stubs;

import org.graalvm.compiler.replacements.nodes.CipherBlockChainingAESNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerMulAddNode;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.replacements.nodes.EncodeArrayNode;
import org.graalvm.compiler.replacements.StringLatin1InflateNode;
import org.graalvm.compiler.replacements.nodes.AESNode.CryptMode;
import org.graalvm.compiler.replacements.nodes.BigIntegerMultiplyToLenNode;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool.ArrayIndexOfVariant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.replacements.nodes.VectorizedMismatchNode;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesNode;
import org.graalvm.compiler.replacements.nodes.CountPositivesNode;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode.SHA256Node;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode.MD5Node;
import org.graalvm.compiler.replacements.nodes.GHASHProcessBlocksNode;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool.CalcStringAttributesEncoding;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode.SHA1Node;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.CounterModeAESNode;
import org.graalvm.compiler.replacements.nodes.VectorizedHashCodeNode;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerSquareToLenNode;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode.SHA512Node;
import org.graalvm.compiler.replacements.nodes.ArrayCopyWithConversionsNode;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.replacements.StringUTF16CompressNode;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode.SHA3Node;
import org.graalvm.compiler.replacements.nodes.ArrayRegionCompareToNode;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool.CharsetName;

public class IntrinsicStubsGen extends SnippetStub {

    public IntrinsicStubsGen(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(linkage.getDescriptor().getName(), options, providers, linkage);
    }

    @Snippet
    private static int indexOf1S1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOf1S2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOf1S4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOf2S1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf2S2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf2S4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfRange1S1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.MatchRange, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfRange1S2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.MatchRange, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfRange1S4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.MatchRange, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfWithMaskS1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.WithMask, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfWithMaskS2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.WithMask, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfWithMaskS4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.WithMask, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveS1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.FindTwoConsecutive, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveS2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.FindTwoConsecutive, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveS4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.FindTwoConsecutive, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf3S1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOf3S2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOf3S4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOf4S1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOf4S2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOf4S4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.MatchAny, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfRange2S1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.MatchRange, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfRange2S2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.MatchRange, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfRange2S4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.MatchRange, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskS1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S1, ArrayIndexOfVariant.FindTwoConsecutiveWithMask, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskS2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S2, ArrayIndexOfVariant.FindTwoConsecutiveWithMask, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskS4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(Stride.S4, ArrayIndexOfVariant.FindTwoConsecutiveWithMask, array, arrayOffset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfTableS1(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        return ArrayIndexOfNode.optimizedArrayIndexOfTable(Stride.S1, ArrayIndexOfVariant.Table, array, arrayOffset, arrayLength, fromIndex, tables);
    }

    @Snippet
    private static int indexOfTableS2(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        return ArrayIndexOfNode.optimizedArrayIndexOfTable(Stride.S2, ArrayIndexOfVariant.Table, array, arrayOffset, arrayLength, fromIndex, tables);
    }

    @Snippet
    private static int indexOfTableS4(java.lang.Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        return ArrayIndexOfNode.optimizedArrayIndexOfTable(Stride.S4, ArrayIndexOfVariant.Table, array, arrayOffset, arrayLength, fromIndex, tables);
    }

    @Snippet
    private static boolean longArraysEquals(org.graalvm.word.Pointer array1, long offset1, org.graalvm.word.Pointer array2, long offset2, int length) {
        return ArrayEqualsNode.equals(array1, offset1, array2, offset2, length, JavaKind.Long);
    }

    @Snippet
    private static boolean floatArraysEquals(org.graalvm.word.Pointer array1, long offset1, org.graalvm.word.Pointer array2, long offset2, int length) {
        return ArrayEqualsNode.equals(array1, offset1, array2, offset2, length, JavaKind.Float);
    }

    @Snippet
    private static boolean doubleArraysEquals(org.graalvm.word.Pointer array1, long offset1, org.graalvm.word.Pointer array2, long offset2, int length) {
        return ArrayEqualsNode.equals(array1, offset1, array2, offset2, length, JavaKind.Double);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S1, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S1, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S2, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S2, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S4, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S4, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsDynamicStrides(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length, int dynamicStrides) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S2S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S2, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S2S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S2, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS4S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S4, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS4S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S4, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS4S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S4, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskDynamicStrides(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, org.graalvm.word.Pointer mask, int length, int stride) {
        return ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, stride);
    }

    @Snippet
    private static int byteArrayCompareToByteArray(org.graalvm.word.Pointer arrayA, int lengthA, org.graalvm.word.Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo(arrayA, lengthA, arrayB, lengthB, Stride.S1, Stride.S1);
    }

    @Snippet
    private static int byteArrayCompareToCharArray(org.graalvm.word.Pointer arrayA, int lengthA, org.graalvm.word.Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo(arrayA, lengthA, arrayB, lengthB, Stride.S1, Stride.S2);
    }

    @Snippet
    private static int charArrayCompareToByteArray(org.graalvm.word.Pointer arrayA, int lengthA, org.graalvm.word.Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo(arrayA, lengthA, arrayB, lengthB, Stride.S2, Stride.S1);
    }

    @Snippet
    private static int charArrayCompareToCharArray(org.graalvm.word.Pointer arrayA, int lengthA, org.graalvm.word.Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo(arrayA, lengthA, arrayB, lengthB, Stride.S2, Stride.S2);
    }

    @Snippet
    private static int arrayRegionCompareToS1S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S1, Stride.S1);
    }

    @Snippet
    private static int arrayRegionCompareToS1S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S1, Stride.S2);
    }

    @Snippet
    private static int arrayRegionCompareToS1S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S1, Stride.S4);
    }

    @Snippet
    private static int arrayRegionCompareToS2S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S2, Stride.S1);
    }

    @Snippet
    private static int arrayRegionCompareToS2S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S2, Stride.S2);
    }

    @Snippet
    private static int arrayRegionCompareToS2S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S2, Stride.S4);
    }

    @Snippet
    private static int arrayRegionCompareToS4S1(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S4, Stride.S1);
    }

    @Snippet
    private static int arrayRegionCompareToS4S2(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S4, Stride.S2);
    }

    @Snippet
    private static int arrayRegionCompareToS4S4(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, Stride.S4, Stride.S4);
    }

    @Snippet
    private static int arrayRegionCompareToDynamicStrides(java.lang.Object arrayA, long offsetA, java.lang.Object arrayB, long offsetB, int length, int dynamicStrides) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
    }

    @Snippet
    private static void arrayCopyWithConversionsS1S1(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S1, Stride.S1);
    }

    @Snippet
    private static void arrayCopyWithConversionsS1S2(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S1, Stride.S2);
    }

    @Snippet
    private static void arrayCopyWithConversionsS1S4(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S1, Stride.S4);
    }

    @Snippet
    private static void arrayCopyWithConversionsS2S1(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S2, Stride.S1);
    }

    @Snippet
    private static void arrayCopyWithConversionsS2S2(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S2, Stride.S2);
    }

    @Snippet
    private static void arrayCopyWithConversionsS2S4(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S2, Stride.S4);
    }

    @Snippet
    private static void arrayCopyWithConversionsS4S1(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S4, Stride.S1);
    }

    @Snippet
    private static void arrayCopyWithConversionsS4S2(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S4, Stride.S2);
    }

    @Snippet
    private static void arrayCopyWithConversionsS4S4(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, Stride.S4, Stride.S4);
    }

    @Snippet
    private static void arrayCopyWithConversionsDynamicStrides(java.lang.Object arraySrc, long offsetSrc, java.lang.Object arrayDst, long offsetDst, int length, int stride) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, stride);
    }

    @Snippet
    private static int calcStringAttributesLatin1(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.intReturnValue(array, offset, length, CalcStringAttributesEncoding.LATIN1, false);
    }

    @Snippet
    private static int calcStringAttributesBMP(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.intReturnValue(array, offset, length, CalcStringAttributesEncoding.BMP, false);
    }

    @Snippet
    private static int calcStringAttributesUTF32(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.intReturnValue(array, offset, length, CalcStringAttributesEncoding.UTF_32, false);
    }

    @Snippet
    private static long calcStringAttributesUTF8Valid(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.longReturnValue(array, offset, length, CalcStringAttributesEncoding.UTF_8, true);
    }

    @Snippet
    private static long calcStringAttributesUTF8Unknown(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.longReturnValue(array, offset, length, CalcStringAttributesEncoding.UTF_8, false);
    }

    @Snippet
    private static long calcStringAttributesUTF16Valid(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.longReturnValue(array, offset, length, CalcStringAttributesEncoding.UTF_16, true);
    }

    @Snippet
    private static long calcStringAttributesUTF16Unknown(java.lang.Object array, long offset, int length) {
        return CalcStringAttributesNode.longReturnValue(array, offset, length, CalcStringAttributesEncoding.UTF_16, false);
    }

    @Snippet
    private static int stringUTF16Compress(org.graalvm.word.Pointer src, org.graalvm.word.Pointer dst, int len) {
        return StringUTF16CompressNode.stringUTF16Compress(src, dst, len);
    }

    @Snippet
    private static void stringLatin1Inflate(org.graalvm.word.Pointer src, org.graalvm.word.Pointer dst, int len) {
        StringLatin1InflateNode.stringLatin1Inflate(src, dst, len);
    }

    @Snippet
    private static int stringCodingCountPositives(org.graalvm.word.Pointer array, int len) {
        return CountPositivesNode.stringCodingCountPositives(array, len);
    }

    @Snippet
    private static int stringCodingEncodeArrayAscii(org.graalvm.word.Pointer src, org.graalvm.word.Pointer dst, int len) {
        return EncodeArrayNode.stringCodingEncodeArray(src, dst, len, CharsetName.ASCII);
    }

    @Snippet
    private static int stringCodingEncodeArrayLatin1(org.graalvm.word.Pointer src, org.graalvm.word.Pointer dst, int len) {
        return EncodeArrayNode.stringCodingEncodeArray(src, dst, len, CharsetName.ISO_8859_1);
    }

    @Snippet
    private static int vectorizedMismatch(org.graalvm.word.Pointer arrayA, org.graalvm.word.Pointer arrayB, int length, int stride) {
        return VectorizedMismatchNode.vectorizedMismatch(arrayA, arrayB, length, stride);
    }

    @Snippet
    private static int vectorizedHashCodeBoolean(org.graalvm.word.Pointer arrayStart, int length, int initialValue) {
        return VectorizedHashCodeNode.vectorizedHashCode(arrayStart, length, initialValue, JavaKind.Boolean);
    }

    @Snippet
    private static int vectorizedHashCodeChar(org.graalvm.word.Pointer arrayStart, int length, int initialValue) {
        return VectorizedHashCodeNode.vectorizedHashCode(arrayStart, length, initialValue, JavaKind.Char);
    }

    @Snippet
    private static int vectorizedHashCodeByte(org.graalvm.word.Pointer arrayStart, int length, int initialValue) {
        return VectorizedHashCodeNode.vectorizedHashCode(arrayStart, length, initialValue, JavaKind.Byte);
    }

    @Snippet
    private static int vectorizedHashCodeShort(org.graalvm.word.Pointer arrayStart, int length, int initialValue) {
        return VectorizedHashCodeNode.vectorizedHashCode(arrayStart, length, initialValue, JavaKind.Short);
    }

    @Snippet
    private static int vectorizedHashCodeInt(org.graalvm.word.Pointer arrayStart, int length, int initialValue) {
        return VectorizedHashCodeNode.vectorizedHashCode(arrayStart, length, initialValue, JavaKind.Int);
    }

    @Snippet
    private static void aesEncrypt(org.graalvm.word.Pointer from, org.graalvm.word.Pointer to, org.graalvm.word.Pointer key) {
        AESNode.apply(from, to, key, CryptMode.ENCRYPT);
    }

    @Snippet
    private static void aesDecrypt(org.graalvm.word.Pointer from, org.graalvm.word.Pointer to, org.graalvm.word.Pointer key) {
        AESNode.apply(from, to, key, CryptMode.DECRYPT);
    }

    @Snippet
    private static int ctrAESCrypt(org.graalvm.word.Pointer inAddr, org.graalvm.word.Pointer outAddr, org.graalvm.word.Pointer kAddr, org.graalvm.word.Pointer counterAddr, int len, org.graalvm.word.Pointer encryptedCounterAddr, org.graalvm.word.Pointer usedPtr) {
        return CounterModeAESNode.apply(inAddr, outAddr, kAddr, counterAddr, len, encryptedCounterAddr, usedPtr);
    }

    @Snippet
    private static int cbcAESEncrypt(org.graalvm.word.Pointer from, org.graalvm.word.Pointer to, org.graalvm.word.Pointer key, org.graalvm.word.Pointer r, int len) {
        return CipherBlockChainingAESNode.apply(from, to, key, r, len, CryptMode.ENCRYPT);
    }

    @Snippet
    private static int cbcAESDecrypt(org.graalvm.word.Pointer from, org.graalvm.word.Pointer to, org.graalvm.word.Pointer key, org.graalvm.word.Pointer r, int len) {
        return CipherBlockChainingAESNode.apply(from, to, key, r, len, CryptMode.DECRYPT);
    }

    @Snippet
    private static void ghashProcessBlocks(org.graalvm.word.Pointer state, org.graalvm.word.Pointer hashSubkey, org.graalvm.word.Pointer data, int blocks) {
        GHASHProcessBlocksNode.apply(state, hashSubkey, data, blocks);
    }

    @Snippet
    private static void multiplyToLen(org.graalvm.word.Pointer x, int xlen, org.graalvm.word.Pointer y, int ylen, org.graalvm.word.Pointer z, int zlen) {
        BigIntegerMultiplyToLenNode.apply(x, xlen, y, ylen, z, zlen);
    }

    @Snippet
    private static int mulAdd(org.graalvm.word.Pointer out, org.graalvm.word.Pointer in, int offset, int len, int k) {
        return BigIntegerMulAddNode.apply(out, in, offset, len, k);
    }

    @Snippet
    private static void squareToLen(org.graalvm.word.Pointer x, int len, org.graalvm.word.Pointer z, int zlen) {
        BigIntegerSquareToLenNode.apply(x, len, z, zlen);
    }

    @Snippet
    private static void sha1ImplCompress(org.graalvm.word.Pointer buf, org.graalvm.word.Pointer state) {
        SHA1Node.sha1ImplCompress(buf, state);
    }

    @Snippet
    private static void sha256ImplCompress(org.graalvm.word.Pointer buf, org.graalvm.word.Pointer state) {
        SHA256Node.sha256ImplCompress(buf, state);
    }

    @Snippet
    private static void sha3ImplCompress(org.graalvm.word.Pointer buf, org.graalvm.word.Pointer state, int blockSize) {
        SHA3Node.sha3ImplCompress(buf, state, blockSize);
    }

    @Snippet
    private static void sha512ImplCompress(org.graalvm.word.Pointer buf, org.graalvm.word.Pointer state) {
        SHA512Node.sha512ImplCompress(buf, state);
    }

    @Snippet
    private static void md5ImplCompress(org.graalvm.word.Pointer buf, org.graalvm.word.Pointer state) {
        MD5Node.md5ImplCompress(buf, state);
    }

}
