/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_km extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "\u17a2\u17b6\u179f\u17ca\u17c2\u1794\u17c3\u17a0\u17d2\u179f\u1784\u17cb";
        final String metaValue_BY = "\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f";
        final String metaValue_BG = "\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1780\u17b6\u179a\u17b8";
        final String metaValue_BD = "\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f";
        final String metaValue_CZ = "\u1786\u17c2\u1780";
        final String metaValue_DK = "\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780";
        final String metaValue_DE = "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb";
        final String metaValue_GR = "\u1780\u17d2\u179a\u17b7\u1780";
        final String metaValue_ES = "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789";
        final String metaValue_EE = "\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8";
        final String metaValue_FI = "\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb";
        final String metaValue_FR = "\u1794\u17b6\u179a\u17b6\u17c6\u1784";
        final String metaValue_IE = "\u17a2\u17c0\u179a\u17a1\u1784\u17cb";
        final String metaValue_HT = "\u17a0\u17c3\u1791\u17b8";
        final String metaValue_HU = "\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8";
        final String metaValue_AM = "\u17a2\u17b6\u1798\u17c1\u1793\u17b8";
        final String metaValue_ID = "\u17a5\u178e\u17d2\u178c\u17bc\u178e\u17c1\u179f\u17ca\u17b8";
        final String metaValue_IS = "\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u1784\u17cb";
        final String metaValue_IT = "\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8";
        final String metaValue_JP = "\u1787\u1794\u17c9\u17bb\u1793";
        final String metaValue_LU = "\u179b\u17bb\u1785\u179f\u17c6\u1794\u17bd";
        final String metaValue_LA = "\u17a1\u17b6\u179c";
        final String metaValue_LT = "\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8";
        final String metaValue_MN = "\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8";
        final String metaValue_NR = "\u178e\u17bc\u179a\u17bc";
        final String metaValue_NP = "\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb";
        final String metaValue_NL = "\u17a0\u17bc\u17a1\u1784\u17cb";
        final String metaValue_NO = "\u1793\u17d0\u179a\u179c\u17c2\u179f";
        final String metaValue_PL = "\u1794\u17c9\u17bc\u17a1\u17bc\u1789";
        final String metaValue_RO = "\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8";
        final String metaValue_RU = "\u179a\u17bb\u179f\u17d2\u179f\u17ca\u17b8";
        final String metaValue_LK = "\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6";
        final String metaValue_SK = "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8";
        final String metaValue_WS = "\u179f\u17b6\u1798\u17d0\u179a";
        final String metaValue_SO = "\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8";
        final String metaValue_AL = "\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8";
        final String metaValue_SD = "\u179f\u17ca\u17bc\u178a\u1784\u17cb";
        final String metaValue_SE = "\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178f";
        final String metaValue_TH = "\u1790\u17c3";
        final String metaValue_TO = "\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6";
        final String metaValue_UA = "\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793";
        final String metaValue_VN = "\u179c\u17c0\u178f\u178e\u17b6\u1798";
        final String metaValue_CN = "\u1785\u17b7\u1793";
        final String metaValue_PH = "\u17a0\u17d2\u179c\u17ca\u17b8\u179b\u17b8\u1796\u17b8\u1793";
        final String metaValue_SY = "\u179f\u17ca\u17b8\u179a\u17b8";
        final String metaValue_TV = "\u1791\u17bc\u179c\u17c9\u17b6\u179b\u17bc";
        final String metaValue_ar = "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb";
        final String metaValue_ae = "\u17a2\u17b6\u179c\u17c1\u179f\u17d2\u1790\u17b6\u1793";
        final String metaValue_ban = "\u1794\u17b6\u179b\u17b8";
        final String metaValue_ccp = "\u1785\u17b6\u1780\u17cb\u1798\u17c9\u17b6";
        final String metaValue_CY = "\u179f\u17ca\u17b8\u1794";
        final String metaValue_ET = "\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8";
        final String metaValue_GE = "\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8";
        final String metaValue_IL = "\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b";
        final String metaValue_jv = "\u1787\u17d2\u179c\u17b6";
        final String metaValue_km = "\u1781\u17d2\u1798\u17c2\u179a";
        final String metaValue_kn = "\u1781\u17b6\u178e\u17b6\u178a\u17b6";
        final String metaValue_ko = "\u1780\u17bc\u179a\u17c9\u17c1";
        final String metaValue_ml = "\u1798\u17c9\u17b6\u17a1\u17b6\u1799\u17c9\u17b6\u17a1\u17b6\u1798";
        final String metaValue_my = "\u1797\u17bc\u1798\u17b6";
        final String metaValue_or = "\u17a2\u17bc\u178c\u17c0";
        final String metaValue_ta = "\u178f\u17b6\u1798\u17b8\u179b";
        final String metaValue_te = "\u178f\u17c1\u179b\u17bb\u1782\u17bb";
        final String metaValue_bo = "\u1791\u17b8\u1794\u17c1";
        final String metaValue_MD = "\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8";
        final String metaValue_type_nu_taml = "\u179b\u17c1\u1781\u200b\u178f\u17b6\u1798\u17b8\u179b";
        final Object[][] data = new Object[][] {
            { "001", "\u1796\u17b7\u1797\u1796\u179b\u17c4\u1780" },
            { "002", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780" },
            { "003", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "005", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "009", "\u17a2\u17bc\u179f\u17c1\u17a2\u17b6\u1793\u17b8" },
            { "011", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "013", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "014", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u1780\u17be\u178f" },
            { "015", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "017", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "018", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "019", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "021", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1797\u17b6\u1782\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "029", "\u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793" },
            { "030", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "034", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "035", "\u17a2\u17b6\u179f\u17ca\u17b8\u17a2\u17b6\u1782\u17d2\u1793\u17c1\u1799\u17cd" },
            { "039", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "053", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u17a1\u17b6\u179f\u17ca\u17b8" },
            { "054", "\u1798\u17c1\u17a1\u17b6\u178e\u17c1\u179f\u17ca\u17b8" },
            { "057", "\u178f\u17c6\u1794\u1793\u17cb\u200b\u1798\u17b8\u1780\u17d2\u179a\u17bc\u178e\u17c1\u179f\u17ca\u17b8" },
            { "061", "\u1794\u17c9\u17bc\u179b\u17b8\u178e\u17c1\u179f\u17ca\u17b8" },
            { "142", "\u17a2\u17b6\u179f\u17ca\u17b8" },
            { "143", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "145", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "150", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794" },
            { "151", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "154", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "155", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "202", "\u17a2\u1793\u17bb\u178f\u17c6\u1794\u1793\u17cb\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780" },
            { "419", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u17a1\u17b6\u1791\u17b8\u1793" },
            { "AC", "\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u179f\u17c1\u1793\u179f\u17b7\u1793" },
            { "AD", "\u17a2\u1784\u17cb\u178a\u17bc\u179a\u17c9\u17b6" },
            { "AE", "\u17a2\u17c1\u1798\u17b8\u179a\u17c9\u17b6\u178f\u200b\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u200b\u179a\u17bd\u1798" },
            { "AF", "\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1780\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "AG", "\u17a2\u1784\u17cb\u1791\u17b8\u17a0\u17d2\u1782\u17b6 \u1793\u17b7\u1784 \u1794\u17b6\u1794\u17ca\u17bb\u1799\u178a\u17b6" },
            { "AI", "\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17b8\u17a1\u17b6" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6" },
            { "AQ", "\u17a2\u1784\u17cb\u178f\u17b6\u1780\u17cb\u1791\u17b7\u1780" },
            { "AR", "\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793" },
            { "AS", "\u179f\u17b6\u1798\u17d0\u179a \u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u17b6\u17c6\u1784" },
            { "AT", "\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f" },
            { "AU", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8" },
            { "AW", "\u17a2\u17b6\u179a\u17bc\u1794\u17b6" },
            { "AX", "\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u17a1\u1784\u17cb" },
            { "AZ", metaValue_AZ },
            { "BA", "\u1794\u17bc\u179f\u17d2\u1793\u17ca\u17b8 \u1793\u17b7\u1784\u17a0\u17ba\u17a0\u17d2\u179f\u17ca\u17b8\u17a0\u17d2\u1782\u17bc\u179c\u17b8\u178e\u17b6" },
            { "BB", "\u1794\u17b6\u1794\u17b6\u178a\u17bb\u179f" },
            { "BD", metaValue_BD },
            { "BE", "\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17ca\u17b7\u1780" },
            { "BF", "\u1794\u17bd\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc" },
            { "BG", metaValue_BG },
            { "BH", "\u1794\u17b6\u179a\u17c9\u17c2\u1793" },
            { "BI", "\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8" },
            { "BJ", "\u1794\u17c1\u178e\u17b6\u17c6\u1784" },
            { "BL", "\u179f\u17b6\u17c6\u1784\u200b\u1794\u17b6\u1790\u17c1\u17a1\u17c1\u1798\u17b8" },
            { "BM", "\u1794\u17ca\u17ba\u1798\u17bb\u1799\u178a\u17b6" },
            { "BN", "\u1796\u17d2\u179a\u17bb\u1799\u178e\u17c1" },
            { "BO", "\u1794\u17bc\u179b\u17b8\u179c\u17b8" },
            { "BQ", "\u17a0\u17bc\u17a1\u1784\u17cb \u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793" },
            { "BR", "\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b" },
            { "BS", "\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6" },
            { "BT", "\u1794\u17ca\u17bc\u178f\u1784\u17cb" },
            { "BV", "\u1780\u17c4\u17c7\u200b\u1794\u17ca\u17bc\u179c\u17c9\u17c1\u178f" },
            { "BW", "\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "BY", metaValue_BY },
            { "BZ", "\u1794\u17c1\u179b\u17b8" },
            { "CA", "\u1780\u17b6\u178e\u17b6\u178a\u17b6" },
            { "CC", "\u1780\u17c4\u17c7\u200b\u1780\u17bc\u1780\u17bc\u179f (\u1782\u17b8\u179b\u17b8\u1784)" },
            { "CD", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4- \u1782\u17b8\u1793\u179f\u17d2\u17a0\u17b6\u179f\u17b6" },
            { "CF", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "CG", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4 - \u1794\u17d2\u179a\u17b6\u17a0\u17d2\u179f\u17b6\u179c\u17b8\u179b" },
            { "CH", "\u179f\u17d2\u179c\u17ca\u17b8\u179f" },
            { "CI", "\u1780\u17bc\u178f\u178c\u17b8\u179c\u17d0\u179a" },
            { "CK", "\u1780\u17c4\u17c7\u200b\u1781\u17bc\u1780" },
            { "CL", "\u179f\u17ca\u17b8\u179b\u17b8" },
            { "CM", "\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793" },
            { "CN", metaValue_CN },
            { "CO", "\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8" },
            { "CP", "\u1780\u17c4\u17c7\u200b\u1783\u17d2\u179b\u17b8\u1797\u17ba\u178f\u17bb\u1793" },
            { "CR", "\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6" },
            { "CU", "\u1782\u17bb\u1799\u1794\u17b6" },
            { "CV", "\u1780\u17b6\u1794\u17cb\u179c\u17c2\u179a" },
            { "CW", "\u1780\u17bc\u179a\u17c9\u17b6\u1780\u17c5" },
            { "CX", "\u1780\u17c4\u17c7\u200b\u1782\u17d2\u179a\u17b8\u179f\u17d2\u1798\u17b6\u179f" },
            { "CY", metaValue_CY },
            { "CZ", metaValue_CZ },
            { "DE", metaValue_DE },
            { "DG", "\u178c\u17c0\u17a0\u17d2\u1782\u17c4\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "DJ", "\u1787\u17b8\u1794\u17ca\u17bc\u1791\u17b8" },
            { "DK", metaValue_DK },
            { "DM", "\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780" },
            { "DO", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u200b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780" },
            { "DZ", "\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8" },
            { "EA", "\u1787\u17ba\u178f\u17b6 \u1793\u17b7\u1784\u200b\u1798\u17c9\u17c1\u179b\u17b8\u17a1\u17b6" },
            { "EC", "\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a" },
            { "EE", metaValue_EE },
            { "EG", "\u17a2\u17c1\u17a0\u17d2\u179f\u17ca\u17b8\u1794" },
            { "EH", "\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ER", "\u17a2\u17c1\u179a\u17b8\u178f\u17d2\u179a\u17c1" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "\u179f\u17a0\u1797\u17b6\u1796\u200b\u17a2\u17ba\u179a\u17c9\u17bb\u1794" },
            { "EZ", "\u178f\u17c6\u1794\u1793\u17cb\u1785\u17b6\u1799\u179b\u17bb\u1799\u17a2\u17ba\u179a\u17c9\u17bc" },
            { "FI", metaValue_FI },
            { "FJ", "\u17a0\u17d2\u179c\u17b8\u1787\u17b8" },
            { "FK", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u1780\u17cb\u17a1\u17c2\u1793" },
            { "FM", "\u1798\u17b8\u1780\u17d2\u179a\u17bc\u178e\u17c1\u179f\u17ca\u17b8" },
            { "FO", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u17b6\u179a\u17c9\u17bc" },
            { "FR", metaValue_FR },
            { "GA", "\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784" },
            { "GB", "\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "GD", "\u17a0\u17d2\u1782\u17d2\u179a\u17be\u178e\u17b6\u178a" },
            { "GE", metaValue_GE },
            { "GF", "\u17a0\u17d2\u1782\u17b8\u17a2\u17b6\u178e\u17b6 \u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "GG", "\u17a0\u17d2\u1782\u17c1\u1793\u179f\u17ca\u17b8" },
            { "GH", "\u17a0\u17d2\u1782\u17b6\u178e\u17b6" },
            { "GI", "\u17a0\u17d2\u179f\u17ca\u17b8\u1794\u17d2\u179a\u17b6\u179b\u17cb\u178f\u17b6" },
            { "GL", "\u17a0\u17d2\u1782\u17d2\u179a\u17c4\u17a2\u1784\u17cb\u17a1\u1784\u17cb" },
            { "GM", "\u17a0\u17d2\u1782\u17c6\u1794\u17ca\u17b8" },
            { "GN", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "GP", "\u17a0\u17d2\u1782\u17c4\u178a\u17ba\u17a1\u17bb\u1794" },
            { "GQ", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a" },
            { "GR", metaValue_GR },
            { "GS", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784 \u1793\u17b7\u1784 \u179f\u1784\u17cb\u179c\u17b7\u1785\u200b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "GT", "\u1780\u17d2\u179c\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6" },
            { "GU", "\u17a0\u17d2\u1782\u17b6\u17c6" },
            { "GW", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17d2\u179f\u17bc" },
            { "GY", "\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u1793" },
            { "HK", "\u17a0\u17bb\u1784\u1780\u17bb\u1784 \u178f\u17c6\u1794\u1793\u17cb\u179a\u178a\u17d2\u178b\u1794\u17b6\u179b\u1796\u17b7\u179f\u17c1\u179f\u1785\u17b7\u1793" },
            { "HM", "\u1780\u17c4\u17c7\u200b\u17a0\u17ba\u178a\u1793\u17b7\u1784\u200b\u1798\u17c9\u17b6\u1780\u17cb\u178a\u17bc\u178e\u17b6\u179b\u17cb" },
            { "HN", "\u17a0\u17bb\u1784\u178c\u17bc\u179a\u17c9\u17b6\u179f" },
            { "HR", "\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u179f\u17ca\u17b8" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "\u1780\u17c4\u17c7\u200b\u1780\u17b6\u178e\u17b6\u179a\u17b8" },
            { "ID", metaValue_ID },
            { "IE", metaValue_IE },
            { "IL", metaValue_IL },
            { "IM", "\u17a2\u17c2\u179b\u17a2\u17bb\u17a0\u17d2\u179c\u1798\u17c2\u1793" },
            { "IN", "\u17a5\u178e\u17d2\u178c\u17b6" },
            { "IO", "\u178a\u17c2\u1793\u178a\u17b8\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f\u200b\u1793\u17c5\u200b\u1798\u17a0\u17b6\u200b\u179f\u1798\u17bb\u1791\u17d2\u179a\u200b\u17a5\u178e\u17d2\u178c\u17b6" },
            { "IQ", "\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb" },
            { "IR", "\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "\u1787\u17be\u179f\u17ca\u17b8" },
            { "JM", "\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17ca\u17b8\u1780" },
            { "JO", "\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8" },
            { "JP", metaValue_JP },
            { "KE", "\u1780\u17c1\u1793\u1799\u17c9\u17b6" },
            { "KG", "\u1780\u17c0\u17a0\u17d2\u179f\u17ca\u17b8\u179f\u17ca\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "KH", "\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6" },
            { "KI", "\u1782\u17b7\u179a\u17b8\u1794\u17b6\u1791\u17b8" },
            { "KM", "\u1780\u17bc\u1798\u17d0\u179a" },
            { "KN", "\u179f\u17b6\u17c6\u1784\u200b\u1782\u17b8\u178f \u1793\u17b7\u1784 \u178e\u17c1\u179c\u17b8\u179f" },
            { "KP", "\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "KR", "\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "KW", "\u1780\u17bc\u179c\u17c9\u17c2\u178f" },
            { "KY", "\u1780\u17c4\u17c7\u200b\u1780\u17c3\u1798\u17c9\u1784\u17cb" },
            { "KZ", "\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1790\u17b6\u1793" },
            { "LA", metaValue_LA },
            { "LB", "\u179b\u17b8\u1794\u1784\u17cb" },
            { "LC", "\u179f\u17b6\u17c6\u1784\u179b\u17bc\u179f\u17ca\u17b8" },
            { "LI", "\u179b\u17b7\u1785\u178f\u17b7\u1793\u179f\u17d2\u178a\u17b6\u1789" },
            { "LK", metaValue_LK },
            { "LR", "\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "LS", "\u17a1\u17c1\u179f\u17bc\u178f\u17bc" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", "\u17a1\u17c1\u178f\u17bc\u1793\u17b8" },
            { "LY", "\u179b\u17b8\u1794\u17ca\u17b8" },
            { "MA", "\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780" },
            { "MC", "\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc" },
            { "MD", metaValue_MD },
            { "ME", "\u1798\u17c9\u17bb\u1784\u178f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17d2\u179a\u17c4" },
            { "MF", "\u179f\u17b6\u17c6\u1784\u200b\u1798\u17c9\u17b6\u1791\u17b8\u1793" },
            { "MG", "\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17d2\u1780\u17b6" },
            { "MH", "\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179f\u17cb\u179f\u179b" },
            { "MK", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17d2\u179c\u17b6\u1793\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "ML", "\u1798\u17c9\u17b6\u179b\u17b8" },
            { "MM", "\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6 (\u1797\u17bc\u1798\u17b6)" },
            { "MN", metaValue_MN },
            { "MO", "\u1798\u17c9\u17b6\u1780\u17b6\u179c \u178f\u17c6\u1794\u1793\u17cb\u179a\u178a\u17d2\u178b\u1794\u17b6\u179b\u1796\u17b7\u179f\u17c1\u179f\u1785\u17b7\u1793" },
            { "MP", "\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17b6\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "MQ", "\u1798\u17c9\u17b6\u1791\u17b8\u1793\u17b8\u1780" },
            { "MR", "\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8" },
            { "MS", "\u1798\u17c9\u17bb\u1784\u179f\u17ca\u17c2\u179a\u17c9\u17b6" },
            { "MT", "\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17cd" },
            { "MU", "\u1798\u17c9\u17bc\u179a\u17b8\u179f" },
            { "MV", "\u1798\u17c9\u17b6\u179b\u17cb\u178c\u17b8\u179c" },
            { "MW", "\u1798\u17c9\u17b6\u17a1\u17b6\u179c\u17b8" },
            { "MX", "\u1798\u17c9\u17b7\u1780\u179f\u17ca\u17b7\u1780" },
            { "MY", "\u1798\u17c9\u17b6\u17a1\u17c1\u179f\u17ca\u17b8" },
            { "MZ", "\u1798\u17c9\u17bc\u179f\u17c6\u1794\u17ca\u17b7\u1780" },
            { "NA", "\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8" },
            { "NC", "\u1793\u17bc\u179c\u17c2\u179b\u200b\u1780\u17b6\u17a1\u17c1\u178a\u17bc\u1793\u17b8" },
            { "NE", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1" },
            { "NF", "\u1780\u17c4\u17c7\u200b\u178e\u17d0\u179a\u17a0\u17d2\u179c\u1780\u17cb" },
            { "NG", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "NI", "\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u178e\u17c0" },
            { "NZ", "\u1793\u17bc\u179c\u17c2\u179b\u200b\u179f\u17c1\u17a1\u1784\u17cb" },
            { "OM", "\u17a2\u17bc\u1798\u17c9\u1784\u17cb" },
            { "PA", "\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6" },
            { "PE", "\u1794\u17c9\u17c1\u179a\u17bc" },
            { "PF", "\u1794\u17c9\u17bc\u179b\u17b8\u200b\u178e\u17c1\u179f\u17ca\u17b8\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "PG", "\u1794\u17c9\u17b6\u1796\u17bc\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "PH", metaValue_PH },
            { "PK", "\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "PL", metaValue_PL },
            { "PM", "\u179f\u1784\u17cb\u1796\u17d2\u1799\u17c2\u179a \u1793\u17b7\u1784\u200b\u1798\u17b8\u1782\u17b8\u17a1\u17bb\u1784" },
            { "PN", "\u1780\u17c4\u17c7\u200b\u1797\u17b8\u178f\u1780\u17b6\u1793" },
            { "PR", "\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc" },
            { "PS", "\u178a\u17c2\u1793\u178a\u17b8\u1794\u17c9\u17b6\u17a1\u17c1\u179f\u17d2\u1791\u17b8\u1793" },
            { "PT", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb" },
            { "PW", "\u1795\u17c5\u17a1\u17bc" },
            { "PY", "\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799" },
            { "QA", "\u1780\u17b6\u178f\u17b6" },
            { "QO", "\u178f\u17c6\u1794\u1793\u17cb\u1787\u17b6\u1799\u17a2\u17bc\u179f\u17c1\u17a2\u17b6\u1793\u17b8" },
            { "RE", "\u179a\u17c1\u17a2\u17bb\u1799\u1789\u17c9\u17bb\u1784" },
            { "RO", metaValue_RO },
            { "RS", "\u179f\u17c2\u1794\u17ca\u17b8" },
            { "RU", metaValue_RU },
            { "RW", "\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "SA", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17bc\u178c\u17b8\u178f" },
            { "SB", "\u1780\u17c4\u17c7\u200b\u179f\u17bc\u17a1\u17bc\u1798\u17c9\u17bb\u1784" },
            { "SC", "\u179f\u17b8\u179f\u17d2\u17a0\u17c2\u179b" },
            { "SD", metaValue_SD },
            { "SE", metaValue_SE },
            { "SG", "\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8" },
            { "SH", "\u179f\u1784\u17cb\u200b\u17a0\u17c1\u17a1\u17c1\u178e\u17b6" },
            { "SI", "\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8" },
            { "SJ", "\u179f\u17d2\u179c\u17b6\u179b\u1794\u17b6\u178a \u1793\u17b7\u1784 \u17a0\u17d2\u179f\u1784\u17cb\u1798\u17c9\u17b6\u1799\u17c1\u1793" },
            { "SK", metaValue_SK },
            { "SL", "\u179f\u17c0\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793" },
            { "SM", "\u179f\u17b6\u1793\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17bc" },
            { "SN", "\u179f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17b6\u179b\u17cb" },
            { "SO", metaValue_SO },
            { "SR", "\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798" },
            { "SS", "\u179f\u17ca\u17bc\u178a\u1784\u17cb\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "ST", "\u179f\u17c5\u178f\u17bc\u1798\u17c9\u17c1 \u1793\u17b7\u1784 \u1794\u17d2\u179a\u17b6\u17c6\u1784\u179f\u17ca\u17b8\u1794" },
            { "SV", "\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a" },
            { "SX", "\u179f\u17b8\u1784\u200b\u1798\u17c9\u17b6\u1792\u17b8\u1793" },
            { "SY", metaValue_SY },
            { "SZ", "\u179f\u17d2\u179c\u17b6\u179f\u17ca\u17b8\u17a1\u1784\u17cb" },
            { "TA", "\u1791\u17d2\u179a\u17b8\u179f\u17d2\u178f\u1784\u17cb\u200b\u178a\u17b6\u200b\u1785\u17bc\u1793\u17a0\u17b6" },
            { "TC", "\u1780\u17c4\u17c7\u200b\u1791\u17bd\u1782 \u1793\u17b7\u1784 \u1780\u17c3\u1780\u17bc\u179f" },
            { "TD", "\u1786\u17b6\u178a" },
            { "TF", "\u178a\u17c2\u1793\u178a\u17b8\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784\u200b\u1793\u17c5\u200b\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "TG", "\u178f\u17bc\u17a0\u17d2\u1782\u17c4" },
            { "TH", metaValue_TH },
            { "TJ", "\u178f\u17b6\u17a0\u17d2\u179f\u17ca\u17b8\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "TK", "\u178f\u17bc\u1781\u17c1\u17a1\u17c5" },
            { "TL", "\u1791\u17b8\u1798\u17d0\u179a\u179b\u17c1\u179f\u17d2\u178f\u17c1" },
            { "TM", "\u178f\u17bd\u1780\u1798\u17c9\u17c1\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "TN", "\u1791\u17bb\u1799\u1793\u17b8\u179f\u17ca\u17b8" },
            { "TO", metaValue_TO },
            { "TR", "\u178f\u17bd\u1780\u1782\u17b8" },
            { "TT", "\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178f \u1793\u17b7\u1784\u200b\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4" },
            { "TV", metaValue_TV },
            { "TW", "\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb" },
            { "TZ", "\u178f\u1784\u17cb\u179f\u17b6\u1793\u17b8" },
            { "UA", metaValue_UA },
            { "UG", "\u17a2\u17ca\u17bc\u17a0\u17d2\u1782\u1784\u17cb\u178a\u17b6" },
            { "UM", "\u1780\u17c4\u17c7\u200b\u17a2\u17c5\u17a1\u17b6\u1799\u17b8\u1784\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "UN", "\u17a2\u1784\u17d2\u1782\u1780\u17b6\u179a\u179f\u17a0\u1794\u17d2\u179a\u1787\u17b6\u1787\u17b6\u178f\u17b7" },
            { "US", "\u179f\u17a0\u179a\u178a\u17d2\u178b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "UY", "\u17a2\u17ca\u17bb\u1799\u179a\u17bc\u17a0\u17d2\u1782\u17b6\u1799" },
            { "UZ", "\u17a2\u17ca\u17bc\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "VA", "\u1794\u17bb\u179a\u17b8\u200b\u179c\u17c9\u17b6\u1791\u17b8\u1780\u1784\u17cb" },
            { "VC", "\u179f\u17b6\u17c6\u1784\u200b\u179c\u17c9\u17b6\u17c6\u1784\u179f\u1784\u17cb \u1793\u17b7\u1784 \u17a0\u17d2\u1782\u17d2\u179a\u17c1\u178e\u17b6\u178c\u17b8\u1793" },
            { "VE", "\u179c\u17c9\u17c1\u178e\u17c1\u179f\u17ca\u17bb\u1799\u17a2\u17c1\u17a1\u17b6" },
            { "VG", "\u1780\u17c4\u17c7\u200b\u179c\u17ba\u1787\u17b7\u1793\u200b\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "VI", "\u1780\u17c4\u17c7\u200b\u179c\u17ba\u1787\u17b8\u1793\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "VN", metaValue_VN },
            { "VU", "\u179c\u17c9\u17b6\u1793\u17bc\u1791\u17bc" },
            { "WF", "\u179c\u17c9\u17b6\u179b\u17b8\u179f \u1793\u17b7\u1784\u200b\u17a0\u17d2\u179c\u17bc\u1791\u17bc\u178e\u17b6" },
            { "WS", metaValue_WS },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "\u1780\u17bc\u179f\u17bc\u179c\u17c9\u17bc" },
            { "YE", "\u1799\u17c1\u1798\u17c9\u17c2\u1793" },
            { "YT", "\u1798\u17c9\u17b6\u1799\u17bb\u178f" },
            { "ZA", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "ZM", "\u179f\u17c6\u1794\u17ca\u17b8" },
            { "ZW", "\u179f\u17ca\u17b8\u1798\u1794\u17b6\u179c\u17c9\u17c1" },
            { "ZZ", "\u178f\u17c6\u1794\u1793\u17cb\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "aa", "\u17a2\u17b6\u17a0\u17d2\u179c\u17b6\u179a" },
            { "ab", "\u17a2\u17b6\u1794\u17cb\u1781\u17b6\u17a0\u17ca\u17d2\u179f\u17b6\u1793" },
            { "ae", metaValue_ae },
            { "af", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u17b6\u1793" },
            { "ak", "\u17a2\u17b6\u1780\u17b6\u1793" },
            { "am", "\u17a2\u17b6\u17c6\u17a0\u17b6\u179a\u17b7\u1780" },
            { "an", "\u17a2\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17c4\u1793" },
            { "ar", metaValue_ar },
            { "as", "\u17a2\u17b6\u179f\u17b6\u1798\u17b8\u179f" },
            { "av", "\u17a2\u17b6\u179c\u17c9\u17b6\u179a\u17b8\u1780" },
            { "ay", "\u17a2\u17b8\u1798\u17c9\u17b6\u179a\u17c9\u17b6" },
            { "az", metaValue_AZ },
            { "ba", "\u1794\u17b6\u179f\u17d2\u1782\u17c0" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "\u1794\u17ca\u17b8\u179f\u17d2\u179b\u17b6\u1798\u17c9\u17b6" },
            { "bm", "\u1794\u17b6\u1798\u17d2\u1794\u17b6\u179a\u17b6" },
            { "bn", metaValue_BD },
            { "bo", metaValue_bo },
            { "br", "\u1794\u17d2\u179a\u17ca\u17b8\u179f\u17d2\u178f\u17bb\u1793" },
            { "bs", "\u1794\u17bc\u179f\u17d2\u1793\u17ca\u17b8" },
            { "ca", "\u1780\u17b6\u178f\u17b6\u17a1\u17b6\u1793" },
            { "ce", "\u1788\u17b8\u1786\u17c1\u1793" },
            { "ch", "\u1788\u17b8\u1798\u17c9\u17bc\u179a\u17c9\u17bc" },
            { "co", "\u1780\u17bc\u179f\u17ca\u17b8\u1781\u17b6\u1793" },
            { "cs", metaValue_CZ },
            { "cu", "\u1788\u17be\u1787\u179f\u17d2\u179b\u17b6\u179c\u17b7\u1780" },
            { "cv", "\u1788\u17bc\u179c\u17c9\u17b6\u179f" },
            { "cy", "\u179c\u17c1\u179b" },
            { "da", metaValue_DK },
            { "de", metaValue_DE },
            { "dv", "\u1791\u17c1\u179c\u17b8\u17a0\u17ca\u17b8" },
            { "dz", "\u178a\u17bb\u1784\u1781\u17b6" },
            { "ee", "\u17a2\u17ca\u17b8\u179c" },
            { "el", metaValue_GR },
            { "en", "\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "eo", "\u17a2\u17c1\u179f\u17d2\u1796\u17c1\u179a\u17c9\u17b6\u1793\u17cb\u178f\u17bc" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "\u1794\u17b6\u179f\u1781\u17cd" },
            { "fa", "\u1797\u17ba\u179f\u17c0\u1793" },
            { "ff", "\u17a0\u17d2\u179c\u17ca\u17bc\u17a1\u17b6" },
            { "fi", metaValue_FI },
            { "fj", "\u17a0\u17ca\u17d2\u179c\u17b8\u1787\u17b8" },
            { "fo", "\u17a0\u17d2\u179c\u17b6\u179a\u17bc\u179f" },
            { "fr", metaValue_FR },
            { "fy", "\u17a0\u17d2\u179c\u17d2\u179a\u17b8\u179f\u17ca\u17b6\u1793\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ga", metaValue_IE },
            { "gd", "\u179f\u17d2\u1780\u17bb\u178f\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782" },
            { "gl", "\u17a0\u17d2\u1780\u17b6\u179b\u17b8\u179f\u17d2\u1799\u17b6\u1793" },
            { "gn", "\u17a0\u17d2\u1782\u17bc\u179a\u17c9\u17b6\u1793\u17b8" },
            { "gu", "\u17a0\u17d2\u1782\u17bb\u1799\u17c9\u17b6\u179a\u17c9\u17b6\u1791\u17b8" },
            { "gv", "\u1798\u17c1\u1793" },
            { "ha", "\u17a0\u17bc\u179f\u17b6" },
            { "he", "\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "hi", "\u17a0\u17b7\u178e\u17d2\u178c\u17b8" },
            { "hr", "\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u178f" },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "\u17a0\u17ba\u179a\u17b8\u179a\u17c9\u17bc" },
            { "ia", "\u17a2\u17ca\u17b8\u1793\u1792\u17be\u179b\u17b8\u1784" },
            { "id", metaValue_ID },
            { "ie", "\u17a2\u17ca\u17b8\u1793\u1792\u17be\u179b\u17b8\u1784\u179c\u17c1" },
            { "ig", "\u17a2\u17ca\u17b8\u1780\u1794\u17bc" },
            { "ii", "\u179f\u17ca\u17b8\u1788\u17b6\u1793\u17cb\u1799\u17b8" },
            { "io", "\u17a2\u17ca\u17b8\u178a\u17bc" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "\u17a2\u17ca\u17b8\u1793\u17bb\u1780\u1791\u17b8\u1791\u17bb\u178f" },
            { "ja", metaValue_JP },
            { "jv", metaValue_jv },
            { "ka", "\u17a0\u17d2\u179f\u1780\u200b\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "ki", "\u1782\u17b8\u1782\u17bc\u1799\u17bc" },
            { "kj", "\u1782\u17bc\u1793\u1799\u17c9\u17b6\u1798\u17c9\u17b6" },
            { "kk", "\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb" },
            { "kl", "\u1780\u17b6\u17a1\u17b6\u179b\u179b\u17b8\u179f\u17ca\u17bb\u178f" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u1780\u17b6\u1793\u17bc\u179a\u17b8" },
            { "ks", "\u1780\u17b6\u179f\u17d2\u1798\u17c0\u179a" },
            { "ku", "\u1783\u17ba\u178a" },
            { "kv", "\u1780\u17bc\u1798\u17b8" },
            { "kw", "\u1780\u17bc\u1793\u17b8\u179f" },
            { "ky", "\u200b\u1780\u17c0\u17a0\u17d2\u179f\u17ca\u17b8\u179f" },
            { "la", "\u17a1\u17b6\u178f\u17c6\u17b6\u1784" },
            { "lb", metaValue_LU },
            { "lg", "\u17a0\u17d2\u1780\u17b6\u1793\u17cb\u178a\u17b6" },
            { "li", "\u179b\u17b8\u1798\u1794\u17ca\u17bc\u179f" },
            { "ln", "\u179b\u17b8\u1793\u1780\u17b6\u17a1\u17b6" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "\u179b\u17bc\u1794\u17b6\u1780\u17b6\u178f\u17b6\u1793\u17a0\u17d2\u1782\u17b6" },
            { "lv", "\u17a1\u17b6\u178f\u179c\u17b8" },
            { "mg", "\u1798\u17c9\u17b6\u17a1\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "mh", "\u1798\u17c9\u17b6\u179f\u17cb\u179f\u179b" },
            { "mi", "\u1798\u17c9\u17c4\u179a\u17b8" },
            { "mk", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "\u1798\u17c9\u17b6\u179a\u17c9\u17b6\u1792\u17b8" },
            { "ms", "\u1798\u17c9\u17b6\u17a1\u17c1" },
            { "mt", "\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6" },
            { "my", metaValue_my },
            { "na", metaValue_NR },
            { "nb", "\u1793\u17d0\u179a\u179c\u17c2\u179f \u1794\u17bb\u1780\u1798\u17c9\u17b6\u179b\u17cb" },
            { "nd", "\u1793\u17c1\u1794\u17c1\u179b\u17c1\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "ne", metaValue_NP },
            { "ng", "\u1793\u17bb\u1793\u17a0\u17d2\u1782\u17b6" },
            { "nl", metaValue_NL },
            { "nn", "\u1793\u17d0\u179a\u179c\u17c2\u179f \u1793\u17b8\u1793\u17bc\u179f" },
            { "no", metaValue_NO },
            { "nr", "\u1793\u17c1\u1794\u17ca\u17c1\u179b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "nv", "\u178e\u17b6\u179c\u17c9\u17b6\u1785\u17bc" },
            { "ny", "\u178e\u17b6\u1793\u1785\u17b6" },
            { "oc", "\u17a2\u17bc\u179f\u17b8\u178f\u17b6\u1793\u17cb" },
            { "om", "\u17a2\u17bc\u179a\u17c9\u17bc\u1798\u17c9\u17bc" },
            { "or", metaValue_or },
            { "os", "\u17a2\u17bc\u179f\u17ca\u17b8\u1791\u17b7\u1780" },
            { "pa", "\u1794\u17b9\u1793\u1787\u17b6\u1796\u17b7" },
            { "pl", metaValue_PL },
            { "ps", "\u1794\u17b6\u179f\u17d2\u178f\u17bc" },
            { "pt", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u179b\u17cb" },
            { "qu", "\u17a0\u17d2\u1782\u17b7\u1780\u1788\u17bd" },
            { "rm", "\u179a\u17c9\u17bc\u1798\u17c9\u1784\u17cb" },
            { "rn", "\u179a\u17bb\u178e\u17d2\u178c\u17b8" },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", "\u1782\u17b7\u1793\u1799\u17c9\u17b6\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "sa", "\u179f\u17c6\u179f\u17d2\u1780\u17d2\u179a\u17b9\u178f" },
            { "sc", "\u179f\u17b6\u178c\u17b8\u1793\u17b6" },
            { "sd", "\u179f\u17ca\u17b8\u1793\u178c\u17b8" },
            { "se", "\u179f\u17b6\u1798\u17b8\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "sg", "\u179f\u17b6\u1793\u17a0\u17d2\u1782\u17c4" },
            { "sh", "\u179f\u17ba\u1794\u17bc\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u178f" },
            { "si", metaValue_LK },
            { "sk", metaValue_SK },
            { "sl", "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1793\u17b8" },
            { "sm", metaValue_WS },
            { "sn", "\u179f\u17bc\u178e\u17b6" },
            { "so", metaValue_SO },
            { "sq", metaValue_AL },
            { "sr", "\u179f\u17ca\u17c2\u1794" },
            { "ss", "\u179f\u17d2\u179c\u17b6\u1791\u17b8" },
            { "st", "\u179f\u17bc\u1790\u17bc\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "sw", "\u179f\u17d2\u179c\u17b6\u17a0\u17ca\u17b8\u179b\u17b8" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u178f\u17b6\u17a0\u17d2\u179f\u17ca\u17b8\u1782" },
            { "th", metaValue_TH },
            { "ti", "\u1791\u17b8\u17a0\u17d2\u1782\u17d2\u179a\u17b8\u1789\u17c9\u17b6" },
            { "tk", "\u178f\u17bd\u1780\u1798\u17c9\u17c1\u1793" },
            { "tn", "\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "to", metaValue_TO },
            { "tr", "\u1791\u17bd\u179a\u1782\u17b8" },
            { "ts", "\u179f\u17bb\u1784\u17a0\u17d2\u1782\u17b6" },
            { "tt", "\u178f\u17b6\u178f\u17b6" },
            { "tw", "\u1791\u17d2\u179c\u17b8" },
            { "ty", "\u178f\u17b6\u17a0\u17ca\u17b8\u1791\u17b8" },
            { "ug", "\u17a2\u17ca\u17bb\u1799\u17a0\u17d2\u1782\u17ba\u179a" },
            { "uk", metaValue_UA },
            { "ur", "\u17a2\u17ca\u17bc\u179a\u178c\u17bc" },
            { "uz", "\u17a2\u17ca\u17bc\u179f\u1794\u17c1\u1782" },
            { "ve", "\u179c\u17c1\u1793\u178a\u17b6" },
            { "vi", metaValue_VN },
            { "vo", "\u179c\u17bc\u17a1\u17b6\u1796\u17bc\u1780" },
            { "wa", "\u179c\u17c9\u17b6\u179b\u17bc\u1793" },
            { "wo", "\u179c\u17bc\u17a1\u17bb\u17a0\u17d2\u179c" },
            { "xh", "\u1783\u179f\u17b6" },
            { "yi", "\u1799\u17c9\u17b8\u178c\u17b8\u179f" },
            { "yo", "\u1799\u179a\u17bc\u1794\u17b6" },
            { "za", "\u17a0\u17d2\u179f\u17bd\u1784" },
            { "zh", metaValue_CN },
            { "zu", "\u17a0\u17d2\u179f\u17bc\u179b\u17bc" },
            { "ace", "\u17a2\u17b6\u1780\u17a0\u17ca\u17b8\u1793\u17ba\u179f" },
            { "ada", "\u17a2\u17b6\u178a\u17c1\u1784\u1798\u17b8" },
            { "ady", "\u17a2\u17b6\u178c\u17b8\u17a0\u17d2\u1782\u17b8" },
            { "agq", "\u17a2\u17b6\u17a0\u17d2\u1782\u17b8\u1798" },
            { "ain", "\u17a2\u17b6\u1799\u1793\u17bc" },
            { "ale", "\u17a2\u17b6\u179b\u17bc\u178f" },
            { "alt", "\u17a2\u17b6\u179b\u17cb\u178f\u17c3\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "ann", "\u17a2\u17bc\u1794\u17bc\u17a1\u17bc" },
            { "anp", "\u17a2\u17b6\u17a0\u17d2\u1782\u17b8\u1780\u17b6" },
            { "arn", "\u1798\u17c9\u17b6\u1796\u17bc\u1788\u17b8" },
            { "arp", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17c9\u17b6\u17a0\u17bc" },
            { "ars", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u178e\u17b6\u178c\u17b8" },
            { "asa", "\u17a2\u17b6\u179f\u17ca\u17bc" },
            { "ast", "\u17a2\u17b6\u179f\u17d2\u1791\u17bc\u179a\u17b8" },
            { "atj", "\u17a2\u17b6\u1791\u17b7\u1780\u17b6\u1798\u17c9\u17c1\u1780" },
            { "awa", "\u17a2\u17b6\u179c\u17c9\u17b6\u178c\u17b8" },
            { "ban", metaValue_ban },
            { "bas", "\u1794\u17b6\u179f\u17b6" },
            { "bem", "\u1794\u17c1\u1798\u1794\u17b6" },
            { "bez", "\u1794\u17c1\u178e\u17b6" },
            { "bgc", "\u17a0\u17b6\u179a\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u179c\u17b8" },
            { "bgn", "\u1794\u17b6\u17a1\u17bc\u1787\u17b8\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "bho", "\u1794\u17bc\u1785\u1796\u17bc\u179a\u17b8" },
            { "bin", "\u1794\u17ca\u17b8\u1793\u17b8" },
            { "bla", "\u179f\u17ca\u17b8\u1780\u179f\u17ca\u17b8\u1780\u17b6" },
            { "blo", "\u17a2\u17b6\u1793\u17b8" },
            { "brx", "\u1794\u17bc\u178a\u17bc" },
            { "bug", "\u1794\u17ca\u17bb\u1780\u17a0\u17d2\u1782\u17b8" },
            { "byn", "\u1794\u17d2\u179b\u17ca\u17b8\u1793" },
            { "cay", "\u1781\u17b6\u1799\u17bc\u17a0\u17d2\u1780\u17b6" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u179f\u17ca\u17b8\u1794\u17ca\u17bc\u17a2\u17b6\u178e\u17bc" },
            { "cgg", "\u1788\u17b8\u17a0\u17d2\u1780\u17b6" },
            { "chk", "\u1788\u17bc\u1782\u17b8" },
            { "chm", "\u1798\u17c9\u17b6\u179a\u17b8" },
            { "cho", "\u1786\u17bb\u1780\u178f\u17b6\u179c" },
            { "chp", "\u1788\u17b8\u1794\u17c9\u17c1\u179c\u17c9\u17b6\u1799\u17a2\u17b7\u1793" },
            { "chr", "\u1786\u17c1\u179a\u17bc\u1782\u17b8" },
            { "chy", "\u1788\u17b8\u1799\u17b8\u1793\u17b8" },
            { "ckb", "\u1783\u17be\u178a\u1797\u17b6\u1782\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "clc", "\u1788\u17b8\u179b\u1780\u17bc\u1791\u17b8\u1793" },
            { "crg", "\u1798\u17b8\u1788\u17b8\u17a0\u17d2\u179c" },
            { "crj", "\u1782\u17d2\u179a\u17b8\u1781\u17b6\u1784\u1780\u17be\u178f\u200b\u1794\u17c9\u17c2\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "crk", "\u1782\u17d2\u179a\u17b8\u178f\u17c6\u1794\u1793\u17cb\u179c\u17b6\u179b\u179a\u17b6\u1794" },
            { "crl", "\u1782\u17d2\u179a\u17b8\u1781\u17b6\u1784\u1780\u17be\u178f\u200b\u1794\u17c9\u17c2\u1780\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "crm", "\u1798\u17bc\u179f\u1782\u17d2\u179a\u17b8" },
            { "crr", "\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u1782\u1793\u1781\u17d2\u179c\u17c0\u1793 \u1781\u17b6\u179a\u17c9\u17bc\u179b\u17b8\u178e\u17b6" },
            { "crs", "\u179f\u17c1\u179f\u17c1\u179b\u179c\u17c9\u17b6\u1782\u17d2\u179a\u17b8\u17a2\u17bc\u179b (\u1794\u17b6\u179a\u17b6\u17c6\u1784)" },
            { "csw", "\u1782\u17d2\u179a\u17b8\u178f\u17c6\u1794\u1793\u17cb\u1797\u1780\u17cb\u179b\u17d2\u1794\u17b6\u1794\u17cb" },
            { "dak", "\u178a\u17b6\u1780\u17bc\u178f\u17b6" },
            { "dar", "\u178a\u17b6\u1785\u179c\u17c9\u17b6" },
            { "dav", "\u178f\u17c3\u178f\u17b6" },
            { "dgr", "\u178a\u17bc\u1782\u17d2\u179a\u17b8\u1794" },
            { "dje", "\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6" },
            { "doi", "\u178a\u17bc\u17a0\u17d2\u1782\u17d2\u179a\u17b8" },
            { "dsb", "\u179f\u17bc\u1794\u17ca\u17b8\u1780\u17d2\u179a\u17c4\u1798" },
            { "dua", "\u178c\u17bd\u179b\u17a1\u17b6" },
            { "dyo", "\u1785\u17bc\u17a1\u17b6\u17a0\u17ca\u17d2\u179c\u17bb\u1793\u1799\u17b8" },
            { "dzg", "\u178a\u17b6\u17a0\u17d2\u179f\u17b6\u17a0\u17d2\u1782\u17b6" },
            { "ebu", "\u17a2\u17c1\u1798\u1794\u17ca\u17bc" },
            { "efi", "\u17a2\u17ca\u17b8\u17a0\u17d2\u179c\u17b7\u1780" },
            { "eka", "\u17a2\u17ca\u17b8\u1780\u17b6\u1787\u17bb\u1780" },
            { "ewo", "\u17a2\u17ca\u17b8\u179c\u17c9\u17bb\u1793\u178a\u17bc" },
            { "fil", metaValue_PH },
            { "fon", "\u17a0\u17d2\u179c\u17ca\u17bb\u1793" },
            { "frc", "\u1794\u17b6\u179a\u17b6\u17c6\u1784\u1780\u17b6\u17a0\u17d2\u179f\u1784\u17cb" },
            { "frr", "\u17a0\u17d2\u179c\u17d2\u179a\u17ca\u17b8\u179f\u17c0\u1793\u200b\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "fur", "\u17a0\u17ca\u17d2\u179c\u17d2\u179a\u17bc\u179b\u17b6\u1793" },
            { "gaa", "\u17a0\u17d2\u1782\u17b6" },
            { "gag", "\u1780\u17b6\u1782\u17bc\u179f" },
            { "gez", "\u1787\u17b8\u179f" },
            { "gil", "\u17a0\u17d2\u1782\u17b8\u179b\u1794\u17ba\u1791" },
            { "gor", "\u17a0\u17d2\u1782\u17bc\u179a\u17bb\u1793\u178f\u17b6\u17a1\u17bc" },
            { "gsw", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784 (\u179f\u17d2\u179c\u17b8\u179f)" },
            { "guz", "\u17a0\u17d2\u1782\u17bc\u179f\u17ca\u17b8" },
            { "gwi", "\u17a0\u17d2\u1782\u17b8\u1785\u1788\u17b8\u1793" },
            { "hai", "\u17a0\u17c3\u178a\u17b6" },
            { "haw", "\u17a0\u17b6\u179c\u17c9\u17c3" },
            { "hax", "\u17a0\u17c3\u178a\u17b6\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "hil", "\u17a0\u17ca\u17b8\u179b\u17b8\u17a0\u17d2\u1782\u17c1\u178e\u17bb\u1793" },
            { "hmn", "\u1798\u17c9\u17bb\u1784" },
            { "hsb", "\u179f\u17bc\u1794\u17ca\u17b8\u179b\u17be" },
            { "hup", "\u17a0\u17ca\u17bc\u1794\u17c9\u17b6" },
            { "hur", "\u17a0\u17b6\u179b\u17cb\u1780\u17bc\u1798\u17c9\u17c1\u17a1\u17c1\u1798" },
            { "iba", "\u17a2\u17ca\u17b8\u1794\u17b6\u1793" },
            { "ibb", "\u17a2\u17b6\u1799\u1794\u17ca\u17b8\u1794\u17ca\u17b8\u17a2\u17bc" },
            { "ikt", "\u17a2\u17ca\u17b8\u1793\u17bb\u1780\u1791\u17b8\u1791\u17bb\u178f\u200b\u1780\u17b6\u178e\u17b6\u178a\u17b6\u200b\u1794\u17c9\u17c2\u1780\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ilo", "\u17a2\u17ca\u17b8\u17a1\u17bc\u1780\u17bc" },
            { "inh", "\u17a2\u17ca\u17b7\u1793\u17a0\u17d2\u1782\u17bc\u179f" },
            { "jbo", "\u179b\u17bb\u1785\u1794\u17b6\u1793" },
            { "jgo", "\u1784\u17bb\u17c6\u1794\u17b6" },
            { "jmc", "\u1798\u17c9\u17b6\u1786\u17b6\u17c6" },
            { "kab", "\u1780\u17b6\u1794\u17ca\u17b8\u17a1\u17c1" },
            { "kac", "\u1780\u17b6\u1788\u17b8\u1793" },
            { "kaj", "\u1787\u17bc" },
            { "kam", "\u1780\u17b6\u17c6\u1794\u17b6" },
            { "kbd", "\u1780\u17b6\u1794\u17b6\u178c\u17c0" },
            { "kcg", "\u1799\u17c9\u17b6\u1794\u17cb" },
            { "kde", "\u1798\u17c9\u17b6\u1780\u17bc\u1793\u178a\u17c1" },
            { "kea", "\u1780\u17b6\u1794\u17ca\u17bc\u179c\u17ba\u178c\u17c0\u1793\u17bc" },
            { "kfo", "\u1782\u17bc\u179a\u17bc" },
            { "kgp", "\u1781\u17b6\u1784\u17a0\u17d2\u1780\u17c1\u1784" },
            { "kha", "\u1780\u17b6\u179f\u17ca\u17b8" },
            { "khq", "\u1782\u17bb\u1799\u179a\u17c9\u17b6\u1788\u17b8\u1793\u17b8" },
            { "kkj", "\u1780\u17b6\u1780\u17bc" },
            { "kln", "\u1780\u17b6\u179b\u17c2\u1793\u1787\u17b8\u1793" },
            { "kmb", "\u1782\u17b8\u1798\u1794\u17ca\u17bb\u1793\u178c\u17bc" },
            { "koi", "\u1782\u17bc\u1798\u17b8\u1797\u17b9\u1798\u1799\u17c9\u17b6\u1782" },
            { "kok", "\u1782\u17bb\u1793\u1780\u17b6\u1793\u17b8" },
            { "kpe", "\u1782\u17d2\u179b\u17b8\u1794" },
            { "krc", "\u1780\u17b6\u179a\u17c9\u17b6\u1786\u17b6\u1799\u1794\u17b6\u179b\u17cb\u1780\u17b6" },
            { "krl", "\u1780\u17b6\u179a\u17b8\u179b\u17b6" },
            { "kru", "\u1782\u17bc\u179a\u17bc\u1780" },
            { "ksb", "\u179f\u17b6\u1798\u1794\u17b6\u17a1\u17b6" },
            { "ksf", "\u1794\u17b6\u17a0\u17d2\u179c\u17c0" },
            { "ksh", "\u1780\u17bc\u17a1\u17bc\u1789" },
            { "kum", "\u1782\u17bc\u1798\u17b8\u1782" },
            { "kwk", "\u1780\u17d2\u179c\u17b6\u1780\u17cb\u179c\u17c9\u17b6\u17a1\u17b6" },
            { "kxv", "\u1782\u17bc\u179c\u17b8" },
            { "lad", "\u17a1\u17b6\u178c\u17b8\u178e\u17bc" },
            { "lag", "\u17a1\u17b6\u1793\u17a0\u17d2\u1782\u17b8" },
            { "lez", "\u17a1\u17c1\u179f\u17a0\u17d2\u1782\u17b8" },
            { "lij", "\u179b\u17b8\u1782\u17bc\u179a\u17b8" },
            { "lil", "\u179b\u17b8\u179b\u179b\u17bc\u17a2\u17c1\u178f" },
            { "lkt", "\u17a1\u17b6\u1780\u17bc\u178f\u17b6" },
            { "lmo", "\u17a1\u17c6\u1794\u17b6\u178f" },
            { "lou", "\u1780\u17d2\u179a\u17c1\u17a2\u17bc\u179b \u179b\u17bc\u17a2\u17ca\u17b8\u179f\u17ca\u17b8\u17a2\u17b6\u178e\u17b6" },
            { "loz", "\u17a1\u17bc\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "lrc", "\u179b\u17bc\u179a\u17b8\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "lsm", "\u179f\u17b6\u1798\u17c0" },
            { "lua", "\u179b\u17bc\u1794\u17b6\u179b\u17bc\u17a1\u17b6" },
            { "lun", "\u179b\u17bb\u1793\u178a\u17b6" },
            { "luo", "\u179b\u17bc\u17a2\u17bc" },
            { "lus", "\u1798\u17b8\u17a0\u17d2\u179f\u17bc" },
            { "luy", "\u179b\u17bc\u1799\u17c9\u17b6" },
            { "mad", "\u1798\u17c9\u17b6\u178c\u17bc\u179a\u17b8\u179f" },
            { "mag", "\u1798\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u17a0\u17ca\u17b8" },
            { "mai", "\u1798\u17c9\u17c3\u1792\u17b8\u179b\u17b8" },
            { "mak", "\u1798\u17c9\u17b6\u1780\u17b6\u179f\u17b6" },
            { "mas", "\u1798\u17c9\u17b6\u179f\u17c3" },
            { "mdf", "\u1798\u17bb\u1781\u179f\u17b6" },
            { "men", "\u1798\u17c1\u1793\u178c\u17b8" },
            { "mer", "\u1798\u17c1\u179a\u17bc" },
            { "mfe", "\u1798\u17c9\u17bc\u179a\u17b8\u179f\u17ca\u17b8\u1793" },
            { "mgh", "\u1798\u17c9\u17b6\u1780\u1782\u17bc\u179c\u17c9\u17b6\u1798\u17b8\u178f\u17bc" },
            { "mgo", "\u1798\u17c1\u178f\u17b6" },
            { "mic", "\u1798\u17b7\u1780\u1798\u17c1\u1780" },
            { "min", "\u1798\u17b8\u178e\u17b6\u1784\u1780\u17b6\u1794\u17ca\u17bc" },
            { "mni", "\u1798\u17c9\u17b6\u1793\u17b8\u1796\u17bc\u179a\u17b8" },
            { "moe", "\u17a2\u17ca\u17b8\u1793\u1793\u17bc\u17a2\u17c3\u1798\u17bb\u1793" },
            { "moh", "\u1798\u17ca\u17bc\u17a0\u17b6\u1782" },
            { "mos", "\u1798\u17bc\u179f\u17ca\u17b8" },
            { "mua", "\u1798\u17bb\u1793\u178a\u17b6\u1784" },
            { "mul", "\u1796\u17a0\u17bb\u1797\u17b6\u179f\u17b6" },
            { "mus", "\u1782\u17d2\u179a\u17b8\u1780" },
            { "mwl", "\u1798\u17b8\u179a\u17c9\u17b6\u1793\u178a\u17c1\u179f" },
            { "myv", "\u17a2\u17ba\u17a0\u17d2\u179f\u17ca\u17b8\u1799\u17c9\u17b6" },
            { "mzn", "\u1798\u17c9\u17b6\u17a0\u17d2\u179f\u17b6\u1793\u178a\u17ba\u179a\u17c1\u1793\u17b8" },
            { "nap", "\u1793\u17b6\u1794\u17c9\u17bc\u179b\u17b8\u178f\u17b6\u1793" },
            { "naq", "\u178e\u17b6\u1798\u17c9\u17b6" },
            { "nds", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb\u1780\u17d2\u179a\u17c4\u1798" },
            { "new", "\u1793\u17c1\u179c\u17c9\u17b6\u179c\u17b8" },
            { "nia", "\u1793\u17b8\u17a2\u17b6\u179f" },
            { "niu", "\u1793\u17bc\u17a2\u17c0\u1793" },
            { "nmg", "\u1780\u17d2\u179c\u17b6\u179f\u17d2\u1799\u17bc" },
            { "nnh", "\u1784\u17c0\u1798\u1794\u17ca\u17bc\u1793" },
            { "nog", "\u178e\u17bc\u17a0\u17d2\u1782\u17c3" },
            { "nqo", "\u1793\u1782\u17c4" },
            { "nso", "\u179f\u17bc\u1790\u17bc\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "nus", "\u1793\u17bc\u17a2\u17d0\u179a" },
            { "nyn", "\u178e\u17b6\u1793\u1780\u17bc\u179b\u17c1" },
            { "ojb", "\u17a2\u17bc\u1787\u17b8\u1794\u179c\u17c9\u17b6\u200b\u1794\u17c9\u17c2\u1780\u1796\u17b6\u1799\u17d0\u1796\u17d2\u1799" },
            { "ojc", "\u17a2\u17bc\u1787\u17b8\u1796\u179c\u17c9\u17b6\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "ojs", "\u17a2\u17bc\u1787\u17b8\u1782\u17d2\u179a\u17b8" },
            { "ojw", "\u17a2\u17bc\u1787\u17b8\u1794\u179c\u17c9\u17b6\u200b\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "oka", "\u17a2\u17bc\u1780\u17b6\u178e\u17b6\u17a0\u17d2\u1780\u17b6\u1793" },
            { "pag", "\u1797\u17c1\u1793\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8\u178e\u17b6\u1793" },
            { "pam", "\u1795\u17b6\u1798\u1797\u17c1\u1793\u17a0\u17d2\u1782\u17b6" },
            { "pap", "\u1794\u17c9\u17b6\u1794\u17c9\u17c3\u1798\u17c1\u1793\u178f\u17bc" },
            { "pau", "\u1794\u17c9\u17b6\u179b\u17bc\u17a2\u17b6\u1793" },
            { "pcm", "\u1797\u17b6\u179f\u17b6\u1791\u17c6\u1793\u17b6\u1780\u17cb\u1791\u17c6\u1793\u1784\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "pis", "\u1796\u17b8\u1787\u17b8\u1793" },
            { "pqm", "\u1798\u17c9\u17b6\u179b\u17b8\u179f\u17ca\u17b8\u178f \u1794\u17c9\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u1781\u17d2\u179c\u17bc\u178c\u17b8" },
            { "prg", "\u1796\u17d2\u179a\u17bc\u179f\u17ca\u17b6\u1793" },
            { "quc", "\u1782\u17b8\u1785\u1788\u17b8" },
            { "raj", "\u179a\u17c9\u17b6\u1785\u17b6\u179f\u17cb\u1790\u17b6\u1793\u17b8" },
            { "rap", "\u179a\u17c9\u17b6\u1794\u17c9\u17b6\u1793\u17bc" },
            { "rar", "\u179a\u17c9\u17b6\u179a\u17c9\u17bc\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6\u1793" },
            { "rhg", "\u179a\u17c9\u17bc\u17a0\u17ca\u17b8\u1784\u1799\u17c9\u17b6" },
            { "rof", "\u179a\u17bb\u1798\u1794\u17bc" },
            { "rup", "\u17a2\u17b6\u179a\u17c9\u17bc\u1798\u17c9\u17b6\u1793\u17b8" },
            { "rwk", "\u179a\u17c9\u17d2\u179c\u17b6" },
            { "sad", "\u179f\u17b6\u1793\u178a\u17b6\u179c\u17b8" },
            { "sah", "\u1799\u17c9\u17b6\u1783\u17bb\u178f" },
            { "saq", "\u179f\u17b6\u1798\u1794\u17bc\u179a\u17bc" },
            { "sat", "\u179f\u17b6\u1793\u17cb\u178f\u17b6\u179b\u17b8" },
            { "sba", "\u1784\u17b6\u17c6\u1794\u17c1\u1799" },
            { "sbp", "\u179f\u17b6\u1793\u17a0\u17d2\u1782\u17bc" },
            { "scn", "\u179f\u17ca\u17b8\u179f\u17ca\u17b8\u179b\u17b6\u1793" },
            { "sco", "\u179f\u17d2\u1780\u17bb\u178f" },
            { "sdh", "\u1783\u17be\u178a\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "seh", "\u179f\u17ca\u17b8\u178e\u17b6" },
            { "ses", "\u1782\u17bb\u1799\u179a\u17c9\u17b6\u1794\u17bc\u179a\u17c9\u17bb\u179f\u17ca\u17b8\u1793\u17b8" },
            { "shi", "\u178f\u17b6\u1788\u17b8\u179b\u17a0\u17ca\u17b8\u178f" },
            { "shn", "\u179f\u17b6\u1793" },
            { "slh", "\u17a1\u17b6\u179f\u17ca\u17bc\u178f\u179f\u17ca\u17b8\u178f\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "sma", "\u179f\u17b6\u1798\u17b8\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "smj", "\u179b\u17bc\u179b\u17b8\u179f\u17b6\u1798\u17b8" },
            { "smn", "\u17a2\u17ca\u17b8\u178e\u17b6\u179a\u17b8\u179f\u17b6\u1798\u17b8" },
            { "sms", "\u179f\u17d2\u1780\u17bb\u179b\u179f\u17b6\u1798\u17b8" },
            { "snk", "\u179f\u17bc\u1793\u17b8\u1793\u1782\u17c1" },
            { "srn", "\u179f\u17d2\u179a\u17b6\u178e\u17b6\u1793\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17c4" },
            { "ssy", "\u179f\u17b6\u17a0\u17bc" },
            { "str", "\u179f\u17b6\u179b\u17b8\u179f\u179f\u17d2\u178f\u17d2\u179a\u17c1\u178f\u179f\u17cd" },
            { "suk", "\u179f\u17ca\u17bc\u1782\u17bc\u1798\u17c9\u17b6" },
            { "swb", "\u1780\u17bc\u1798\u17c9\u17bc\u179a\u17b8" },
            { "syr", metaValue_SY },
            { "szl", "\u179f\u17ca\u17b8\u17a1\u17c1\u179f\u17ca\u17b8" },
            { "tce", "\u1790\u17bb\u1785\u1786\u17bb\u1793\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "tem", "\u1792\u17b8\u1798\u1793\u17b8" },
            { "teo", "\u178f\u17c1\u179f\u17bc" },
            { "tet", "\u1791\u17b8\u1791\u17bb\u17c6" },
            { "tgx", "\u178f\u17b6\u17a0\u17d2\u1782\u17b8\u179f" },
            { "tht", "\u178f\u17b6\u179b\u17cb\u178f\u17b6\u1793" },
            { "tig", "\u1792\u17b8\u17a0\u17d2\u1782\u17d2\u179a\u17b6" },
            { "tlh", "\u1783\u17d2\u179b\u17b8\u1793\u17a0\u17d2\u1782\u17bb\u1793" },
            { "tli", "\u1790\u17d2\u179b\u17b8\u1784\u17a0\u17d2\u1782\u17b8\u178f" },
            { "tok", "\u178f\u17bc\u1782\u17b8\u1794\u17c9\u17bc\u178e\u17b6" },
            { "tpi", "\u1790\u17bb\u1780\u1796\u17b8\u179f\u17ca\u17b8\u1793" },
            { "trv", "\u178f\u17b6\u179a\u17c9\u17bc\u1780\u17bc" },
            { "ttm", "\u1790\u17bb\u1785\u1786\u17bb\u1793\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "tum", "\u1791\u17bb\u1798\u1794\u17ca\u17bc\u1780\u17b6" },
            { "tvl", metaValue_TV },
            { "twq", "\u178f\u17b6\u179f\u17b6\u179c\u17c9\u17b6\u1780\u17cb" },
            { "tyv", "\u1791\u17bc\u179c\u17b8\u1793\u17c0" },
            { "tzm", "\u178f\u17b6\u1798\u17c9\u17b6\u179f\u17b6\u1799\u17a2\u17b6\u178f\u17d2\u179b\u17b6\u179f\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "udm", "\u17a2\u17b6\u178f\u17cb\u1798\u17bc\u178a" },
            { "umb", "\u17a2\u17b6\u1798\u17cb\u1794\u17ca\u17bb\u1793\u178c\u17bc" },
            { "und", "\u1797\u17b6\u179f\u17b6\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "vai", "\u179c\u17c3" },
            { "vec", "\u179c\u17c1\u178e\u17c1\u178f\u17bc" },
            { "vmw", "\u1798\u17c9\u17b6\u1783\u17bc\u179c\u17c9\u17b6" },
            { "vun", "\u179c\u17bb\u1793\u1785\u17bc" },
            { "wae", "\u179c\u17c1\u179b\u179f\u17ba" },
            { "wal", "\u179c\u17c9\u17bc\u17a1\u17b6\u1799\u178f\u17b6" },
            { "war", "\u179c\u17c9\u17b6\u179a\u17c1\u1799" },
            { "wbp", "\u179c\u17c9\u17b6\u179a\u17b8\u1794\u17c9\u17b6\u179a\u17b8" },
            { "wuu", "\u17a2\u17ca\u17bc\u1785\u17b7\u1793" },
            { "xal", "\u1780\u17b6\u179b\u1798\u17b8\u1782" },
            { "xnr", "\u1781\u17c2\u1784\u1782\u17d2\u179a\u17b8" },
            { "xog", "\u179f\u17bc\u17a0\u17d2\u1782\u17b6" },
            { "yav", "\u1799\u17c9\u17b6\u1784\u1794\u17c1\u1793" },
            { "ybb", "\u1799\u17c1\u1798\u1794\u17b6" },
            { "yrl", "\u1789\u17b8\u1793\u17a0\u17d2\u1780\u17b6\u1791\u17bc" },
            { "yue", "\u1780\u1793\u17d2\u178f\u17b6\u17c6\u1784" },
            { "zgh", "\u178f\u17b6\u1798\u17c9\u17b6\u17a0\u17d2\u179f\u17c3\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6" },
            { "zun", "\u17a0\u17d2\u179f\u17bc\u1793\u17b8" },
            { "zxx", "\u1782\u17d2\u1798\u17b6\u1793\u200b\u1791\u17b7\u1793\u17d2\u1793\u1793\u17d0\u1799\u200b\u1797\u17b6\u179f\u17b6" },
            { "zza", "\u17a0\u17d2\u179f\u17b6\u17a0\u17d2\u179f\u17b6" },
            { "Adlm", "\u17a2\u17b6\u178f\u17a1\u17b6\u1798" },
            { "Aghb", "\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8\u1780\u17c5\u1780\u17b6\u179f\u17ca\u17b8" },
            { "Ahom", "\u17a2\u17b6\u17a0\u17bc\u1798" },
            { "Arab", metaValue_ar },
            { "Aran", "\u17a2\u17b6\u179a\u17c9\u17b6\u1793" },
            { "Armi", "\u17a2\u17b6\u179a\u17c9\u17b6\u1798\u17c9\u17b6\u17a2\u17ca\u17b8\u1798\u1797\u17be\u179a\u17c0\u179b" },
            { "Armn", metaValue_AM },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "\u1794\u17b6\u1798\u17bb\u1793" },
            { "Bass", "\u1794\u17b6\u179f\u17b6\u179c\u17c9\u17c7" },
            { "Batk", "\u1794\u17b6\u178f\u17b6\u1780" },
            { "Beng", metaValue_BD },
            { "Bhks", "\u1794\u17c9\u17c3\u179f\u17ca\u17bc\u1782\u17b8" },
            { "Bopo", "\u1794\u17bc\u1795\u17bc\u1798\u17c9\u17bc\u17a0\u17d2\u179c\u17bc" },
            { "Brah", "\u1794\u17d2\u179a\u17b6\u1798\u17b7" },
            { "Brai", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u179f\u1798\u17d2\u179a\u17b6\u1794\u17cb\u1798\u1793\u17bb\u179f\u17d2\u179f\u200b\u1796\u17b7\u1780\u17b6\u179a\u200b\u1797\u17d2\u1793\u17c2\u1780" },
            { "Bugi", "\u1794\u17ca\u17bc\u1782\u17b8\u1793\u17c1" },
            { "Buhd", "\u1794\u17ca\u17bc\u17a0\u17ca\u17b8\u178a" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u1796\u17d2\u1799\u17b6\u1784\u17d2\u1782\u17a2\u17b6\u1794\u17bc\u179a\u17b8\u1787\u17b8\u1793\u200b\u1780\u17b6\u178e\u17b6\u178a\u17b6\u179a\u17bd\u1798" },
            { "Cari", "\u1781\u17b6\u179a\u17b8" },
            { "Cham", "\u1785\u17b6\u1798" },
            { "Cher", "\u1786\u17c1\u179a\u17c9\u17bc\u1782\u17b8" },
            { "Chrs", "\u1781\u17bc\u179a\u17c9\u17b6\u179f\u17d2\u1798\u17b8" },
            { "Copt", "\u1781\u17bc\u1794\u17d2\u1791" },
            { "Cpmn", "\u179f\u17ca\u17b8\u1794\u17d2\u179a\u17bc\u1798\u17b8\u178e\u17bc" },
            { "Cprt", metaValue_CY },
            { "Cyrl", "\u179f\u17ca\u17b8\u179a\u17b8\u179b\u17b8\u1780" },
            { "Deva", "\u178a\u17b6\u179c\u17c9\u17b6\u1793\u17cb\u178e\u17b6\u1780\u17b6\u179a\u17b7" },
            { "Ethi", metaValue_ET },
            { "Geor", metaValue_GE },
            { "Gong", "\u1782\u17bb\u1793\u1785\u17b6\u17a1\u17b6\u1780\u17bb\u1793\u178c\u17b7" },
            { "Grek", "\u1780\u17d2\u179a\u17b7\u1785" },
            { "Gujr", "\u1782\u17bc\u1785\u17b6\u179a\u17c9\u17b6\u1791\u17b8" },
            { "Guru", "\u1780\u17bb\u1798\u17bb\u1799\u1783\u17b8" },
            { "Hanb", "\u17a0\u17b6\u1793\u1794\u17cd" },
            { "Hang", "\u17a0\u17b6\u17c6\u1784\u1780\u17bb\u179b" },
            { "Hani", "\u17a0\u17b6\u1793" },
            { "Hans", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u1785\u17b7\u1793\u200b\u1780\u17b6\u178f\u17cb" },
            { "Hant", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u1785\u17b7\u1793\u200b\u1796\u17c1\u1789" },
            { "Hebr", metaValue_IL },
            { "Hira", "\u17a0\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17b6\u178e\u17b6" },
            { "Hmnp", "\u1793\u17b8\u1799\u17c9\u17b6\u1780\u17c1\u1784\u1796\u17bd\u1787\u17ba\u1798\u17c9\u17bb\u1784" },
            { "Hrkt", "\u179f\u1789\u17d2\u1789\u17b6\u179f\u17c6\u17a1\u17c1\u1784\u1797\u17b6\u179f\u17b6\u1787\u1794\u17c9\u17bb\u1793" },
            { "Jamo", "\u1785\u17b6\u1798\u17c9\u17bc" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_JP },
            { "Kali", "\u1780\u17b6\u1799\u17c9\u17b6\u179b\u17b8" },
            { "Kana", "\u1780\u17b6\u178f\u17b6\u1780\u17b6\u178e\u17b6" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "\u17a1\u17b6\u178e\u17b6" },
            { "Laoo", metaValue_LA },
            { "Latn", "\u17a1\u17b6\u178f\u17b6\u17c6\u1784" },
            { "Lepc", "\u17a1\u17c1\u1794\u1785\u17b6" },
            { "Limb", "\u179b\u17b8\u1794\u1794\u17ca\u17bc" },
            { "Lisu", "\u17a0\u17d2\u179c\u17d2\u179a\u17b6\u179f\u17ba" },
            { "Mand", "\u1798\u17c9\u17b6\u1793\u178a\u17b6" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_MN },
            { "Mtei", "\u1798\u17c9\u17b8\u178f\u17b8\u1798\u17c9\u17b6\u1799\u17c9\u17c2\u1780" },
            { "Mymr", metaValue_my },
            { "Newa", "\u178e\u17c1\u179c\u17c9\u17b6" },
            { "Nkoo", "\u1793\u1780\u17bc" },
            { "Olck", "\u17a2\u17bc\u179b\u1788\u17b7\u1782\u17b7" },
            { "Orya", metaValue_or },
            { "Osge", "\u17a2\u17bc\u179f\u17d2\u1782" },
            { "Plrd", "\u1795\u17bc\u17a1\u17b6\u178a" },
            { "Rohg", "\u17a0\u17b6\u1793\u17b8\u17a0\u17d2\u179c\u17ca\u17b8" },
            { "Saur", "\u179f\u17c5\u179a\u17c9\u17b6\u179f\u178f\u17d2\u179a\u17b6" },
            { "Sinh", "\u179f\u17ca\u17b8\u1793\u17a0\u17b6\u17a1\u17b6" },
            { "Sund", metaValue_SD },
            { "Sylo", "\u179f\u17ca\u17b8\u17a1\u17bc" },
            { "Syrc", "\u179f\u17ca\u17b8\u179a\u17b8\u17a2\u17c2\u1780" },
            { "Tale", "\u178f\u17c3\u17a1\u17c1" },
            { "Talu", "\u178f\u17c3\u17a1\u17ba\u1790\u17d2\u1798\u17b8" },
            { "Taml", metaValue_ta },
            { "Tavt", "\u178f\u17c3\u179c\u17c0\u178f" },
            { "Telu", metaValue_te },
            { "Tfng", "\u1791\u17b8\u17a0\u17d2\u179c\u17ca\u17b8\u178e\u17b6\u17a0\u17d2\u179c" },
            { "Thaa", "\u1790\u17b6\u178e\u17b6" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Vaii", "\u179c\u17c9\u17c3" },
            { "Wcho", "\u179c\u17c9\u17b6\u1793\u17cb\u1786\u17bc" },
            { "Yiii", "\u1799\u17b8" },
            { "Zinh", "\u179f\u17d2\u1793\u1784\u1780\u17c1\u179a\u17d2\u178f\u17b7\u17cd" },
            { "Zmth", "\u1793\u17b7\u1798\u17b7\u178f\u17d2\u178f\u179f\u1789\u17d2\u1789\u17b6\u1782\u178e\u17b7\u178f\u179c\u17b7\u1791\u17d2\u1799\u17b6" },
            { "Zsye", "\u179f\u1789\u17d2\u1789\u17b6\u17a2\u17b6\u179a\u1798\u17d2\u1798\u178e\u17cd" },
            { "Zsym", "\u1793\u17b7\u1798\u17b7\u178f\u17d2\u178f\u179f\u1789\u17d2\u1789\u17b6" },
            { "Zxxx", "\u1782\u17d2\u1798\u17b6\u1793\u1780\u17b6\u179a\u179f\u179a\u179f\u17c1\u179a" },
            { "Zyyy", "\u1791\u17bc\u1791\u17c5" },
            { "Zzzz", "\u17a2\u1780\u17d2\u179f\u179a\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "es_ES", "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789 (\u17a2\u17ca\u17ba\u179a\u17c9\u17bb\u1794)" },
            { "fa_AF", "\u178a\u17b6\u179a\u17b8" },
            { "nl_BE", "\u1795\u17d2\u179b\u17b6\u1798\u17b8\u179f" },
            { "pt_BR", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb (\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b)" },
            { "pt_PT", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u179b\u17cb (\u17a2\u17ba\u179a\u17c9\u17bb\u1794)" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179f\u17d2\u179c\u17b6\u17a0\u17ca\u17b8\u179b\u17b8" },
            { "ar_001", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6\u179a\u1791\u17c6\u1793\u17be\u1794" },
            { "key.ca", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793" },
            { "key.cf", "\u1791\u1798\u17d2\u179a\u1784\u17cb\u179a\u17bc\u1794\u17b7\u1799\u1794\u178e\u17d2\u178e" },
            { "key.co", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794" },
            { "key.cu", "\u179a\u17bc\u1794\u17b7\u1799\u1794\u178e\u17d2\u178e" },
            { "key.hc", "\u179c\u178a\u17d2\u178f\u1798\u17c9\u17c4\u1784 (12 vs 24)" },
            { "key.lb", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb" },
            { "key.ms", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784" },
            { "key.nu", "\u179b\u17c1\u1781" },
            { "nds_NL", "\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1799\u17bb\u1784\u1780\u17d2\u179a\u17c4\u1798" },
            { "zh_Hans", "\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "zh_Hant", "\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "type.ca.roc", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1798\u17b8\u1784\u1782\u17d0\u179a" },
            { "type.hc.h11", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 12 \u1798\u17c9\u17c4\u1784 (0\u201311)" },
            { "type.hc.h12", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 12 \u1798\u17c9\u17c4\u1784 (1\u201312)" },
            { "type.hc.h23", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 24 \u1798\u17c9\u17c4\u1784 (0\u201323)" },
            { "type.hc.h24", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 24 \u1798\u17c9\u17c4\u1784 (1\u201324)" },
            { "type.nu.arab", "\u179b\u17c1\u1781\u200b\u17a5\u178e\u17d2\u178c\u17b6-\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb" },
            { "type.nu.armn", "\u179b\u17c1\u1781\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "type.nu.beng", "\u179b\u17c1\u1781\u200b\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f" },
            { "type.nu.cakm", "\u179b\u17c1\u1781\u1785\u17b6\u1780\u17cb\u1798\u17c9\u17b6" },
            { "type.nu.deva", "\u179b\u17c1\u1781\u200b\u178c\u17b8\u179c\u17c9\u17b6\u178e\u17b6\u1780\u17b6\u179a\u17b8" },
            { "type.nu.ethi", "\u179b\u17c1\u1781\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "type.nu.geor", "\u179b\u17c1\u1781\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17b8" },
            { "type.nu.grek", "\u179b\u17c1\u1781\u200b\u1780\u17d2\u179a\u17b7\u1780" },
            { "type.nu.gujr", "\u179b\u17c1\u1781\u200b\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8" },
            { "type.nu.guru", "\u179b\u17c1\u1781\u200b\u1780\u17bb\u1798\u17bb\u1783\u17b8" },
            { "type.nu.hans", "\u179b\u17c1\u1781\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "type.nu.hant", "\u179b\u17c1\u1781\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "type.nu.hebr", "\u179b\u17c1\u1781\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "type.nu.java", "\u179b\u17c1\u1781\u1787\u17d2\u179c\u17b6" },
            { "type.nu.jpan", "\u179b\u17c1\u1781\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "type.nu.khmr", "\u179b\u17c1\u1781\u200b\u1781\u17d2\u1798\u17c2\u179a" },
            { "type.nu.knda", "\u179b\u17c1\u1781\u1781\u17b6\u178e\u17b6\u178a\u17b6" },
            { "type.nu.laoo", "\u179b\u17c1\u1781\u200b\u17a1\u17b6\u179c" },
            { "type.nu.latn", "\u179b\u17c1\u1781\u200b\u1794\u1785\u17d2\u1785\u17b9\u1798\u200b\u1794\u17d2\u179a\u1791\u17c1\u179f" },
            { "type.nu.mlym", "\u179b\u17c1\u1781\u200b\u1798\u179b\u1799\u17b6\u179b\u17d0\u1798" },
            { "type.nu.mtei", "\u179b\u17c1\u1781\u1798\u17b8\u178f\u17b8\u1798\u17c9\u17b6\u1799\u17c9\u17c2\u1780" },
            { "type.nu.mymr", "\u179b\u17c1\u1781\u200b\u1797\u17bc\u1798\u17b6" },
            { "type.nu.olck", "\u179b\u17c1\u1781\u17a2\u17bc\u179b\u1788\u17b7\u1782\u17b7" },
            { "type.nu.orya", "\u179b\u17c1\u1781\u17a2\u17bc\u178c\u17c0" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "type.nu.telu", "\u179b\u17c1\u1781\u200b\u178f\u17c1\u179b\u17bb\u1782\u17bb" },
            { "type.nu.thai", "\u179b\u17c1\u1781\u200b\u1790\u17c3" },
            { "type.nu.tibt", "\u179b\u17c1\u1781\u1791\u17b8\u1794\u17c1" },
            { "type.nu.vaii", "\u179b\u17c1\u1781\u179c\u17c9\u17c3" },
            { "type.ca.dangi", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1780\u17bc\u179a\u17c9\u17c1" },
            { "type.co.ducet", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794\u200b\u1799\u17bc\u1793\u17b8\u1780\u17bc\u178a\u200b\u179b\u17c6\u1793\u17b6\u17c6\u178a\u17be\u1798" },
            { "type.lb.loose", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u1781\u17d2\u179b\u17b8" },
            { "type.nu.roman", "\u179b\u17c1\u1781\u200b\u179a\u17c9\u17bc\u1798\u17b6\u17c6\u1784" },
            { "type.ca.coptic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1780\u1794\u1791\u17b7\u1785" },
            { "type.ca.hebrew", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "type.co.search", "\u179f\u17d2\u179c\u17c2\u1784\u179a\u1780\u200b\u1791\u17bc\u1791\u17c5" },
            { "type.lb.normal", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u1792\u1798\u17d2\u1798\u178f\u17b6" },
            { "type.lb.strict", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u178f\u17b9\u1784\u179a\u17b9\u1784" },
            { "type.ms.metric", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u1798\u17c9\u17b6\u1791\u17d2\u179a\u17b7\u1780" },
            { "type.ca.chinese", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u1785\u17b7\u1793" },
            { "type.ca.islamic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u17b6\u1798" },
            { "type.ca.iso8601", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793 ISO-8601" },
            { "type.ca.persian", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1796\u17c2\u1780\u17d2\u179f" },
            { "type.cf.account", "\u1791\u1798\u17d2\u179a\u1784\u17cb\u179a\u17bc\u1794\u17b7\u1799\u1794\u178e\u17d2\u178e\u1782\u178e\u1793\u17b8" },
            { "type.nu.arabext", "\u179b\u17c1\u1781\u200b\u17a5\u178e\u17d2\u178c\u17b6-\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u200b\u1796\u1784\u17d2\u179a\u17b8\u1780" },
            { "type.nu.armnlow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "type.nu.greklow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u1780\u17d2\u179a\u17b7\u1780" },
            { "type.nu.hanidec", "\u179b\u17c1\u1781\u200b\u1791\u179f\u1797\u17b6\u1782\u200b\u1785\u17b7\u1793" },
            { "type.nu.hansfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "type.nu.hantfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "type.nu.jpanfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "type.ca.buddhist", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1796\u17bb\u1791\u17d2\u1792\u179f\u17b6\u179f\u1793\u17b6" },
            { "type.ca.ethiopic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "type.ca.japanese", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "type.cf.standard", "\u1791\u1798\u17d2\u179a\u1784\u17cb\u179a\u17bc\u1794\u17b7\u1799\u1794\u178e\u17d2\u178e\u1794\u1791\u178a\u17d2\u178b\u17b6\u1793" },
            { "type.co.standard", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794\u200b\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6\u179a" },
            { "type.ms.uksystem", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u1785\u1780\u17d2\u179a\u1796\u17d0\u1791\u17d2\u1792" },
            { "type.ms.ussystem", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "type.nu.fullwide", "\u179b\u17c1\u1781\u200b\u1791\u1791\u17b9\u1784\u200b\u1796\u17c1\u1789" },
            { "type.nu.romanlow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u179a\u17c9\u17bc\u1798\u17b6\u17c6\u1784" },
            { "type.ca.gregorian", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "ListKeyTypePattern", "{0}\u17d6 {1}" },
            { "type.ca.islamic-civil", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a2\u17ca\u17b7\u179f\u17d2\u179b\u17b6\u1798 (\u178f\u17b6\u179a\u17b6\u1784, \u179f\u1798\u17d0\u1799\u179f\u17ca\u17b8\u179c\u17b7\u179b)" },
            { "type.ca.islamic-umalqura", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a2\u17ca\u17b7\u179f\u17d2\u179b\u17b6\u1798 (\u17a2\u17ca\u17bb\u17c6\u17a2\u17b6\u179b\u17cb\u1782\u17bc\u179a\u17c9\u17b6)" },
            { "type.ca.ethiopic-amete-alem", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8\u17a2\u17b6\u1798\u17c9\u17c1\u178f\u17c1\u200b\u17a2\u17b6\u179b\u17c2\u1798" },
        };
        return data;
    }
}
