/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_xnr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "\u0924\u0941\u0930\u094d\u0915\u0940";
        final String metaValue_ar = "\u0905\u0930\u092c\u0940";
        final String metaValue_hy = "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908";
        final String metaValue_bn = "\u092c\u0902\u0917\u093e\u0932\u0940";
        final String metaValue_bug = "\u092c\u0917\u093f\u0928\u0940\u0938";
        final String metaValue_ccp = "\u091a\u0915\u092e\u093e";
        final String metaValue_chr = "\u091a\u0947\u0930\u094b\u0915\u0940";
        final String metaValue_el = "\u092f\u0942\u0928\u093e\u0928\u0940";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_he = "\u0939\u093f\u092c\u094d\u0930\u0942";
        final String metaValue_ja = "\u091c\u093e\u092a\u093e\u0928\u0940";
        final String metaValue_km = "\u0916\u092e\u0947\u0930";
        final String metaValue_kn = "\u0915\u0928\u094d\u0928\u0921\u093c";
        final String metaValue_ko = "\u0915\u094b\u0930\u093f\u092f\u093e\u0908";
        final String metaValue_lo = "\u0932\u093e\u0913";
        final String metaValue_la = "\u0932\u0948\u091f\u093f\u0928";
        final String metaValue_ml = "\u092e\u0932\u092f\u093e\u0932\u092e";
        final String metaValue_mn = "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e\u0908";
        final String metaValue_or = "\u0909\u0921\u093c\u093f\u092f\u093e";
        final String metaValue_si = "\u0938\u093f\u0902\u0939\u0932\u0940";
        final String metaValue_ta = "\u0924\u092e\u093f\u0932";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0942";
        final String metaValue_th = "\u0925\u093e\u0908";
        final String metaValue_bo = "\u0924\u093f\u092c\u094d\u092c\u0924\u0940";
        final String metaValue_vai = "\u0935\u093e\u0908";
        final Object[][] data = new Object[][] {
            { "001", "\u0926\u0941\u0928\u093f\u092f\u093e" },
            { "002", "\u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "003", "\u0909\u0924\u094d\u0924\u0930 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "005", "\u0926\u0916\u0923 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "009", "\u0913\u0936\u093f\u0906\u0928\u093f\u092f\u093e" },
            { "011", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "013", "\u092c\u093f\u091a\u0932\u093e \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "014", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "015", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "017", "\u092c\u093f\u091a\u0932\u093e \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "018", "\u0926\u0916\u0923\u0947 \u092c\u0916\u0947\u0902 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "019", "\u0905\u092e\u0930\u093f\u0915\u093e \u0926\u093e" },
            { "021", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "029", "\u0915\u0948\u0930\u093f\u092c\u093f\u092f\u0928" },
            { "030", "\u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "034", "\u0926\u0916\u0923\u0947 \u092c\u0916\u0947\u0902 \u090f\u0936\u093f\u092f\u093e" },
            { "035", "\u0926\u0916\u0923-\u092a\u0942\u0930\u094d\u0935 \u090f\u0936\u093f\u092f\u093e" },
            { "039", "\u0926\u0916\u0923\u0947 \u092c\u0916\u0947\u0902 \u092f\u0942\u0930\u094b\u092a" },
            { "053", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "054", "\u092e\u0947\u0932\u093e\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "057", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u0932\u093e\u0915\u093e" },
            { "061", "\u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "142", "\u090f\u0936\u093f\u092f\u093e" },
            { "143", "\u092c\u093f\u091a\u0932\u093e \u090f\u0936\u093f\u092f\u093e" },
            { "145", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "150", "\u092f\u0942\u0930\u094b\u092a" },
            { "151", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "154", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "155", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "202", "\u0909\u092a-\u0938\u0939\u093e\u0930\u093e \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "419", "\u0932\u0948\u091f\u093f\u0928 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "AC", "\u0905\u0938\u0947\u0902\u0936\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "AD", "\u090f\u0902\u0921\u094b\u0930\u093e" },
            { "AE", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0905\u092e\u0940\u0930\u093e\u0924" },
            { "AF", "\u0905\u092b\u093c\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0902\u091f\u093f\u0917\u0941\u0906 \u0915\u0928\u0947 \u092c\u0930\u092c\u0941\u0921\u093e" },
            { "AI", "\u090f\u0902\u0917\u094d\u0935\u093f\u0932\u093e" },
            { "AL", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "AO", "\u0905\u0902\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e" },
            { "AS", "\u0905\u092e\u0930\u093f\u0915\u0940 \u0938\u092e\u094b\u0906" },
            { "AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0905\u0930\u0942\u092c\u093e" },
            { "AX", "\u090f\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "AZ", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928" },
            { "BA", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0915\u0928\u0947 \u0939\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e" },
            { "BB", "\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938" },
            { "BD", "\u092c\u093e\u0902\u0917\u094d\u0932\u093e\u0926\u0947\u0936" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093c\u093e\u0938\u094b" },
            { "BG", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u0939\u0930\u0940\u0928" },
            { "BI", "\u092c\u0941\u0930\u0941\u0902\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u093f\u0928" },
            { "BL", "\u0938\u0947\u0902\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u0930\u092e\u0942\u0921\u093e" },
            { "BN", "\u092c\u094d\u0930\u0942\u0928\u0947\u0908" },
            { "BO", "\u092c\u094b\u0932\u0940\u0935\u093f\u092f\u093e" },
            { "BQ", "\u0915\u0948\u0930\u093f\u092c\u093f\u092f\u0928 \u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e\u0938" },
            { "BT", "\u092d\u0942\u091f\u093e\u0928" },
            { "BV", "\u092c\u094b\u0935\u0947\u0924 \u0926\u094d\u0935\u0940\u092a" },
            { "BW", "\u092c\u094b\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u0940\u091c\u093c" },
            { "CA", "\u0915\u0928\u0947\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 (\u0915\u0940\u0932\u093f\u0902\u0917) \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "CD", "\u0915\u093e\u0902\u0917\u094b - \u0915\u093f\u0902\u0936\u093e\u0938\u093e" },
            { "CF", "\u092c\u093f\u091a\u0932\u093e \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "CG", "\u0915\u093e\u0902\u0917\u094b \u2013 \u092c\u094d\u0930\u093e\u091c\u093c\u093e\u0935\u093f\u0932" },
            { "CH", "\u0938\u094d\u0935\u093f\u091f\u094d\u091c\u093c\u0930\u0932\u0948\u0902\u0921" },
            { "CI", "\u0915\u094b\u091f \u0921\u0940 \u0906\u0907\u0935\u0930" },
            { "CK", "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "CM", "\u0915\u0948\u092e\u0930\u0942\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e" },
            { "CP", "\u0915\u094d\u0932\u093f\u092a\u0930\u094d\u091f\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "CR", "\u0915\u094b\u0938\u094d\u091f\u093e\u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0942\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u0935\u0930\u094d\u0921" },
            { "CW", "\u0915\u094d\u092f\u0942\u0930\u093e\u0938\u093e\u0913" },
            { "CX", "\u0915\u094d\u0930\u093f\u0938\u092e\u0938 \u0926\u094d\u0935\u0940\u092a" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915\u093f\u092f\u093e" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "DG", "\u0921\u093f\u090f\u0917\u094b \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "DJ", "\u091c\u093f\u092c\u0942\u0924\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "EA", "\u0938\u0947\u0909\u091f\u093e \u0915\u0928\u0947 \u092e\u0947\u0932\u093f\u0932\u093e" },
            { "EC", "\u0907\u0915\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "EE", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "EG", "\u092e\u093f\u0938\u094d\u0930" },
            { "EH", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u0939\u093e\u0930\u093e" },
            { "ER", "\u0907\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0938\u0902\u0918" },
            { "EZ", "\u092f\u0942\u0930\u094b\u091c\u093c\u094b\u0928" },
            { "FI", "\u092b\u093c\u093f\u0928\u0932\u0948\u0902\u0921" },
            { "FJ", "\u092b\u093c\u093f\u091c\u0940" },
            { "FK", "\u092b\u093c\u0949\u0915\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "FO", "\u092b\u093c\u0947\u0930\u094b \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "FR", "\u092b\u093c\u094d\u0930\u093e\u0902\u0938" },
            { "GA", "\u0917\u0948\u092c\u0949\u0928" },
            { "GB", "\u092f\u0942\u0928\u093e\u0907\u091f\u0947\u0921 \u0915\u093f\u0902\u0917\u0921\u092e" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u0947\u0921\u093e" },
            { "GE", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u093c\u094d\u0930\u0947\u0902\u091a \u0917\u0941\u092f\u093e\u0928\u093e" },
            { "GG", "\u0917\u0930\u094d\u0928\u0938\u0940" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930" },
            { "GL", "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0902\u0921" },
            { "GM", "\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940" },
            { "GP", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0942\u092a" },
            { "GQ", "\u0907\u0915\u094d\u0935\u0947\u091f\u094b\u0930\u093f\u092f\u0932 \u0917\u093f\u0928\u0940" },
            { "GR", "\u092f\u0942\u0928\u093e\u0928" },
            { "GS", "\u0926\u0916\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0915\u0928\u0947 \u0926\u0916\u0923 \u0938\u0948\u0902\u0921\u0935\u093f\u091a \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "GT", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0906\u092e" },
            { "GW", "\u0917\u093f\u0928\u0940-\u092c\u093f\u0938\u093e\u0909" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "HK", "\u0939\u093e\u0901\u0917 \u0915\u093e\u0901\u0917 (\u091a\u0940\u0928 \u0916\u093e\u0938 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0932\u093e\u0915\u093e)" },
            { "HM", "\u0939\u0930\u094d\u0921 \u0926\u094d\u0935\u0940\u092a \u0915\u0928\u0947 \u092e\u0948\u0915\u0921\u094b\u0928\u0949\u0932\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "HN", "\u0939\u094b\u0902\u0921\u0942\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e" },
            { "HT", "\u0939\u0948\u0924\u0940" },
            { "HU", "\u0939\u0902\u0917\u0930\u0940" },
            { "IC", "\u0915\u0948\u0928\u0947\u0930\u0940 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "ID", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "IE", "\u0906\u092f\u0930\u0932\u0948\u0902\u0921" },
            { "IL", "\u0907\u091c\u093c\u0930\u093e\u0907\u0932" },
            { "IM", "\u0906\u0907\u0932 \u0911\u092b\u093c \u092e\u0948\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "IO", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093f\u0902\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930\u0940\u092f \u0932\u093e\u0915\u093e" },
            { "IQ", "\u0907\u0930\u093e\u0915" },
            { "IR", "\u0908\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921" },
            { "IT", "\u0907\u091f\u0932\u0940" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "JM", "\u091c\u092e\u0948\u0915\u093e" },
            { "JO", "\u091c\u0949\u0930\u094d\u0921\u0928" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "KE", "\u0915\u0947\u0928\u094d\u092f\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u0938" },
            { "KN", "\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u0915\u0928\u0947 \u0928\u0947\u0935\u093f\u0938" },
            { "KP", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0916\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KW", "\u0915\u0941\u0935\u0948\u0924" },
            { "KY", "\u0915\u0948\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "KZ", "\u0915\u091c\u093c\u093e\u0916\u0938\u094d\u0924\u093e\u0928" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u093e\u0928" },
            { "LC", "\u0938\u0947\u0902\u091f \u0932\u0942\u0938\u093f\u092f\u093e" },
            { "LI", "\u0932\u093f\u091a\u0947\u0902\u0938\u094d\u091f\u0940\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940\u0932\u0902\u0915\u093e" },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "LS", "\u0932\u0947\u0938\u094b\u0925\u094b" },
            { "LT", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0917\u094d\u091c\u093c\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u0924\u0935\u093f\u092f\u093e" },
            { "LY", "\u0932\u0940\u092c\u093f\u092f\u093e" },
            { "MA", "\u092e\u094b\u0930\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u093e\u0915\u094b" },
            { "MD", "\u092e\u0949\u0932\u094d\u0921\u094b\u0935\u093e" },
            { "ME", "\u092e\u094b\u0902\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0947\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "MG", "\u092e\u0947\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0932 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "MK", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)" },
            { "MN", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "MO", "\u092e\u0915\u093e\u090a (\u0916\u093e\u0938 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0932\u093e\u0915\u093e \u091a\u0940\u0928)" },
            { "MP", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u0940\u0928\u093f\u0915" },
            { "MR", "\u092e\u0949\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u094b\u0902\u091f\u0938\u0947\u0930\u093e\u0924" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "MU", "\u092e\u0949\u0930\u0940\u0936\u0938" },
            { "MV", "\u092e\u093e\u0932\u0926\u0940\u0935" },
            { "MW", "\u092e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "MY", "\u092e\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "MZ", "\u092e\u094b\u091c\u093c\u093e\u0902\u092c\u093f\u0915" },
            { "NA", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e" },
            { "NC", "\u0928\u094d\u092f\u0942 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0930" },
            { "NF", "\u0928\u0949\u0930\u092b\u093c\u0949\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "NG", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906" },
            { "NL", "\u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921" },
            { "NO", "\u0928\u0949\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", "\u0928\u093e\u0909\u0930\u0941" },
            { "NU", "\u0928\u0940\u092f\u0942" },
            { "NZ", "\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0948\u0902\u0921" },
            { "OM", "\u0913\u092e\u093e\u0928" },
            { "PA", "\u092a\u0928\u093e\u092e\u093e" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092b\u093c\u094d\u0930\u0947\u0902\u091a \u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "PG", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940" },
            { "PH", "\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0902\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u0948\u0902\u0921" },
            { "PM", "\u0938\u0947\u0902\u091f \u092a\u093f\u090f\u0930\u0947 \u0915\u0928\u0947 \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u093e\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u0948\u0930\u094d\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "PR", "\u092a\u094b\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "PS", "\u092b\u093c\u093f\u0932\u093f\u0938\u094d\u0924\u0940\u0928\u0940 \u0932\u093e\u0915\u093e" },
            { "PT", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932" },
            { "PW", "\u092a\u0932\u093e\u090a" },
            { "PY", "\u092a\u0930\u093e\u0917\u094d\u0935\u0947" },
            { "QA", "\u0915\u093c\u0924\u0930" },
            { "QO", "\u0906\u0909\u091f\u0932\u093e\u0907\u0902\u0917 \u0913\u0936\u093f\u0928\u093f\u092f\u093e" },
            { "RE", "\u0930\u093f\u092f\u0942\u0928\u093f\u092f\u0928" },
            { "RO", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u0935\u093e\u0902\u0921\u093e" },
            { "SA", "\u0938\u090a\u0926\u0940 \u0905\u0930\u092c" },
            { "SB", "\u0938\u094b\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939" },
            { "SC", "\u0938\u0947\u0936\u0947\u0932\u094d\u0938" },
            { "SD", "\u0938\u0942\u0921\u093e\u0928" },
            { "SE", "\u0938\u094d\u0935\u0940\u0921\u0928" },
            { "SG", "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930" },
            { "SH", "\u0938\u0947\u0902\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e" },
            { "SJ", "\u0938\u094d\u0935\u093e\u0932\u092c\u093e\u0930\u094d\u0921 \u0915\u0928\u0947 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "SK", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u092f\u094b\u0928" },
            { "SM", "\u0938\u0948\u0928 \u092e\u0947\u0930\u0940\u0928\u094b" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "SR", "\u0938\u0942\u0930\u0940\u0928\u093e\u092e" },
            { "SS", "\u0926\u0916\u0923 \u0938\u0942\u0921\u093e\u0928" },
            { "ST", "\u0938\u093e\u0913 \u091f\u094b\u092e \u0915\u0928\u0947 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947" },
            { "SV", "\u0905\u0932 \u0938\u0932\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "SX", "\u0938\u093f\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "SY", "\u0938\u0940\u0930\u093f\u092f\u093e" },
            { "SZ", "\u090f\u0938\u094d\u0935\u093e\u091f\u093f\u0928\u0940" },
            { "TA", "\u091f\u094d\u0930\u093f\u0938\u094d\u091f\u0928 \u0926\u093e \u0915\u0941\u0928\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915 \u0915\u0928\u0947 \u0915\u0948\u0915\u094b\u091c\u093c \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 \u0926\u0916\u0923\u0947 \u092c\u0916\u0947\u0902 \u0932\u093e\u0915\u093e" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0925\u093e\u0908\u0932\u0948\u0902\u0921" },
            { "TJ", "\u0924\u093e\u091c\u093c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TK", "\u0924\u094b\u0915\u0947\u0932\u093e\u0909" },
            { "TL", "\u0924\u093f\u092e\u094b\u0930-\u0932\u0947\u0938\u094d\u0924" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u091f\u094d\u092f\u0942\u0928\u0940\u0936\u093f\u092f\u093e" },
            { "TO", "\u091f\u094b\u0902\u0917\u093e" },
            { "TR", metaValue_TR },
            { "TT", "\u0924\u094d\u0930\u093f\u0928\u093f\u0926\u093e\u0926 \u0915\u0928\u0947 \u091f\u094b\u092c\u0948\u0917\u094b" },
            { "TV", "\u0924\u0941\u0935\u093e\u0932\u0942" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "TZ", "\u0924\u0902\u091c\u093c\u093e\u0928\u093f\u092f\u093e" },
            { "UA", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928" },
            { "UG", "\u092f\u0941\u0917\u093e\u0902\u0921\u093e" },
            { "UM", "\u092f\u0942\u0970\u090f\u0938\u0970 \u0906\u0909\u091f\u0932\u093e\u0907\u0902\u0917 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "UN", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u0938\u094d\u091f\u0930" },
            { "US", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f" },
            { "UY", "\u0909\u0930\u0942\u0917\u094d\u0935\u0947" },
            { "UZ", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "VA", "\u0935\u0947\u091f\u093f\u0915\u0928 \u0938\u093f\u091f\u0940" },
            { "VC", "\u0938\u0947\u0902\u091f \u0935\u093f\u0902\u0938\u0947\u0902\u091f \u0915\u0928\u0947 \u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e\u0907\u0902\u0938" },
            { "VE", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0935\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "VI", "\u092f\u0942\u0970\u090f\u0938\u0970 \u0935\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a\u093e\u0902 \u0926\u093e \u091d\u0941\u0902\u0921" },
            { "VN", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e" },
            { "VU", "\u0935\u0928\u0941\u0906\u0924\u0942" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0915\u0928\u0947 \u092b\u093c\u094d\u092f\u0942\u091a\u0942\u0928\u093e" },
            { "WS", "\u0938\u092e\u094b\u0906" },
            { "XA", "\u0938\u0942\u0921\u094b-\u090f\u0915\u094d\u0938\u0947\u0902\u091f" },
            { "XB", "\u0938\u0942\u0921\u094b-\u092c\u093e\u092f\u0921\u093e\u092f\u0930\u0947\u0915\u094d\u0936\u0928\u0932" },
            { "XK", "\u0915\u094b\u0938\u094b\u0935\u094b" },
            { "YE", "\u092f\u092e\u0928" },
            { "YT", "\u092e\u093e\u092f\u094b\u0924\u0947" },
            { "ZA", "\u0926\u0916\u0923 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "ZM", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093c\u093f\u092e\u094d\u092c\u093e\u092c\u094d\u0935\u0947" },
            { "ZZ", "\u0905\u0923\u091c\u093e\u0923 \u0932\u093e\u0915\u093e" },
            { "aa", "\u0905\u092b\u093c\u093e\u0930" },
            { "ab", "\u0905\u092c\u094d\u0916\u093c\u093e\u091c\u093c\u093f\u092f\u0928" },
            { "af", "\u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940" },
            { "ak", "\u0905\u0915\u0928" },
            { "am", "\u0905\u092e\u094d\u0939\u0947\u0930\u0940" },
            { "an", "\u0905\u0930\u094d\u0917\u094b\u0928\u0940" },
            { "ar", metaValue_ar },
            { "as", "\u0905\u0938\u092e\u0940" },
            { "av", "\u0905\u0935\u0947\u0930\u093f\u0915" },
            { "ay", "\u0906\u092f\u092e\u093e\u0930\u093e" },
            { "az", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928\u0940" },
            { "ba", "\u092c\u0936\u0916\u093c\u093f\u0930" },
            { "be", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938\u0940" },
            { "bg", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e\u0908" },
            { "bi", "\u092c\u093f\u0938\u094d\u0932\u093e\u092e\u093e" },
            { "bm", "\u092c\u093e\u092e\u094d\u092c\u093e\u0930\u093e" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u092c\u094d\u0930\u0947\u091f\u0928" },
            { "bs", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e\u0908" },
            { "ca", "\u0915\u093e\u0924\u093e\u0932\u093e\u0928" },
            { "ce", "\u091a\u0947\u091a\u0928" },
            { "ch", "\u0915\u092e\u094b\u0930\u094b" },
            { "co", "\u0915\u094b\u0930\u094d\u0938\u0940\u0915\u0928" },
            { "cs", "\u091a\u0947\u0915" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u093e\u0932\u094d\u0935\u093f\u0915" },
            { "cv", "\u091a\u0942\u0935\u093e\u0936" },
            { "cy", "\u0935\u0947\u0932\u094d\u0936" },
            { "da", "\u0921\u0947\u0928\u093f\u0936" },
            { "de", "\u091c\u0930\u094d\u092e\u0928" },
            { "dv", "\u0926\u093f\u0935\u0947\u0939\u0940" },
            { "dz", "\u091c\u093c\u094b\u0928\u094d\u0917\u0916\u093e" },
            { "ee", "\u0908\u0935\u0947" },
            { "el", metaValue_el },
            { "en", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "eo", "\u090f\u0938\u094d\u092a\u0947\u0930\u0947\u0902\u0924\u094b" },
            { "es", "\u0938\u094d\u092a\u0947\u0928\u0940" },
            { "et", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u0947 \u0906\u0932\u0940" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "fa", "\u092b\u093c\u093e\u0930\u0938\u0940" },
            { "ff", "\u092b\u0941\u0932\u093e\u0939" },
            { "fi", "\u092b\u093c\u093f\u0928\u093f\u0936" },
            { "fj", "\u092b\u093f\u091c\u093f\u092f\u0928" },
            { "fo", "\u092b\u093c\u0948\u0930\u094b\u0907\u091c\u093c" },
            { "fr", "\u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "fy", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092b\u093c\u094d\u0930\u093f\u0938\u093f\u092f\u093e\u0908" },
            { "ga", "\u0906\u092f\u0930\u093f\u0936" },
            { "gd", "\u0938\u094d\u0915\u0949\u091f\u093f\u0936 \u0917\u093e\u090f\u0932\u093f\u0915" },
            { "gl", "\u0917\u0948\u0932\u093f\u0936\u093f\u092f\u0928" },
            { "gn", "\u0917\u0941\u0906\u0930\u093e\u0928\u0940" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u0948\u0902\u0915\u094d\u0938" },
            { "ha", "\u0939\u094c\u0938\u093e" },
            { "he", metaValue_he },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "hr", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e\u0908" },
            { "ht", "\u0939\u0948\u0924\u093f\u092f\u093e\u0908" },
            { "hu", "\u0939\u0902\u0917\u0947\u0930\u093f\u092f\u093e\u0908" },
            { "hy", metaValue_hy },
            { "hz", "\u0939\u0930\u0948\u0930\u094b" },
            { "ia", "\u0907\u0902\u091f\u0930\u0932\u093f\u0902\u0917\u0941\u0906" },
            { "id", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908" },
            { "ie", "\u0908\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u0941\u0907" },
            { "ig", "\u0908\u0917\u094d\u092c\u094b" },
            { "ii", "\u0938\u093f\u091a\u0941\u0906\u0928 \u092f\u0940" },
            { "io", "\u0907\u0921\u094c" },
            { "is", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921\u093f\u0915" },
            { "it", "\u0907\u0924\u093e\u0932\u0935\u0940" },
            { "iu", "\u0907\u0928\u0942\u0915\u0940\u091f\u0942\u0924\u094d" },
            { "ja", metaValue_ja },
            { "jv", "\u091c\u093e\u0935\u093e\u0928\u0940\u091c\u093c" },
            { "ka", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e\u0908" },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0942" },
            { "kj", "\u0915\u094d\u0935\u093e\u0928\u094d\u092f\u093e\u092e\u093e" },
            { "kk", "\u0915\u091c\u093c\u093e\u0916\u093c" },
            { "kl", "\u0915\u0932\u093e\u0932\u0940\u0938\u0941\u0924" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0915\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u0936\u094d\u092e\u0940\u0930\u0940" },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u093f\u0936" },
            { "kv", "\u0915\u094b\u092e\u0940" },
            { "kw", "\u0915\u094b\u0930\u094d\u0928\u093f\u0936" },
            { "ky", "\u0915\u093f\u0930\u094d\u0917\u0940\u091c\u093c" },
            { "la", metaValue_la },
            { "lb", "\u0932\u0917\u094d\u091c\u093c\u092e\u092c\u0930\u094d\u0917\u0940" },
            { "lg", "\u0917\u093e\u0902\u0921\u093e" },
            { "li", "\u0932\u093f\u0902\u092c\u0930\u094d\u0917\u093f\u0936" },
            { "ln", "\u0932\u093f\u0902\u0917\u093e\u0932\u093e" },
            { "lo", metaValue_lo },
            { "lt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0908" },
            { "lu", "\u0932\u094d\u092f\u0942\u092c\u093e-\u0915\u091f\u093e\u0902\u0917\u093e" },
            { "lv", "\u0932\u093e\u0924\u0935\u093f\u092f\u093e\u0908" },
            { "mg", "\u092e\u093e\u0932\u093e\u0917\u093e\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0936\u0932\u0940\u091c\u093c" },
            { "mi", "\u092e\u093e\u0913\u0930\u0940" },
            { "mk", "\u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e\u0908" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u092f" },
            { "mt", "\u092e\u093e\u0932\u094d\u091f\u0940\u091c\u093c" },
            { "my", "\u092c\u0930\u094d\u092e\u0940\u091c\u093c" },
            { "na", "\u0928\u093e\u0909\u0930\u0942" },
            { "nb", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0908 \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "nd", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0926\u0947\u092c\u0947\u0932" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "ng", "\u0921\u094b\u0928\u094d\u0917\u093e" },
            { "nl", "\u0921\u091a" },
            { "nn", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0908 \u0928\u0949\u092f\u0928\u0949\u0930\u094d\u0938\u094d\u0915" },
            { "no", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0908" },
            { "nr", "\u0926\u0916\u0923 \u0926\u0947\u092c\u0947\u0932" },
            { "nv", "\u0928\u093e\u0935\u093e\u091c\u094b" },
            { "ny", "\u0928\u094d\u092f\u093e\u0928\u091c\u093e" },
            { "oc", "\u0913\u0938\u0940\u091f\u093e\u0928" },
            { "om", "\u0913\u0930\u094b\u092e\u094b" },
            { "or", metaValue_or },
            { "os", "\u0913\u0938\u094d\u0938\u0947\u091f\u093f\u0915" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "pl", "\u092a\u094b\u0932\u093f\u0936" },
            { "ps", "\u092a\u0936\u094d\u0924\u094b" },
            { "pt", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u0941\u0906" },
            { "rm", "\u0930\u094b\u092e\u093e\u0928\u094d\u0936" },
            { "rn", "\u0930\u0941\u0928\u094d\u0926\u0940" },
            { "ro", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0908" },
            { "ru", "\u0930\u0942\u0938\u0940" },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u0935\u093e\u0902\u0921\u093e" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sc", "\u0938\u093e\u0930\u094d\u0926\u093f\u0928\u093f\u092f\u0928" },
            { "sd", "\u0938\u093f\u0902\u0927\u0940" },
            { "se", "\u0909\u0924\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "sg", "\u0938\u093e\u0902\u0917\u094b" },
            { "si", metaValue_si },
            { "sk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915" },
            { "sl", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "sm", "\u0938\u093e\u092e\u094b\u0928" },
            { "sn", "\u0936\u094b\u0923\u093e" },
            { "so", "\u0938\u094b\u092e\u093e\u0932\u0940" },
            { "sq", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0908" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0908" },
            { "ss", "\u0938\u094d\u0935\u093e\u0924\u0940" },
            { "st", "\u0926\u0916\u0923\u0947 \u092c\u0916\u0947\u0902 \u0938\u0947\u0938\u0947\u0925\u094b" },
            { "su", "\u0938\u0941\u0902\u0921\u093e\u0928\u0940" },
            { "sv", "\u0938\u094d\u0935\u0940\u0921\u093f\u0936" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0924\u093e\u091c\u093f\u0915" },
            { "th", metaValue_th },
            { "ti", "\u0924\u093f\u0917\u094d\u0930\u0940\u0928\u094d\u092f\u093e" },
            { "tk", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928" },
            { "tn", "\u0938\u0947\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", "\u091f\u094b\u0902\u0917\u0928" },
            { "tr", metaValue_TR },
            { "ts", "\u0938\u094b\u0902\u0917\u093e" },
            { "tt", "\u0924\u093e\u0924\u093e\u0930" },
            { "ty", "\u0924\u093e\u0939\u093f\u0924\u093f\u092f\u0928" },
            { "ug", "\u0909\u0907\u0917\u0930" },
            { "uk", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "ur", "\u0909\u0930\u094d\u0926\u0942" },
            { "uz", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915" },
            { "ve", "\u0935\u0947\u0928\u094d\u0926\u093e" },
            { "vi", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e\u0940" },
            { "vo", "\u0935\u094b\u0932\u093e\u092a\u0941\u0915" },
            { "wa", "\u0935\u093e\u0932\u094d\u0932\u0942\u0928" },
            { "wo", "\u0935\u094b\u0932\u094b\u092b\u093c" },
            { "xh", "\u0916\u093c\u094b\u0938\u093e" },
            { "yi", "\u092f\u0939\u0942\u0926\u0940" },
            { "yo", "\u092f\u094b\u0930\u0942\u092c\u093e" },
            { "za", "\u091c\u093c\u0941\u0906\u0902\u0917" },
            { "zh", "\u091a\u0940\u0928\u0940" },
            { "zu", "\u091c\u093c\u0941\u0932\u0942" },
            { "ace", "\u0905\u091a\u093e\u0907\u0928\u0940\u0938" },
            { "ada", "\u0905\u0926\u093e\u0928\u094d\u0917\u092e\u0947" },
            { "ady", "\u0905\u0926\u093f\u0918\u0947" },
            { "agq", "\u0905\u0917\u094d\u0939\u0947\u092e" },
            { "ain", "\u0910\u0928\u0942" },
            { "ale", "\u0905\u0932\u0947\u0909\u0924" },
            { "alt", "\u0926\u0916\u0923\u0947 \u092c\u0916\u0947\u0902 \u0905\u0932\u094d\u0924\u093e\u0908" },
            { "anp", "\u0905\u0902\u0917\u093f\u0915\u093e" },
            { "arn", "\u092e\u093e\u092a\u0942\u091a\u0947" },
            { "arp", "\u0905\u0930\u093e\u092a\u093e\u0939\u094b" },
            { "ars", "\u0928\u091c\u094d\u0926\u0940 \u0905\u0930\u092c\u0940" },
            { "asa", "\u0905\u0938\u0941" },
            { "ast", "\u0905\u0938\u094d\u0924\u0941\u0930\u093f\u092f\u0928" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "ban", "\u092c\u093e\u0932\u093f\u0928\u0940\u0938" },
            { "bas", "\u092c\u0938\u093e" },
            { "bem", "\u092c\u0947\u092e\u094d\u092c\u093e" },
            { "bez", "\u092c\u0947\u0928\u093e" },
            { "bgn", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092c\u0932\u094b\u091a\u0940" },
            { "bho", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "bla", "\u0938\u093f\u0915\u094d\u0938\u093f\u0915\u093e" },
            { "brx", "\u092c\u094b\u0921\u094b" },
            { "bug", metaValue_bug },
            { "byn", "\u092c\u094d\u0932\u093f\u0928" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u0938\u093f\u092c\u0941\u0906\u0928\u094b" },
            { "cgg", "\u0936\u093f\u0917\u093e" },
            { "chk", "\u091a\u0942\u0915\u0940\u0938" },
            { "chm", "\u092e\u093e\u0930\u0940" },
            { "cho", "\u091a\u094b\u0915\u094d\u0924\u094c" },
            { "chp", "\u0936\u093f\u092a\u0947\u0935\u094d\u092f\u093e\u0928" },
            { "chr", metaValue_chr },
            { "chy", "\u0936\u0947\u092f\u0947\u0928\u094d\u0928" },
            { "ckb", "\u0938\u094b\u0930\u093e\u0928\u0940 \u0915\u0941\u0930\u094d\u0926\u093f\u0936" },
            { "dak", "\u0926\u093e\u0915\u094b\u0924\u093e" },
            { "dar", "\u0926\u093e\u0930\u094d\u0917\u0935\u093e" },
            { "dav", "\u0924\u0948\u0924\u093e" },
            { "dgr", "\u0921\u094b\u0917\u094d\u0930\u093f\u092c" },
            { "dje", "\u091d\u093e\u0930\u094d\u092e\u093e" },
            { "doi", "\u0921\u094b\u0917\u0930\u0940" },
            { "dsb", "\u092c\u0941\u0930\u0932\u093e \u0938\u0949\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "dua", "\u0926\u0941\u0906\u0932\u093e" },
            { "dyo", "\u091c\u094b\u0932\u093e-\u092b\u094b\u0902\u0908" },
            { "dzg", "\u0926\u091c\u093c\u093e\u0917\u093e" },
            { "ebu", "\u090f\u092e\u094d\u092c\u0941" },
            { "efi", "\u090f\u092b\u093f\u0915" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "ewo", "\u0907\u0935\u094b\u0928\u094d\u0921\u094b" },
            { "fil", "\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0928\u094b" },
            { "fon", "\u092b\u0949\u0928" },
            { "frc", "\u0915\u0947\u091c\u0928 \u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "frr", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092b\u093c\u094d\u0930\u0940\u0938\u093f\u092f\u093e\u0908" },
            { "fur", "\u092b\u094d\u0930\u0940\u092f\u0941\u0932\u0940\u092f\u093e\u0928" },
            { "gaa", "\u0917\u093e" },
            { "gez", "\u0917\u0940\u091c\u093c" },
            { "gil", "\u0917\u093f\u0932\u094d\u092c\u0930\u0924\u0940\u0938" },
            { "gor", "\u0917\u094b\u0930\u094b\u0928\u094d\u0924\u093e\u0932\u094b" },
            { "gsw", "\u0938\u094d\u0935\u093f\u0938 \u091c\u0930\u094d\u092e\u0928" },
            { "guz", "\u0917\u0941\u0938\u0940" },
            { "gwi", "\u0917\u094d\u0935\u093f\u091a\u0907\u0928" },
            { "hai", "\u0939\u0948\u0921\u093e" },
            { "haw", "\u0939\u0935\u093e\u0908" },
            { "hil", "\u0939\u093f\u0932\u093f\u0917\u0947\u0928\u0928" },
            { "hmn", "\u0939\u094d\u092e\u0949\u0902\u0917" },
            { "hsb", "\u0909\u092a\u0930\u0932\u0940 \u0938\u0949\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "hup", "\u0939\u0942\u092a\u093e" },
            { "iba", "\u0907\u092c\u093e\u0928" },
            { "ibb", "\u0907\u092c\u093f\u092c\u093f\u092f\u094b" },
            { "ilo", "\u0907\u0932\u094b\u0915\u094b" },
            { "inh", "\u0907\u0902\u0917\u0941\u0936" },
            { "jbo", "\u0932\u094b\u091c\u094d\u092c\u093e\u0928" },
            { "jgo", "\u0928\u0917\u094b\u0902\u092c\u093e" },
            { "jmc", "\u092e\u0948\u0915\u0939\u0948\u092e\u0947" },
            { "kaa", "\u0915\u093e\u0930\u093e-\u0915\u0932\u094d\u092a\u0915" },
            { "kab", "\u0915\u092c\u093e\u0907\u0932" },
            { "kac", "\u0915\u093e\u091a\u093f\u0928" },
            { "kaj", "\u091c\u094d\u091c\u0941" },
            { "kam", "\u0915\u092e\u094d\u092c\u093e" },
            { "kbd", "\u0915\u092c\u093e\u0930\u094d\u0921\u093f\u092f\u0928" },
            { "kcg", "\u0924\u094d\u092f\u093e\u092a" },
            { "kde", "\u092e\u0948\u0915\u094b\u0902\u0921" },
            { "kea", "\u0915\u093e\u092c\u0941\u0935\u0947\u0930\u094d\u0926\u093f\u092f\u093e\u0928\u0941" },
            { "kfo", "\u0915\u094b\u0930\u094b" },
            { "kgp", "\u0915\u0907\u0902\u0917\u0902\u0917" },
            { "kha", "\u0916\u093e\u0938\u0940" },
            { "khq", "\u0915\u094b\u092f\u0930\u093e \u091a\u0940\u0928\u0940" },
            { "kkj", "\u0915\u093e\u0915\u094b" },
            { "kln", "\u0915\u0932\u0947\u0902\u091c\u093f\u0928" },
            { "kmb", "\u0915\u093f\u092e\u094d\u092c\u0928\u094d\u0926\u0941" },
            { "kok", "\u0915\u094b\u0902\u0915\u0923\u0940" },
            { "kpe", "\u0915\u094d\u092a\u0947\u0932" },
            { "krc", "\u0915\u0930\u093e\u091a\u092f-\u092c\u0932\u094d\u0915\u093e\u0930" },
            { "krl", "\u0915\u0930\u0947\u0932\u093f\u092f\u0928" },
            { "kru", "\u0915\u0941\u0930\u0942\u0916" },
            { "ksb", "\u0936\u092e\u094d\u092c\u093e\u0932\u093e" },
            { "ksf", "\u092c\u092b\u093f\u0906" },
            { "ksh", "\u0915\u094b\u0932\u094b\u0928\u093f\u092f\u093e\u0908" },
            { "kum", "\u0915\u0941\u092e\u0940\u0915" },
            { "lad", "\u0932\u093e\u0926\u0940\u0928\u094b" },
            { "lag", "\u0932\u093e\u0902\u0917\u093f" },
            { "lez", "\u0932\u0947\u091c\u093c\u094d\u0918\u0940\u092f\u0928" },
            { "lkt", "\u0932\u0948\u0915\u094b\u091f\u093e" },
            { "lou", "\u0932\u0941\u0908\u091c\u093c\u093f\u092f\u093e\u0928\u093e \u0915\u094d\u0930\u093f\u092f\u094b\u0932" },
            { "loz", "\u0932\u094b\u091c\u093c\u0940" },
            { "lrc", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0932\u0942\u0930\u0940" },
            { "lua", "\u0932\u094d\u092f\u0942\u092c\u093e-\u0932\u0941\u0932\u0941\u0906" },
            { "lun", "\u0932\u0941\u0928\u094d\u0921\u093e" },
            { "luo", "\u0932\u094d\u092f\u0941\u0913" },
            { "lus", "\u092e\u093f\u091c\u093c\u094b" },
            { "luy", "\u0932\u094d\u092f\u0941\u0908\u0906" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0940\u0938" },
            { "mag", "\u092e\u0917\u0939\u0940" },
            { "mai", "\u092e\u0948\u0925\u093f\u0932\u0940" },
            { "mak", "\u092e\u0915\u093e\u0938\u0930" },
            { "mas", "\u092e\u0938\u093e\u0908" },
            { "mdf", "\u092e\u0941\u0917\u0924\u0940" },
            { "men", "\u092e\u0947\u0928\u094d\u0921\u0947" },
            { "mer", "\u092e\u0947\u0930\u0941" },
            { "mfe", "\u092e\u094b\u0930\u0940\u0938\u094d\u092f\u0947\u0928" },
            { "mgh", "\u092e\u0948\u0916\u0941\u0935\u093e-\u092e\u0940\u091f\u094d\u091f\u094b" },
            { "mgo", "\u092e\u0947\u091f\u093e" },
            { "mic", "\u092e\u093f\u0915\u092e\u0948\u0915" },
            { "min", "\u092e\u093f\u0928\u093e\u0902\u0917\u094d\u0915\u093e\u092c\u093e\u0909" },
            { "mni", "\u092e\u0923\u093f\u092a\u0941\u0930\u0940" },
            { "moh", "\u092e\u094b\u0939\u094c\u0915" },
            { "mos", "\u092e\u094b\u0938\u094d\u0938\u0940" },
            { "mua", "\u092e\u0941\u0902\u0921\u0948\u0902\u0917" },
            { "mul", "\u0907\u0915 \u0924\u0947 \u091c\u093e\u0926\u093e \u092c\u094b\u0932\u093f\u092f\u093e\u0901" },
            { "mus", "\u0915\u094d\u0930\u0940\u0915" },
            { "mwl", "\u092e\u093f\u0930\u093e\u0902\u0921\u0940" },
            { "myv", "\u090f\u0930\u094d\u091c\u093c\u092f\u093e" },
            { "mzn", "\u092e\u093e\u091c\u093c\u0928\u094d\u0926\u0947\u0930\u093e\u0928\u0940" },
            { "nap", "\u0928\u0940\u092a\u094b\u0932\u093f\u091f\u0928" },
            { "naq", "\u0928\u093e\u092e\u093e" },
            { "nds", "\u092c\u0941\u0930\u0932\u093e \u091c\u0930\u094d\u092e\u0928" },
            { "new", "\u0928\u0947\u0935\u093e\u0921\u093c\u0940" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "niu", "\u0928\u093f\u092f\u0941\u0906\u0928" },
            { "nmg", "\u0915\u094d\u0935\u093e\u0938\u093f\u0913" },
            { "nnh", "\u0917\u0948\u092e\u094d\u092c\u0942" },
            { "nog", "\u0928\u094b\u0917\u093e\u0908" },
            { "nqo", "\u090f\u0928\u094d\u0915\u094b" },
            { "nso", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u094b\u0925\u094b" },
            { "nus", "\u0928\u0941\u090f\u0930" },
            { "nyn", "\u0928\u094d\u092f\u093e\u0928\u0915\u094b\u0932" },
            { "osa", "\u0913\u0938\u0947\u091c" },
            { "pag", "\u092a\u0902\u0917\u093e\u0938\u0940\u0928\u093e\u0928" },
            { "pam", "\u092a\u093e\u092e\u094d\u092a\u093e\u0928\u094d\u0917\u093e" },
            { "pap", "\u092a\u093e\u092a\u093f\u092f\u093e\u092e\u0947\u0928\u094d\u091f\u094b" },
            { "pau", "\u092a\u0932\u094b\u0909\u0906\u0928" },
            { "pcm", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e\u0908 \u092a\u093f\u0921\u0917\u093f\u0928" },
            { "prg", "\u092a\u094d\u0930\u0941\u0936\u093f\u092f\u093e\u0908" },
            { "quc", "\u0915\u093f\u0936" },
            { "raj", "\u0930\u093e\u091c\u0938\u094d\u0925\u093e\u0928\u0940" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u0941\u0908" },
            { "rar", "\u0930\u093e\u0930\u094b\u0924\u094b\u0902\u0917\u0928" },
            { "rof", "\u0930\u094b\u092e\u094d\u092c\u094b" },
            { "rup", "\u0905\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u0928" },
            { "rwk", "\u0930\u0935\u093e" },
            { "sad", "\u0938\u0928\u094d\u0921\u093e\u0935\u0947" },
            { "sah", "\u092f\u093e\u0915\u0942\u0924" },
            { "saq", "\u0938\u0948\u092e\u094d\u092c\u0941\u0930\u0941" },
            { "sat", "\u0938\u0902\u0925\u093e\u0932\u0940" },
            { "sba", "\u0928\u094d\u0917\u093e\u092e\u094d\u092c\u0947" },
            { "sbp", "\u0938\u0948\u0902\u0917\u0941" },
            { "scn", "\u0938\u093f\u0938\u093f\u0932\u093f\u092f\u0928" },
            { "sco", "\u0938\u094d\u0915\u0949\u091f\u094d\u0938" },
            { "seh", "\u0938\u0947\u0928\u093e" },
            { "ses", "\u0915\u094b\u092f\u0930\u093e\u092c\u094b\u0930\u094b \u0938\u0947\u0928\u094d\u0928\u0940" },
            { "shi", "\u0924\u0948\u091a\u0947\u0932\u094d\u0939\u093f\u0924" },
            { "shn", "\u0936\u0948\u0928" },
            { "smn", "\u0907\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "sms", "\u0938\u094d\u0915\u094b\u0932\u094d\u091f \u0938\u093e\u092e\u0940" },
            { "snk", "\u0938\u094b\u0928\u093f\u0928\u094d\u0915\u0947" },
            { "srn", "\u0938\u094d\u0930\u093e\u0928\u093e\u0928 \u091f\u0949\u0928\u094d\u0917\u094b" },
            { "ssy", "\u0938\u093e\u0939\u094b" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "swb", "\u0915\u094b\u092e\u094b\u0930\u093f\u092f\u0928" },
            { "tem", "\u091f\u093f\u092e\u094d\u0928\u0947" },
            { "teo", "\u091f\u0947\u0938\u094b" },
            { "tet", "\u0924\u0947\u0924\u0941\u092e" },
            { "tig", "\u091f\u093e\u0907\u0917\u094d\u0930\u0947" },
            { "tlh", "\u0915\u094d\u0932\u093f\u0902\u0917\u0928" },
            { "tli", "\u0924\u094d\u0932\u093f\u0902\u0917\u093f\u0924" },
            { "tpi", "\u091f\u094b\u0915 \u092a\u093f\u0938\u093f\u0928" },
            { "trv", "\u0924\u093e\u0930\u094b\u0915\u094b" },
            { "tvl", "\u0924\u0941\u0935\u093e\u0932\u0941" },
            { "twq", "\u091f\u093e\u0938\u0935\u093e\u0915" },
            { "tyv", "\u0924\u0941\u0935\u0940\u0928\u093f\u092f\u0928" },
            { "tzm", "\u092c\u093f\u091a\u0932\u093e \u090f\u091f\u0932\u0938 \u0924\u092e\u093e\u091c\u093c\u093f\u0924" },
            { "udm", "\u0909\u0926\u092e\u0941\u0930\u094d\u0924" },
            { "umb", "\u0909\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0941" },
            { "und", "\u0905\u0923\u091c\u093e\u0923 \u092c\u094b\u0932\u0940" },
            { "vai", metaValue_vai },
            { "vun", "\u0935\u0941\u0902\u091c\u094b" },
            { "wae", "\u0935\u093e\u0932\u094d\u0938\u0930" },
            { "wal", "\u0935\u0932\u093e\u092e\u094b" },
            { "war", "\u0935\u093e\u0930\u0948" },
            { "wbp", "\u0935\u0949\u0932\u094d\u092a\u0947\u0930\u0940" },
            { "wuu", "\u0935\u0942 \u091a\u0940\u0928\u0940" },
            { "xal", "\u0915\u093e\u0932\u094d\u092e\u093f\u0915" },
            { "xnr", "\u0915\u093e\u0902\u0917\u0921\u093c\u0940" },
            { "xog", "\u0938\u094b\u0917\u093e" },
            { "yav", "\u092f\u093e\u0902\u0917\u092c\u0947\u0928" },
            { "ybb", "\u092f\u0947\u0902\u092c\u093e" },
            { "yue", "\u0915\u0948\u0902\u091f\u094b\u0928\u0940\u091c\u093c" },
            { "zgh", "\u092e\u093e\u0928\u0915 \u092e\u094b\u0930\u0915\u094d\u0915\u0928 \u0924\u093e\u092e\u093e\u091c\u093c\u093e\u0907\u091f" },
            { "zun", "\u091c\u093c\u0942\u0928\u0940" },
            { "zxx", "\u0915\u094b\u0908 \u092c\u094b\u0932\u0940 \u0938\u093e\u092e\u0917\u094d\u0930\u0940 \u0928\u0940" },
            { "zza", "\u091c\u093c\u093e\u091c\u093c\u093e" },
            { "Arab", metaValue_ar },
            { "Armi", "\u0907\u092e\u094d\u092a\u093f\u0930\u093f\u092f\u0932 \u0906\u0930\u094d\u092e\u0947\u0928\u093f\u0915" },
            { "Armn", metaValue_hy },
            { "Avst", "\u0905\u0935\u0947\u0938\u094d\u0924\u0928" },
            { "Bali", "\u092c\u093e\u0932\u0940" },
            { "Batk", "\u092c\u091f\u0915\u0940" },
            { "Beng", metaValue_bn },
            { "Bopo", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u093c\u094b" },
            { "Brah", "\u092c\u094d\u0930\u0939\u094d\u092e\u0940" },
            { "Brai", "\u092c\u094d\u0930\u0947\u0932" },
            { "Bugi", metaValue_bug },
            { "Buhd", "\u092c\u0941\u0939\u093f\u0926" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u092f\u0941\u0928\u093f\u092b\u093e\u0907\u0921 \u0915\u0948\u0928\u0947\u0921\u093f\u092f\u0928 \u090f\u092c\u094b\u0930\u093f\u091c\u0928\u0932 \u0938\u093f\u0932\u0947\u092c\u093f\u0915\u094d\u0938" },
            { "Cari", "\u0915\u0930\u0948\u0928" },
            { "Cham", "\u091a\u093e\u092e" },
            { "Cher", metaValue_chr },
            { "Copt", "\u0915\u0949\u092a\u094d\u091f\u093f\u0915" },
            { "Cprt", "\u0915\u093e\u0907\u092a\u094d\u0930\u093e\u092f\u091f" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "Cyrs", "\u0913\u0932\u094d\u0921 \u091a\u0930\u094d\u091a \u0938\u094d\u0932\u093e\u0935\u094b\u0928\u093f\u0915 \u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "Deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940" },
            { "Dsrt", "\u0921\u0947\u0938\u0930\u0947\u091f" },
            { "Egyp", "\u0907\u091c\u093f\u092a\u094d\u0936\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "Ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e\u0908" },
            { "Geor", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928" },
            { "Glag", "\u0917\u094d\u0932\u0947\u0917\u094b\u0932\u093f\u091f\u093f\u0915" },
            { "Goth", "\u0917\u094b\u0925\u093f\u0915" },
            { "Gran", "\u0917\u094d\u0930\u0928\u094d\u0925" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940" },
            { "Hanb", "\u0939\u093e\u0902\u092c" },
            { "Hang", "\u0939\u0902\u0917\u0941\u0932" },
            { "Hani", "\u0939\u093e\u0928" },
            { "Hano", "\u0939\u0928\u0941\u0928\u0942" },
            { "Hans", "\u0938\u093e\u0926\u0940" },
            { "Hant", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0939\u093f\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "Hmng", "\u092a\u093e\u0939\u094b \u0939\u094d\u092e\u094b\u0928\u094d\u0917" },
            { "Hrkt", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0938\u093f\u0932\u0947\u092c\u0930\u0940\u091c\u093c" },
            { "Hung", "\u0911\u0932\u094d\u0921 \u0939\u0902\u0917\u0947\u0930\u093f\u092f\u0928" },
            { "Ital", "\u092a\u0930\u093e\u0923\u0940 \u0907\u091f\u0932\u0940" },
            { "Jamo", "\u091c\u093e\u092e\u094b" },
            { "Java", "\u091c\u093e\u0935\u093e\u0928\u0940\u0938" },
            { "Jpan", metaValue_ja },
            { "Kali", "\u0915\u093e\u092f\u093e\u0939 \u0932\u0940" },
            { "Kana", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e" },
            { "Khar", "\u0916\u093e\u0930\u094b\u0936\u0925\u0940" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "\u0915\u0948\u0925\u0940" },
            { "Lana", "\u0932\u093e\u0928\u093e" },
            { "Laoo", metaValue_lo },
            { "Latf", "\u092b\u093c\u094d\u0930\u0948\u0915\u094d\u091f\u0941\u0930 \u0932\u093e\u0924\u093f\u0928\u0940" },
            { "Latg", "\u0917\u0947\u0932\u0940 \u0932\u093e\u0924\u093f\u0928\u0940" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0932\u0947\u092a\u091a\u093e" },
            { "Limb", "\u0932\u093f\u092e\u094d\u092c\u0942" },
            { "Lina", "\u0930\u0947\u0916\u093e \u0906\u0932\u0940 \u090f" },
            { "Linb", "\u0930\u0947\u0916\u093e \u0906\u0932\u0940 \u092c\u0940" },
            { "Lyci", "\u0932\u093f\u0936\u093f\u092f\u0928" },
            { "Lydi", "\u0932\u093f\u0921\u093f\u092f\u0928" },
            { "Mand", "\u092e\u0928\u0921\u0947\u0928" },
            { "Mani", "\u092e\u0928\u0940\u0936\u0940\u0928" },
            { "Mero", "\u092e\u0947\u0930\u094b\u0907\u091f\u093f\u0915" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "\u092e\u0947\u0907\u0924\u0947\u0907 \u092e\u093e\u092f\u0947\u0915" },
            { "Mymr", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930" },
            { "Nkoo", "\u090f\u0928\u094d\u2018\u0915\u094b" },
            { "Ogam", "\u0913\u0917\u092e" },
            { "Olck", "\u0911\u0932 \u091a\u093f\u0915\u0940" },
            { "Orkh", "\u0913\u0930\u0916\u094b\u0928" },
            { "Orya", metaValue_or },
            { "Osma", "\u0913\u0938\u094d\u092e\u093e\u0928\u094d\u092f\u093e" },
            { "Perm", "\u0913\u0932\u094d\u0921 \u092a\u0930\u092e\u093f\u0915" },
            { "Phag", "\u092b\u093e\u0917\u094d\u0938-\u092a\u093e" },
            { "Phli", "\u0907\u0902\u0938\u094d\u0915\u094d\u0930\u093f\u092a\u0936\u094d\u0928\u0932 \u092a\u093e\u0939\u0932\u0935\u0940" },
            { "Phlp", "\u0938\u0949\u0932\u094d\u091f\u0930 \u092a\u093e\u0939\u0932\u0935\u0940" },
            { "Phnx", "\u092b\u094b\u0928\u093f\u0936\u093f\u092f\u0928" },
            { "Plrd", "\u092a\u0949\u0932\u093e\u0930\u094d\u0921 \u092b\u094b\u0928\u0947\u091f\u093f\u0915" },
            { "Prti", "\u0907\u0902\u0938\u094d\u0915\u094d\u0930\u093f\u092a\u0936\u094d\u0928\u0932 \u092a\u093e\u0930\u094d\u0925\u093f\u092f\u0928" },
            { "Rjng", "\u0930\u0940\u091c\u093e\u0902\u0917" },
            { "Runr", "\u0930\u0942\u0928\u093f\u0915" },
            { "Samr", "\u0938\u092e\u0930\u093f\u091f\u0928" },
            { "Saur", "\u0938\u094c\u0930\u093e\u0938\u091f\u0930" },
            { "Sgnw", "\u0938\u093e\u0902\u0915\u0947\u0924\u093f\u0915 \u0932\u0947\u0916" },
            { "Shaw", "\u0936\u093e\u0935\u093f\u092f\u093e\u0928" },
            { "Sinh", metaValue_si },
            { "Sund", "\u0938\u0942\u0921\u093e\u0928\u0940" },
            { "Sylo", "\u0938\u093f\u0932\u094b\u0924\u0940 \u0928\u093e\u0917\u0930\u0940" },
            { "Syrc", "\u0938\u093f\u0930\u093f\u092f\u0947\u0915" },
            { "Syre", "\u090f\u0938\u094d\u0924\u094d\u0930\u0947\u0928\u094d\u091c\u0947\u0932\u094b \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "Syrj", "\u092a\u0936\u094d\u091a\u093f\u092e \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "Syrn", "\u092a\u0942\u0930\u094d\u0935 \u0938\u093f\u0930\u093f\u090f\u0915" },
            { "Tagb", "\u0924\u0917\u092c\u0928\u094d\u0935\u093e" },
            { "Tale", "\u0924\u093e\u0908 \u0932\u0940" },
            { "Talu", "\u0928\u094b\u0906 \u0924\u093e\u0908 \u0932\u0941" },
            { "Taml", metaValue_ta },
            { "Tavt", "\u0924\u093e\u0908 \u0935\u093f\u090f\u0924" },
            { "Telu", metaValue_te },
            { "Tfng", "\u0924\u093f\u092b\u093f\u0928\u093e\u0918" },
            { "Tglg", "\u091f\u0948\u0917\u093e\u0932\u094b\u0917" },
            { "Thaa", "\u0925\u093e\u0928\u093e" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "\u092f\u0941\u0917\u093e\u0930\u093f\u091f\u093f\u0915" },
            { "Vaii", metaValue_vai },
            { "Xpeo", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u093e\u0930\u0938\u0940" },
            { "Xsux", "\u0938\u0941\u092e\u0947\u0930\u094b \u0905\u0915\u094d\u0915\u093e\u0926\u093f\u092f\u0928 \u0938\u0941\u0928\u093f\u092b\u0949\u0930\u094d\u092e" },
            { "Yiii", "\u092f\u0940" },
            { "Zinh", "\u0935\u093f\u0930\u093e\u0938\u0924" },
            { "Zmth", "\u0917\u0923\u093f\u0924\u0947 \u0906\u0932\u0947 \u0938\u0902\u0915\u0947\u0924\u0928" },
            { "Zsye", "\u0908\u092e\u094b\u091c\u0940" },
            { "Zsym", "\u091a\u093f\u0939\u094d\u0928" },
            { "Zxxx", "\u0928\u0940 \u0932\u0916\u094b\u092f\u093e" },
            { "Zyyy", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f" },
            { "Zzzz", "\u0905\u0923\u091c\u093e\u0923 \u0932\u093f\u092a\u093f" },
            { "de_AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e \u0906\u0932\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "de_CH", "\u0938\u094d\u0935\u093f\u0938 \u0909\u091a\u094d\u091a \u091c\u0930\u094d\u092e\u0928" },
            { "en_AU", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0906\u0932\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "en_CA", "\u0915\u0928\u0947\u0921\u0947 \u0906\u0932\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "en_GB", "\u092c\u094d\u0930\u093f\u091f\u0947\u0928\u0947 \u0906\u0932\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "en_US", "\u0905\u092e\u0930\u093f\u0915\u0947 \u0906\u0932\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "es_ES", "\u092f\u0942\u0930\u094b\u092a\u0947 \u0906\u0932\u0940 \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "es_MX", "\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u094b \u0906\u0932\u0940 \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "fa_AF", "\u0926\u093e\u0930\u0940" },
            { "fr_CA", "\u0915\u0928\u0947\u0921\u0947 \u0906\u0932\u0940 \u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "fr_CH", "\u0938\u094d\u0935\u093f\u0938 \u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "nl_BE", "\u092b\u093c\u094d\u0932\u0947\u092e\u093f\u0936" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u0940 \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "pt_PT", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "%%1901", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091c\u0930\u094d\u092e\u0928 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "%%1996", "\u091c\u0930\u094d\u092e\u0947\u0928\u0940 \u0926\u0940 1996 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "ar_001", "\u0906\u0927\u0941\u0928\u093f\u0915 \u092e\u093e\u0928\u0915 \u0905\u0930\u092c\u0940" },
            { "es_419", "\u0932\u0948\u091f\u093f\u0928 \u0905\u092e\u0930\u093f\u0915\u0940 \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "key.ca", "\u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "key.cf", "\u092e\u0941\u0926\u094d\u0930\u093e \u092a\u094d\u0930\u093e\u0930\u0942\u092a" },
            { "key.co", "\u0938\u0949\u0930\u094d\u091f \u0915\u094d\u0930\u092e" },
            { "key.cu", "\u092e\u0941\u0926\u094d\u0930\u093e" },
            { "key.hc", "\u0918\u0902\u091f\u0947\u092f\u093e\u0902 \u0926\u093e \u091a\u0915\u094d\u0930 (12 \u0915\u0928\u0947 24)" },
            { "key.lb", "\u092a\u0902\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "key.ms", "\u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "key.nu", "\u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "%%NJIVA", "\u091c\u0928\u0940\u0935\u093e \u092c\u094b\u0932\u0940" },
            { "%%POSIX", "\u0915\u092e\u094d\u092a\u094d\u092f\u0942\u091f\u0930" },
            { "zh_Hans", "\u0938\u093e\u0926\u0940 \u091a\u0940\u0928\u0940" },
            { "zh_Hant", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u091a\u0940\u0928\u0940" },
            { "%%MONOTON", "\u090f\u0915\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "%%POLYTON", "\u092c\u0921\u093c\u0947 \u0938\u093e\u0930\u0947 \u0938\u094d\u0935\u0930\u093e\u0902 \u0906\u0932\u0940" },
            { "%%REVISED", "\u0938\u0902\u0936\u094b\u0927\u093f\u0924 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "type.ca.roc", "\u091a\u0940\u0928\u0940 \u0917\u0923\u0924\u0902\u0924\u094d\u0930 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.hc.h11", "12 \u0918\u0902\u091f\u0947\u092f\u093e\u0902 \u0926\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (0\u201311)" },
            { "type.hc.h12", "12 \u0918\u0902\u091f\u0947\u092f\u093e\u0902 \u0926\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (1\u201312)" },
            { "type.hc.h23", "24 \u0918\u0902\u091f\u0947\u092f\u093e\u0902 \u0926\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (0\u201323)" },
            { "type.hc.h24", "24 \u0918\u0902\u091f\u0947\u092f\u093e\u0902 \u0926\u0940 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (1\u201324)" },
            { "type.nu.arab", "\u0905\u0930\u092c\u0940-\u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "type.nu.armn", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908 \u0938\u0902\u0916\u094d\u092f\u093e\u090f\u0901" },
            { "type.nu.beng", "\u092c\u0902\u0917\u093e\u0932\u0940 \u0905\u0902\u0915" },
            { "type.nu.deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940 \u0905\u0902\u0915" },
            { "type.nu.ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e\u0908 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.geor", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.grek", "\u092f\u0942\u0928\u093e\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0905\u0902\u0915" },
            { "type.nu.guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940 \u0905\u0902\u0915" },
            { "type.nu.hans", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.hant", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.hebr", "\u0939\u093f\u092c\u094d\u0930\u0942 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.jpan", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.khmr", "\u0916\u092e\u0947\u0930 \u0905\u0902\u0915" },
            { "type.nu.knda", "\u0915\u0928\u094d\u0928\u0921\u093c \u0905\u0902\u0915" },
            { "type.nu.laoo", "\u0932\u093e\u0913 \u0905\u0902\u0915" },
            { "type.nu.latn", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0902\u0915" },
            { "type.nu.mlym", "\u092e\u0932\u092f\u093e\u0932\u092e \u0905\u0902\u0915" },
            { "type.nu.mymr", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 \u0905\u0902\u0915" },
            { "type.nu.orya", "\u0909\u0921\u093c\u093f\u092f\u093e \u0905\u0902\u0915" },
            { "type.nu.taml", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u0924\u092e\u093f\u0932 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0941\u0917\u0942 \u0905\u0902\u0915" },
            { "type.nu.thai", "\u0925\u093e\u0908 \u0905\u0902\u0915" },
            { "type.nu.tibt", "\u0924\u093f\u092c\u094d\u092c\u0924\u0940 \u0905\u0902\u0915" },
            { "type.ca.dangi", "\u0926\u093e\u0902\u0917\u0940 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.co.ducet", "\u0921\u093f\u092b\u093c\u0949\u0932\u094d\u091f \u092f\u0942\u0928\u093f\u0915\u094b\u0921 \u0938\u0949\u0930\u094d\u091f \u0915\u094d\u0930\u092e" },
            { "type.lb.loose", "\u0922\u0940\u0932\u0940 \u0932\u0948\u0902\u0923 \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940<" },
            { "type.nu.roman", "\u0930\u094b\u092e\u0928 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.ca.hebrew", "\u0939\u093f\u092c\u094d\u0930\u0942 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.ca.indian", "\u092d\u093e\u0930\u0924\u0940\u092f \u0930\u093e\u0938\u094d\u091f\u0930\u093f\u092f\u093e \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.co.pinyin", "\u092a\u093f\u0928\u092f\u0940\u0928 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.co.search", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f-\u0909\u0926\u094d\u0926\u0947\u0936\u094d\u092f \u0916\u094b\u091c" },
            { "type.co.stroke", "\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.lb.normal", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f \u0932\u0948\u0902\u0923 \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "type.lb.strict", "\u0938\u0916\u094d\u0924 \u0932\u0948\u0902\u0923 \u0935\u093f\u091a\u094d\u091b\u0947\u0926 \u0936\u0948\u0932\u0940" },
            { "type.ms.metric", "\u092e\u0947\u091f\u094d\u0930\u093f\u0915 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ca.chinese", "\u091a\u0940\u0928\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.ca.islamic", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.ca.iso8601", "\u0906\u0908\u090f\u0938\u0913-8601 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.ca.persian", "\u092b\u093c\u093e\u0930\u0938\u0940 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.cf.account", "\u0932\u0947\u0916\u093e\u0902\u0915\u0928 \u092e\u0941\u0926\u094d\u0930\u093e \u092a\u094d\u0930\u093e\u0930\u0942\u092a" },
            { "type.co.big5han", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.nu.arabext", "\u092c\u0927\u093e\u092f\u094b \u0905\u0930\u092c\u0940-\u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0902\u0915" },
            { "type.nu.armnlow", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908 \u0932\u094b\u0905\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.greklow", "\u092f\u0942\u0928\u093e\u0928\u0940 \u0932\u094b\u0905\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.hanidec", "\u091a\u0940\u0928\u0940 \u0926\u0936\u092e\u0932\u0935 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.hansfin", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.hantfin", "\u092a\u093e\u0930\u0902\u092a\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.jpanfin", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.nu.tamldec", "\u0924\u092e\u093f\u0932 \u0905\u0902\u0915" },
            { "type.ca.buddhist", "\u092c\u094c\u0926\u094d\u0927 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.ca.ethiopic", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.ca.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "type.cf.standard", "\u092e\u093e\u0928\u0915 \u092e\u0941\u0926\u094d\u0930\u093e \u092a\u094d\u0930\u093e\u0930\u0942\u092a" },
            { "type.co.standard", "\u092e\u093e\u0928\u0915 \u0938\u0949\u0930\u094d\u091f \u0915\u094d\u0930\u092e" },
            { "type.ms.uksystem", "\u0907\u092e\u094d\u092a\u0940\u0930\u093f\u092f\u0932 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ms.ussystem", "\u0905\u092e\u0930\u093f\u0915\u0940 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.nu.fullwide", "\u092a\u0942\u0930\u0940 \u091a\u094c\u0921\u093c\u093e\u0908 \u0905\u0902\u0915" },
            { "type.nu.romanlow", "\u0930\u094b\u092e\u0928 \u0932\u094b\u0905\u0930\u0915\u0947\u0938 \u0938\u0902\u0916\u094d\u092f\u093e\u0902" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u0915\u0948\u0932\u0947\u0902\u0921\u0930" },
            { "type.co.gb2312han", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.co.phonebook", "\u092b\u094b\u0928\u092c\u0941\u0915 \u091b\u0902\u091f\u093e\u0908 \u0915\u094d\u0930\u092e" },
            { "type.co.traditional", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.ca.islamic-civil", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u0928\u093e\u0917\u0930\u093f\u0915 \u092a\u0902\u091a\u093e\u0902\u0917" },
        };
        return data;
    }
}
