/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.X509Authentication;
import sun.security.util.KeyUtil;
import sun.security.util.SSLScope;
import sun.security.util.SignatureUtil;

enum SignatureScheme {
    ED25519(2055, "ed25519", "ed25519", "ed25519", ProtocolVersion.PROTOCOLS_OF_13),
    ED448(2056, "ed448", "ed448", "ed448", ProtocolVersion.PROTOCOLS_OF_13),
    ECDSA_SECP256R1_SHA256(1027, "ecdsa_secp256r1_sha256", "SHA256withECDSA", "EC", SupportedGroupsExtension.NamedGroup.SECP256_R1, ProtocolVersion.PROTOCOLS_TO_13),
    ECDSA_SECP384R1_SHA384(1283, "ecdsa_secp384r1_sha384", "SHA384withECDSA", "EC", SupportedGroupsExtension.NamedGroup.SECP384_R1, ProtocolVersion.PROTOCOLS_TO_13),
    ECDSA_SECP521R1_SHA512(1539, "ecdsa_secp521r1_sha512", "SHA512withECDSA", "EC", SupportedGroupsExtension.NamedGroup.SECP521_R1, ProtocolVersion.PROTOCOLS_TO_13),
    RSA_PSS_RSAE_SHA256(2052, "rsa_pss_rsae_sha256", "RSASSA-PSS", "RSA", SigAlgParamSpec.RSA_PSS_SHA256, 528, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_RSAE_SHA384(2053, "rsa_pss_rsae_sha384", "RSASSA-PSS", "RSA", SigAlgParamSpec.RSA_PSS_SHA384, 784, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_RSAE_SHA512(2054, "rsa_pss_rsae_sha512", "RSASSA-PSS", "RSA", SigAlgParamSpec.RSA_PSS_SHA512, 1040, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_PSS_SHA256(2057, "rsa_pss_pss_sha256", "RSASSA-PSS", "RSASSA-PSS", SigAlgParamSpec.RSA_PSS_SHA256, 528, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_PSS_SHA384(2058, "rsa_pss_pss_sha384", "RSASSA-PSS", "RSASSA-PSS", SigAlgParamSpec.RSA_PSS_SHA384, 784, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PSS_PSS_SHA512(2059, "rsa_pss_pss_sha512", "RSASSA-PSS", "RSASSA-PSS", SigAlgParamSpec.RSA_PSS_SHA512, 1040, ProtocolVersion.PROTOCOLS_12_13),
    RSA_PKCS1_SHA256(1025, "rsa_pkcs1_sha256", "SHA256withRSA", "RSA", null, null, 511, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    RSA_PKCS1_SHA384(1281, "rsa_pkcs1_sha384", "SHA384withRSA", "RSA", null, null, 768, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    RSA_PKCS1_SHA512(1537, "rsa_pkcs1_sha512", "SHA512withRSA", "RSA", null, null, 768, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    DSA_SHA256(1026, "dsa_sha256", "SHA256withDSA", "DSA", ProtocolVersion.PROTOCOLS_TO_12),
    ECDSA_SHA224(771, "ecdsa_sha224", "SHA224withECDSA", "EC", ProtocolVersion.PROTOCOLS_TO_12),
    RSA_SHA224(769, "rsa_sha224", "SHA224withRSA", "RSA", 511, ProtocolVersion.PROTOCOLS_TO_12),
    DSA_SHA224(770, "dsa_sha224", "SHA224withDSA", "DSA", ProtocolVersion.PROTOCOLS_TO_12),
    ECDSA_SHA1(515, "ecdsa_sha1", "SHA1withECDSA", "EC", ProtocolVersion.PROTOCOLS_TO_13),
    RSA_PKCS1_SHA1(513, "rsa_pkcs1_sha1", "SHA1withRSA", "RSA", null, null, 511, ProtocolVersion.PROTOCOLS_TO_13, ProtocolVersion.PROTOCOLS_TO_12),
    DSA_SHA1(514, "dsa_sha1", "SHA1withDSA", "DSA", ProtocolVersion.PROTOCOLS_TO_12),
    RSA_MD5(257, "rsa_md5", "MD5withRSA", "RSA", 511, ProtocolVersion.PROTOCOLS_TO_12);

    final int id;
    final String name;
    private final String algorithm;
    final String keyAlgorithm;
    private final SigAlgParamSpec signAlgParams;
    private final SupportedGroupsExtension.NamedGroup namedGroup;
    final int minimalKeySize;
    final List<ProtocolVersion> supportedProtocols;
    final List<ProtocolVersion> handshakeSupportedProtocols;
    final boolean isAvailable;
    private static final String[] hashAlgorithms;
    private static final String[] signatureAlgorithms;
    static final Set<SSLScope> HANDSHAKE_SCOPE;
    static final Set<SSLScope> CERTIFICATE_SCOPE;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET;

    private SignatureScheme(int n2, String string2, String string3, String string4, ProtocolVersion[] protocolVersionArray) {
        this(n2, string2, string3, string4, -1, protocolVersionArray);
    }

    private SignatureScheme(int n2, String string2, String string3, String string4, int n3, ProtocolVersion[] protocolVersionArray) {
        this(n2, string2, string3, string4, null, n3, protocolVersionArray);
    }

    private SignatureScheme(int n2, String string2, String string3, String string4, SigAlgParamSpec sigAlgParamSpec, int n3, ProtocolVersion[] protocolVersionArray) {
        this(n2, string2, string3, string4, sigAlgParamSpec, null, n3, protocolVersionArray, protocolVersionArray);
    }

    private SignatureScheme(int n2, String string2, String string3, String string4, SupportedGroupsExtension.NamedGroup namedGroup, ProtocolVersion[] protocolVersionArray) {
        this(n2, string2, string3, string4, null, namedGroup, -1, protocolVersionArray, protocolVersionArray);
    }

    private SignatureScheme(int n2, String string2, String string3, String string4, SigAlgParamSpec sigAlgParamSpec, SupportedGroupsExtension.NamedGroup namedGroup, int n3, ProtocolVersion[] protocolVersionArray, ProtocolVersion[] protocolVersionArray2) {
        boolean bl;
        block7: {
            this.id = n2;
            this.name = string2;
            this.algorithm = string3;
            this.keyAlgorithm = string4;
            this.signAlgParams = sigAlgParamSpec;
            this.namedGroup = namedGroup;
            this.minimalKeySize = n3;
            this.supportedProtocols = Arrays.asList(protocolVersionArray);
            this.handshakeSupportedProtocols = Arrays.asList(protocolVersionArray2);
            bl = true;
            if ("EC".equals(string4)) {
                bl = JsseJce.isEcAvailable();
            }
            if (bl) {
                if (sigAlgParamSpec != null) {
                    bl = sigAlgParamSpec.isAvailable;
                } else {
                    try {
                        JsseJce.getSignature(string3);
                    }
                    catch (Exception exception) {
                        bl = false;
                        if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block7;
                        SSLLogger.warning("Signature algorithm, " + string3 + ", is not supported by the underlying providers", new Object[0]);
                    }
                }
            }
        }
        if (bl && (n2 >> 8 & 0xFF) == 3 && Security.getProvider("SunMSCAPI") != null) {
            bl = false;
        }
        this.isAvailable = bl;
    }

    static SignatureScheme valueOf(int n) {
        for (SignatureScheme signatureScheme : SignatureScheme.values()) {
            if (signatureScheme.id != n) continue;
            return signatureScheme;
        }
        return null;
    }

    static String nameOf(int n) {
        Object object2;
        for (Object object2 : SignatureScheme.values()) {
            if (object2.id != n) continue;
            return object2.name;
        }
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        String string = n2 >= hashAlgorithms.length ? "UNDEFINED-HASH(" + n2 + ")" : hashAlgorithms[n2];
        object2 = n3 >= signatureAlgorithms.length ? "UNDEFINED-SIGNATURE(" + n3 + ")" : signatureAlgorithms[n3];
        return (String)object2 + "_" + string;
    }

    static SignatureScheme nameOf(String string) {
        for (SignatureScheme signatureScheme : SignatureScheme.values()) {
            if (!signatureScheme.name.equalsIgnoreCase(string)) continue;
            return signatureScheme;
        }
        return null;
    }

    static int sizeInRecord() {
        return 2;
    }

    private boolean isPermitted(SSLAlgorithmConstraints sSLAlgorithmConstraints, Set<SSLScope> set) {
        return sSLAlgorithmConstraints.permits(this.name, set) && sSLAlgorithmConstraints.permits(this.keyAlgorithm, set) && sSLAlgorithmConstraints.permits(this.algorithm, set) && sSLAlgorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, this.name, null) && sSLAlgorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, this.keyAlgorithm, null) && sSLAlgorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, this.algorithm, this.signAlgParams != null ? this.signAlgParams.parameters : null);
    }

    static void updateHandshakeLocalSupportedAlgs(HandshakeContext handshakeContext) {
        if (handshakeContext.localSupportedSignAlgs != null && handshakeContext.localSupportedCertSignAlgs != null && (handshakeContext.negotiatedProtocol == null || handshakeContext.activeProtocols.size() == 1)) {
            return;
        }
        List<ProtocolVersion> list = handshakeContext.negotiatedProtocol != null ? Arrays.asList(handshakeContext.negotiatedProtocol) : handshakeContext.activeProtocols;
        handshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(handshakeContext.sslConfig, handshakeContext.algorithmConstraints, list, HANDSHAKE_SCOPE);
        handshakeContext.localSupportedCertSignAlgs = SignatureScheme.getSupportedAlgorithms(handshakeContext.sslConfig, handshakeContext.algorithmConstraints, list, CERTIFICATE_SCOPE);
    }

    private static List<SignatureScheme> getSupportedAlgorithms(SSLConfiguration sSLConfiguration, SSLAlgorithmConstraints sSLAlgorithmConstraints, List<ProtocolVersion> list, Set<SSLScope> set) {
        LinkedList<SignatureScheme> linkedList = new LinkedList<SignatureScheme>();
        List<SignatureScheme> list2 = sSLConfiguration.signatureSchemes.isEmpty() ? Arrays.asList(SignatureScheme.values()) : sSLConfiguration.signatureSchemes;
        for (SignatureScheme signatureScheme : list2) {
            if (!signatureScheme.isAvailable) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
                SSLLogger.finest("Ignore unsupported signature scheme: " + signatureScheme.name, new Object[0]);
                continue;
            }
            boolean bl = false;
            for (ProtocolVersion protocolVersion : list) {
                if (!signatureScheme.isSupportedProtocol(protocolVersion, set)) continue;
                bl = true;
                break;
            }
            if (bl) {
                if (signatureScheme.isPermitted(sSLAlgorithmConstraints, set)) {
                    linkedList.add(signatureScheme);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
                SSLLogger.finest("Ignore disabled signature scheme: " + signatureScheme.name, new Object[0]);
                continue;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
            SSLLogger.finest("Ignore inactive signature scheme: " + signatureScheme.name, new Object[0]);
        }
        return linkedList;
    }

    static List<SignatureScheme> getSupportedAlgorithms(SSLConfiguration sSLConfiguration, SSLAlgorithmConstraints sSLAlgorithmConstraints, ProtocolVersion protocolVersion, int[] nArray, Set<SSLScope> set) {
        LinkedList<SignatureScheme> linkedList = new LinkedList<SignatureScheme>();
        for (int n : nArray) {
            SignatureScheme signatureScheme = SignatureScheme.valueOf(n);
            if (signatureScheme == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.warning("Unsupported signature scheme: " + SignatureScheme.nameOf(n), new Object[0]);
                continue;
            }
            if ((sSLConfiguration.signatureSchemes.isEmpty() || sSLConfiguration.signatureSchemes.contains((Object)signatureScheme)) && signatureScheme.isAllowed(sSLAlgorithmConstraints, protocolVersion, set)) {
                linkedList.add(signatureScheme);
                continue;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
            SSLLogger.warning("Unsupported signature scheme: " + signatureScheme.name, new Object[0]);
        }
        return linkedList;
    }

    static SignatureScheme getPreferableAlgorithm(SSLAlgorithmConstraints sSLAlgorithmConstraints, List<SignatureScheme> list, SignatureScheme signatureScheme, ProtocolVersion protocolVersion) {
        for (SignatureScheme signatureScheme2 : list) {
            if (!signatureScheme.keyAlgorithm.equalsIgnoreCase(signatureScheme2.keyAlgorithm) || !signatureScheme2.isAllowed(sSLAlgorithmConstraints, protocolVersion, HANDSHAKE_SCOPE)) continue;
            return signatureScheme2;
        }
        return null;
    }

    static Map.Entry<SignatureScheme, Signature> getSignerOfPreferableAlgorithm(SSLAlgorithmConstraints sSLAlgorithmConstraints, List<SignatureScheme> list, X509Authentication.X509Possession x509Possession, ProtocolVersion protocolVersion) {
        PrivateKey privateKey = x509Possession.popPrivateKey;
        String string = privateKey.getAlgorithm();
        int n = string.equalsIgnoreCase("RSA") || string.equalsIgnoreCase("RSASSA-PSS") ? KeyUtil.getKeySize(privateKey) : Integer.MAX_VALUE;
        for (SignatureScheme signatureScheme : list) {
            Object object;
            Object object2;
            if (n < signatureScheme.minimalKeySize || !string.equalsIgnoreCase(signatureScheme.keyAlgorithm) || !signatureScheme.isAllowed(sSLAlgorithmConstraints, protocolVersion, HANDSHAKE_SCOPE)) continue;
            if (signatureScheme.namedGroup != null && signatureScheme.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                object2 = x509Possession.getECParameterSpec();
                if (object2 != null && signatureScheme.namedGroup == SupportedGroupsExtension.NamedGroup.valueOf((ECParameterSpec)object2) && (object = signatureScheme.getSigner(privateKey)) != null) {
                    return new AbstractMap.SimpleImmutableEntry<SignatureScheme, SupportedGroupsExtension.NamedGroup>(signatureScheme, (SupportedGroupsExtension.NamedGroup)((Object)object));
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
                SSLLogger.finest("Ignore the signature algorithm (" + (Object)((Object)signatureScheme) + "), unsupported EC parameter spec: " + object2, new Object[0]);
                continue;
            }
            if ("EC".equals(signatureScheme.keyAlgorithm)) {
                Signature signature;
                object2 = x509Possession.getECParameterSpec();
                if (object2 != null && (object = SupportedGroupsExtension.NamedGroup.valueOf((ECParameterSpec)object2)) != null && SupportedGroupsExtension.SupportedGroups.isSupported(object) && (signature = signatureScheme.getSigner(privateKey)) != null) {
                    return new AbstractMap.SimpleImmutableEntry<SignatureScheme, Signature>(signatureScheme, signature);
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake,verbose")) continue;
                SSLLogger.finest("Ignore the legacy signature algorithm (" + (Object)((Object)signatureScheme) + "), unsupported EC parameter spec: " + object2, new Object[0]);
                continue;
            }
            object2 = signatureScheme.getSigner(privateKey);
            if (object2 == null) continue;
            return new AbstractMap.SimpleImmutableEntry<SignatureScheme, Object>(signatureScheme, object2);
        }
        return null;
    }

    private boolean isSupportedProtocol(ProtocolVersion protocolVersion, Set<SSLScope> set) {
        if (set != null && set.equals(HANDSHAKE_SCOPE)) {
            return this.handshakeSupportedProtocols.contains((Object)protocolVersion);
        }
        return this.supportedProtocols.contains((Object)protocolVersion);
    }

    private boolean isAllowed(SSLAlgorithmConstraints sSLAlgorithmConstraints, ProtocolVersion protocolVersion, Set<SSLScope> set) {
        return this.isAvailable && this.isSupportedProtocol(protocolVersion, set) && this.isPermitted(sSLAlgorithmConstraints, set);
    }

    static String[] getAlgorithmNames(Collection<SignatureScheme> collection) {
        if (collection != null) {
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (SignatureScheme signatureScheme : collection) {
                arrayList.add(signatureScheme.algorithm);
            }
            return arrayList.toArray(new String[0]);
        }
        return new String[0];
    }

    Signature getVerifier(PublicKey publicKey) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (!this.isAvailable) {
            return null;
        }
        Signature signature = Signature.getInstance(this.algorithm);
        SignatureUtil.initVerifyWithParam(signature, publicKey, this.signAlgParams != null ? this.signAlgParams.parameterSpec : null);
        return signature;
    }

    private Signature getSigner(PrivateKey privateKey) {
        if (!this.isAvailable) {
            return null;
        }
        try {
            Signature signature = Signature.getInstance(this.algorithm);
            SignatureUtil.initSignWithParam(signature, privateKey, this.signAlgParams != null ? this.signAlgParams.parameterSpec : null, null);
            return signature;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.finest("Ignore unsupported signature algorithm (" + this.name + ")", generalSecurityException);
            }
            return null;
        }
    }

    static {
        hashAlgorithms = new String[]{"none", "md5", "sha1", "sha224", "sha256", "sha384", "sha512"};
        signatureAlgorithms = new String[]{"anonymous", "rsa", "dsa", "ecdsa"};
        HANDSHAKE_SCOPE = Collections.unmodifiableSet(EnumSet.of(SSLScope.HANDSHAKE_SIGNATURE));
        CERTIFICATE_SCOPE = Collections.unmodifiableSet(EnumSet.of(SSLScope.CERTIFICATE_SIGNATURE));
        SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    }

    static enum SigAlgParamSpec {
        RSA_PSS_SHA256("SHA-256", 32),
        RSA_PSS_SHA384("SHA-384", 48),
        RSA_PSS_SHA512("SHA-512", 64);

        private final AlgorithmParameterSpec parameterSpec;
        private final AlgorithmParameters parameters;
        private final boolean isAvailable;

        private SigAlgParamSpec(String string2, int n2) {
            boolean bl;
            AlgorithmParameters algorithmParameters;
            PSSParameterSpec pSSParameterSpec;
            block2: {
                pSSParameterSpec = new PSSParameterSpec(string2, "MGF1", new MGF1ParameterSpec(string2), n2, 1);
                algorithmParameters = null;
                bl = true;
                try {
                    Signature signature = JsseJce.getSignature("RSASSA-PSS");
                    signature.setParameter(pSSParameterSpec);
                    algorithmParameters = signature.getParameters();
                }
                catch (RuntimeException | InvalidAlgorithmParameterException | NoSuchAlgorithmException exception) {
                    bl = false;
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block2;
                    SSLLogger.warning("RSASSA-PSS signature with " + string2 + " is not supported by the underlying providers", exception);
                }
            }
            this.isAvailable = bl;
            this.parameterSpec = bl ? pSSParameterSpec : null;
            this.parameters = bl ? algorithmParameters : null;
        }
    }
}

