/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.RepaintManager;
import sun.awt.AppContext;
import sun.awt.EventQueueDelegate;
import sun.awt.SunToolkit;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;

public class SwingUtilities3 {
    private static final Object DELEGATE_REPAINT_MANAGER_KEY = new StringBuilder("DelegateRepaintManagerKey");
    private static Color disabledForeground;
    private static Color acceleratorSelectionForeground;
    private static Color acceleratorForeground;
    private static final Map<Container, Boolean> vsyncedMap;

    public static void setDelegateRepaintManager(JComponent jComponent, RepaintManager repaintManager) {
        AppContext.getAppContext().put(DELEGATE_REPAINT_MANAGER_KEY, Boolean.TRUE);
        jComponent.putClientProperty(DELEGATE_REPAINT_MANAGER_KEY, repaintManager);
    }

    public static void setVsyncRequested(Container container, boolean bl) {
        assert (container instanceof Applet || container instanceof Window);
        if (bl) {
            vsyncedMap.put(container, Boolean.TRUE);
        } else {
            vsyncedMap.remove(container);
        }
    }

    public static boolean isVsyncRequested(Container container) {
        assert (container instanceof Applet || container instanceof Window);
        return Boolean.TRUE == vsyncedMap.get(container);
    }

    public static RepaintManager getDelegateRepaintManager(Component component) {
        RepaintManager repaintManager = null;
        if (Boolean.TRUE == SunToolkit.targetToAppContext(component).get(DELEGATE_REPAINT_MANAGER_KEY)) {
            while (repaintManager == null && component != null) {
                while (component != null && !(component instanceof JComponent)) {
                    component = component.getParent();
                }
                if (component == null) continue;
                repaintManager = (RepaintManager)((JComponent)component).getClientProperty(DELEGATE_REPAINT_MANAGER_KEY);
                component = component.getParent();
            }
        }
        return repaintManager;
    }

    public static void setEventQueueDelegate(Map<String, Map<String, Object>> map) {
        EventQueueDelegate.setDelegate(new EventQueueDelegateFromMap(map));
    }

    public static void applyInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
    }

    public static void paintCheckIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color, Color color2) {
        if (menuItemLayoutHelper.getCheckIcon() != null) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            if (buttonModel.isArmed() || menuItemLayoutHelper.getMenuItem() instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            if (menuItemLayoutHelper.useCheckAndArrow()) {
                menuItemLayoutHelper.getCheckIcon().paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getCheckRect().x, layoutResult.getCheckRect().y);
            }
            graphics.setColor(color);
        }
    }

    public static void paintIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color) {
        if (menuItemLayoutHelper.getIcon() != null) {
            Icon icon;
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            if (!buttonModel.isEnabled()) {
                icon = menuItemLayoutHelper.getMenuItem().getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = menuItemLayoutHelper.getMenuItem().getPressedIcon();
                if (icon == null) {
                    icon = menuItemLayoutHelper.getMenuItem().getIcon();
                }
            } else {
                icon = menuItemLayoutHelper.getMenuItem().getIcon();
            }
            if (icon != null) {
                icon.paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getIconRect().x, layoutResult.getIconRect().y);
                graphics.setColor(color);
            }
        }
    }

    public static void paintAccText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!menuItemLayoutHelper.getAccText().isEmpty()) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            graphics.setFont(menuItemLayoutHelper.getAccFontMetrics().getFont());
            if (!buttonModel.isEnabled()) {
                if (disabledForeground != null) {
                    graphics.setColor(disabledForeground);
                    SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x, layoutResult.getAccRect().y + menuItemLayoutHelper.getAccFontMetrics().getAscent());
                } else {
                    graphics.setColor(menuItemLayoutHelper.getMenuItem().getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x, layoutResult.getAccRect().y + menuItemLayoutHelper.getAccFontMetrics().getAscent());
                    graphics.setColor(menuItemLayoutHelper.getMenuItem().getBackground().darker());
                    SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x - 1, layoutResult.getAccRect().y + menuItemLayoutHelper.getFontMetrics().getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || menuItemLayoutHelper.getMenuItem() instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(acceleratorSelectionForeground);
                } else {
                    graphics.setColor(acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x, layoutResult.getAccRect().y + menuItemLayoutHelper.getAccFontMetrics().getAscent());
            }
        }
    }

    public static void setDisabledForeground(Color color) {
        disabledForeground = color;
    }

    public static void setAcceleratorSelectionForeground(Color color) {
        acceleratorSelectionForeground = color;
    }

    public static void setAcceleratorForeground(Color color) {
        acceleratorForeground = color;
    }

    public static void paintArrowIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color) {
        if (menuItemLayoutHelper.getArrowIcon() != null) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            if (buttonModel.isArmed() || menuItemLayoutHelper.getMenuItem() instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
            }
            if (menuItemLayoutHelper.useCheckAndArrow()) {
                menuItemLayoutHelper.getArrowIcon().paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getArrowRect().x, layoutResult.getArrowRect().y);
            }
        }
    }

    static {
        vsyncedMap = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class EventQueueDelegateFromMap
    implements EventQueueDelegate.Delegate {
        private final AWTEvent[] afterDispatchEventArgument;
        private final Object[] afterDispatchHandleArgument;
        private final Callable<Void> afterDispatchCallable;
        private final AWTEvent[] beforeDispatchEventArgument;
        private final Callable<Object> beforeDispatchCallable;
        private final EventQueue[] getNextEventEventQueueArgument;
        private final Callable<AWTEvent> getNextEventCallable;

        public EventQueueDelegateFromMap(Map<String, Map<String, Object>> map) {
            Map<String, Object> map2 = map.get("afterDispatch");
            this.afterDispatchEventArgument = (AWTEvent[])map2.get("event");
            this.afterDispatchHandleArgument = (Object[])map2.get("handle");
            this.afterDispatchCallable = (Callable)map2.get("method");
            map2 = map.get("beforeDispatch");
            this.beforeDispatchEventArgument = (AWTEvent[])map2.get("event");
            this.beforeDispatchCallable = (Callable)map2.get("method");
            map2 = map.get("getNextEvent");
            this.getNextEventEventQueueArgument = (EventQueue[])map2.get("eventQueue");
            this.getNextEventCallable = (Callable)map2.get("method");
        }

        @Override
        public void afterDispatch(AWTEvent aWTEvent, Object object) throws InterruptedException {
            this.afterDispatchEventArgument[0] = aWTEvent;
            this.afterDispatchHandleArgument[0] = object;
            try {
                this.afterDispatchCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object beforeDispatch(AWTEvent aWTEvent) throws InterruptedException {
            this.beforeDispatchEventArgument[0] = aWTEvent;
            try {
                return this.beforeDispatchCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public AWTEvent getNextEvent(EventQueue eventQueue) throws InterruptedException {
            this.getNextEventEventQueueArgument[0] = eventQueue;
            try {
                return this.getNextEventCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

