/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import com.sun.jndi.rmi.registry.AtomicNameParser;
import com.sun.jndi.rmi.registry.BindingEnumeration;
import com.sun.jndi.rmi.registry.NameClassPairEnumeration;
import com.sun.jndi.rmi.registry.ReferenceWrapper;
import com.sun.jndi.rmi.registry.RegistryContextFactory;
import com.sun.jndi.rmi.registry.RemoteReference;
import com.sun.naming.internal.NamingManagerHelper;
import com.sun.naming.internal.ObjectFactoriesFilter;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.SocketSecurityException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;

public class RegistryContext
implements Context,
Referenceable {
    private Hashtable<String, Object> environment;
    private Registry registry;
    private String host;
    private int port;
    private static final NameParser nameParser = new AtomicNameParser();
    private static final String SOCKET_FACTORY = "com.sun.jndi.rmi.factory.socket";
    static final boolean trustURLCodebase;
    Reference reference = null;
    public static final String SECURITY_MGR = "java.naming.rmi.security.manager";

    public RegistryContext(String string, int n, Hashtable<?, ?> hashtable) throws NamingException {
        Hashtable hashtable2 = this.environment = hashtable == null ? new Hashtable(5) : hashtable;
        if (this.environment.get(SECURITY_MGR) != null) {
            RegistryContext.installSecurityMgr();
        }
        if (string != null && string.charAt(0) == '[') {
            string = string.substring(1, string.length() - 1);
        }
        RMIClientSocketFactory rMIClientSocketFactory = (RMIClientSocketFactory)this.environment.get(SOCKET_FACTORY);
        this.registry = RegistryContext.getRegistry(string, n, rMIClientSocketFactory);
        this.host = string;
        this.port = n;
    }

    RegistryContext(RegistryContext registryContext) {
        this.environment = (Hashtable)registryContext.environment.clone();
        this.registry = registryContext.registry;
        this.host = registryContext.host;
        this.port = registryContext.port;
        this.reference = registryContext.reference;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Remote remote;
        if (name.isEmpty()) {
            return new RegistryContext(this);
        }
        try {
            remote = this.registry.lookup(name.get(0));
        }
        catch (NotBoundException notBoundException) {
            throw new NameNotFoundException(name.get(0));
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
        return this.decodeObject(remote, name.getPrefix(1));
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: Cannot bind empty name");
        }
        try {
            this.registry.bind(name.get(0), this.encodeObject(object, name.getPrefix(1)));
        }
        catch (AlreadyBoundException alreadyBoundException) {
            NameAlreadyBoundException nameAlreadyBoundException = new NameAlreadyBoundException(name.get(0));
            nameAlreadyBoundException.setRootCause(alreadyBoundException);
            throw nameAlreadyBoundException;
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: Cannot rebind empty name");
        }
        try {
            this.registry.rebind(name.get(0), this.encodeObject(object, name.getPrefix(1)));
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: Cannot unbind empty name");
        }
        try {
            this.registry.unbind(name.get(0));
        }
        catch (NotBoundException notBoundException) {
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.bind(name2, this.lookup(name));
        this.unbind(name);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: can only list \"\"");
        }
        try {
            String[] stringArray = this.registry.list();
            return new NameClassPairEnumeration(stringArray);
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: can only list \"\"");
        }
        try {
            String[] stringArray = this.registry.list();
            return new BindingEnumeration(this, stringArray);
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return nameParser;
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        return name3.addAll(name);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return this.composeName(new CompositeName(string), new CompositeName(string2)).toString();
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.remove(string);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string.equals(SECURITY_MGR)) {
            RegistryContext.installSecurityMgr();
        }
        return this.environment.put(string, object);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public void close() {
        this.environment = null;
        this.registry = null;
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.reference != null) {
            return (Reference)this.reference.clone();
        }
        if (this.host == null || this.host.equals("localhost")) {
            throw new ConfigurationException("Cannot create a reference for an RMI registry whose host was unspecified or specified as \"localhost\"");
        }
        String string = "rmi://";
        String string2 = string = this.host.indexOf(":") > -1 ? string + "[" + this.host + "]" : string + this.host;
        if (this.port > 0) {
            string = string + ":" + Integer.toString(this.port);
        }
        StringRefAddr stringRefAddr = new StringRefAddr("URL", string);
        return new Reference(RegistryContext.class.getName(), stringRefAddr, RegistryContextFactory.class.getName(), null);
    }

    public static NamingException wrapRemoteException(RemoteException remoteException) {
        NamingException namingException = remoteException instanceof ConnectException ? new ServiceUnavailableException() : (remoteException instanceof AccessException ? new NoPermissionException() : (remoteException instanceof StubNotFoundException || remoteException instanceof UnknownHostException || remoteException instanceof SocketSecurityException ? new ConfigurationException() : (remoteException instanceof ExportException || remoteException instanceof ConnectIOException || remoteException instanceof MarshalException || remoteException instanceof UnmarshalException || remoteException instanceof NoSuchObjectException ? new CommunicationException() : (remoteException instanceof ServerException && remoteException.detail instanceof RemoteException ? RegistryContext.wrapRemoteException((RemoteException)remoteException.detail) : new NamingException()))));
        namingException.setRootCause(remoteException);
        return namingException;
    }

    private static Registry getRegistry(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) throws NamingException {
        try {
            if (rMIClientSocketFactory == null) {
                return LocateRegistry.getRegistry(string, n);
            }
            return LocateRegistry.getRegistry(string, n, rMIClientSocketFactory);
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
    }

    private static void installSecurityMgr() {
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Remote encodeObject(Object object, Name name) throws NamingException, RemoteException {
        if ((object = NamingManager.getStateToBind(object, name, this, this.environment)) instanceof Remote) {
            return (Remote)object;
        }
        if (object instanceof Reference) {
            return new ReferenceWrapper((Reference)object);
        }
        if (object instanceof Referenceable) {
            return new ReferenceWrapper(((Referenceable)object).getReference());
        }
        throw new IllegalArgumentException("RegistryContext: object to bind must be Remote, Reference, or Referenceable");
    }

    private Object decodeObject(Remote remote, Name name) throws NamingException {
        try {
            Remote remote2 = remote instanceof RemoteReference ? ((RemoteReference)remote).getReference() : remote;
            Reference reference = null;
            if (remote2 instanceof Reference) {
                reference = (Reference)((Object)remote2);
            } else if (remote2 instanceof Referenceable) {
                reference = ((Referenceable)((Object)remote2)).getReference();
            }
            if (reference != null && reference.getFactoryClassLocation() != null && !trustURLCodebase) {
                throw new ConfigurationException("The object factory is untrusted. Set the system property 'com.sun.jndi.rmi.object.trustURLCodebase' to 'true'.");
            }
            return NamingManagerHelper.getObjectInstance(remote2, name, this, this.environment, ObjectFactoriesFilter::checkRmiFilter);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (RemoteException remoteException) {
            throw (NamingException)RegistryContext.wrapRemoteException(remoteException).fillInStackTrace();
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    static {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty("com.sun.jndi.rmi.object.trustURLCodebase", "false");
        String string = AccessController.doPrivileged(privilegedAction);
        trustURLCodebase = "true".equalsIgnoreCase(string);
    }
}

