/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import sun.misc.ObjectInputFilter;
import sun.security.util.SecurityProperties;

public final class ObjectFactoriesFilter {
    private static final String GLOBAL_FACTORIES_FILTER_PROPNAME = "jdk.jndi.object.factoriesFilter";
    private static final String LDAP_FACTORIES_FILTER_PROPNAME = "jdk.jndi.ldap.object.factoriesFilter";
    private static final String RMI_FACTORIES_FILTER_PROPNAME = "jdk.jndi.rmi.object.factoriesFilter";
    private static final String DEFAULT_GLOBAL_SP_VALUE = "*";
    private static final String DEFAULT_LDAP_SP_VALUE = "com.sun.jndi.ldap.**;!*";
    private static final String DEFAULT_RMI_SP_VALUE = "com.sun.jndi.rmi.**;!*";
    private static final ConfiguredFilter GLOBAL_FILTER = ObjectFactoriesFilter.initializeFilter("jdk.jndi.object.factoriesFilter", "*");
    private static final ConfiguredFilter LDAP_FILTER = ObjectFactoriesFilter.initializeFilter("jdk.jndi.ldap.object.factoriesFilter", "com.sun.jndi.ldap.**;!*");
    private static final ConfiguredFilter RMI_FILTER = ObjectFactoriesFilter.initializeFilter("jdk.jndi.rmi.object.factoriesFilter", "com.sun.jndi.rmi.**;!*");

    public static boolean checkGlobalFilter(Class<?> clazz) {
        return ObjectFactoriesFilter.checkInput(GLOBAL_FILTER, () -> clazz);
    }

    public static boolean checkLdapFilter(Class<?> clazz) {
        return ObjectFactoriesFilter.checkInput(LDAP_FILTER, () -> clazz);
    }

    public static boolean checkRmiFilter(Class<?> clazz) {
        return ObjectFactoriesFilter.checkInput(RMI_FILTER, () -> clazz);
    }

    private static boolean checkInput(ConfiguredFilter configuredFilter, FactoryInfo factoryInfo) {
        ObjectInputFilter objectInputFilter = GLOBAL_FILTER.filter();
        ObjectInputFilter objectInputFilter2 = configuredFilter.filter();
        ObjectInputFilter.Status status = objectInputFilter.checkInput(factoryInfo);
        if (configuredFilter == GLOBAL_FILTER) {
            return status == ObjectInputFilter.Status.ALLOWED;
        }
        switch (status) {
            case ALLOWED: {
                return objectInputFilter2.checkInput(factoryInfo) != ObjectInputFilter.Status.REJECTED;
            }
            case REJECTED: {
                return false;
            }
            case UNDECIDED: {
                return objectInputFilter2.checkInput(factoryInfo) == ObjectInputFilter.Status.ALLOWED;
            }
        }
        return false;
    }

    private ObjectFactoriesFilter() {
        throw new InternalError("Not instantiable");
    }

    private static ConfiguredFilter initializeFilter(String string, String string2) {
        try {
            ObjectInputFilter objectInputFilter = ObjectInputFilter.Config.createFilter(ObjectFactoriesFilter.getFilterPropertyValue(string, string2));
            return new ValidFilter(objectInputFilter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidFilter(string, illegalArgumentException);
        }
    }

    private static String getFilterPropertyValue(String string, String string2) {
        String string3 = SecurityProperties.privilegedGetOverridable(string);
        return string3 != null ? string3 : string2;
    }

    private static final class InvalidFilter
    implements ConfiguredFilter {
        final String filterPropertyName;
        final IllegalArgumentException error;

        InvalidFilter(String string, IllegalArgumentException illegalArgumentException) {
            this.filterPropertyName = string;
            this.error = illegalArgumentException;
        }

        @Override
        public ObjectInputFilter filter() {
            throw new IllegalArgumentException(this.filterPropertyName + ": " + this.error.getMessage());
        }

        public String toString() {
            return "InvalidFilter[filterPropertyName=" + this.filterPropertyName + ", error=" + this.error + "]";
        }
    }

    private static final class ValidFilter
    implements ConfiguredFilter {
        final ObjectInputFilter filter;

        ValidFilter(ObjectInputFilter objectInputFilter) {
            this.filter = objectInputFilter;
        }

        @Override
        public ObjectInputFilter filter() {
            return this.filter;
        }

        public String toString() {
            return this.filter.toString();
        }
    }

    private static interface ConfiguredFilter {
        public ObjectInputFilter filter();
    }

    @FunctionalInterface
    private static interface FactoryInfo
    extends ObjectInputFilter.FilterInfo {
        @Override
        default public long arrayLength() {
            return -1L;
        }

        @Override
        default public long depth() {
            return 1L;
        }

        @Override
        default public long references() {
            return 0L;
        }

        @Override
        default public long streamBytes() {
            return 0L;
        }
    }
}

