/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;

public class ContentInfo {
    public static ObjectIdentifier PKCS7_OID = ObjectIdentifier.of(KnownOIDs.PKCS7);
    public static ObjectIdentifier DATA_OID = ObjectIdentifier.of(KnownOIDs.Data);
    public static ObjectIdentifier SIGNED_DATA_OID = ObjectIdentifier.of(KnownOIDs.SignedData);
    public static ObjectIdentifier ENVELOPED_DATA_OID = ObjectIdentifier.of(KnownOIDs.EnvelopedData);
    public static ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID = ObjectIdentifier.of(KnownOIDs.SignedAndEnvelopedData);
    public static ObjectIdentifier DIGESTED_DATA_OID = ObjectIdentifier.of(KnownOIDs.DigestedData);
    public static ObjectIdentifier ENCRYPTED_DATA_OID = ObjectIdentifier.of(KnownOIDs.EncryptedData);
    public static ObjectIdentifier OLD_SIGNED_DATA_OID = ObjectIdentifier.of(KnownOIDs.JDK_OLD_SignedData);
    public static ObjectIdentifier OLD_DATA_OID = ObjectIdentifier.of(KnownOIDs.JDK_OLD_Data);
    public static ObjectIdentifier NETSCAPE_CERT_SEQUENCE_OID = ObjectIdentifier.of(KnownOIDs.NETSCAPE_CertSequence);
    public static ObjectIdentifier TIMESTAMP_TOKEN_INFO_OID = ObjectIdentifier.of(KnownOIDs.TimeStampTokenInfo);
    ObjectIdentifier contentType;
    DerValue content;

    public ContentInfo(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.contentType = objectIdentifier;
        this.content = derValue;
    }

    public ContentInfo(byte[] byArray) {
        DerValue derValue = new DerValue(4, byArray);
        this.contentType = DATA_OID;
        this.content = derValue;
    }

    public ContentInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public ContentInfo(DerInputStream derInputStream, boolean bl) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length < 1 || derValueArray.length > 2) {
            throw new ParsingException("Invalid length for ContentInfo");
        }
        DerValue derValue = derValueArray[0];
        DerInputStream derInputStream2 = new DerInputStream(derValue.toByteArray());
        this.contentType = derInputStream2.getOID();
        if (bl) {
            if (derValueArray.length > 1) {
                this.content = derValueArray[1];
            }
        } else if (derValueArray.length > 1) {
            DerValue derValue2 = derValueArray[1];
            DerInputStream derInputStream3 = new DerInputStream(derValue2.toByteArray());
            DerValue[] derValueArray2 = derInputStream3.getSet(1, true);
            if (derValueArray2.length != 1) {
                throw new ParsingException("ContentInfo encoding error");
            }
            this.content = derValueArray2[0];
        }
    }

    public DerValue getContent() {
        return this.content;
    }

    public ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public byte[] getData() throws IOException {
        if (this.contentType.equals((Object)DATA_OID) || this.contentType.equals((Object)OLD_DATA_OID) || this.contentType.equals((Object)TIMESTAMP_TOKEN_INFO_OID)) {
            if (this.content == null) {
                return null;
            }
            return this.content.getOctetString();
        }
        throw new IOException("content type is not DATA: " + this.contentType);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.contentType);
        if (this.content != null) {
            DerValue derValue = null;
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.content.encode(derOutputStream3);
            derValue = new DerValue(-96, derOutputStream3.toByteArray());
            derOutputStream2.putDerValue(derValue);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getContentBytes() throws IOException {
        if (this.content == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(this.content.toByteArray());
        return derInputStream.getOctetString();
    }

    public String toString() {
        String string = "";
        string = string + "Content Info Sequence\n\tContent type: " + this.contentType + "\n";
        string = string + "\tContent: " + this.content;
        return string;
    }
}

