/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.security.Provider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import sun.security.util.SecurityProviderConstants;

public final class SunRsaSignEntries {
    private LinkedHashSet<Provider.Service> services = new LinkedHashSet(20, 0.9f);

    private void add(Provider provider, String string, String string2, String string3, List<String> list, HashMap<String, String> hashMap) {
        this.services.add(new Provider.Service(provider, string, string2, string3, list, hashMap));
    }

    private void addA(Provider provider, String string, String string2, String string3, HashMap<String, String> hashMap) {
        this.services.add(new Provider.Service(provider, string, string2, string3, SecurityProviderConstants.getAliases(string2), hashMap));
    }

    public SunRsaSignEntries(Provider provider) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        this.add(provider, "KeyFactory", "RSA", "sun.security.rsa.RSAKeyFactory$Legacy", SecurityProviderConstants.getAliases("PKCS1"), null);
        this.add(provider, "KeyPairGenerator", "RSA", "sun.security.rsa.RSAKeyPairGenerator$Legacy", SecurityProviderConstants.getAliases("PKCS1"), null);
        this.addA(provider, "Signature", "MD2withRSA", "sun.security.rsa.RSASignature$MD2withRSA", hashMap);
        this.addA(provider, "Signature", "MD5withRSA", "sun.security.rsa.RSASignature$MD5withRSA", hashMap);
        this.addA(provider, "Signature", "SHA1withRSA", "sun.security.rsa.RSASignature$SHA1withRSA", hashMap);
        this.addA(provider, "Signature", "SHA224withRSA", "sun.security.rsa.RSASignature$SHA224withRSA", hashMap);
        this.addA(provider, "Signature", "SHA256withRSA", "sun.security.rsa.RSASignature$SHA256withRSA", hashMap);
        this.addA(provider, "Signature", "SHA384withRSA", "sun.security.rsa.RSASignature$SHA384withRSA", hashMap);
        this.addA(provider, "Signature", "SHA512withRSA", "sun.security.rsa.RSASignature$SHA512withRSA", hashMap);
        this.addA(provider, "Signature", "SHA512/224withRSA", "sun.security.rsa.RSASignature$SHA512_224withRSA", hashMap);
        this.addA(provider, "Signature", "SHA512/256withRSA", "sun.security.rsa.RSASignature$SHA512_256withRSA", hashMap);
        this.addA(provider, "KeyFactory", "RSASSA-PSS", "sun.security.rsa.RSAKeyFactory$PSS", hashMap);
        this.addA(provider, "KeyPairGenerator", "RSASSA-PSS", "sun.security.rsa.RSAKeyPairGenerator$PSS", hashMap);
        this.addA(provider, "Signature", "RSASSA-PSS", "sun.security.rsa.RSAPSSSignature", hashMap);
        this.addA(provider, "AlgorithmParameters", "RSASSA-PSS", "sun.security.rsa.PSSParameters", hashMap);
    }

    public Iterator<Provider.Service> iterator() {
        return this.services.iterator();
    }
}

