"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SFTP = void 0;
const helpers_1 = require("./helpers");
class SFTP extends helpers_1.Destructible {
    constructor(inner, events) {
        super();
        this.inner = inner;
        this.events = events;
        this.closed$ = this.events.close$.subscribe(this.inner.channelId);
        // Trigger subscriptions to stop buffering data
        this.events.data$.subscribe(this.inner.channelId).subscribe().unsubscribe();
        this.events.extendedData$.subscribe(this.inner.channelId).subscribe().unsubscribe();
    }
    createDirectory(path) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.createDir(path);
        });
    }
    removeDirectory(path) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.removeDir(path);
        });
    }
    removeFile(path) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.removeFile(path);
        });
    }
    readlink(path) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            return this.inner.readlink(path);
        });
    }
    rename(src, dst) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.rename(src, dst);
        });
    }
    stat(path) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            const md = yield this.inner.stat(path);
            return Object.assign(Object.assign({}, md), { type: md.type(), size: parseInt(md.size) });
        });
    }
    readDirectory(path) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            let entries = yield this.inner.readDir(path);
            return entries.map(e => {
                const md = e.metadata();
                return {
                    name: e.name,
                    metadata: {
                        // Can't just spread a napi object
                        type: e.type,
                        size: parseInt(md.size),
                        atime: md.atime,
                        mtime: md.mtime,
                        gid: md.gid,
                        group: md.group,
                        permissions: md.permissions,
                        uid: md.uid,
                        user: md.user,
                    },
                };
            });
        });
    }
    chmod(path, mode) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            let parsed = typeof mode === 'string' ? parseInt(mode, 8) : mode;
            yield this.inner.chmod(path, parsed);
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.inner.close();
        });
    }
    open(path, mode) {
        return __awaiter(this, void 0, void 0, function* () {
            const f = yield this.inner.open(path, mode);
            return f;
        });
    }
}
exports.SFTP = SFTP;
