import { NgZone } from '@angular/core';
import { TabContextMenuItemProvider } from '../api/tabContextMenuProvider';
import { BaseTabComponent } from './baseTab.component';
import { HotkeysService } from '../services/hotkeys.service';
import { AppService } from '../services/app.service';
import { HostAppService, Platform } from '../api/hostApp';
import { ConfigService } from '../services/config.service';
import { BaseComponent } from './base.component';
import { MenuItemOptions } from '../api/menu';
import { PlatformService } from '../api/platform';
/** @hidden */
export declare class TabHeaderComponent extends BaseComponent {
    app: AppService;
    config: ConfigService;
    hostApp: HostAppService;
    private hotkeys;
    private platform;
    private zone;
    protected contextMenuProviders: TabContextMenuItemProvider[];
    index: number;
    active: boolean;
    tab: BaseTabComponent;
    progress: number | null;
    Platform: typeof Platform;
    constructor(app: AppService, config: ConfigService, hostApp: HostAppService, hotkeys: HotkeysService, platform: PlatformService, zone: NgZone, contextMenuProviders: TabContextMenuItemProvider[]);
    ngOnInit(): void;
    buildContextMenu(): Promise<MenuItemOptions[]>;
    onTabDragStart(tab: BaseTabComponent): void;
    onTabDragEnd(): void;
    get isFlexWidthEnabled(): boolean;
    onDoubleClick($event: MouseEvent): void;
    onMouseDown($event: MouseEvent): Promise<void>;
    onMouseUp($event: MouseEvent): Promise<void>;
    onContextMenu($event: MouseEvent): Promise<void>;
}
